/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

public abstract class JsonValue {
    public static final String KEYS = "@keys";
    public static final String ITEMS = "@items";
    public static final String ID = "@id";
    public static final String REF = "@ref";
    public static final String TYPE = "@type";
    public static final String ENUM = "@enum";
    public static final String SHORT_TYPE = "@t";
    public static final String SHORT_ITEMS = "@e";
    public static final String SHORT_KEYS = "@k";
    public static final String SHORT_ID = "@i";
    public static final String SHORT_REF = "@r";
    public static final String VALUE = "value";
    protected Class<?> javaType = null;
    protected Class<?> hintType = null;
    protected Object target = null;
    protected boolean isFinished = false;
    protected long id = -1L;
    protected Long refId = null;
    protected int line;
    protected int col;

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean isReference() {
        return this.refId != null;
    }

    public Long getReferenceId() {
        return this.refId;
    }

    public void setReferenceId(Long id) {
        this.refId = id;
        this.isFinished = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished() {
        this.isFinished = true;
    }

    public Object setTarget(Object target) {
        this.target = target;
        if (target != null) {
            this.setJavaType(target.getClass());
        }
        return target;
    }

    public Object setFinishedTarget(Object o, boolean isFinished) {
        this.isFinished = isFinished;
        return this.setTarget(o);
    }

    public Object getTarget() {
        return this.target;
    }

    public abstract boolean isArray();

    public Class<?> getJavaType() {
        return this.javaType == null ? this.hintType : this.javaType;
    }

    public void setJavaType(Class<?> type) {
        this.javaType = type;
        if (this.hintType == null) {
            this.hintType = type;
        }
    }

    void setHintType(Class<?> type) {
        this.hintType = type;
    }

    String getJavaTypeName() {
        if (this.javaType != null) {
            return this.javaType.getName();
        }
        return this.hintType != null ? this.hintType.getName() : null;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean hasId() {
        return this.id > 0L;
    }

    void clear() {
        this.id = -1L;
        this.javaType = null;
        this.refId = null;
    }
}

