/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class Resolver {
    protected final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    protected final JsonReader reader;
    private static final NullClass nullReader = new NullClass();
    final ConcurrentMap<Class, JsonReader.JsonClassReaderBase> readerCache = new ConcurrentHashMap<Class, JsonReader.JsonClassReaderBase>();
    private final Collection<Object[]> prettyMaps = new ArrayList<Object[]>();
    private final boolean useMaps;
    private final Object unknownClass;

    protected Resolver(JsonReader reader) {
        this.reader = reader;
        Map optionalArgs = reader.getArgs();
        this.useMaps = Boolean.TRUE.equals(optionalArgs.get("USE_MAPS"));
        this.unknownClass = optionalArgs.containsKey("UNKNOWN_OBJECT") ? optionalArgs.get("UNKNOWN_OBJECT") : null;
    }

    protected JsonReader getReader() {
        return this.reader;
    }

    protected Object convertMapsToObjects(JsonObject<String, Object> root) {
        ArrayDeque<JsonObject<String, Object>> stack = new ArrayDeque<JsonObject<String, Object>>();
        stack.addFirst(root);
        while (!stack.isEmpty()) {
            JsonObject jsonObj = (JsonObject)stack.removeFirst();
            if (jsonObj.isArray()) {
                this.traverseArray(stack, jsonObj);
                continue;
            }
            if (jsonObj.isCollection()) {
                this.traverseCollection(stack, jsonObj);
                continue;
            }
            if (jsonObj.isMap()) {
                this.traverseMap(stack, jsonObj);
                continue;
            }
            this.traverseFields(stack, jsonObj);
        }
        return root.target;
    }

    protected abstract void traverseFields(Deque<JsonObject<String, Object>> var1, JsonObject<String, Object> var2);

    protected abstract void traverseCollection(Deque<JsonObject<String, Object>> var1, JsonObject<String, Object> var2);

    protected abstract void traverseArray(Deque<JsonObject<String, Object>> var1, JsonObject<String, Object> var2);

    protected void cleanup() {
        this.patchUnresolvedReferences();
        this.rehashMaps();
        this.reader.getObjectsRead().clear();
        this.unresolvedRefs.clear();
        this.prettyMaps.clear();
        this.readerCache.clear();
    }

    protected void traverseMap(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        Resolver.convertMapToKeysItems(jsonObj);
        Object[] keys = (Object[])jsonObj.get("@keys");
        Object[] items = jsonObj.getArray();
        if (keys == null || items == null) {
            if (keys != items) {
                throw new JsonIoException("Map written where one of @keys or @items is empty");
            }
            return;
        }
        int size = keys.length;
        if (size != items.length) {
            throw new JsonIoException("Map written with @keys and @items entries of different sizes");
        }
        Object[] mapKeys = Resolver.buildCollection(stack, keys, size);
        Object[] mapValues = Resolver.buildCollection(stack, items, size);
        this.prettyMaps.add(new Object[]{jsonObj, mapKeys, mapValues});
    }

    private static Object[] buildCollection(Deque<JsonObject<String, Object>> stack, Object[] items, int size) {
        Object[] javaKeys;
        JsonObject<String, Object[]> jsonCollection = new JsonObject<String, Object[]>();
        jsonCollection.put("@items", items);
        jsonCollection.target = javaKeys = new Object[size];
        stack.addFirst(jsonCollection);
        return javaKeys;
    }

    protected static void convertMapToKeysItems(JsonObject map) {
        if (!map.containsKey("@keys") && !map.isReference()) {
            Object[] keys = new Object[map.size()];
            Object[] values = new Object[map.size()];
            int i = 0;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = iterator.next();
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            String saveType = map.getType();
            map.clear();
            map.setType(saveType);
            map.put("@keys", keys);
            map.put("@items", values);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object createJavaObjectInstance(Class clazz, JsonObject jsonObj) {
        Object mate;
        boolean useMapsLocal = this.useMaps;
        String type = jsonObj.type;
        if ("java.lang.Object".equals(type)) {
            Object value = jsonObj.get("value");
            if (jsonObj.keySet().size() == 1 && value != null) {
                type = value.getClass().getName();
            }
        }
        if (type != null) {
            Class c;
            try {
                c = MetaUtils.classForName(type);
            }
            catch (Exception e) {
                if (useMapsLocal) {
                    jsonObj.type = null;
                    jsonObj.target = null;
                    return jsonObj;
                }
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create class: " + name, e);
            }
            if (c.isArray()) {
                int size;
                Object[] items = jsonObj.getArray();
                int n = size = items == null ? 0 : items.length;
                if (c == char[].class) {
                    jsonObj.moveCharsToMate();
                    mate = jsonObj.target;
                } else {
                    mate = Array.newInstance(c.getComponentType(), size);
                }
            } else {
                mate = MetaUtils.isPrimitive(c) ? MetaUtils.newPrimitiveWrapper(c, jsonObj.get("value")) : (c == Class.class ? MetaUtils.classForName((String)jsonObj.get("value")) : (c.isEnum() ? this.getEnum(c, jsonObj) : (Enum.class.isAssignableFrom(c) ? this.getEnum(c.getSuperclass(), jsonObj) : (EnumSet.class.isAssignableFrom(c) ? this.getEnumSet(c, jsonObj) : ("java.util.Arrays$ArrayList".equals(c.getName()) ? new ArrayList() : Resolver.newInstance(c, jsonObj))))));
            }
        } else {
            Object[] items = jsonObj.getArray();
            if (clazz.isArray() || items != null && clazz == Object.class && !jsonObj.containsKey("@keys")) {
                int size = items == null ? 0 : items.length;
                mate = Array.newInstance(clazz.isArray() ? clazz.getComponentType() : Object.class, size);
            } else if (clazz.isEnum()) {
                mate = this.getEnum(clazz, jsonObj);
            } else if (Enum.class.isAssignableFrom(clazz)) {
                mate = this.getEnum(clazz.getSuperclass(), jsonObj);
            } else if (EnumSet.class.isAssignableFrom(clazz)) {
                mate = this.getEnumSet(clazz, jsonObj);
            } else if ("java.util.Arrays$ArrayList".equals(clazz.getName())) {
                mate = new ArrayList();
            } else if (clazz == Object.class && !useMapsLocal) {
                if (this.unknownClass == null) {
                    mate = new JsonObject();
                    ((JsonObject)mate).type = Map.class.getName();
                } else {
                    if (!(this.unknownClass instanceof String)) throw new JsonIoException("Unable to determine object type at column: " + jsonObj.col + ", line: " + jsonObj.line + ", content: " + jsonObj);
                    mate = Resolver.newInstance(MetaUtils.classForName(((String)this.unknownClass).trim()), jsonObj);
                }
            } else {
                mate = Resolver.newInstance(clazz, jsonObj);
            }
        }
        jsonObj.target = mate;
        return jsonObj.target;
    }

    protected JsonObject getReferencedObj(Long ref) {
        JsonObject refObject = this.reader.getObjectsRead().get(ref);
        if (refObject == null) {
            throw new JsonIoException("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
        }
        return refObject;
    }

    protected JsonReader.JsonClassReaderBase getCustomReader(Class c) {
        JsonReader.JsonClassReaderBase readerRef;
        JsonReader.JsonClassReaderBase reader = (JsonReader.JsonClassReaderBase)this.readerCache.get(c);
        if (reader == null && (readerRef = this.readerCache.putIfAbsent(c, reader = this.forceGetCustomReader(c))) != null) {
            reader = readerRef;
        }
        return reader == nullReader ? null : reader;
    }

    private JsonReader.JsonClassReaderBase forceGetCustomReader(Class c) {
        JsonReader.JsonClassReaderBase closestReader = nullReader;
        int minDistance = Integer.MAX_VALUE;
        for (Map.Entry<Class, JsonReader.JsonClassReaderBase> entry : this.getReaders().entrySet()) {
            Class clz = entry.getKey();
            if (clz == c) {
                return entry.getValue();
            }
            int distance = MetaUtils.getDistance(clz, c);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestReader = entry.getValue();
        }
        return closestReader;
    }

    private Object getEnum(Class c, JsonObject jsonObj) {
        try {
            return Enum.valueOf(c, (String)jsonObj.get("name"));
        }
        catch (Exception exception) {
            return Enum.valueOf(c, (String)jsonObj.get("java.lang.Enum.name"));
        }
    }

    private Object getEnumSet(Class c, JsonObject jsonObj) {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return Resolver.newInstance(c, jsonObj);
        }
        JsonObject item = (JsonObject)items[0];
        String type = item.getType();
        Class enumClass = MetaUtils.classForName(type);
        EnumSet<Enum> enumSet = null;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectItem = objectArray[n2];
            item = (JsonObject)objectItem;
            Enum enumItem = (Enum)this.getEnum(enumClass, item);
            if (enumSet == null) {
                enumSet = EnumSet.of(enumItem);
            } else {
                enumSet.add(enumItem);
            }
            ++n2;
        }
        return enumSet;
    }

    protected void patchUnresolvedReferences() {
        Iterator<UnresolvedReference> i = this.unresolvedRefs.iterator();
        while (i.hasNext()) {
            UnresolvedReference ref = i.next();
            Object objToFix = ((UnresolvedReference)ref).referencingObj.target;
            JsonObject objReferenced = this.reader.getObjectsRead().get(ref.refId);
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List list = (List)objToFix;
                    list.set(ref.index, objReferenced.target);
                } else if (objToFix instanceof Collection) {
                    Collection col = (Collection)objToFix;
                    col.add(objReferenced.target);
                } else {
                    Array.set(objToFix, ref.index, objReferenced.target);
                }
            } else {
                Field field = MetaUtils.getField(objToFix.getClass(), ref.field);
                if (field != null) {
                    try {
                        field.set(objToFix, objReferenced.target);
                    }
                    catch (Exception e) {
                        throw new JsonIoException("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
                    }
                }
            }
            i.remove();
        }
    }

    protected void rehashMaps() {
        boolean useMapsLocal = this.useMaps;
        for (Object[] mapPieces : this.prettyMaps) {
            Object[] javaValues;
            Object[] javaKeys;
            Map<Object, Object> map;
            JsonObject jObj = (JsonObject)mapPieces[0];
            if (useMapsLocal) {
                map = jObj;
                javaKeys = (Object[])jObj.remove("@keys");
                javaValues = (Object[])jObj.remove("@items");
            } else {
                map = (Map)jObj.target;
                javaKeys = (Object[])mapPieces[1];
                javaValues = (Object[])mapPieces[2];
                jObj.clear();
            }
            int j = 0;
            while (javaKeys != null && j < javaKeys.length) {
                map.put(javaKeys[j], javaValues[j]);
                ++j;
            }
        }
    }

    public static Object newInstance(Class c) {
        return JsonReader.newInstance(c);
    }

    public static Object newInstance(Class c, JsonObject jsonObject) {
        return JsonReader.newInstance(c, jsonObject);
    }

    protected Map<Class, JsonReader.JsonClassReaderBase> getReaders() {
        return this.reader.readers;
    }

    protected boolean notCustom(Class cls) {
        return this.reader.notCustom.contains(cls);
    }

    static class NullClass
    implements JsonReader.JsonClassReaderBase {
        NullClass() {
        }
    }

    protected static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        protected UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        protected UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }
}

