/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIo;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.factory.ArrayFactory;
import com.cedarsoftware.io.factory.ConvertableFactory;
import com.cedarsoftware.io.factory.EnumClassFactory;
import com.cedarsoftware.io.factory.ThrowableFactory;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.io.reflect.InjectorFactory;
import com.cedarsoftware.io.reflect.factories.MethodInjectorFactory;
import com.cedarsoftware.io.reflect.filters.FieldFilter;
import com.cedarsoftware.io.reflect.filters.field.EnumFieldFilter;
import com.cedarsoftware.io.reflect.filters.field.StaticFieldFilter;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.ConverterOptions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ReadOptionsBuilder {
    private static final Map<Class<?>, JsonReader.JsonClassReader> BASE_READERS = new ConcurrentHashMap();
    private static final Map<Class<?>, JsonReader.ClassFactory> BASE_CLASS_FACTORIES = new ConcurrentHashMap();
    private static final Map<String, String> BASE_ALIAS_MAPPINGS = new ConcurrentHashMap<String, String>();
    private static final Map<Class<?>, Class<?>> BASE_COERCED_TYPES = new ConcurrentHashMap();
    private static final Set<Class<?>> BASE_NON_REFS = ConcurrentHashMap.newKeySet();
    private static final Map<Class<?>, Map<String, String>> BASE_NONSTANDARD_SETTERS = new ConcurrentHashMap();
    private static final Map<Class<?>, Set<String>> BASE_NOT_IMPORTED_FIELDS = new ConcurrentHashMap();
    private final DefaultReadOptions options = new DefaultReadOptions();

    public ReadOptionsBuilder() {
        BASE_ALIAS_MAPPINGS.forEach((srcType, alias) -> this.options.aliasTypeNames.put(alias, srcType));
        this.options.injectorFactories.add(new MethodInjectorFactory());
        this.options.fieldFilters.add(new StaticFieldFilter());
        this.options.fieldFilters.add(new EnumFieldFilter());
        this.options.coercedTypes.putAll(BASE_COERCED_TYPES);
        this.options.customReaderClasses.putAll(BASE_READERS);
        this.options.classFactoryMap.putAll(BASE_CLASS_FACTORIES);
        this.options.nonRefClasses.addAll(BASE_NON_REFS);
        this.options.nonStandardSetters.putAll(BASE_NONSTANDARD_SETTERS);
        this.options.excludedFieldNames.putAll(WriteOptionsBuilder.BASE_EXCLUDED_FIELD_NAMES);
        this.options.fieldsNotImported.putAll(BASE_NOT_IMPORTED_FIELDS);
        this.withExtendedAliases();
    }

    public ReadOptionsBuilder(ReadOptions copy) {
        this();
        if (copy != null) {
            DefaultReadOptions other = (DefaultReadOptions)copy;
            this.options.converterOptions = other.converterOptions;
            this.options.allowNanAndInfinity = other.allowNanAndInfinity;
            this.options.closeStream = other.closeStream;
            this.options.failOnUnknownType = other.failOnUnknownType;
            this.options.maxDepth = other.maxDepth;
            this.options.returnType = other.returnType;
            this.options.unknownTypeClass = other.unknownTypeClass;
            this.options.missingFieldHandler = other.missingFieldHandler;
            this.options.decimalType = other.decimalType;
            this.options.integerType = other.integerType;
            this.options.aliasTypeNames.clear();
            this.options.aliasTypeNames.putAll(other.aliasTypeNames);
            this.options.injectorFactories.clear();
            this.options.injectorFactories.addAll(other.injectorFactories);
            this.options.fieldFilters.clear();
            this.options.fieldFilters.addAll(other.fieldFilters);
            this.options.excludedFieldNames.clear();
            this.options.excludedFieldNames.putAll(other.excludedFieldNames);
            this.options.fieldsNotImported.clear();
            this.options.fieldsNotImported.putAll(other.fieldsNotImported);
            this.options.nonStandardSetters.clear();
            this.options.nonStandardSetters.putAll(other.nonStandardSetters);
            this.options.coercedTypes.clear();
            this.options.coercedTypes.putAll(other.coercedTypes);
            this.options.customReaderClasses.clear();
            this.options.customReaderClasses.putAll(other.customReaderClasses);
            this.options.notCustomReadClasses.clear();
            this.options.notCustomReadClasses.addAll(other.notCustomReadClasses);
            this.options.classFactoryMap.clear();
            this.options.classFactoryMap.putAll(other.classFactoryMap);
            this.options.nonRefClasses.clear();
            this.options.nonRefClasses.addAll(other.nonRefClasses);
        }
    }

    public static void addPermanentClassFactory(Class<?> sourceClass, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(sourceClass, factory);
    }

    @Deprecated
    public static void assignInstantiator(Class<?> classToCreate, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(classToCreate, factory);
    }

    public static void addPermanentCoercedType(Class<?> sourceClass, Class<?> destinationClass) {
        BASE_COERCED_TYPES.put(sourceClass, destinationClass);
    }

    public static void addPermanentAlias(Class<?> sourceClass, String alias) {
        BASE_ALIAS_MAPPINGS.put(sourceClass.getName(), alias);
    }

    public static void addPermanentReader(Class<?> c, JsonReader.JsonClassReader reader) {
        BASE_READERS.put(c, reader);
    }

    public static void addPermanentNonReferenceableClass(Class<?> clazz) {
        BASE_NON_REFS.add(clazz);
    }

    public static void addPermanentNotImportedField(Class<?> clazz, String fieldName) {
        BASE_NOT_IMPORTED_FIELDS.computeIfAbsent(clazz, k -> ConcurrentHashMap.newKeySet()).add(fieldName);
    }

    public static void addPermanentNonStandardSetter(Class<?> clazz, String fieldName, String alias) {
        BASE_NONSTANDARD_SETTERS.computeIfAbsent(clazz, k -> new ConcurrentHashMap()).put(fieldName, alias);
    }

    public ReadOptions build() {
        this.options.clearCaches();
        this.options.aliasTypeNames = Collections.unmodifiableMap(this.options.aliasTypeNames);
        this.options.coercedTypes = Collections.unmodifiableMap(this.options.coercedTypes);
        this.options.notCustomReadClasses = Collections.unmodifiableSet(this.options.notCustomReadClasses);
        this.options.customReaderClasses = Collections.unmodifiableMap(this.options.customReaderClasses);
        this.options.classFactoryMap = Collections.unmodifiableMap(this.options.classFactoryMap);
        this.options.nonRefClasses = Collections.unmodifiableSet(this.options.nonRefClasses);
        this.options.converterOptions.converterOverrides = Collections.unmodifiableMap(this.options.converterOptions.converterOverrides);
        this.options.converterOptions.customOptions = Collections.unmodifiableMap(this.options.converterOptions.customOptions);
        this.options.excludedFieldNames = Collections.unmodifiableMap(this.options.excludedFieldNames);
        this.options.fieldsNotImported = Collections.unmodifiableMap(this.options.fieldsNotImported);
        this.options.fieldFilters = Collections.unmodifiableList(this.options.fieldFilters);
        this.options.injectorFactories = Collections.unmodifiableList(this.options.injectorFactories);
        this.options.nonStandardSetters = Collections.unmodifiableMap(this.options.nonStandardSetters);
        this.options.customOptions = Collections.unmodifiableMap(this.options.customOptions);
        return this.options;
    }

    public ReadOptionsBuilder addNotCustomReaderClass(Class<?> notCustomClass) {
        this.options.notCustomReadClasses.add(notCustomClass);
        return this;
    }

    public ReadOptionsBuilder replaceNotCustomReaderClasses(Collection<Class<?>> notCustomClasses) {
        this.options.notCustomReadClasses.clear();
        this.options.notCustomReadClasses.addAll(notCustomClasses);
        return this;
    }

    public ReadOptionsBuilder addConverterOverride(Class<?> source, Class<?> target, Convert<?> conversionFunction) {
        source = ClassUtilities.toPrimitiveWrapperClass(source);
        target = ClassUtilities.toPrimitiveWrapperClass(target);
        this.options.converterOptions.converterOverrides.put(new AbstractMap.SimpleImmutableEntry<Class, Class>(source, target), conversionFunction);
        return this;
    }

    public ReadOptionsBuilder replaceCustomReaderClasses(Map<? extends Class<?>, ? extends JsonReader.JsonClassReader> customReaderClasses) {
        this.options.customReaderClasses.clear();
        this.options.customReaderClasses.putAll(customReaderClasses);
        return this;
    }

    public ReadOptionsBuilder addCustomReaderClass(Class<?> clazz, JsonReader.JsonClassReader customReader) {
        this.options.customReaderClasses.put(clazz, customReader);
        return this;
    }

    public ReadOptionsBuilder replaceClassFactories(Map<Class<?>, ? extends JsonReader.ClassFactory> factories) {
        this.options.classFactoryMap.clear();
        this.options.classFactoryMap.putAll(factories);
        return this;
    }

    public ReadOptionsBuilder addClassFactory(Class<?> clazz, JsonReader.ClassFactory factory) {
        this.options.classFactoryMap.put(clazz, factory);
        return this;
    }

    public ReadOptionsBuilder returnAsNativeJsonObjects() {
        this.options.returnType = ReadOptions.ReturnType.JSON_OBJECTS;
        return this;
    }

    public ReadOptionsBuilder returnAsJavaObjects() {
        this.options.returnType = ReadOptions.ReturnType.JAVA_OBJECTS;
        return this;
    }

    public ReadOptionsBuilder floatPointDouble() {
        this.options.decimalType = ReadOptions.Decimals.DOUBLE;
        return this;
    }

    public ReadOptionsBuilder floatPointBigDecimal() {
        this.options.decimalType = ReadOptions.Decimals.BIG_DECIMAL;
        return this;
    }

    public ReadOptionsBuilder floatPointBoth() {
        this.options.decimalType = ReadOptions.Decimals.BOTH;
        return this;
    }

    public ReadOptionsBuilder integerTypeLong() {
        this.options.integerType = ReadOptions.Integers.LONG;
        return this;
    }

    public ReadOptionsBuilder integerTypeBigInteger() {
        this.options.integerType = ReadOptions.Integers.BOTH;
        return this;
    }

    public ReadOptionsBuilder integerTypeBoth() {
        this.options.integerType = ReadOptions.Integers.BOTH;
        return this;
    }

    public ReadOptionsBuilder classLoader(ClassLoader classLoader) {
        Convention.throwIfNull((Object)classLoader, (String)"classloader cannot be null");
        this.options.converterOptions.classloader = classLoader;
        return this;
    }

    public ReadOptionsBuilder failOnUnknownType(boolean fail) {
        this.options.failOnUnknownType = fail;
        return this;
    }

    public ReadOptionsBuilder unknownTypeClass(Class<?> c) {
        this.options.unknownTypeClass = c;
        return this;
    }

    public ReadOptionsBuilder closeStream(boolean closeStream) {
        this.options.closeStream = closeStream;
        return this;
    }

    public ReadOptionsBuilder maxDepth(int maxDepth) {
        this.options.maxDepth = maxDepth;
        return this;
    }

    public ReadOptionsBuilder allowNanAndInfinity(boolean allowNanAndInfinity) {
        this.options.allowNanAndInfinity = allowNanAndInfinity;
        return this;
    }

    public ReadOptionsBuilder aliasTypeNames(Map<String, String> aliasTypeNames) {
        aliasTypeNames.forEach(this::addUniqueAlias);
        return this;
    }

    public ReadOptionsBuilder aliasTypeName(Class<?> type, String alias) {
        this.addUniqueAlias(type.getName(), alias);
        return this;
    }

    public ReadOptionsBuilder aliasTypeName(String typeName, String alias) {
        this.addUniqueAlias(typeName, alias);
        return this;
    }

    public ReadOptionsBuilder withExtendedAliases() {
        Map<String, String> extendedAliases = MetaUtils.loadMapDefinition("config/extendedAliases.txt");
        extendedAliases.forEach((key, value) -> this.options.aliasTypeNames.putIfAbsent(value, key));
        return this;
    }

    public ReadOptionsBuilder setLocale(Locale locale) {
        this.options.converterOptions.locale = locale;
        return this;
    }

    public ReadOptionsBuilder setCharset(Charset charset) {
        this.options.converterOptions.charset = charset;
        return this;
    }

    public ReadOptionsBuilder setZoneId(ZoneId zoneId) {
        this.options.converterOptions.zoneId = zoneId;
        return this;
    }

    public ReadOptionsBuilder setTrueCharacter(Character ch) {
        this.options.converterOptions.trueChar = ch;
        return this;
    }

    public ReadOptionsBuilder setFalseCharacter(Character ch) {
        this.options.converterOptions.falseChar = ch;
        return this;
    }

    public ReadOptionsBuilder addCustomOption(String key, Object value) {
        if (key == null) {
            throw new JsonIoException("Custom option key must not be null.");
        }
        if (value == null) {
            this.options.customOptions.remove(key);
        } else {
            this.options.customOptions.put(key, value);
        }
        return this;
    }

    private void addUniqueAlias(String type, String alias) {
        String existType;
        Class clazz = ClassUtilities.forName((String)type, (ClassLoader)this.options.getClassLoader());
        if (clazz == null) {
            System.out.println("Unknown class: " + type + " cannot be added to the ReadOptions alias map.");
        }
        if ((existType = (String)this.options.aliasTypeNames.get(alias)) != null) {
            System.out.println("Non-unique ReadOptions alias: " + alias + " attempted assign to: " + type + ", but is already assigned to: " + existType);
        }
        this.options.aliasTypeNames.put(alias, type);
    }

    public ReadOptionsBuilder coerceClass(String sourceClassName, Class<?> destClass) {
        Class clazz = ClassUtilities.forName((String)sourceClassName, (ClassLoader)this.options.getClassLoader());
        if (clazz != null) {
            this.options.coercedTypes.put(clazz, destClass);
        }
        return this;
    }

    public ReadOptionsBuilder missingFieldHandler(JsonReader.MissingFieldHandler missingFieldHandler) {
        this.options.missingFieldHandler = missingFieldHandler;
        return this;
    }

    public ReadOptionsBuilder addNonReferenceableClass(Class<?> clazz) {
        this.options.nonRefClasses.add(clazz);
        return this;
    }

    private static void loadBaseClassFactory() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/classFactory.txt");
        ClassLoader classLoader = ReadOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String factoryClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                System.out.println("Skipping class: " + className + " not defined in JVM, but listed in resources/classFactories.txt");
                continue;
            }
            if (factoryClassName.equalsIgnoreCase("Convertable")) {
                ReadOptionsBuilder.addPermanentClassFactory(clazz, new ConvertableFactory(clazz));
                continue;
            }
            if (factoryClassName.equalsIgnoreCase("ArrayFactory")) {
                ReadOptionsBuilder.addPermanentClassFactory(clazz, new ArrayFactory(clazz));
                continue;
            }
            try {
                Class factoryClass = ClassUtilities.forName((String)factoryClassName, (ClassLoader)classLoader);
                if (factoryClass == null) {
                    System.out.println("Skipping class: " + factoryClassName + " not defined in JVM, but listed in resources/classFactories.txt, as factory for: " + className);
                    continue;
                }
                ReadOptionsBuilder.addPermanentClassFactory(clazz, (JsonReader.ClassFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                System.out.println("Unable to create JsonReader.ClassFactory class: " + factoryClassName + ", a factory class for: " + className + ", listed in resources/classFactories.txt");
            }
        }
    }

    private static void loadBaseReaders() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/customReaders.txt");
        ClassLoader classLoader = ReadOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String readerClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz != null) {
                Class customReaderClass = ClassUtilities.forName((String)readerClassName, (ClassLoader)classLoader);
                try {
                    ReadOptionsBuilder.addPermanentReader(clazz, (JsonReader.JsonClassReader)customReaderClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    System.out.println("Note: could not instantiate (custom JsonClassReader class): " + readerClassName + " from resources/customReaders.txt");
                }
                continue;
            }
            System.out.println("Class: " + className + " not defined in JVM, but listed in resources/customReaders.txt");
        }
    }

    private static void loadBaseCoercedTypes() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/coercedTypes.txt");
        ClassLoader classLoader = ReadOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String srcClassName = entry.getKey();
            String destClassName = entry.getValue();
            Class srcType = ClassUtilities.forName((String)srcClassName, (ClassLoader)classLoader);
            if (srcType == null) {
                System.out.println("Skipping class coercion for source class: " + srcClassName + " (not found) to: " + destClassName + ", listed in resources/coercedTypes.txt");
                continue;
            }
            Class destType = ClassUtilities.forName((String)destClassName, (ClassLoader)classLoader);
            if (destType == null) {
                System.out.println("Skipping class coercion for source class: " + srcClassName + " cannot be mapped to: " + destClassName + " (not found), listed in resources/coercedTypes.txt");
                continue;
            }
            ReadOptionsBuilder.addPermanentCoercedType(srcType, destType);
        }
    }

    static Map<Class<?>, Set<String>> loadClassToSetOfStrings(String fileName) {
        Map<String, String> map = MetaUtils.loadMapDefinition(fileName);
        LinkedHashMap builtMap = new LinkedHashMap();
        ClassLoader classLoader = MetaUtils.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) continue;
            ConcurrentHashMap.KeySetView resultSet = ConcurrentHashMap.newKeySet();
            resultSet.addAll(MetaUtils.commaSeparatedStringToSet(entry.getValue()));
            builtMap.put(clazz, resultSet);
        }
        return builtMap;
    }

    static Map<Class<?>, Map<String, String>> loadClassToFieldAliasNameMapping(String fileName) {
        Map<String, String> map = MetaUtils.loadMapDefinition(fileName);
        ConcurrentHashMap nonStandardMapping = new ConcurrentHashMap();
        ClassLoader classLoader = WriteOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String mappings = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                System.out.println("Class: " + className + " not defined in the JVM");
                continue;
            }
            Map mapping = nonStandardMapping.computeIfAbsent(clazz, c -> new ConcurrentHashMap());
            Set<String> pairs = MetaUtils.commaSeparatedStringToSet(mappings);
            for (String pair : pairs) {
                String[] fieldAlias = pair.split(":");
                mapping.put(fieldAlias[0], fieldAlias[1]);
            }
        }
        return nonStandardMapping;
    }

    private static void loadBaseNonRefs() {
        Set<String> set = MetaUtils.loadSetDefinition("config/nonRefs.txt");
        ClassLoader classLoader = WriteOptions.class.getClassLoader();
        for (String className : set) {
            Class loadedClass = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (loadedClass != null) {
                ReadOptionsBuilder.addPermanentNonReferenceableClass(loadedClass);
                continue;
            }
            throw new JsonIoException("Class: " + className + " is undefined.");
        }
    }

    static void loadBaseAliasMappings(AliasApplier aliasApplier) {
        Map<String, String> aliasMappings = MetaUtils.loadMapDefinition("config/aliases.txt");
        for (Map.Entry<String, String> entry : aliasMappings.entrySet()) {
            String className = entry.getKey();
            String alias = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)JsonIo.class.getClassLoader());
            if (clazz == null) {
                System.out.println("Could not find class: " + className + " which has associated alias value: " + alias + " config/aliases.txt");
                continue;
            }
            aliasApplier.apply(clazz, alias);
        }
    }

    private static void loadBaseFieldsNotImported() {
        Map<Class<?>, Set<String>> allFieldsNotImported = ReadOptionsBuilder.loadClassToSetOfStrings("config/fieldsNotImported.txt");
        for (Map.Entry<Class<?>, Set<String>> entry : allFieldsNotImported.entrySet()) {
            Class<?> clazz = entry.getKey();
            Set<String> notImportedFields = entry.getValue();
            for (String notImportedField : notImportedFields) {
                ReadOptionsBuilder.addPermanentNotImportedField(clazz, notImportedField);
            }
        }
    }

    private static void loadBaseNonStandardSetters() {
        Map<Class<?>, Map<String, String>> allNonStandardSetters = ReadOptionsBuilder.loadClassToFieldAliasNameMapping("config/nonStandardSetters.txt");
        for (Map.Entry<Class<?>, Map<String, String>> entry : allNonStandardSetters.entrySet()) {
            Class<?> clazz = entry.getKey();
            Map<String, String> nonStandardSetters = entry.getValue();
            for (Map.Entry<String, String> stringEntry : nonStandardSetters.entrySet()) {
                ReadOptionsBuilder.addPermanentNonStandardSetter(clazz, stringEntry.getKey(), stringEntry.getValue());
            }
        }
    }

    static {
        ReadOptionsBuilder.loadBaseClassFactory();
        ReadOptionsBuilder.loadBaseReaders();
        ReadOptionsBuilder.loadBaseAliasMappings(ReadOptionsBuilder::addPermanentAlias);
        ReadOptionsBuilder.loadBaseCoercedTypes();
        ReadOptionsBuilder.loadBaseNonRefs();
        ReadOptionsBuilder.loadBaseFieldsNotImported();
        ReadOptionsBuilder.loadBaseNonStandardSetters();
    }

    static class DefaultReadOptions
    implements ReadOptions {
        private Class<?> unknownTypeClass = null;
        private boolean failOnUnknownType = true;
        private boolean closeStream = true;
        private int maxDepth = 1000;
        private JsonReader.MissingFieldHandler missingFieldHandler = null;
        private DefaultConverterOptions converterOptions = new DefaultConverterOptions();
        private ReadOptions.ReturnType returnType = ReadOptions.ReturnType.JAVA_OBJECTS;
        private ReadOptions.Decimals decimalType = ReadOptions.Decimals.DOUBLE;
        private ReadOptions.Integers integerType = ReadOptions.Integers.LONG;
        private boolean allowNanAndInfinity = false;
        private Map<String, String> aliasTypeNames = new LinkedHashMap<String, String>();
        private Map<Class<?>, Class<?>> coercedTypes = new LinkedHashMap();
        private Set<Class<?>> notCustomReadClasses = new LinkedHashSet();
        private Map<Class<?>, JsonReader.JsonClassReader> customReaderClasses = new LinkedHashMap();
        private Map<Class<?>, JsonReader.ClassFactory> classFactoryMap = new LinkedHashMap();
        private Set<Class<?>> nonRefClasses = new LinkedHashSet();
        private Map<Class<?>, Set<String>> excludedFieldNames = new LinkedHashMap();
        private Map<Class<?>, Set<String>> fieldsNotImported = new LinkedHashMap();
        private List<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
        private List<InjectorFactory> injectorFactories = new ArrayList<InjectorFactory>();
        private Map<String, Object> customOptions = new LinkedHashMap<String, Object>();
        private final Map<Class<?>, Map<String, Injector>> injectorsCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private Map<Class<?>, Map<String, String>> nonStandardSetters = new HashMap();
        private final Map<Class<?>, JsonReader.JsonClassReader> readerCache = new ConcurrentHashMap(300);
        private final JsonReader.ClassFactory throwableFactory = new ThrowableFactory();
        private final JsonReader.ClassFactory enumFactory = new EnumClassFactory();
        private final Map<Class<?>, Map<String, Field>> classMetaCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private static final NullClass nullReader = new NullClass();

        private DefaultReadOptions() {
        }

        @Override
        public boolean isAllowNanAndInfinity() {
            return this.allowNanAndInfinity;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.converterOptions.getClassLoader();
        }

        @Override
        public boolean isFailOnUnknownType() {
            return this.failOnUnknownType;
        }

        @Override
        public Class<?> getUnknownTypeClass() {
            return this.unknownTypeClass;
        }

        @Override
        public boolean isCloseStream() {
            return this.closeStream;
        }

        @Override
        public int getMaxDepth() {
            return this.maxDepth;
        }

        @Override
        public String getTypeNameAlias(String typeName) {
            String alias = this.aliasTypeNames.get(typeName);
            return alias == null ? typeName : alias;
        }

        @Override
        public boolean isClassCoerced(String className) {
            return this.coercedTypes.containsKey(className);
        }

        @Override
        public Class<?> getCoercedClass(Class<?> c) {
            return this.coercedTypes.get(c);
        }

        @Override
        public JsonReader.MissingFieldHandler getMissingFieldHandler() {
            return this.missingFieldHandler;
        }

        @Override
        public boolean isNonReferenceableClass(Class<?> clazz) {
            return this.nonRefClasses.contains(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || clazz.isEnum();
        }

        @Override
        public boolean isNotCustomReaderClass(Class<?> clazz) {
            return this.notCustomReadClasses.contains(clazz);
        }

        @Override
        public boolean isCustomReaderClass(Class<?> clazz) {
            return this.customReaderClasses.containsKey(clazz);
        }

        @Override
        public JsonReader.ClassFactory getClassFactory(Class<?> c) {
            if (c == null) {
                return null;
            }
            JsonReader.ClassFactory factory = this.classFactoryMap.get(c);
            if (factory != null) {
                return factory;
            }
            if (Throwable.class.isAssignableFrom(c)) {
                return this.throwableFactory;
            }
            Optional<Class<?>> optional = MetaUtils.getClassIfEnum(c);
            if (optional.isPresent()) {
                return this.enumFactory;
            }
            return null;
        }

        @Override
        public JsonReader.JsonClassReader getCustomReader(Class<?> c) {
            JsonReader.JsonClassReader reader = this.readerCache.computeIfAbsent(c, cls -> MetaUtils.findClosest(c, this.customReaderClasses, nullReader));
            return reader == nullReader ? null : reader;
        }

        @Override
        public boolean isReturningJsonObjects() {
            return this.returnType == ReadOptions.ReturnType.JSON_OBJECTS;
        }

        @Override
        public boolean isReturningJavaObjects() {
            return this.returnType == ReadOptions.ReturnType.JAVA_OBJECTS;
        }

        @Override
        public boolean isFloatingPointDouble() {
            return this.decimalType == ReadOptions.Decimals.DOUBLE;
        }

        @Override
        public boolean isFloatingPointBigDecimal() {
            return this.decimalType == ReadOptions.Decimals.BIG_DECIMAL;
        }

        @Override
        public boolean isFloatingPointBoth() {
            return this.decimalType == ReadOptions.Decimals.BOTH;
        }

        @Override
        public boolean isIntegerTypeLong() {
            return this.integerType == ReadOptions.Integers.LONG;
        }

        @Override
        public boolean isIntegerTypeBigInteger() {
            return this.integerType == ReadOptions.Integers.BIG_INTEGER;
        }

        @Override
        public boolean isIntegerTypeBoth() {
            return this.integerType == ReadOptions.Integers.BOTH;
        }

        @Override
        public Map<String, Injector> getDeepInjectorMap(Class<?> classToTraverse) {
            if (classToTraverse == null) {
                return Collections.emptyMap();
            }
            return this.injectorsCache.computeIfAbsent(classToTraverse, this::buildInjectors);
        }

        @Override
        public void clearCaches() {
            this.injectorsCache.clear();
        }

        private Map<String, Injector> buildInjectors(Class<?> c) {
            Map<String, Field> fields = this.getDeepDeclaredFields(c);
            LinkedHashMap<String, Injector> injectors = new LinkedHashMap<String, Injector>(fields.size());
            for (Map.Entry<String, Field> entry : fields.entrySet()) {
                String fieldName;
                Field field = entry.getValue();
                Injector injector = this.findInjector(field, fieldName = entry.getKey());
                if (injector == null) {
                    injector = Injector.create(field, fieldName);
                }
                if (injector == null) continue;
                injectors.put(fieldName, injector);
            }
            return injectors;
        }

        private Injector findInjector(Field field, String key) {
            for (InjectorFactory factory : this.injectorFactories) {
                try {
                    Injector injector = factory.createInjector(field, this.nonStandardSetters, key);
                    if (injector == null) continue;
                    return injector;
                }
                catch (Exception exception) {
                }
            }
            return null;
        }

        @Override
        public Map<String, Field> getDeepDeclaredFields(Class<?> c) {
            return this.classMetaCache.computeIfAbsent(c, this::buildDeepFieldMap);
        }

        @Override
        public ConverterOptions getConverterOptions() {
            return this.converterOptions;
        }

        @Override
        public Object getCustomOption(String key) {
            return this.customOptions.get(key);
        }

        public Map<String, Field> buildDeepFieldMap(Class<?> clazz) {
            Convention.throwIfNull(clazz, (String)"class cannot be null");
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            HashSet<String> excludedFields = new HashSet<String>();
            for (Class<?> curr = clazz; curr != null; curr = curr.getSuperclass()) {
                Set<String> notImported;
                Field[] fields = curr.getDeclaredFields();
                Set<String> excludedForClass = this.excludedFieldNames.get(curr);
                if (excludedForClass != null) {
                    excludedFields.addAll(excludedForClass);
                }
                if ((notImported = this.fieldsNotImported.get(curr)) != null) {
                    excludedFields.addAll(notImported);
                }
                for (Field field : fields) {
                    String name;
                    if (Modifier.isStatic(field.getModifiers()) || excludedFields.contains(field.getName()) || this.fieldIsFiltered(field) || map.putIfAbsent(name = field.getName(), field) == null) continue;
                    map.put(field.getDeclaringClass().getSimpleName() + '.' + name, field);
                }
            }
            return Collections.unmodifiableMap(map);
        }

        private boolean fieldIsFiltered(Field field) {
            for (FieldFilter filter : this.fieldFilters) {
                if (!filter.filter(field)) continue;
                return true;
            }
            return false;
        }

        private static final class NullClass
        implements JsonReader.JsonClassReader {
            private NullClass() {
            }
        }
    }

    public static class DefaultConverterOptions
    implements ConverterOptions {
        private ZoneId zoneId = ZoneId.systemDefault();
        private Locale locale = Locale.getDefault();
        private Charset charset = StandardCharsets.UTF_8;
        private ClassLoader classloader = DefaultConverterOptions.class.getClassLoader();
        private Character trueChar = CommonValues.CHARACTER_ONE;
        private Character falseChar = CommonValues.CHARACTER_ZERO;
        private Map<String, Object> customOptions = new ConcurrentHashMap<String, Object>();
        private Map<Map.Entry<Class<?>, Class<?>>, Convert<?>> converterOverrides = new ConcurrentHashMap(100, 0.8f);

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public ClassLoader getClassLoader() {
            return this.classloader;
        }

        public Character trueChar() {
            return this.trueChar;
        }

        public Character falseChar() {
            return this.falseChar;
        }

        public Map<Map.Entry<Class<?>, Class<?>>, Convert<?>> getConverterOverrides() {
            return this.converterOverrides;
        }

        public <T> T getCustomOption(String name) {
            return (T)this.customOptions.get(name);
        }
    }

    @FunctionalInterface
    public static interface AliasApplier {
        public void apply(Class<?> var1, String var2);
    }
}

