/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.reflect;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.StringUtilities;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class Injector {
    private final Field field;
    private final String displayName;
    private final String uniqueFieldName;
    private MethodHandle injector;

    public Injector(Field field, MethodHandle handle, String uniqueFieldName, String displayName) {
        this.field = field;
        this.displayName = displayName;
        this.uniqueFieldName = uniqueFieldName;
        this.injector = handle;
    }

    public static Injector create(Field field, String uniqueFieldName) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            try {
                field.setAccessible(true);
            }
            catch (Exception ioe) {
                return null;
            }
        }
        try {
            MethodHandle handle = MethodHandles.lookup().unreflectSetter(field);
            return new Injector(field, handle, uniqueFieldName, field.getName());
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
    }

    public static Injector create(Field field, String methodName, String uniqueFieldName) {
        try {
            MethodType methodType = MethodType.methodType(Void.class, field.getType());
            MethodHandle handle = MethodHandles.publicLookup().findVirtual(field.getDeclaringClass(), methodName, methodType);
            return new Injector(field, handle, uniqueFieldName, methodName);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            return null;
        }
    }

    public void inject(Object object, Object value) {
        if (object == null) {
            throw new JsonIoException("Attempting to set field: " + this.getName() + " on null object.");
        }
        try {
            this.injector.invoke(object, value);
        }
        catch (ClassCastException e) {
            String msg = e.getMessage();
            if (StringUtilities.hasContent((String)msg) && msg.contains("LinkedHashMap")) {
                throw new JsonIoException("Unable to set field: " + this.getName() + " using " + this.getDisplayName() + ". If using 'withExtendedAliases()' option, make it is set on both ReadOptions and WriteOptions.", e);
            }
            try {
                this.injector.invoke(object, Converter.convert((Object)value, this.field.getType()));
            }
            catch (Throwable ex) {
                throw new JsonIoException("Unable to set field: " + this.getName() + " using " + this.getDisplayName() + ". Getting a ClassCastExcepton.", e);
            }
        }
        catch (Throwable t) {
            throw new JsonIoException("Unable to set field: " + this.getName() + " using " + this.getDisplayName(), t);
        }
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public String getName() {
        return this.field.getName();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUniqueFieldName() {
        return this.uniqueFieldName;
    }
}

