/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SingletonList<T>
implements List<T> {
    private static final Object UNINITIALIZED = new Object();
    private T element = UNINITIALIZED;

    public SingletonList(T element) {
        this.element = element == null ? UNINITIALIZED : element;
    }

    public SingletonList() {
    }

    @Override
    public int size() {
        return this.element == UNINITIALIZED ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.element == UNINITIALIZED;
    }

    @Override
    public boolean contains(Object o) {
        return this.element != UNINITIALIZED && this.element.equals(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this.element == UNINITIALIZED) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.element;
        }
        return objectArray;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        if (this.element == UNINITIALIZED) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        if (a.length > 0) {
            a[0] = this.element;
            if (a.length > 1) {
                a[1] = null;
            }
            return a;
        }
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
        newArray[0] = this.element;
        return newArray;
    }

    @Override
    public boolean add(T t) {
        if (this.element == UNINITIALIZED) {
            this.element = t;
            return true;
        }
        throw new UnsupportedOperationException("Cannot add item to singleton list");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove item from singleton list");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() == 1) {
            return this.contains(c.iterator().next());
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Cannot add items to SingletonList");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Cannot add items to SingletonList");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from SingletonList");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items to SingletonList");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear SingletonList");
    }

    @Override
    public T get(int index) {
        if (index != 0 || this.element == UNINITIALIZED) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return this.element;
    }

    @Override
    public T set(int index, T element) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        T oldElement = this.element;
        this.element = element;
        return oldElement;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Cannot add items to SingletonList");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot remove items to SingletonList");
    }

    @Override
    public int indexOf(Object o) {
        return this.element != UNINITIALIZED && this.element.equals(o) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        if (index != 0 && (index != 1 || this.element == UNINITIALIZED)) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListIterator<T>(){
            private int cursor;
            {
                this.cursor = index;
            }

            @Override
            public boolean hasNext() {
                return this.cursor == 0 && SingletonList.this.element != UNINITIALIZED;
            }

            @Override
            public T next() {
                if (this.cursor != 0 || SingletonList.this.element == UNINITIALIZED) {
                    throw new NoSuchElementException();
                }
                this.cursor = 1;
                return SingletonList.this.element;
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor == 1;
            }

            @Override
            public T previous() {
                if (this.cursor != 1) {
                    throw new NoSuchElementException();
                }
                this.cursor = 0;
                return SingletonList.this.element;
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove items from SingletonList");
            }

            @Override
            public void set(T e) {
                if (this.cursor != 1) {
                    throw new IllegalStateException();
                }
                SingletonList.this.element = e;
            }

            @Override
            public void add(T e) {
                throw new UnsupportedOperationException("Cannot add items to SingletonList");
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == 0 || this.element == UNINITIALIZED) {
            return new ArrayList();
        }
        if (fromIndex != 0 || toIndex != 1) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex);
        }
        return Collections.singletonList(this.element);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        return this.size() == that.size() && this.containsAll(that);
    }

    @Override
    public int hashCode() {
        return this.element != UNINITIALIZED ? Arrays.hashCode(new Object[]{this.element}) : 1;
    }
}

