/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonParser;
import com.cedarsoftware.io.MapResolver;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ObjectResolver;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.convert.Converter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JsonReader
implements Closeable {
    private final FastReader input;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final JsonParser parser;
    static final Set<Class<?>> jsonPrimitives = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Boolean.class, AtomicBoolean.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, AtomicInteger.class, Long.TYPE, Long.class, AtomicLong.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class, String.class, StringBuffer.class, StringBuilder.class));

    protected FastReader getReader(InputStream inputStream) {
        return new FastReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), 8192, 10);
    }

    public JsonReader(InputStream input, ReadOptions readOptions) {
        this(input, readOptions, new DefaultReferenceTracker());
    }

    public JsonReader(InputStream inputStream, ReadOptions readOptions, ReferenceTracker references) {
        this.readOptions = readOptions == null ? new ReadOptionsBuilder().returnAsJavaObjects().build() : readOptions;
        Converter converter = new Converter(this.readOptions.getConverterOptions());
        this.input = this.getReader(inputStream);
        this.resolver = this.readOptions.isReturningJsonObjects() ? new MapResolver(this.readOptions, references, converter) : new ObjectResolver(this.readOptions, references, converter);
        this.parser = new JsonParser(this.input, this.resolver);
    }

    public JsonReader(ReadOptions readOptions) {
        this((InputStream)new FastByteArrayInputStream(new byte[0]), readOptions);
    }

    public <T> T readObject(Class<T> rootType) {
        Object returnValue;
        try {
            returnValue = this.parser.readValue(rootType);
            if (returnValue == null) {
                return null;
            }
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("error parsing JSON value", e);
        }
        boolean asMaps = this.readOptions.isReturningJsonObjects();
        if (returnValue instanceof JsonObject) {
            T graph = this.toJavaObjects((JsonObject)returnValue, rootType);
            return (T)(asMaps ? returnValue : graph);
        }
        if (returnValue instanceof Object[]) {
            JsonObject rootObj = new JsonObject();
            rootObj.setJavaType(Object[].class);
            rootObj.setTarget(returnValue);
            rootObj.setJsonArray((Object[])returnValue);
            T graph = this.toJavaObjects(rootObj, rootType);
            return (T)(asMaps ? returnValue : graph);
        }
        if (rootType != null) {
            if (jsonPrimitives.contains(rootType)) {
                return (T)this.resolver.getConverter().convert(returnValue, rootType);
            }
            Object graph = this.resolver.getConverter().convert(returnValue, rootType);
            if (asMaps) {
                JsonObject rootObj = new JsonObject();
                rootObj.setTarget(graph);
                return (T)rootObj;
            }
            return (T)graph;
        }
        return (T)returnValue;
    }

    protected <T> T toJavaObjects(JsonObject rootObj, Class<T> root) {
        try {
            if (root == null) {
                root = rootObj.getJavaType() == null ? Object.class : rootObj.getJavaType();
            }
            T t = this.resolver.toJavaObjects(rootObj, root);
            return t;
        }
        catch (Exception e) {
            if (this.readOptions.isCloseStream()) {
                MetaUtils.safelyIgnoreException(this::close);
            }
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
        finally {
            this.resolver.cleanup();
        }
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return msg + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol();
        }
        return msg;
    }

    static class DefaultReferenceTracker
    implements ReferenceTracker {
        final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();

        DefaultReferenceTracker() {
        }

        @Override
        public JsonObject put(Long l, JsonObject o) {
            return this.references.put(l, o);
        }

        @Override
        public void clear() {
            this.references.clear();
        }

        @Override
        public int size() {
            return this.references.size();
        }

        @Override
        public JsonObject get(JsonObject jObj) {
            if (!jObj.isReference()) {
                return jObj;
            }
            return this.get(jObj.getReferenceId());
        }

        @Override
        public JsonObject get(Long id) {
            JsonObject target = this.references.get(id);
            if (target == null) {
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            while (target.isReference()) {
                id = target.getReferenceId();
                if ((target = this.references.get(id)) != null) continue;
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            return target;
        }
    }

    public static interface JsonClassReader {
        default public Object read(Object jsonObj, Deque<JsonObject> stack, Resolver resolver) {
            throw new UnsupportedOperationException("You must implement this method and read the JSON content from jsonObj and copy the values from jsonObj to the target class, jsonObj.getTarget()");
        }
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }

    public static interface ClassFactory {
        default public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
            return MetaUtils.newInstance(resolver.getConverter(), c, null);
        }

        default public boolean isObjectFinal() {
            return false;
        }

        default public void gatherRemainingValues(Resolver resolver, JsonObject jObj, List<Object> arguments, Set<String> excludedFields) {
            Convention.throwIfNull((Object)jObj, (String)"JsonObject cannot be null");
            for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
                JsonObject sub;
                Object value;
                if (excludedFields.contains(entry.getKey().toString()) || entry.getValue() == null || !(entry.getValue() instanceof JsonObject) || (value = resolver.toJavaObjects(sub = (JsonObject)entry.getValue(), sub.getJavaType())) == null || sub.getJavaType() == null) continue;
                arguments.add(value);
            }
        }
    }
}

