/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastByteArrayOutputStream;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.ConverterOptions;
import com.cedarsoftware.util.convert.DefaultConverterOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JsonIo {
    public static final String CUSTOM_READER_MAP = "CUSTOM_READERS";
    public static final String NOT_CUSTOM_READER_MAP = "NOT_CUSTOM_READERS";
    public static final String USE_MAPS = "USE_MAPS";
    public static final String UNKNOWN_OBJECT = "UNKNOWN_OBJECT";
    public static final String FAIL_ON_UNKNOWN_TYPE = "FAIL_ON_UNKNOWN_TYPE";
    public static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    public static final String MISSING_FIELD_HANDLER = "MISSING_FIELD_HANDLER";
    public static final String CLASSLOADER = "CLASSLOADER";
    public static final String MAX_PARSE_DEPTH = "MAX_PARSE_DEPTH";
    private static final Set<String> OPTIONAL_READ_KEYS = new HashSet<String>(Arrays.asList("CUSTOM_READERS", "NOT_CUSTOM_READERS", "USE_MAPS", "UNKNOWN_OBJECT", "UNKNOWN_TYPE", "FAIL_ON_UNKNOWN_TYPE", "TYPE_NAME_MAP", "MISSING_FIELD_HANDLER", "CLASSLOADER"));
    public static final String CUSTOM_WRITER_MAP = "CUSTOM_WRITERS";
    public static final String NOT_CUSTOM_WRITER_MAP = "NOT_CUSTOM_WRITERS";
    public static final String DATE_FORMAT = "DATE_FORMAT";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String TYPE = "TYPE";
    public static final String PRETTY_PRINT = "PRETTY_PRINT";
    public static final String FIELD_SPECIFIERS = "FIELD_SPECIFIERS";
    public static final String FIELD_NAME_BLACK_LIST = "FIELD_NAME_BLACK_LIST";
    public static final String ENUM_PUBLIC_ONLY = "ENUM_PUBLIC_ONLY";
    public static final String WRITE_LONGS_AS_STRINGS = "WLAS";
    public static final String SHORT_META_KEYS = "SHORT_META_KEYS";
    public static final String SKIP_NULL_FIELDS = "SKIP_NULL";
    public static final String FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS = "FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS";
    private static final Set<String> OPTIONAL_WRITE_KEYS = new HashSet<String>(Arrays.asList("CUSTOM_WRITERS", "NOT_CUSTOM_WRITERS", "DATE_FORMAT", "TYPE", "PRETTY_PRINT", "ENUM_PUBLIC_ONLY", "WLAS", "TYPE_NAME_MAP", "SHORT_META_KEYS", "SKIP_NULL", "CLASSLOADER", "FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS"));

    private JsonIo() {
    }

    public static String toJson(Object srcObject, WriteOptions writeOptions) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        JsonWriter writer = new JsonWriter((OutputStream)out, writeOptions);
        try {
            writer.write(srcObject);
            String string = out.toString();
            writer.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException("Unable to convert object to JSON", e);
            }
        }
    }

    public static void toJson(OutputStream out, Object source, WriteOptions writeOptions) {
        Convention.throwIfNull((Object)out, (String)"OutputStream cannot be null");
        JsonWriter writer = null;
        try {
            writer = new JsonWriter(out, writeOptions);
            writer.write(source);
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object and send in JSON format to OutputStream.", e);
        }
        finally {
            if (writeOptions.isCloseStream() && writer != null) {
                writer.close();
            }
        }
    }

    public static <T> T toObjects(String json, ReadOptions readOptions, Class<T> rootType) {
        if (json == null) {
            json = "";
        }
        return JsonIo.toObjects((InputStream)new FastByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), readOptions, rootType);
    }

    public static <T> T toObjects(InputStream in, ReadOptions readOptions, Class<T> rootType) {
        Convention.throwIfNull((Object)in, (String)"InputStream cannot be null");
        JsonReader jr = null;
        try {
            T root;
            jr = new JsonReader(in, readOptions);
            T t = root = jr.readObject(rootType);
            return t;
        }
        catch (JsonIoException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JsonIoException(e);
        }
        finally {
            if (readOptions != null && readOptions.isCloseStream() && jr != null) {
                jr.close();
            }
        }
    }

    public static <T> T toObjects(JsonObject jsonObject, ReadOptions readOptions, Class<T> rootType) {
        if (readOptions == null || !readOptions.isReturningJavaObjects()) {
            readOptions = new ReadOptionsBuilder(readOptions).returnAsJavaObjects().build();
        }
        JsonReader reader = new JsonReader(readOptions);
        return reader.toJavaObjects(jsonObject, rootType);
    }

    public static String formatJson(String json, ReadOptions readOptions, WriteOptions writeOptions) {
        if (writeOptions == null || !writeOptions.isPrettyPrint()) {
            writeOptions = new WriteOptionsBuilder(writeOptions).prettyPrint(true).build();
        }
        if (readOptions == null || !readOptions.isReturningJavaObjects()) {
            readOptions = new ReadOptionsBuilder(readOptions).returnAsJavaObjects().build();
        }
        Object object = JsonIo.toObjects(json, readOptions, null);
        return JsonIo.toJson(object, writeOptions);
    }

    public static String formatJson(String json) {
        return JsonIo.formatJson(json, null, null);
    }

    public static <T> T deepCopy(Object source, ReadOptions readOptions, WriteOptions writeOptions) {
        if (source == null) {
            return null;
        }
        writeOptions = new WriteOptionsBuilder(writeOptions).showTypeInfoMinimal().shortMetaKeys(true).withExtendedAliases().build();
        readOptions = new ReadOptionsBuilder(readOptions).withExtendedAliases().build();
        String json = JsonIo.toJson(source, writeOptions);
        return (T)JsonIo.toObjects(json, readOptions, source.getClass());
    }

    public static void main(String[] args) {
        String json = JsonIo.toJson(new Converter((ConverterOptions)new DefaultConverterOptions()).getSupportedConversions(), new WriteOptionsBuilder().prettyPrint(true).showTypeInfoNever().build());
        System.out.println("json-io supported conversions (source type to target types):");
        System.out.println(json);
    }

    public static ReadOptionsBuilder getReadOptionsBuilder(Map<String, Object> optionalArgs) {
        Object notCustomReadersObject;
        Object customReaderMap;
        Object missingFieldHandler;
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        ReadOptionsBuilder builder = new ReadOptionsBuilder();
        int maxParseDepth = 1000;
        if (optionalArgs.containsKey(MAX_PARSE_DEPTH)) {
            maxParseDepth = (Integer)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(MAX_PARSE_DEPTH), Integer.TYPE);
        }
        builder.maxDepth(maxParseDepth);
        boolean useMaps = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(USE_MAPS), Boolean.TYPE);
        if (useMaps) {
            builder.returnAsNativeJsonObjects();
        } else {
            builder.returnAsJavaObjects();
        }
        boolean failOnUnknownType = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(FAIL_ON_UNKNOWN_TYPE), Boolean.TYPE);
        builder.failOnUnknownType(failOnUnknownType);
        Object loader = optionalArgs.get(CLASSLOADER);
        ClassLoader classLoader = loader instanceof ClassLoader ? (ClassLoader)loader : JsonReader.class.getClassLoader();
        builder.classLoader(classLoader);
        Object type = optionalArgs.get("UNKNOWN_TYPE");
        if (type == null) {
            type = optionalArgs.get(UNKNOWN_OBJECT);
        }
        if (type instanceof Boolean) {
            builder.failOnUnknownType(true);
        } else if (type instanceof String) {
            Class unknownType = ClassUtilities.forName((String)((String)type), (ClassLoader)classLoader);
            builder.unknownTypeClass(unknownType);
            builder.failOnUnknownType(false);
        }
        Object aliasMap = optionalArgs.get(TYPE_NAME_MAP);
        if (aliasMap instanceof Map) {
            Map aliases = (Map)aliasMap;
            for (Map.Entry entry : aliases.entrySet()) {
                builder.aliasTypeName((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((missingFieldHandler = optionalArgs.get(MISSING_FIELD_HANDLER)) instanceof JsonReader.MissingFieldHandler) {
            builder.missingFieldHandler((JsonReader.MissingFieldHandler)missingFieldHandler);
        }
        if ((customReaderMap = optionalArgs.get(CUSTOM_READER_MAP)) instanceof Map) {
            Map customReaders = (Map)customReaderMap;
            for (Map.Entry entry : customReaders.entrySet()) {
                try {
                    Class<?> clazz = Class.forName((String)entry.getKey());
                    builder.addCustomReaderClass(clazz, (JsonReader.JsonClassReader)entry.getValue());
                }
                catch (ClassNotFoundException e) {
                    String message = "Custom json-io reader class: " + (String)entry.getKey() + " not found.";
                    throw new JsonIoException(message, e);
                }
                catch (ClassCastException e) {
                    String message = "Custom json-io reader for: " + (String)entry.getKey() + " must be an instance of com.cedarsoftware.io.JsonReader.JsonClassReader.";
                    throw new JsonIoException(message, e);
                }
            }
        }
        if ((notCustomReadersObject = optionalArgs.get(NOT_CUSTOM_READER_MAP)) instanceof Iterable) {
            Iterable notCustomReaders = (Iterable)notCustomReadersObject;
            for (Class notCustomReader : notCustomReaders) {
                builder.addNotCustomReaderClass(notCustomReader);
            }
        }
        for (Map.Entry<Object, Object> entry : optionalArgs.entrySet()) {
            if (OPTIONAL_READ_KEYS.contains(entry.getKey())) continue;
            builder.addCustomOption((String)entry.getKey(), entry.getValue());
        }
        return builder;
    }

    public static WriteOptionsBuilder getWriteOptionsBuilder(Map<String, Object> optionalArgs) {
        Object object;
        Object object2;
        Object notCustomWritersObject;
        Object customWriterMap;
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        WriteOptionsBuilder builder = new WriteOptionsBuilder();
        Object dateFormat = optionalArgs.get(DATE_FORMAT);
        if (dateFormat instanceof String) {
            builder.dateTimeFormat((String)dateFormat);
        } else if (dateFormat instanceof SimpleDateFormat) {
            builder.dateTimeFormat(((SimpleDateFormat)dateFormat).toPattern());
        }
        Boolean showType = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(TYPE), Boolean.class);
        if (showType == null) {
            builder.showTypeInfoMinimal();
        } else if (showType.booleanValue()) {
            builder.showTypeInfoAlways();
        } else {
            builder.showTypeInfoNever();
        }
        boolean prettyPrint = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(PRETTY_PRINT), Boolean.TYPE);
        builder.prettyPrint(prettyPrint);
        boolean writeLongsAsStrings = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(WRITE_LONGS_AS_STRINGS), Boolean.TYPE);
        builder.writeLongsAsStrings(writeLongsAsStrings);
        boolean shortMetaKeys = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(SHORT_META_KEYS), Boolean.TYPE);
        builder.shortMetaKeys(shortMetaKeys);
        boolean skipNullFields = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(SKIP_NULL_FIELDS), Boolean.TYPE);
        builder.skipNullFields(skipNullFields);
        boolean forceMapOutputAsTwoArrays = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS), Boolean.TYPE);
        builder.forceMapOutputAsTwoArrays(forceMapOutputAsTwoArrays);
        boolean writeEnumsAsJsonObject = (Boolean)com.cedarsoftware.util.Converter.convert((Object)optionalArgs.get(ENUM_PUBLIC_ONLY), Boolean.TYPE);
        builder.writeEnumAsJsonObject(writeEnumsAsJsonObject);
        Object loader = optionalArgs.get(CLASSLOADER);
        ClassLoader classLoader = loader instanceof ClassLoader ? (ClassLoader)loader : JsonReader.class.getClassLoader();
        builder.classLoader(classLoader);
        Object aliasMap = optionalArgs.get(TYPE_NAME_MAP);
        if (aliasMap instanceof Map) {
            Map aliases = (Map)aliasMap;
            for (Map.Entry entry : aliases.entrySet()) {
                builder.aliasTypeName((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((customWriterMap = optionalArgs.get(CUSTOM_WRITER_MAP)) instanceof Map) {
            Map customWriters = (Map)customWriterMap;
            for (Map.Entry entry : customWriters.entrySet()) {
                try {
                    Class<?> clazz = Class.forName((String)entry.getKey());
                    builder.addCustomWrittenClass(clazz, (JsonWriter.JsonClassWriter)entry.getValue());
                }
                catch (ClassNotFoundException e) {
                    String string = "Custom json-io writer class: " + (String)entry.getKey() + " not found.";
                    throw new JsonIoException(string, e);
                }
                catch (ClassCastException e) {
                    String string = "Custom json-io writer for: " + (String)entry.getKey() + " must be an instance of com.cedarsoftware.io.JsonWriter.JsonClassWriter.";
                    throw new JsonIoException(string, e);
                }
            }
        }
        if ((notCustomWritersObject = optionalArgs.get(NOT_CUSTOM_WRITER_MAP)) instanceof Iterable) {
            Iterable iterable = (Iterable)notCustomWritersObject;
            for (Object notCustomWriter : iterable) {
                builder.addNotCustomWrittenClass((Class<?>)notCustomWriter);
            }
        }
        if ((object2 = optionalArgs.get(FIELD_SPECIFIERS)) instanceof Map) {
            Map map = (Map)object2;
            for (Map.Entry entry : map.entrySet()) {
                for (String fieldName : (Collection)entry.getValue()) {
                    builder.addIncludedField((Class)entry.getKey(), fieldName);
                }
            }
        }
        if ((object = optionalArgs.get(FIELD_NAME_BLACK_LIST)) instanceof Map) {
            Map excludedFields = (Map)object;
            for (Map.Entry entry : excludedFields.entrySet()) {
                for (String fieldName : (Collection)entry.getValue()) {
                    builder.addExcludedField((Class)entry.getKey(), fieldName);
                }
            }
        }
        for (Map.Entry<String, Object> entry : optionalArgs.entrySet()) {
            if (OPTIONAL_WRITE_KEYS.contains(entry.getKey())) continue;
            builder.addCustomOption(entry.getKey(), entry.getValue());
        }
        return builder;
    }
}

