/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.Writers;
import com.cedarsoftware.io.reflect.Accessor;
import com.cedarsoftware.io.reflect.AccessorFactory;
import com.cedarsoftware.io.reflect.factories.GetMethodAccessorFactory;
import com.cedarsoftware.io.reflect.factories.IsMethodAccessorFactory;
import com.cedarsoftware.io.reflect.filters.FieldFilter;
import com.cedarsoftware.io.reflect.filters.MethodFilter;
import com.cedarsoftware.io.reflect.filters.field.EnumFieldFilter;
import com.cedarsoftware.io.reflect.filters.field.StaticFieldFilter;
import com.cedarsoftware.io.reflect.filters.method.AccessorMethodFilter;
import com.cedarsoftware.io.reflect.filters.method.ModifierMethodFilter;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WriteOptionsBuilder {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final DefaultWriteOptions options = new DefaultWriteOptions();
    private static final Map<String, String> BASE_ALIAS_MAPPINGS = new ConcurrentHashMap<String, String>();
    private static final Map<Class<?>, JsonWriter.JsonClassWriter> BASE_WRITERS = new ConcurrentHashMap();
    private static final Set<Class<?>> BASE_NON_REFS = new HashSet();
    private static final Set<String> BASE_FILTERED_METHOD_NAMES = new HashSet<String>();
    static final Map<Class<?>, Set<String>> BASE_EXCLUDED_FIELD_NAMES = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, String>> BASE_NONSTANDARD_MAPPINGS = new ConcurrentHashMap();

    public WriteOptionsBuilder() {
        this.options.includedFieldNames = new HashMap();
        this.options.nonStandardMappings = new HashMap();
        this.options.aliasTypeNames = new HashMap();
        this.options.excludedFieldNames = new HashMap();
        this.options.customWrittenClasses = new HashMap();
        this.options.notCustomWrittenClasses = new HashSet();
        this.options.nonRefClasses = new HashSet();
        this.options.filteredMethodNames = new HashSet();
        this.options.fieldFilters = new ArrayList();
        this.options.fieldFilters.add(new StaticFieldFilter());
        this.options.fieldFilters.add(new EnumFieldFilter());
        this.options.methodFilters = new ArrayList();
        this.options.methodFilters.add(new AccessorMethodFilter());
        this.options.methodFilters.add(new ModifierMethodFilter(1));
        this.options.accessorFactories = new ArrayList();
        this.options.accessorFactories.add(new GetMethodAccessorFactory());
        this.options.accessorFactories.add(new IsMethodAccessorFactory());
        this.options.nonStandardMappings.putAll(BASE_NONSTANDARD_MAPPINGS);
        this.options.aliasTypeNames.putAll(BASE_ALIAS_MAPPINGS);
        this.options.customWrittenClasses.putAll(BASE_WRITERS);
        this.options.nonRefClasses.addAll(BASE_NON_REFS);
        this.options.filteredMethodNames.addAll(BASE_FILTERED_METHOD_NAMES);
        this.options.excludedFieldNames.putAll(BASE_EXCLUDED_FIELD_NAMES);
    }

    public static void addPermanentAlias(Class<?> clazz, String alias) {
        BASE_ALIAS_MAPPINGS.put(clazz.getName(), alias);
    }

    public static void addPermanentAlias(Class<?> clazz) {
        BASE_ALIAS_MAPPINGS.put(clazz.getName(), clazz.getSimpleName());
    }

    public static void addPermanentNonRef(Class<?> clazz) {
        BASE_NON_REFS.add(clazz);
    }

    public static void addPermanentWriter(Class<?> clazz, JsonWriter.JsonClassWriter writer) {
        BASE_WRITERS.put(clazz, writer);
    }

    public WriteOptionsBuilder classLoader(ClassLoader loader) {
        this.options.classLoader = loader;
        return this;
    }

    public WriteOptionsBuilder shortMetaKeys(boolean shortMetaKeys) {
        this.options.shortMetaKeys = shortMetaKeys;
        return this;
    }

    public WriteOptionsBuilder aliasTypeNames(Map<String, String> aliases) {
        aliases.forEach(this::addUniqueAlias);
        return this;
    }

    public WriteOptionsBuilder aliasTypeName(Class<?> type) {
        return this.aliasTypeName(type.getName(), type.getSimpleName());
    }

    public WriteOptionsBuilder aliasTypeName(Class<?> type, String alias) {
        this.options.aliasTypeNames.put(type.getName(), alias);
        return this;
    }

    public WriteOptionsBuilder aliasTypeName(String typeName, String alias) {
        this.addUniqueAlias(typeName, alias);
        return this;
    }

    private void addUniqueAlias(String typeName, String alias) {
        Convention.throwIfClassNotFound((String)typeName, (ClassLoader)this.options.classLoader);
        Convention.throwIfKeyExists((Map)this.options.aliasTypeNames, (Object)typeName, (String)("Tried to create @type alias" + typeName + " -> " + alias + ", but it is already aliased to: " + (String)this.options.aliasTypeNames.get(typeName)));
        this.options.aliasTypeNames.put(typeName, alias);
    }

    public WriteOptionsBuilder withExtendedAliases() {
        Map<String, String> extendedAliases = MetaUtils.loadMapDefinition("extendedAliases.txt");
        extendedAliases.forEach((key, value) -> this.options.aliasTypeNames.putIfAbsent(key, value));
        return this;
    }

    public WriteOptionsBuilder showTypeInfoAlways() {
        this.options.showTypeInfo = WriteOptions.ShowType.ALWAYS;
        return this;
    }

    public WriteOptionsBuilder showTypeInfoNever() {
        this.options.showTypeInfo = WriteOptions.ShowType.NEVER;
        return this;
    }

    public WriteOptionsBuilder showTypeInfoMinimal() {
        this.options.showTypeInfo = WriteOptions.ShowType.MINIMAL;
        return this;
    }

    public WriteOptionsBuilder prettyPrint(boolean prettyPrint) {
        this.options.prettyPrint = prettyPrint;
        return this;
    }

    public WriteOptionsBuilder writeLongsAsStrings(boolean writeLongsAsStrings) {
        this.options.writeLongsAsStrings = writeLongsAsStrings;
        return this;
    }

    public WriteOptionsBuilder skipNullFields(boolean skipNullFields) {
        this.options.skipNullFields = skipNullFields;
        return this;
    }

    public WriteOptionsBuilder forceMapOutputAsTwoArrays(boolean forceMapOutputAsTwoArrays) {
        this.options.forceMapOutputAsTwoArrays = forceMapOutputAsTwoArrays;
        return this;
    }

    public WriteOptionsBuilder allowNanAndInfinity(boolean allowNanAndInfinity) {
        this.options.allowNanAndInfinity = allowNanAndInfinity;
        return this;
    }

    public WriteOptionsBuilder writeEnumsAsString() {
        this.options.enumWriter = new Writers.EnumsAsStringWriter();
        return this;
    }

    public WriteOptionsBuilder writeEnumAsJsonObject(boolean writePublicFieldsOnly) {
        this.options.enumWriter = DefaultWriteOptions.nullWriter;
        this.options.enumPublicFieldsOnly = writePublicFieldsOnly;
        return this;
    }

    public WriteOptionsBuilder closeStream(boolean closeStream) {
        this.options.closeStream = closeStream;
        return this;
    }

    public WriteOptionsBuilder setCustomWrittenClasses(Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses) {
        this.options.customWrittenClasses.clear();
        this.addCustomWrittenClasses(customWrittenClasses);
        return this;
    }

    public WriteOptionsBuilder addCustomWrittenClasses(Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses) {
        this.options.customWrittenClasses.putAll(customWrittenClasses);
        return this;
    }

    public WriteOptionsBuilder addCustomWrittenClass(Class<?> clazz, JsonWriter.JsonClassWriter customWriter) {
        this.options.customWrittenClasses.put(clazz, customWriter);
        return this;
    }

    public WriteOptionsBuilder addNotCustomWrittenClass(Class<?> notCustomClass) {
        this.options.notCustomWrittenClasses.add(notCustomClass);
        return this;
    }

    public WriteOptionsBuilder setNotCustomWrittenClasses(Collection<Class<?>> notCustomClasses) {
        this.options.notCustomWrittenClasses.clear();
        this.options.notCustomWrittenClasses.addAll(notCustomClasses);
        return this;
    }

    public WriteOptionsBuilder addIncludedField(Class<?> clazz, String includedFieldName) {
        Convention.throwIfNull((Object)includedFieldName, (String)"includedFieldName cannot be null");
        this.options.includedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).add(includedFieldName);
        return this;
    }

    public WriteOptionsBuilder addIncludedFields(Class<?> clazz, Collection<String> includedFieldNames) {
        this.options.includedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(includedFieldNames);
        return this;
    }

    public WriteOptionsBuilder addIncludedFields(Map<Class<?>, Collection<String>> includedFieldNames) {
        includedFieldNames.forEach(this::addIncludedFields);
        return this;
    }

    public WriteOptionsBuilder addExcludedField(Class<?> clazz, String excludedFieldName) {
        this.options.excludedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).add(excludedFieldName);
        return this;
    }

    public WriteOptionsBuilder addExcludedFields(Class<?> clazz, Collection<String> excludedFields) {
        this.options.excludedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(excludedFields);
        return this;
    }

    public WriteOptionsBuilder addExcludedFields(Map<Class<?>, Collection<String>> excludedFieldNames) {
        excludedFieldNames.forEach(this::addExcludedFields);
        return this;
    }

    public WriteOptionsBuilder isoDateFormat() {
        return this.dateTimeFormat(ISO_DATE_FORMAT);
    }

    public WriteOptionsBuilder isoDateTimeFormat() {
        return this.dateTimeFormat(ISO_DATE_TIME_FORMAT);
    }

    public WriteOptionsBuilder longDateFormat() {
        this.addCustomWrittenClass(Date.class, new Writers.DateAsLongWriter());
        return this;
    }

    public WriteOptionsBuilder dateTimeFormat(String format) {
        this.addCustomWrittenClass(Date.class, new Writers.DateWriter(format));
        return this;
    }

    public WriteOptionsBuilder setFilteredMethodNames(Collection<String> methodNames) {
        Convention.throwIfNull(methodNames, (String)"methodNames cannot be null");
        this.options.filteredMethodNames.clear();
        this.options.filteredMethodNames.addAll(methodNames);
        return this;
    }

    public WriteOptionsBuilder addFilteredMethodNames(Collection<String> methodNames) {
        Convention.throwIfNull(methodNames, (String)"methodNames cannot be null");
        this.options.filteredMethodNames.addAll(methodNames);
        return this;
    }

    public WriteOptionsBuilder addFilteredMethodName(String methodName) {
        Convention.throwIfNull((Object)methodName, (String)"methodName cannot be null");
        this.options.filteredMethodNames.add(methodName);
        return this;
    }

    WriteOptionsBuilder setNonStandardMappings(Map<Class<?>, Map<String, String>> nonStandardMappings) {
        Convention.throwIfNull(nonStandardMappings, (String)"nonStandardMappings cannot be null");
        this.options.nonStandardMappings.clear();
        this.options.nonStandardMappings.putAll(nonStandardMappings);
        return this;
    }

    public WriteOptionsBuilder addNonStandardMappings(Map<Class<?>, Map<String, String>> nonStandardMappings) {
        Convention.throwIfNull(nonStandardMappings, (String)"nonStandardMappings cannot be null");
        this.options.nonStandardMappings.putAll(nonStandardMappings);
        return this;
    }

    public WriteOptionsBuilder addNonStandardMapping(Class<?> c, String fieldName, String methodName) {
        Convention.throwIfNull(c, (String)"class cannot be null");
        Convention.throwIfNull((Object)fieldName, (String)"fieldName cannot be null");
        Convention.throwIfNull((Object)methodName, (String)"methodName cannot be null");
        this.options.nonStandardMappings.computeIfAbsent(c, cls -> new LinkedHashMap()).put(fieldName, methodName);
        return this;
    }

    public WriteOptionsBuilder setNonReferenceableClasses(Collection<Class<?>> classes) {
        Convention.throwIfNull(classes, (String)"classes cannot be null");
        this.options.nonRefClasses.clear();
        this.options.nonRefClasses.addAll(classes);
        return this;
    }

    public WriteOptionsBuilder addNonReferenceableClasses(Collection<Class<?>> classes) {
        Convention.throwIfNull(classes, (String)"classes cannot be null");
        this.options.nonRefClasses.addAll(classes);
        return this;
    }

    public WriteOptionsBuilder addNonReferenceableClass(Class<?> clazz) {
        Convention.throwIfNull(clazz, (String)"clazz cannot be null");
        this.options.nonRefClasses.add(clazz);
        return this;
    }

    public WriteOptions build() {
        this.options.clearCaches();
        return this.options;
    }

    private static Map<Class<?>, JsonWriter.JsonClassWriter> loadWriters() {
        Map<String, String> map = MetaUtils.loadMapDefinition("customWriters.txt");
        HashMap writers = new HashMap();
        ClassLoader classLoader = WriteOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String writerClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                System.out.println("Class: " + className + " not defined in the JVM, so custom writer: " + writerClassName + ", will not be used.");
                continue;
            }
            Class customWriter = ClassUtilities.forName((String)writerClassName, (ClassLoader)classLoader);
            if (customWriter == null) {
                System.out.println("Note: class not found (custom JsonClassWriter class): " + writerClassName + ", listed in resources/customWriters.txt as a custom writer for: " + className);
            }
            try {
                JsonWriter.JsonClassWriter writer = (JsonWriter.JsonClassWriter)customWriter.newInstance();
                writers.put(clazz, writer);
            }
            catch (Exception e) {
                System.out.println("Note: class failed to instantiate (a custom JsonClassWriter class): " + writerClassName + ", listed in resources/customWriters.txt as a custom writer for: " + className);
            }
        }
        return writers;
    }

    private static Map<Class<?>, Map<String, String>> loadNonStandardMethodNames() {
        Map<String, String> map = MetaUtils.loadMapDefinition("nonStandardAccessors.txt");
        ConcurrentHashMap nonStandardMapping = new ConcurrentHashMap();
        ClassLoader classLoader = WriteOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String mappings = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                System.out.println("Class: " + className + " not defined in the JVM");
                continue;
            }
            Map mapping = nonStandardMapping.computeIfAbsent(clazz, c -> new ConcurrentHashMap());
            for (String split : mappings.split(",")) {
                String[] parts = split.split(":");
                mapping.put(parts[0].trim(), parts[1].trim());
            }
        }
        return nonStandardMapping;
    }

    static Set<Class<?>> loadNonRefs() {
        LinkedHashSet nonRefs = new LinkedHashSet();
        Set<String> set = MetaUtils.loadSetDefinition("nonRefs.txt");
        set.forEach(className -> {
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)WriteOptions.class.getClassLoader());
            if (clazz == null) {
                System.out.println("Class: " + className + " undefined.  Cannot be used as non-referenceable class, listed in resources/nonRefs.txt");
            }
            nonRefs.add(clazz);
        });
        return nonRefs;
    }

    public boolean addFilter(FieldFilter filter) {
        return this.options.fieldFilters.add(filter);
    }

    public boolean removeFilter(FieldFilter filter) {
        return this.options.fieldFilters.remove(filter);
    }

    static {
        BASE_ALIAS_MAPPINGS.putAll(MetaUtils.loadMapDefinition("aliases.txt"));
        BASE_WRITERS.putAll(WriteOptionsBuilder.loadWriters());
        BASE_NON_REFS.addAll(WriteOptionsBuilder.loadNonRefs());
        BASE_FILTERED_METHOD_NAMES.addAll(MetaUtils.loadSetDefinition("excludedAccessorMethods.txt"));
        BASE_EXCLUDED_FIELD_NAMES.putAll(MetaUtils.loadClassToSetOfStrings("ignoredFields.txt"));
        BASE_NONSTANDARD_MAPPINGS.putAll(MetaUtils.loadNonStandardMethodNames("nonStandardAccessors.txt"));
    }

    public static class DefaultWriteOptions
    implements WriteOptions {
        private boolean shortMetaKeys = false;
        private WriteOptions.ShowType showTypeInfo = WriteOptions.ShowType.MINIMAL;
        private boolean prettyPrint = false;
        private boolean writeLongsAsStrings = false;
        private boolean skipNullFields = false;
        private boolean forceMapOutputAsTwoArrays = false;
        private boolean allowNanAndInfinity = false;
        private boolean enumPublicFieldsOnly = false;
        private boolean closeStream = true;
        private JsonWriter.JsonClassWriter enumWriter = new Writers.EnumsAsStringWriter();
        private ClassLoader classLoader = WriteOptions.class.getClassLoader();
        private Map<Class<?>, Set<String>> includedFieldNames;
        private Map<Class<?>, Map<String, String>> nonStandardMappings;
        private Map<String, String> aliasTypeNames;
        private Set<Class<?>> notCustomWrittenClasses;
        private Set<Class<?>> nonRefClasses;
        private Map<Class<?>, Set<String>> excludedFieldNames;
        private List<FieldFilter> fieldFilters;
        private List<MethodFilter> methodFilters;
        private List<AccessorFactory> accessorFactories;
        private Set<String> filteredMethodNames;
        private Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses;
        private Map<Class<?>, JsonWriter.JsonClassWriter> writerCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private final Map<Class<?>, List<Accessor>> accessorsCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private final Map<Class<?>, Map<String, Field>> classMetaCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        static final NullClass nullWriter = new NullClass();

        private DefaultWriteOptions() {
        }

        @Override
        public String getTypeNameAlias(String typeName) {
            String alias = this.aliasTypeNames.get(typeName);
            return alias == null ? typeName : alias;
        }

        @Override
        public boolean isAlwaysShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.ALWAYS;
        }

        @Override
        public boolean isNeverShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.NEVER;
        }

        @Override
        public boolean isMinimalShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.MINIMAL;
        }

        @Override
        public boolean isCustomWrittenClass(Class<?> clazz) {
            return this.customWrittenClasses.containsKey(clazz);
        }

        @Override
        public boolean isNotCustomWrittenClass(Class<?> clazz) {
            return this.notCustomWrittenClasses.contains(clazz);
        }

        @Override
        public List<Accessor> getAccessorsForClass(Class<?> c) {
            return this.accessorsCache.computeIfAbsent(c, this::buildDeepAccessors);
        }

        @Override
        public boolean isLongDateFormat() {
            JsonWriter.JsonClassWriter a = this.customWrittenClasses.get(Date.class);
            return a instanceof Writers.DateAsLongWriter;
        }

        @Override
        public boolean isNonReferenceableClass(Class<?> clazz) {
            return this.nonRefClasses.contains(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.isEnum();
        }

        @Override
        public JsonWriter.JsonClassWriter getCustomWriter(Class<?> c) {
            JsonWriter.JsonClassWriter writer = this.writerCache.computeIfAbsent(c, this::findCustomWriter);
            return writer == nullWriter ? null : writer;
        }

        public JsonWriter.JsonClassWriter findCustomWriter(Class<?> c) {
            JsonWriter.JsonClassWriter writer = MetaUtils.findClosest(c, this.customWrittenClasses, nullWriter);
            return writer != nullWriter ? writer : (MetaUtils.getClassIfEnum(c).isPresent() ? this.enumWriter : nullWriter);
        }

        @Override
        public void clearCaches() {
            this.accessorsCache.clear();
        }

        private List<Accessor> buildDeepAccessors(Class<?> c) {
            Map<String, Field> fields = this.getDeepDeclaredFields(c);
            ArrayList<Accessor> accessors = new ArrayList<Accessor>(fields.size());
            for (Map.Entry<String, Field> entry : fields.entrySet()) {
                String key;
                Field field = entry.getValue();
                Accessor accessor = this.findAccessor(field, key = entry.getKey());
                if (accessor == null) {
                    accessor = Accessor.create(field, key);
                }
                if (accessor == null) continue;
                accessors.add(accessor);
            }
            return Collections.unmodifiableList(accessors);
        }

        @Override
        public Map<String, Field> getDeepDeclaredFields(Class<?> c) {
            Set<String> inclusions = this.includedFieldNames.get(c);
            return inclusions == null ? this.classMetaCache.computeIfAbsent(c, this::buildExclusiveFields) : this.classMetaCache.computeIfAbsent(c, cls -> this.buildInclusiveFields((Class<?>)cls, inclusions));
        }

        private Accessor findAccessor(Field field, String key) {
            for (AccessorFactory factory : this.accessorFactories) {
                try {
                    Accessor accessor = factory.buildAccessor(field, this.nonStandardMappings, key);
                    if (accessor == null) continue;
                    return accessor;
                }
                catch (Throwable throwable) {
                }
            }
            return null;
        }

        private Map<String, Field> buildInclusiveFields(Class<?> c, Set<String> inclusions) {
            Convention.throwIfNull(c, (String)"class cannot be null");
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
                List fields = ReflectionUtils.getDeclaredFields(curr);
                for (Field field : fields) {
                    String name = field.getName();
                    if (map.containsKey(name)) {
                        name = field.getDeclaringClass().getSimpleName() + '.' + name;
                    }
                    if (!inclusions.contains(name) || this.fieldIsFiltered(field)) continue;
                    map.put(name, field);
                }
            }
            return Collections.unmodifiableMap(map);
        }

        private Map<String, Field> buildExclusiveFields(Class<?> c) {
            Convention.throwIfNull(c, (String)"class cannot be null");
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            HashSet<String> exclusions = new HashSet<String>();
            for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
                List fields = ReflectionUtils.getDeclaredFields(curr);
                Set<String> excludedForClass = this.excludedFieldNames.get(curr);
                if (excludedForClass != null) {
                    exclusions.addAll(excludedForClass);
                }
                for (Field field : fields) {
                    String name;
                    if (Modifier.isTransient(field.getModifiers()) || exclusions.contains(field.getName()) || this.fieldIsFiltered(field) || map.putIfAbsent(name = field.getName(), field) == null) continue;
                    map.put(field.getDeclaringClass().getSimpleName() + '.' + name, field);
                }
            }
            return Collections.unmodifiableMap(map);
        }

        private boolean fieldIsFiltered(Field field) {
            for (FieldFilter filter : this.fieldFilters) {
                if (!filter.filter(field)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isShortMetaKeys() {
            return this.shortMetaKeys;
        }

        @Override
        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        @Override
        public boolean isWriteLongsAsStrings() {
            return this.writeLongsAsStrings;
        }

        @Override
        public boolean isSkipNullFields() {
            return this.skipNullFields;
        }

        @Override
        public boolean isForceMapOutputAsTwoArrays() {
            return this.forceMapOutputAsTwoArrays;
        }

        @Override
        public boolean isAllowNanAndInfinity() {
            return this.allowNanAndInfinity;
        }

        @Override
        public boolean isEnumPublicFieldsOnly() {
            return this.enumPublicFieldsOnly;
        }

        @Override
        public boolean isCloseStream() {
            return this.closeStream;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        private static final class NullClass
        implements JsonWriter.JsonClassWriter {
            private NullClass() {
            }
        }
    }
}

