/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect;

import com.cedarsoftware.util.Convention;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReflectionUtils {
    private static final Map<Class<?>, List<Field>> fieldMetaCache = new ConcurrentHashMap();

    private ReflectionUtils() {
    }

    public static Map<String, Method> buildInjectorMap(Class<?> c) {
        return Arrays.stream(c.getDeclaredMethods()).filter(m -> m.getParameterCount() == 1).collect(Collectors.toMap(Method::getName, Function.identity(), ReflectionUtils::oneParameterMethodPreference, LinkedHashMap::new));
    }

    public static Method oneParameterMethodPreference(Method method1, Method method2) {
        return method1.getParameterCount() == 1 ? method1 : method2;
    }

    public static <T> T newInstance(Class<? extends T> c) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor = c.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public static List<Field> getDeclaredFields(Class<?> c) {
        return fieldMetaCache.computeIfAbsent(c, ReflectionUtils::buildDeclaredFields);
    }

    public static List<Field> buildDeclaredFields(Class<?> c) {
        Convention.throwIfNull(c, (String)"class cannot be null");
        Field[] fields = c.getDeclaredFields();
        ArrayList<Field> list = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass().isEnum() && ("internal".equals(field.getName()) || "ENUM$VALUES".equals(field.getName())) || field.getDeclaringClass().isAssignableFrom(Enum.class) && ("hash".equals(field.getName()) || "ordinal".equals(field.getName()))) continue;
            list.add(field);
        }
        return list;
    }
}

