/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.LRUCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

class JsonParser {
    private static final JsonObject EMPTY_ARRAY = new JsonObject();
    private static final Map<String, String> stringCache = new LRUCache(2500);
    private static final Map<Number, Number> numberCache = new LRUCache(2500);
    private static final Map<String, String> substitutes = new LinkedHashMap<String, String>();
    private final FastReader input;
    private final StringBuilder strBuf = new StringBuilder(256);
    private final StringBuilder hexBuf = new StringBuilder();
    private final StringBuilder numBuf = new StringBuilder();
    private int curParseDepth = 0;
    private final boolean allowNanAndInfinity;
    private final int maxParseDepth;
    private final ReadOptions readOptions;
    private final ReferenceTracker references;
    private final Resolver resolver;
    private static final int STRING_START = 0;
    private static final int STRING_SLASH = 1;
    private static final int HEX_DIGITS = 2;

    JsonParser(FastReader reader, Resolver resolver) {
        this.input = reader;
        this.resolver = resolver;
        this.readOptions = resolver.getReadOptions();
        this.references = resolver.getReferences();
        this.maxParseDepth = this.readOptions.getMaxDepth();
        this.allowNanAndInfinity = this.readOptions.isAllowNanAndInfinity();
    }

    private JsonObject readJsonObject(Class<?> suggestedClass) throws IOException {
        JsonObject jObj = new JsonObject();
        jObj.setHintType(suggestedClass);
        FastReader in = this.input;
        this.skipWhitespaceRead(true);
        jObj.line = in.getLine();
        jObj.col = in.getCol();
        int c = this.skipWhitespaceRead(true);
        if (c == 125) {
            return new JsonObject();
        }
        in.pushback((char)c);
        ++this.curParseDepth;
        Map<String, Injector> injectors = this.readOptions.getDeepInjectorMap(suggestedClass);
        while (true) {
            Injector injector;
            String field;
            if (substitutes.containsKey(field = this.readField())) {
                field = substitutes.get(field);
            }
            Object value = this.readValue((injector = injectors.get(field)) == null ? null : injector.getType());
            switch (field) {
                case "@type": {
                    Class<?> type = this.loadType(value);
                    jObj.setJavaType(type);
                    break;
                }
                case "@ref": {
                    this.loadRef(value, jObj);
                    break;
                }
                case "@id": {
                    this.loadId(value, jObj);
                    break;
                }
                case "@items": {
                    jObj.put(field, value);
                    break;
                }
                case "@keys": {
                    jObj.put(field, value);
                    break;
                }
                default: {
                    jObj.put(field, value);
                }
            }
            c = this.skipWhitespaceRead(true);
            if (c == 125) break;
            if (c == 44) continue;
            this.error("Object not ended with '}', instead found '" + (char)c + "'");
        }
        --this.curParseDepth;
        return jObj;
    }

    private String readField() throws IOException {
        int c = this.skipWhitespaceRead(true);
        if (c != 34) {
            this.error("Expected quote before field name");
        }
        String field = this.readString();
        c = this.skipWhitespaceRead(true);
        if (c != 58) {
            this.error("Expected ':' between field and value, instead found '" + (char)c + "'");
        }
        return field;
    }

    Object readValue(Class<?> suggestedClass) throws IOException {
        int c;
        if (this.curParseDepth > this.maxParseDepth) {
            this.error("Maximum parsing depth exceeded");
        }
        if ((c = this.skipWhitespaceRead(true)) >= 48 && c <= 57 || c == 45 || c == 78 || c == 73) {
            return this.readNumber(c);
        }
        switch (c) {
            case 34: {
                String str = this.readString();
                return str;
            }
            case 123: {
                this.input.pushback('{');
                JsonObject jObj = this.readJsonObject(suggestedClass);
                boolean useMaps = this.readOptions.isReturningJsonObjects();
                if (jObj.isLogicalPrimitive() && useMaps) {
                    jObj.isFinished = true;
                    return jObj.getPrimitiveValue(this.resolver.getConverter(), this.readOptions.getClassLoader());
                }
                return jObj;
            }
            case 91: {
                Object[] array = this.readArray(suggestedClass == null ? null : suggestedClass.getComponentType());
                return array;
            }
            case 93: {
                this.input.pushback(']');
                return EMPTY_ARRAY;
            }
            case 70: 
            case 102: {
                this.readToken("false");
                return false;
            }
            case 78: 
            case 110: {
                this.readToken("null");
                return null;
            }
            case 84: 
            case 116: {
                this.readToken("true");
                return true;
            }
        }
        return this.error("Unknown JSON value type");
    }

    private Object[] readArray(Class<?> suggestedClass) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        ++this.curParseDepth;
        while (true) {
            int c;
            Object value;
            if ((value = this.readValue(suggestedClass)) != EMPTY_ARRAY) {
                array.add(value);
            }
            if ((c = this.skipWhitespaceRead(true)) == 93) break;
            if (c == 44) continue;
            this.error("Expected ',' or ']' inside array");
        }
        --this.curParseDepth;
        return array.toArray();
    }

    private void readToken(String token) throws IOException {
        int len = token.length();
        for (int i = 1; i < len; ++i) {
            int c = this.input.read();
            if (c == -1) {
                this.error("EOF reached while reading token: " + token);
            }
            c = Character.toLowerCase((char)c);
            char loTokenChar = token.charAt(i);
            if (loTokenChar == c) continue;
            this.error("Expected token: " + token);
        }
    }

    private Number readNumber(int c) throws IOException {
        FastReader in = this.input;
        boolean isFloat = false;
        if (this.allowNanAndInfinity && (c == 45 || c == 78 || c == 73)) {
            boolean isNeg;
            boolean bl = isNeg = c == 45;
            if (isNeg) {
                c = this.input.read();
            }
            if (c == 73) {
                this.readToken("infinity");
                return isNeg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (78 == c) {
                this.readToken("nan");
                return Double.NaN;
            }
            this.input.pushback((char)c);
            c = 45;
        }
        StringBuilder number = this.numBuf;
        number.setLength(0);
        number.append((char)c);
        while (true) {
            if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                number.append((char)c);
                continue;
            }
            if (c != 46 && c != 101 && c != 69) break;
            number.append((char)c);
            isFloat = true;
        }
        if (c != -1) {
            in.pushback((char)c);
        }
        try {
            Number val = isFloat ? (Number)Double.parseDouble(number.toString()) : (Number)Long.parseLong(number.toString(), 10);
            Number cachedInstance = numberCache.get(val);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            numberCache.put(val, val);
            return val;
        }
        catch (Exception e) {
            return (Number)this.error("Invalid number: " + number, e);
        }
    }

    private String readString() throws IOException {
        StringBuilder str = this.strBuf;
        str.setLength(0);
        StringBuilder hex = this.hexBuf;
        int state = 0;
        FastReader in = this.input;
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                this.error("EOF reached while reading JSON string");
            }
            if (state == 0) {
                if (c == 34) {
                    if (this.curParseDepth != 0 || (c = this.skipWhitespaceRead(false)) == -1) break;
                    throw new JsonIoException("EOF expected, content found after \"" + str + "\" --> " + (char)c);
                }
                if (c == 92) {
                    state = 1;
                    continue;
                }
                str.append((char)c);
                continue;
            }
            if (state == 1) {
                switch (c) {
                    case 92: {
                        str.append('\\');
                        break;
                    }
                    case 47: {
                        str.append('/');
                        break;
                    }
                    case 34: {
                        str.append('\"');
                        break;
                    }
                    case 39: {
                        str.append('\'');
                        break;
                    }
                    case 98: {
                        str.append('\b');
                        break;
                    }
                    case 102: {
                        str.append('\f');
                        break;
                    }
                    case 110: {
                        str.append('\n');
                        break;
                    }
                    case 114: {
                        str.append('\r');
                        break;
                    }
                    case 116: {
                        str.append('\t');
                        break;
                    }
                    case 117: {
                        hex.setLength(0);
                        state = 2;
                        break;
                    }
                    default: {
                        this.error("Invalid character escape sequence specified: " + c);
                    }
                }
                if (c == 117) continue;
                state = 0;
                continue;
            }
            if (c >= 48 && c <= 57 || c >= 65 && c <= 70 || c >= 97 && c <= 102) {
                hex.append((char)c);
                if (hex.length() != 4) continue;
                int value = Integer.parseInt(hex.toString(), 16);
                str.append((char)value);
                state = 0;
                continue;
            }
            this.error("Expected hexadecimal digits");
        }
        String s = str.toString();
        String cachedInstance = stringCache.get(s);
        if (cachedInstance != null) {
            return cachedInstance;
        }
        stringCache.put(s, s);
        return s;
    }

    private int skipWhitespaceRead(boolean throwOnEof) throws IOException {
        int c;
        FastReader in = this.input;
        while ((c = in.read()) == 32 || c == 10 || c == 13 || c == 9) {
        }
        if (c == -1 && throwOnEof) {
            this.error("EOF reached prematurely");
        }
        return c;
    }

    private void loadId(Object value, JsonObject jObj) {
        if (!(value instanceof Long)) {
            this.error("Expected a number for @id, instead got: " + value);
        }
        Long id = (Long)value;
        this.references.put(id, jObj);
        jObj.setId(id);
    }

    private void loadRef(Object value, JsonValue jObj) {
        if (!(value instanceof Long)) {
            this.error("Expected a number for @ref, instead got: " + value);
        }
        jObj.setReferenceId((Long)value);
        jObj.setFinished();
    }

    private Class<?> loadType(Object value) {
        Class<Object> clazz;
        String javaType;
        String substitute;
        if (!(value instanceof String)) {
            this.error("Expected a String for @type, instead got: " + value);
        }
        if ((substitute = this.readOptions.getTypeNameAlias(javaType = (String)value)) != null) {
            javaType = substitute;
        }
        if ((clazz = ClassUtilities.forName((String)javaType, (ClassLoader)this.readOptions.getClassLoader())) == null) {
            if (this.readOptions.isFailOnUnknownType()) {
                this.error("Class: " + javaType + " not defined.");
            }
            if ((clazz = this.readOptions.getUnknownTypeClass()) == null) {
                clazz = LinkedHashMap.class;
            }
        }
        return clazz;
    }

    Object error(String msg) {
        throw new JsonIoException(this.getMessage(msg));
    }

    Object error(String msg, Exception e) {
        throw new JsonIoException(this.getMessage(msg), e);
    }

    String getMessage(String msg) {
        return msg + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol() + "\n" + this.input.getLastSnippet();
    }

    static {
        substitutes.put("@i", "@id");
        substitutes.put("@r", "@ref");
        substitutes.put("@e", "@items");
        substitutes.put("@t", "@type");
        substitutes.put("@k", "@keys");
        stringCache.put("", "");
        stringCache.put("true", "true");
        stringCache.put("True", "True");
        stringCache.put("TRUE", "TRUE");
        stringCache.put("false", "false");
        stringCache.put("False", "False");
        stringCache.put("FALSE", "FALSE");
        stringCache.put("null", "null");
        stringCache.put("yes", "yes");
        stringCache.put("Yes", "Yes");
        stringCache.put("YES", "YES");
        stringCache.put("no", "no");
        stringCache.put("No", "No");
        stringCache.put("NO", "NO");
        stringCache.put("on", "on");
        stringCache.put("On", "On");
        stringCache.put("ON", "ON");
        stringCache.put("off", "off");
        stringCache.put("Off", "Off");
        stringCache.put("OFF", "OFF");
        stringCache.put("@id", "@id");
        stringCache.put("@ref", "@ref");
        stringCache.put("@items", "@items");
        stringCache.put("@type", "@type");
        stringCache.put("@keys", "@keys");
        stringCache.put("0", "0");
        stringCache.put("1", "1");
        stringCache.put("2", "2");
        stringCache.put("3", "3");
        stringCache.put("4", "4");
        stringCache.put("5", "5");
        stringCache.put("6", "6");
        stringCache.put("7", "7");
        stringCache.put("8", "8");
        stringCache.put("9", "9");
        numberCache.put(-1L, -1L);
        numberCache.put(0L, 0L);
        numberCache.put(1L, 1L);
        numberCache.put(-1.0, -1.0);
        numberCache.put(0.0, 0.0);
        numberCache.put(1.0, 1.0);
        numberCache.put(Double.MIN_VALUE, Double.MIN_VALUE);
        numberCache.put(Double.MAX_VALUE, Double.MAX_VALUE);
        numberCache.put(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        numberCache.put(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        numberCache.put(Double.NaN, Double.NaN);
    }
}

