/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.factory.ArrayFactory;
import com.cedarsoftware.io.factory.ConvertableFactory;
import com.cedarsoftware.io.factory.EnumClassFactory;
import com.cedarsoftware.io.factory.ThrowableFactory;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.io.reflect.InjectorFactory;
import com.cedarsoftware.io.reflect.factories.MethodInjectorFactory;
import com.cedarsoftware.io.reflect.filters.FieldFilter;
import com.cedarsoftware.io.reflect.filters.field.EnumFieldFilter;
import com.cedarsoftware.io.reflect.filters.field.StaticFieldFilter;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.ConverterOptions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ReadOptionsBuilder {
    private static final Map<Class<?>, JsonReader.JsonClassReader> BASE_READERS = new ConcurrentHashMap();
    private static final Map<Class<?>, JsonReader.ClassFactory> BASE_CLASS_FACTORIES = new ConcurrentHashMap();
    private static final Map<String, String> BASE_ALIAS_MAPPINGS = new ConcurrentHashMap<String, String>();
    private static final Map<Class<?>, Class<?>> BASE_COERCED_TYPES = new ConcurrentHashMap();
    private static final Set<Class<?>> BASE_NON_REFS = Collections.synchronizedSet(new LinkedHashSet());
    private static final Map<Class<?>, Map<String, String>> BASE_NONSTANDARD_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<?>, Set<String>> BASE_EXCLUDED_FIELD_NAMES = new ConcurrentHashMap();
    private DefaultReadOptions options = new DefaultReadOptions();

    public ReadOptionsBuilder() {
        BASE_ALIAS_MAPPINGS.forEach((srcType, alias) -> this.options.aliasTypeNames.put(alias, srcType));
        this.options.injectorFactories = new ArrayList();
        this.options.injectorFactories.add(new MethodInjectorFactory());
        this.options.fieldFilters = new ArrayList();
        this.options.fieldFilters.add(new StaticFieldFilter());
        this.options.fieldFilters.add(new EnumFieldFilter());
        this.options.excludedFieldNames = new HashMap();
        this.options.excludedInjectorFields = new HashMap();
        this.options.nonStandardMappings = new HashMap();
        this.options.coercedTypes = new HashMap();
        this.options.coercedTypes.putAll(BASE_COERCED_TYPES);
        this.options.customReaderClasses.putAll(BASE_READERS);
        this.options.classFactoryMap.putAll(BASE_CLASS_FACTORIES);
        this.options.nonRefClasses.addAll(BASE_NON_REFS);
        this.options.nonStandardMappings.putAll(BASE_NONSTANDARD_MAPPINGS);
        this.options.excludedFieldNames.putAll(WriteOptionsBuilder.BASE_EXCLUDED_FIELD_NAMES);
        this.options.excludedInjectorFields.putAll(BASE_EXCLUDED_FIELD_NAMES);
    }

    public static void addPermanentClassFactory(Class<?> sourceClass, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(sourceClass, factory);
    }

    public static void addPermanentCoercedType(Class<?> sourceClass, Class<?> destinationClass) {
        BASE_COERCED_TYPES.put(sourceClass, destinationClass);
    }

    public static void addPermanentAlias(Class<?> sourceClass, String alias) {
        BASE_ALIAS_MAPPINGS.put(sourceClass.getName(), alias);
    }

    public static void addPermanentReader(Class<?> c, JsonReader.JsonClassReader reader) {
        BASE_READERS.put(c, reader);
    }

    public static void assignInstantiator(Class<?> classToCreate, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(classToCreate, factory);
    }

    public ReadOptions build() {
        this.options.clearCaches();
        this.options.aliasTypeNames = Collections.unmodifiableMap(this.options.aliasTypeNames);
        this.options.coercedTypes = Collections.unmodifiableMap(this.options.coercedTypes);
        this.options.notCustomReadClasses = Collections.unmodifiableSet(this.options.notCustomReadClasses);
        this.options.customReaderClasses = Collections.unmodifiableMap(this.options.customReaderClasses);
        this.options.classFactoryMap = Collections.unmodifiableMap(this.options.classFactoryMap);
        this.options.nonRefClasses = Collections.unmodifiableSet(this.options.nonRefClasses);
        this.options.converterOptions.converterOverrides = Collections.unmodifiableMap(this.options.converterOptions.converterOverrides);
        this.options.converterOptions.customOptions = Collections.unmodifiableMap(this.options.converterOptions.customOptions);
        return this.options;
    }

    public ReadOptionsBuilder addNotCustomReaderClass(Class<?> notCustomClass) {
        this.options.notCustomReadClasses.add(notCustomClass);
        return this;
    }

    public ReadOptionsBuilder replaceNotCustomReaderClasses(Collection<Class<?>> notCustomClasses) {
        this.options.notCustomReadClasses.clear();
        this.options.notCustomReadClasses.addAll(notCustomClasses);
        return this;
    }

    public ReadOptionsBuilder addConverterOverride(Class<?> source, Class<?> target, Convert<?> conversionFunction) {
        source = ClassUtilities.toPrimitiveWrapperClass(source);
        target = ClassUtilities.toPrimitiveWrapperClass(target);
        this.options.converterOptions.converterOverrides.put(new AbstractMap.SimpleImmutableEntry<Class, Class>(source, target), conversionFunction);
        return this;
    }

    public ReadOptionsBuilder replaceCustomReaderClasses(Map<? extends Class<?>, ? extends JsonReader.JsonClassReader> customReaderClasses) {
        this.options.customReaderClasses.clear();
        this.options.customReaderClasses.putAll(customReaderClasses);
        return this;
    }

    public ReadOptionsBuilder addCustomReaderClass(Class<?> clazz, JsonReader.JsonClassReader customReader) {
        this.options.customReaderClasses.put(clazz, customReader);
        return this;
    }

    public ReadOptionsBuilder replaceClassFactories(Map<Class<?>, ? extends JsonReader.ClassFactory> factories) {
        this.options.classFactoryMap.clear();
        this.options.classFactoryMap.putAll(factories);
        return this;
    }

    public ReadOptionsBuilder addClassFactory(Class<?> clazz, JsonReader.ClassFactory factory) {
        this.options.classFactoryMap.put(clazz, factory);
        return this;
    }

    public ReadOptionsBuilder returnAsNativeJsonObjects() {
        this.options.returnType = ReadOptions.ReturnType.JSON_OBJECTS;
        return this;
    }

    public ReadOptionsBuilder returnAsJavaObjects() {
        this.options.returnType = ReadOptions.ReturnType.JAVA_OBJECTS;
        return this;
    }

    public ReadOptionsBuilder classLoader(ClassLoader classLoader) {
        Convention.throwIfNull((Object)classLoader, (String)"classloader cannot be null");
        this.options.converterOptions.classloader = classLoader;
        return this;
    }

    public ReadOptionsBuilder failOnUnknownType(boolean fail) {
        this.options.failOnUnknownType = fail;
        return this;
    }

    public ReadOptionsBuilder unknownTypeClass(Class<?> c) {
        this.options.unknownTypeClass = c;
        return this;
    }

    public ReadOptionsBuilder closeStream(boolean closeStream) {
        this.options.closeStream = closeStream;
        return this;
    }

    public ReadOptionsBuilder maxDepth(int maxDepth) {
        this.options.maxDepth = maxDepth;
        return this;
    }

    public ReadOptionsBuilder allowNanAndInfinity(boolean allowNanAndInfinity) {
        this.options.allowNanAndInfinity = allowNanAndInfinity;
        return this;
    }

    public ReadOptionsBuilder aliasTypeNames(Map<String, String> aliasTypeNames) {
        aliasTypeNames.forEach(this::addUniqueAlias);
        return this;
    }

    public ReadOptionsBuilder aliasTypeName(Class<?> type, String alias) {
        this.addUniqueAlias(type.getName(), alias);
        return this;
    }

    public ReadOptionsBuilder aliasTypeName(String typeName, String alias) {
        this.addUniqueAlias(typeName, alias);
        return this;
    }

    public ReadOptionsBuilder setLocale(Locale locale) {
        this.options.converterOptions.locale = locale;
        return this;
    }

    public ReadOptionsBuilder setCharset(Charset charset) {
        this.options.converterOptions.charset = charset;
        return this;
    }

    public ReadOptionsBuilder setZoneId(ZoneId zoneId) {
        this.options.converterOptions.zoneId = zoneId;
        return this;
    }

    public ReadOptionsBuilder setTrueCharacter(Character ch) {
        this.options.converterOptions.trueChar = ch;
        return this;
    }

    public ReadOptionsBuilder setFalseCharacter(Character ch) {
        this.options.converterOptions.falseChar = ch;
        return this;
    }

    public ReadOptionsBuilder addCustomOption(String key, Object value) {
        if (key == null) {
            throw new JsonIoException("Custom option key must not be null.");
        }
        if (value == null) {
            this.options.customOptions.remove(key);
        } else {
            this.options.customOptions.put(key, value);
        }
        return this;
    }

    private void addUniqueAlias(String type, String alias) {
        String existType;
        Class clazz = ClassUtilities.forName((String)type, (ClassLoader)this.options.getClassLoader());
        if (clazz == null) {
            System.out.println("Unknown class: " + type + " cannot be added to the ReadOptions alias map.");
        }
        if ((existType = (String)this.options.aliasTypeNames.get(alias)) != null) {
            System.out.println("Non-unique ReadOptions alias: " + alias + " attempted assign to: " + type + ", but is already assigned to: " + existType);
        }
        this.options.aliasTypeNames.put(alias, type);
    }

    public ReadOptionsBuilder coerceClass(String sourceClassName, Class<?> destClass) {
        Class clazz = ClassUtilities.forName((String)sourceClassName, (ClassLoader)this.options.getClassLoader());
        if (clazz != null) {
            this.options.coercedTypes.put(clazz, destClass);
        }
        return this;
    }

    public ReadOptionsBuilder missingFieldHandler(JsonReader.MissingFieldHandler missingFieldHandler) {
        this.options.missingFieldHandler = missingFieldHandler;
        return this;
    }

    public ReadOptionsBuilder addNonReferenceableClass(Class<?> clazz) {
        this.options.nonRefClasses.add(clazz);
        return this;
    }

    private static Map<Class<?>, JsonReader.ClassFactory> loadClassFactory() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/classFactory.txt");
        HashMap factories = new HashMap();
        ClassLoader classLoader = ReadOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String factoryClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                System.out.println("Skipping class: " + className + " not defined in JVM, but listed in resources/classFactories.txt");
                continue;
            }
            if (factoryClassName.equalsIgnoreCase("Convertable")) {
                factories.put(clazz, new ConvertableFactory(clazz));
                continue;
            }
            if (factoryClassName.equalsIgnoreCase("ArrayFactory")) {
                factories.put(clazz, new ArrayFactory(clazz));
                continue;
            }
            try {
                Class factoryClass = ClassUtilities.forName((String)factoryClassName, (ClassLoader)classLoader);
                if (factoryClass == null) {
                    System.out.println("Skipping class: " + factoryClassName + " not defined in JVM, but listed in resources/classFactories.txt, as factory for: " + className);
                    continue;
                }
                factories.put(clazz, (JsonReader.ClassFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                System.out.println("Unable to create JsonReader.ClassFactory class: " + factoryClassName + ", a factory class for: " + className + ", listed in resources/classFactories.txt");
            }
        }
        return factories;
    }

    private static Map<Class<?>, JsonReader.JsonClassReader> loadReaders() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/customReaders.txt");
        HashMap readers = new HashMap();
        ClassLoader classLoader = ReadOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String readerClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz != null) {
                Class customReaderClass = ClassUtilities.forName((String)readerClassName, (ClassLoader)classLoader);
                try {
                    readers.put(clazz, (JsonReader.JsonClassReader)customReaderClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    System.out.println("Note: could not instantiate (custom JsonClassReader class): " + readerClassName + " from resources/customReaders.txt");
                }
                continue;
            }
            System.out.println("Class: " + className + " not defined in JVM, but listed in resources/customReaders.txt");
        }
        return readers;
    }

    private static Map<Class<?>, Class<?>> loadCoercedTypes() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/coercedTypes.txt");
        HashMap coerced = new HashMap();
        ClassLoader classLoader = ReadOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String srcClassName = entry.getKey();
            String destClassName = entry.getValue();
            Class srcType = ClassUtilities.forName((String)srcClassName, (ClassLoader)classLoader);
            if (srcType == null) {
                System.out.println("Skipping class coercion for source class: " + srcClassName + " (not found) to: " + destClassName + ", listed in resources/coercedTypes.txt");
                continue;
            }
            Class destType = ClassUtilities.forName((String)destClassName, (ClassLoader)classLoader);
            if (destType == null) {
                System.out.println("Skipping class coercion for source class: " + srcClassName + " cannot be mapped to: " + destClassName + " (not found), listed in resources/coercedTypes.txt");
                continue;
            }
            coerced.put(srcType, destType);
        }
        return coerced;
    }

    static {
        BASE_CLASS_FACTORIES.putAll(ReadOptionsBuilder.loadClassFactory());
        BASE_READERS.putAll(ReadOptionsBuilder.loadReaders());
        BASE_ALIAS_MAPPINGS.putAll(MetaUtils.loadMapDefinition("config/aliases.txt"));
        BASE_COERCED_TYPES.putAll(ReadOptionsBuilder.loadCoercedTypes());
        BASE_NON_REFS.addAll(MetaUtils.loadNonRefs());
        BASE_EXCLUDED_FIELD_NAMES.putAll(MetaUtils.loadClassToSetOfStrings("config/excludedInjectorFields.txt"));
        BASE_NONSTANDARD_MAPPINGS.putAll(MetaUtils.loadNonStandardMethodNames("config/nonStandardInjectors.txt"));
    }

    public static class DefaultReadOptions
    implements ReadOptions {
        private Class<?> unknownTypeClass = null;
        private boolean failOnUnknownType = false;
        private boolean closeStream = true;
        private int maxDepth = 1000;
        private JsonReader.MissingFieldHandler missingFieldHandler = null;
        private final DefaultConverterOptions converterOptions = new DefaultConverterOptions();
        private final Map<String, Object> customOptions = new ConcurrentHashMap<String, Object>();
        private ReadOptions.ReturnType returnType = ReadOptions.ReturnType.JAVA_OBJECTS;
        private boolean allowNanAndInfinity = false;
        private Map<String, String> aliasTypeNames = new ConcurrentHashMap<String, String>();
        private Map<Class<?>, Class<?>> coercedTypes = new ConcurrentHashMap();
        private Map<Class<?>, JsonReader.JsonClassReader> customReaderClasses = new ConcurrentHashMap();
        private Map<Class<?>, JsonReader.ClassFactory> classFactoryMap = new ConcurrentHashMap();
        private Set<Class<?>> notCustomReadClasses = Collections.synchronizedSet(new LinkedHashSet());
        private Set<Class<?>> nonRefClasses = Collections.synchronizedSet(new LinkedHashSet());
        private Map<Class<?>, Set<String>> excludedFieldNames;
        private Map<Class<?>, Set<String>> excludedInjectorFields;
        private List<FieldFilter> fieldFilters;
        private List<InjectorFactory> injectorFactories;
        private final Map<Class<?>, Map<String, Injector>> injectorsCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private Map<Class<?>, Map<String, String>> nonStandardMappings;
        private final Map<Class<?>, JsonReader.JsonClassReader> readerCache = new ConcurrentHashMap(300);
        private final JsonReader.ClassFactory throwableFactory = new ThrowableFactory();
        private final JsonReader.ClassFactory enumFactory = new EnumClassFactory();
        private final Map<Class<?>, Map<String, Field>> classMetaCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private static final NullClass nullReader = new NullClass();

        private DefaultReadOptions() {
        }

        @Override
        public boolean isAllowNanAndInfinity() {
            return this.allowNanAndInfinity;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.converterOptions.getClassLoader();
        }

        @Override
        public boolean isFailOnUnknownType() {
            return this.failOnUnknownType;
        }

        @Override
        public Class<?> getUnknownTypeClass() {
            return this.unknownTypeClass;
        }

        @Override
        public boolean isCloseStream() {
            return this.closeStream;
        }

        @Override
        public int getMaxDepth() {
            return this.maxDepth;
        }

        @Override
        public String getTypeNameAlias(String typeName) {
            String alias = this.aliasTypeNames.get(typeName);
            return alias == null ? typeName : alias;
        }

        @Override
        public boolean isClassCoerced(String className) {
            return this.coercedTypes.containsKey(className);
        }

        @Override
        public Class<?> getCoercedClass(Class<?> c) {
            return this.coercedTypes.get(c);
        }

        @Override
        public JsonReader.MissingFieldHandler getMissingFieldHandler() {
            return this.missingFieldHandler;
        }

        @Override
        public boolean isNonReferenceableClass(Class<?> clazz) {
            return this.nonRefClasses.contains(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.isEnum();
        }

        @Override
        public boolean isNotCustomReaderClass(Class<?> clazz) {
            return this.notCustomReadClasses.contains(clazz);
        }

        @Override
        public boolean isCustomReaderClass(Class<?> clazz) {
            return this.customReaderClasses.containsKey(clazz);
        }

        @Override
        public JsonReader.ClassFactory getClassFactory(Class<?> c) {
            if (c == null) {
                return null;
            }
            JsonReader.ClassFactory factory = this.classFactoryMap.get(c);
            if (factory != null) {
                return factory;
            }
            if (Throwable.class.isAssignableFrom(c)) {
                return this.throwableFactory;
            }
            Optional<Class<?>> optional = MetaUtils.getClassIfEnum(c);
            if (optional.isPresent()) {
                return this.enumFactory;
            }
            return null;
        }

        @Override
        public JsonReader.JsonClassReader getCustomReader(Class<?> c) {
            JsonReader.JsonClassReader reader = this.readerCache.computeIfAbsent(c, cls -> MetaUtils.findClosest(c, this.customReaderClasses, nullReader));
            return reader == nullReader ? null : reader;
        }

        @Override
        public boolean isReturningJsonObjects() {
            return this.returnType == ReadOptions.ReturnType.JSON_OBJECTS;
        }

        @Override
        public boolean isReturningJavaObjects() {
            return this.returnType == ReadOptions.ReturnType.JAVA_OBJECTS;
        }

        @Override
        public Map<String, Injector> getDeepInjectorMap(Class<?> classToTraverse) {
            if (classToTraverse == null) {
                return Collections.emptyMap();
            }
            return this.injectorsCache.computeIfAbsent(classToTraverse, this::buildInjectors);
        }

        @Override
        public void clearCaches() {
            this.injectorsCache.clear();
        }

        private Map<String, Injector> buildInjectors(Class<?> c) {
            Map<String, Field> fields = this.getDeepDeclaredFields(c);
            LinkedHashMap<String, Injector> injectors = new LinkedHashMap<String, Injector>(fields.size());
            for (Map.Entry<String, Field> entry : fields.entrySet()) {
                String fieldName;
                Field field = entry.getValue();
                Injector injector = this.findInjector(field, fieldName = entry.getKey());
                if (injector == null) {
                    injector = Injector.create(field, fieldName);
                }
                if (injector == null) continue;
                injectors.put(fieldName, injector);
            }
            return injectors;
        }

        private Injector findInjector(Field field, String key) {
            for (InjectorFactory factory : this.injectorFactories) {
                try {
                    Injector injector = factory.createInjector(field, this.nonStandardMappings, key);
                    if (injector == null) continue;
                    return injector;
                }
                catch (Exception exception) {
                }
            }
            return null;
        }

        @Override
        public Map<String, Field> getDeepDeclaredFields(Class<?> c) {
            return this.classMetaCache.computeIfAbsent(c, this::buildDeepFieldMap);
        }

        @Override
        public ConverterOptions getConverterOptions() {
            return this.converterOptions;
        }

        @Override
        public Object getCustomOption(String key) {
            return this.customOptions.get(key);
        }

        public Map<String, Field> buildDeepFieldMap(Class<?> c) {
            Convention.throwIfNull(c, (String)"class cannot be null");
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            HashSet<String> exclusions = new HashSet<String>();
            for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
                Set<String> excludedInjectors;
                Field[] fields = curr.getDeclaredFields();
                Set<String> excludedForClass = this.excludedFieldNames.get(curr);
                if (excludedForClass != null) {
                    exclusions.addAll(excludedForClass);
                }
                if ((excludedInjectors = this.excludedInjectorFields.get(curr)) != null) {
                    exclusions.addAll(excludedInjectors);
                }
                for (Field field : fields) {
                    String name;
                    if (Modifier.isStatic(field.getModifiers()) || exclusions.contains(field.getName()) || this.fieldIsFiltered(field) || map.putIfAbsent(name = field.getName(), field) == null) continue;
                    map.put(field.getDeclaringClass().getSimpleName() + '.' + name, field);
                }
            }
            return Collections.unmodifiableMap(map);
        }

        private boolean fieldIsFiltered(Field field) {
            for (FieldFilter filter : this.fieldFilters) {
                if (!filter.filter(field)) continue;
                return true;
            }
            return false;
        }

        private static final class NullClass
        implements JsonReader.JsonClassReader {
            private NullClass() {
            }
        }
    }

    public static class DefaultConverterOptions
    implements ConverterOptions {
        private ZoneId zoneId = ZoneId.systemDefault();
        private Locale locale = Locale.getDefault();
        private Charset charset = StandardCharsets.UTF_8;
        private ClassLoader classloader = DefaultConverterOptions.class.getClassLoader();
        private Character trueChar = CommonValues.CHARACTER_ONE;
        private Character falseChar = CommonValues.CHARACTER_ZERO;
        private Map<String, Object> customOptions = new ConcurrentHashMap<String, Object>();
        private Map<Map.Entry<Class<?>, Class<?>>, Convert<?>> converterOverrides = new ConcurrentHashMap(100, 0.8f);

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public ClassLoader getClassLoader() {
            return this.classloader;
        }

        public Character trueChar() {
            return this.trueChar;
        }

        public Character falseChar() {
            return this.falseChar;
        }

        public Map<Map.Entry<Class<?>, Class<?>>, Convert<?>> getConverterOverrides() {
            return this.converterOverrides;
        }

        public <T> T getCustomOption(String name) {
            return (T)this.customOptions.get(name);
        }
    }
}

