/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect;

import com.cedarsoftware.util.reflect.Accessor;
import com.cedarsoftware.util.reflect.AccessorFactory;
import com.cedarsoftware.util.reflect.ClassDescriptor;
import com.cedarsoftware.util.reflect.FieldFilter;
import com.cedarsoftware.util.reflect.Injector;
import com.cedarsoftware.util.reflect.InjectorFactory;
import com.cedarsoftware.util.reflect.KnownFilteredFields;
import com.cedarsoftware.util.reflect.ReflectionUtils;
import com.cedarsoftware.util.reflect.factories.BooleanAccessorFactory;
import com.cedarsoftware.util.reflect.factories.EnumNameAccessorFactory;
import com.cedarsoftware.util.reflect.factories.MappedMethodAccessorFactory;
import com.cedarsoftware.util.reflect.factories.MappedMethodInjectorFactory;
import com.cedarsoftware.util.reflect.filters.EnumFilter;
import com.cedarsoftware.util.reflect.filters.GroovyFilter;
import com.cedarsoftware.util.reflect.filters.StaticFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ClassDescriptors {
    private final List<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
    private final List<AccessorFactory> accessorFactories;
    private final List<InjectorFactory> injectorFactories;
    private final Map<Class<?>, Map<String, Accessor>> deepAccessors;
    private final Map<Class<?>, Map<String, Injector>> deepInjectors;
    private static final ClassDescriptors instance = new ClassDescriptors();

    private ClassDescriptors() {
        this.fieldFilters.add(new StaticFilter());
        this.fieldFilters.add(new GroovyFilter());
        this.fieldFilters.add(new EnumFilter());
        this.accessorFactories = new ArrayList<AccessorFactory>();
        this.accessorFactories.add(new MappedMethodAccessorFactory());
        this.accessorFactories.add(new BooleanAccessorFactory());
        this.accessorFactories.add(new EnumNameAccessorFactory());
        this.injectorFactories = new ArrayList<InjectorFactory>();
        this.injectorFactories.add(new MappedMethodInjectorFactory());
        this.deepAccessors = new ConcurrentHashMap();
        this.deepInjectors = new ConcurrentHashMap();
    }

    public static ClassDescriptors instance() {
        return instance;
    }

    public Map<String, Accessor> getDeepAccessorMap(Class<?> classToTraverse) {
        return this.deepAccessors.computeIfAbsent(classToTraverse, this::buildDeepAccessors);
    }

    public Collection<Accessor> getDeepAccessors(Class<?> c) {
        return this.getDeepAccessorMap(c).values();
    }

    public Map<String, Injector> getDeepInjectorMap(Class<?> classToTraverse) {
        return this.deepInjectors.computeIfAbsent(classToTraverse, this::buildDeepInjectors);
    }

    private Map<String, Accessor> buildDeepAccessors(Class<?> classToTraverse) {
        LinkedHashMap<String, Accessor> accessorMap = new LinkedHashMap<String, Accessor>();
        for (Class<?> c = classToTraverse; c != null; c = c.getSuperclass()) {
            this.buildAccessors(c, accessorMap);
        }
        return accessorMap;
    }

    private Map<String, Injector> buildDeepInjectors(Class<?> classToTraverse) {
        LinkedHashMap<String, Injector> injectorMap = new LinkedHashMap<String, Injector>();
        for (Class<?> c = classToTraverse; c != null; c = c.getSuperclass()) {
            this.buildInjectors(c, injectorMap);
        }
        return injectorMap;
    }

    public void clearDescriptorCache() {
        this.deepInjectors.clear();
        this.deepAccessors.clear();
    }

    private void buildAccessors(Class<?> c, Map<String, Accessor> accessorMap) {
        Field[] declaredFields;
        Map<String, Method> possibleMethods = ReflectionUtils.buildAccessorMap(c);
        for (Field field : declaredFields = c.getDeclaredFields()) {
            boolean isKnownFilter = KnownFilteredFields.instance().isFieldFiltered(field);
            if (isKnownFilter || this.fieldFilters.stream().anyMatch(f -> f.filter(field))) continue;
            Optional<Accessor> accessor = this.accessorFactories.stream().map(factory -> {
                try {
                    return factory.createAccessor(field, possibleMethods);
                }
                catch (Throwable t) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst();
            String fieldName = field.getName();
            String key = accessorMap.containsKey(fieldName) ? c.getSimpleName() + '.' + fieldName : fieldName;
            accessorMap.put(key, accessor.orElseGet(() -> {
                try {
                    return new Accessor(field);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    return null;
                }
            }));
        }
    }

    private void buildInjectors(Class<?> c, Map<String, Injector> injectorMap) {
        Field[] declaredFields;
        Map<String, Method> possibleInjectors = ReflectionUtils.buildInjectorMap(c);
        for (Field field : declaredFields = c.getDeclaredFields()) {
            boolean isKnownFilter = KnownFilteredFields.instance().isFieldFiltered(field);
            boolean isInjectionFiltered = KnownFilteredFields.instance().isInjectionFiltered(field);
            if (isKnownFilter || isInjectionFiltered || this.fieldFilters.stream().anyMatch(f -> f.filter(field))) continue;
            Optional<Injector> injector = this.injectorFactories.stream().map(factory -> {
                try {
                    return factory.createInjector(field, possibleInjectors);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst();
            String fieldName = field.getName();
            String key = injectorMap.containsKey(fieldName) ? c.getSimpleName() + '.' + fieldName : fieldName;
            injectorMap.put(key, injector.orElseGet(() -> {
                try {
                    return new Injector(field);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    return null;
                }
            }));
        }
    }

    public boolean addFilter(FieldFilter filter) {
        this.clearDescriptorCache();
        return this.fieldFilters.add(filter);
    }

    public boolean removeFilter(FieldFilter filter) {
        this.clearDescriptorCache();
        return this.fieldFilters.remove(filter);
    }

    public class ClassDescriptorImpl
    implements ClassDescriptor {
        private final Map<String, Accessor> accessors = new LinkedHashMap<String, Accessor>();
        private final Map<String, Injector> injectors = new LinkedHashMap<String, Injector>();

        public void addAccessor(String name, Accessor accessor) {
            if (accessor == null) {
                return;
            }
            this.accessors.put(name, accessor);
        }

        public void addInjector(String name, Injector injector) {
            if (injector == null) {
                return;
            }
            this.injectors.put(name, injector);
        }

        @Override
        public Map<String, Accessor> getAccessors() {
            return this.accessors;
        }

        @Override
        public Map<String, Injector> getInjectors() {
            return this.injectors;
        }
    }
}

