/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.MetaUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class Injector {
    private final Class<?> type;
    private final Class<?> declaringClass;
    private final Type genericType;
    private final String name;
    private final String displayName;
    private MethodHandle injector;

    public Injector(Field field) throws Throwable {
        this.name = field.getName();
        this.displayName = field.getName();
        this.type = field.getType();
        this.declaringClass = field.getDeclaringClass();
        this.genericType = field.getGenericType();
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            MetaUtils.trySetAccessible(field);
        }
        try {
            this.injector = MethodHandles.lookup().unreflectSetter(field);
        }
        catch (Exception e) {
            this.injector = null;
        }
    }

    public Injector(Field field, Method method) throws Throwable {
        this.name = field.getName();
        this.type = field.getType();
        this.declaringClass = field.getDeclaringClass();
        this.genericType = field.getGenericType();
        this.displayName = method.getName();
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            MetaUtils.trySetAccessible(method);
        }
        this.injector = MethodHandles.lookup().unreflect(method);
    }

    public void inject(Object object, Object value) {
        if (object == null) {
            throw new JsonIoException("Attempting to set field: " + this.getName() + " on null object.");
        }
        try {
            this.injector.invoke(object, value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            throw new JsonIoException("Attempting to set field: " + this.getName() + " using " + this.getDisplayName(), t);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

