/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeFactory
extends AbstractTemporalFactory<ZonedDateTime> {
    public ZonedDateTimeFactory(DateTimeFormatter dateFormatter, ZoneId zoneId) {
        super(dateFormatter, zoneId);
    }

    public ZonedDateTimeFactory() {
        super(DateTimeFormatter.ISO_ZONED_DATE_TIME, ZoneId.systemDefault());
    }

    @Override
    protected ZonedDateTime fromString(String s) {
        try {
            return ZonedDateTime.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            return this.convertToZonedDateTime(s);
        }
    }

    @Override
    protected ZonedDateTime fromJsonObject(JsonObject job, ReaderContext context) {
        String dateTime = (String)job.get("dateTime");
        LocalDateTime localDateTime = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        JsonObject zone = (JsonObject)job.get("zone");
        String id = (String)this.checkReferences(context, zone, "id");
        ZoneId zoneId = ZoneId.of(id);
        JsonObject offsetMap = (JsonObject)job.get("offset");
        Number totalSeconds = (Number)this.checkReferences(context, offsetMap, "totalSeconds");
        if (totalSeconds == null) {
            return ZonedDateTime.of(localDateTime, zoneId);
        }
        return ZonedDateTime.ofStrict(localDateTime, ZoneOffset.ofTotalSeconds(totalSeconds.intValue()), zoneId);
    }

    private <T> T checkReferences(ReaderContext context, JsonObject job, String key) {
        if (job == null) {
            return null;
        }
        return (T)context.getReferences().get(job).get(key);
    }
}

