/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import com.cedarsoftware.util.io.factory.DateFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class InstantFactory
extends AbstractTemporalFactory<Instant> {
    public InstantFactory(DateTimeFormatter dateFormatter, ZoneId zoneId) {
        super(dateFormatter, zoneId);
    }

    public InstantFactory() {
        super(DateTimeFormatter.ISO_INSTANT, ZoneId.systemDefault());
    }

    @Override
    protected Instant fromString(String s) {
        try {
            return this.dateTimeFormatter.parse((CharSequence)s, Instant::from);
        }
        catch (Exception e) {
            Date date = DateFactory.parseDate(s);
            if (date == null) {
                throw new JsonIoException("Could not parse date: " + s);
            }
            return date.toInstant();
        }
    }

    @Override
    protected Instant fromJsonObject(JsonObject job, ReaderContext context) {
        return null;
    }
}

