/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.ReferenceTracker;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class Resolver {
    final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    final Map<Class<?>, Optional<JsonReader.JsonClassReader>> readerCache = new HashMap();
    private final Collection<Object[]> prettyMaps = new ArrayList<Object[]>();
    protected final Collection<Missingfields> missingFields = new ArrayList<Missingfields>();
    private final ReadOptions readOptions;
    private final ReferenceTracker references;

    @Deprecated
    protected JsonReader getReader() {
        return ReaderContext.instance().getReader();
    }

    protected Resolver(ReadOptions readOptions, ReferenceTracker references) {
        this.readOptions = readOptions;
        this.references = references;
    }

    protected <T> T convertMapsToObjects(JsonObject root) {
        if (root.isFinished) {
            return (T)root.target;
        }
        ArrayDeque<JsonObject> stack = new ArrayDeque<JsonObject>();
        stack.addFirst(root);
        while (!stack.isEmpty()) {
            JsonObject jsonObj = (JsonObject)stack.removeFirst();
            if (jsonObj.isArray()) {
                this.traverseArray(stack, jsonObj);
                continue;
            }
            if (jsonObj.isCollection()) {
                this.traverseCollection(stack, jsonObj);
                continue;
            }
            if (jsonObj.isMap()) {
                this.traverseMap(stack, jsonObj);
                continue;
            }
            Object special = this.readWithFactoryIfExists(jsonObj, null, stack);
            if (special != null) {
                jsonObj.target = special;
                continue;
            }
            this.traverseFields(stack, jsonObj);
        }
        return (T)root.target;
    }

    protected abstract Object readWithFactoryIfExists(Object var1, Class var2, Deque<JsonObject> var3);

    public abstract void traverseFields(Deque<JsonObject> var1, JsonObject var2);

    public abstract void traverseFields(Deque<JsonObject> var1, JsonObject var2, Set<String> var3);

    protected abstract void traverseCollection(Deque<JsonObject> var1, JsonObject var2);

    protected abstract void traverseArray(Deque<JsonObject> var1, JsonObject var2);

    protected void cleanup() {
        this.patchUnresolvedReferences();
        this.rehashMaps();
        this.references.clear();
        this.unresolvedRefs.clear();
        this.prettyMaps.clear();
        this.readerCache.clear();
        this.handleMissingFields();
    }

    private void handleMissingFields() {
        JsonReader.MissingFieldHandler missingFieldHandler = this.readOptions.getMissingFieldHandler();
        if (missingFieldHandler != null) {
            for (Missingfields mf : this.missingFields) {
                missingFieldHandler.fieldMissing(mf.target, mf.fieldName, mf.value);
            }
        }
    }

    protected void traverseMap(Deque<JsonObject> stack, JsonObject jsonObj) {
        Resolver.convertMapToKeysItems(jsonObj);
        Object[] keys = (Object[])jsonObj.get("@keys");
        Object[] items = jsonObj.getArray();
        if (keys == null || items == null) {
            if (keys != items) {
                throw new JsonIoException("Unbalanced Object in JSON, it has @keys or @items empty");
            }
            return;
        }
        int size = keys.length;
        if (size != items.length) {
            throw new JsonIoException("Map written with @keys and @itemss entries of different sizes");
        }
        Resolver.buildCollection(stack, keys);
        Resolver.buildCollection(stack, items);
        this.prettyMaps.add(new Object[]{jsonObj, keys, items});
    }

    private static void buildCollection(Deque<JsonObject> stack, Object[] arrayContent) {
        JsonObject collection = new JsonObject();
        collection.put("@items", arrayContent);
        collection.target = arrayContent;
        stack.addFirst(collection);
    }

    protected static void convertMapToKeysItems(JsonObject map) {
        if (!map.containsKey("@keys") && !map.isReference()) {
            Object[] keys = new Object[map.size()];
            Object[] values = new Object[map.size()];
            int i = 0;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = iterator.next();
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            String saveType = map.getType();
            map.clear();
            map.setType(saveType);
            map.put("@keys", keys);
            map.put("@items", values);
        }
    }

    protected Object createInstance(Class clazz, JsonObject jsonObj) {
        Object mayEnumSpecial;
        String type = jsonObj.type;
        if ("java.lang.Object".equals(type)) {
            Object value = jsonObj.getValue();
            if (jsonObj.keySet().size() == 1 && value != null) {
                type = value.getClass().getName();
            }
        }
        if (type == null && (mayEnumSpecial = jsonObj.get("@enum")) instanceof String) {
            jsonObj.type = type = "java.util.EnumSet";
        }
        if (type != null) {
            return this.createInstanceUsingType(jsonObj);
        }
        return this.createInstanceUsingClass(clazz, jsonObj);
    }

    protected Object createInstanceUsingType(JsonObject jsonObj) {
        Object mate;
        String type = jsonObj.type;
        boolean failOnUnknownType = this.getReadOptions().isFailOnUnknownType();
        Class<Object> c = MetaUtils.classForName(type, this.readOptions.getClassLoader());
        if (c == null) {
            if (failOnUnknownType) {
                throw new JsonIoException("Unable to create class: " + type + ". If you don't want to see this error, you can turn off 'failOnUnknownType' and a LinkedHashMap or failOnUnknownClass() will be used instead.");
            }
            c = this.getReadOptions().getUnknownTypeClass();
            if (c == null) {
                c = LinkedHashMap.class;
            }
        }
        if ((mate = this.createInstanceUsingClassFactory(c, jsonObj)) != null) {
            return mate;
        }
        if (c.isArray()) {
            int size;
            Object[] items = jsonObj.getArray();
            int n = size = items == null ? 0 : items.length;
            if (c == char[].class) {
                jsonObj.moveCharsToMate();
                mate = jsonObj.target;
            } else {
                mate = Array.newInstance(c.getComponentType(), size);
            }
        } else if (MetaUtils.isPrimitive(c)) {
            mate = MetaUtils.convert(c, jsonObj.getValue());
            jsonObj.isFinished = true;
        } else if (c == Class.class) {
            mate = MetaUtils.classForName((String)jsonObj.getValue(), this.readOptions.getClassLoader());
        } else if (EnumSet.class.isAssignableFrom(c)) {
            mate = this.extractEnumSet(c, jsonObj);
            jsonObj.isFinished = true;
        } else {
            mate = this.coerceCertainTypes(c.getName());
            if (mate == null) {
                mate = MetaUtils.newInstance(c, null);
            }
        }
        jsonObj.setTarget(mate);
        return mate;
    }

    protected Object createInstanceUsingClass(Class clazz, JsonObject jsonObj) {
        Object mate = this.createInstanceUsingClassFactory(clazz, jsonObj);
        if (mate != null) {
            return mate;
        }
        Object[] items = jsonObj.getArray();
        boolean useMaps = this.getReadOptions().isUsingMaps();
        if (clazz.isArray() || items != null && clazz == Object.class && !jsonObj.containsKey("@keys")) {
            int size = items == null ? 0 : items.length;
            mate = Array.newInstance(clazz.isArray() ? clazz.getComponentType() : Object.class, size);
        } else {
            mate = this.coerceCertainTypes(clazz.getName());
            if (mate == null) {
                if (clazz == Object.class && !useMaps) {
                    Class<?> unknownClass = this.getReadOptions().getUnknownTypeClass();
                    if (unknownClass == null) {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.type = Map.class.getName();
                        mate = jsonObject;
                    } else {
                        mate = MetaUtils.newInstance(unknownClass, null);
                    }
                } else {
                    mate = MetaUtils.newInstance(clazz, null);
                }
            }
        }
        jsonObj.setTarget(mate);
        return jsonObj.getTarget();
    }

    Object createInstanceUsingClassFactory(Class c, JsonObject jsonObj) {
        if (jsonObj.target != null) {
            return jsonObj.target;
        }
        JsonReader.ClassFactory classFactory = this.getReadOptions().getClassFactory(c);
        if (classFactory == null) {
            return null;
        }
        Object target = classFactory.newInstance(c, jsonObj);
        if (classFactory.isObjectFinal()) {
            return jsonObj.setFinishedTarget(target, true);
        }
        jsonObj.setTarget(target);
        return target;
    }

    protected Object coerceCertainTypes(String type) {
        Class<?> clazz = this.getReadOptions().getCoercedType(type);
        if (clazz == null) {
            return null;
        }
        return MetaUtils.newInstance(clazz, null);
    }

    protected JsonReader.JsonClassReader getCustomReader(Class c) {
        return this.readerCache.computeIfAbsent(c, key -> this.getReadOptions().getClosestReader((Class<?>)key)).orElse(null);
    }

    protected EnumSet<?> extractEnumSet(Class c, JsonObject jsonObj) {
        String enumClassName = (String)jsonObj.get("@enum");
        Class<?> enumClass = enumClassName == null ? null : MetaUtils.classForName(enumClassName, this.readOptions.getClassLoader());
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            if (enumClass != null) {
                return EnumSet.noneOf(enumClass);
            }
            return EnumSet.noneOf(MetaUtils.Dumpty.class);
        }
        if (enumClass == null) {
            throw new JsonIoException("Could not figure out Enum of the not empty set " + jsonObj);
        }
        EnumSet<?> enumSet = null;
        for (Object item : items) {
            Object enumItem;
            if (item instanceof String) {
                enumItem = Enum.valueOf(enumClass, (String)item);
            } else {
                JsonObject jObj = (JsonObject)item;
                enumItem = Enum.valueOf(enumClass, (String)jObj.get("name"));
            }
            if (enumSet == null) {
                enumSet = EnumSet.of(enumItem);
                continue;
            }
            enumSet.add(enumItem);
        }
        return enumSet;
    }

    protected void patchUnresolvedReferences() {
        for (UnresolvedReference ref : this.unresolvedRefs) {
            Object objToFix = ((UnresolvedReference)ref).referencingObj.target;
            JsonObject objReferenced = this.references.get(ref.refId);
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List<Object> list = (List<Object>)objToFix;
                    list.set(ref.index, objReferenced.target);
                    String containingTypeName = ((UnresolvedReference)ref).referencingObj.type;
                    if (containingTypeName == null || !containingTypeName.startsWith("java.util.Immutable") || !containingTypeName.contains("List") || !list.stream().noneMatch(c -> c == null || c instanceof JsonObject)) continue;
                    ((UnresolvedReference)ref).referencingObj.target = list = MetaUtils.listOf(list.toArray());
                    continue;
                }
                if (objToFix instanceof Collection) {
                    String containingTypeName = ((UnresolvedReference)ref).referencingObj.type;
                    Collection col = (Collection)objToFix;
                    if (containingTypeName != null && containingTypeName.startsWith("java.util.Immutable") && containingTypeName.contains("Set")) {
                        throw new JsonIoException("Error setting set entry of ImmutableSet '" + ((UnresolvedReference)ref).referencingObj.type + "', @ref = " + ref.refId);
                    }
                    col.add(objReferenced.target);
                    continue;
                }
                Array.set(objToFix, ref.index, objReferenced.target);
                continue;
            }
            Field field = MetaUtils.getField(objToFix.getClass(), ref.field);
            if (field == null) continue;
            try {
                MetaUtils.setFieldValue(field, objToFix, objReferenced.target);
            }
            catch (Exception e) {
                throw new JsonIoException("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
            }
        }
        this.unresolvedRefs.clear();
    }

    protected void rehashMaps() {
        boolean useMapsLocal = this.getReadOptions().isUsingMaps();
        for (Object[] mapPieces : this.prettyMaps) {
            Object[] javaValues;
            Object[] javaKeys;
            Map<Object, Object> map;
            JsonObject jObj = (JsonObject)mapPieces[0];
            if (useMapsLocal) {
                map = jObj;
                javaKeys = (Object[])jObj.remove("@keys");
                javaValues = (Object[])jObj.remove("@items");
            } else {
                map = (Map)jObj.target;
                javaKeys = (Object[])mapPieces[1];
                javaValues = (Object[])mapPieces[2];
                jObj.clear();
            }
            for (int j = 0; javaKeys != null && j < javaKeys.length; ++j) {
                map.put(javaKeys[j], javaValues[j]);
            }
        }
    }

    protected ReadOptions getReadOptions() {
        return this.readOptions;
    }

    protected ReferenceTracker getReferences() {
        return this.references;
    }

    private static final class NullClass
    implements JsonReader.JsonClassReader {
        private NullClass() {
        }
    }

    protected static class Missingfields {
        private Object target;
        private String fieldName;
        private Object value;

        public Missingfields(Object target, String fieldName, Object value) {
            this.target = target;
            this.fieldName = fieldName;
            this.value = value;
        }
    }

    static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }
}

