/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ReadOptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Readers {
    private Readers() {
    }

    private static Object getValueFromJsonObject(Object o, Object value, String typeName) {
        if (o instanceof JsonObject) {
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                value = jObj.getValue();
            } else {
                throw new JsonIoException(typeName + " defined as JSON {} object, missing 'value' field");
            }
        }
        return value;
    }

    public static BigInteger bigIntegerFrom(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("".equals(s.trim())) {
                return null;
            }
            try {
                return new BigInteger(MetaUtils.removeLeadingAndTrailingQuotes(s));
            }
            catch (Exception e) {
                throw new JsonIoException("Could not parse '" + value + "' as BigInteger.", e);
            }
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return bd.toBigInteger();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (value instanceof Double || value instanceof Float) {
            return new BigDecimal(((Number)value).doubleValue()).toBigInteger();
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return new BigInteger(value.toString());
        }
        throw new JsonIoException("Could not convert value: " + value.toString() + " to BigInteger.");
    }

    public static BigDecimal bigDecimalFrom(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("".equals(s.trim())) {
                return null;
            }
            try {
                return new BigDecimal(MetaUtils.removeLeadingAndTrailingQuotes(s));
            }
            catch (Exception e) {
                throw new JsonIoException("Could not parse '" + s + "' as BigDecimal.", e);
            }
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Double || value instanceof Short || value instanceof Byte || value instanceof Float) {
            return new BigDecimal(value.toString());
        }
        throw new JsonIoException("Could not convert value: " + value + " to BigInteger.");
    }

    public static class RecordReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            try {
                Object[] recordComponents;
                JsonObject jsonObj = (JsonObject)o;
                ArrayList<Class> lParameterTypes = new ArrayList<Class>(jsonObj.size());
                ArrayList<Object> lParameterValues = new ArrayList<Object>(jsonObj.size());
                Class<?> c = Class.forName(jsonObj.getType());
                Method getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
                for (Object recordComponent : recordComponents = (Object[])getRecordComponents.invoke(c, new Object[0])) {
                    Class type = (Class)recordComponent.getClass().getMethod("getType", new Class[0]).invoke(recordComponent, new Object[0]);
                    lParameterTypes.add(type);
                    String parameterName = (String)recordComponent.getClass().getMethod("getName", new Class[0]).invoke(recordComponent, new Object[0]);
                    JsonObject parameterValueJsonObj = new JsonObject();
                    parameterValueJsonObj.setType(type.getName());
                    parameterValueJsonObj.put("value", jsonObj.get(parameterName));
                    if (parameterValueJsonObj.isLogicalPrimitive()) {
                        lParameterValues.add(parameterValueJsonObj.getPrimitiveValue());
                        continue;
                    }
                    lParameterValues.add(parameterValueJsonObj.getValue());
                }
                Constructor<?> constructor = c.getDeclaredConstructor(lParameterTypes.toArray(new Class[0]));
                try {
                    constructor.setAccessible(true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return constructor.newInstance(lParameterValues.toArray(new Object[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Record de-serialization only works with java>=16.", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class UUIDReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            if (o instanceof String) {
                try {
                    return UUID.fromString((String)o);
                }
                catch (Exception e) {
                    throw new JsonIoException("Unable to load UUID from JSON string: " + o, e);
                }
            }
            JsonObject jObj = UUIDReader.getJsonObject((JsonObject)o);
            return jObj.getTarget();
        }

        private static JsonObject getJsonObject(JsonObject o) {
            JsonObject jObj = o;
            Long mostSigBits = (Long)jObj.get("mostSigBits");
            if (mostSigBits == null) {
                throw new JsonIoException("java.util.UUID must specify 'mostSigBits' field and it cannot be empty in JSON");
            }
            Long leastSigBits = (Long)jObj.get("leastSigBits");
            if (leastSigBits == null) {
                throw new JsonIoException("java.util.UUID must specify 'leastSigBits' field and it cannot be empty in JSON");
            }
            UUID uuid = new UUID(mostSigBits, leastSigBits);
            jObj.setTarget(uuid);
            return jObj;
        }
    }

    public static class StringBufferReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            if (o instanceof String) {
                return new StringBuffer((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = new StringBuffer((String)jObj.getValue());
                return jObj.target;
            }
            throw new JsonIoException("StringBuffer missing 'value' field");
        }
    }

    public static class StringBuilderReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            if (o instanceof String) {
                return new StringBuilder((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = new StringBuilder((String)jObj.getValue());
                return jObj.target;
            }
            throw new JsonIoException("StringBuilder missing 'value' field");
        }
    }

    public static class BigDecimalReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            JsonObject jObj = null;
            Object value = o;
            if (o instanceof JsonObject) {
                jObj = (JsonObject)o;
                if (jObj.containsKey("value")) {
                    value = jObj.getValue();
                } else {
                    throw new JsonIoException("BigDecimal missing 'value' field");
                }
            }
            if (value instanceof JsonObject) {
                JsonObject valueObj = (JsonObject)value;
                if ("java.math.BigInteger".equals(valueObj.type)) {
                    BigIntegerReader reader = new BigIntegerReader();
                    value = reader.read(value, stack, options);
                } else if ("java.math.BigDecimal".equals(valueObj.type)) {
                    value = this.read(value, stack, options);
                } else {
                    return Readers.bigDecimalFrom(valueObj.getValue());
                }
            }
            BigDecimal x = Readers.bigDecimalFrom(value);
            if (jObj != null) {
                jObj.target = x;
            }
            return x;
        }
    }

    public static class BigIntegerReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            JsonObject jObj = null;
            Object value = o;
            if (o instanceof JsonObject) {
                jObj = (JsonObject)o;
                if (jObj.containsKey("value")) {
                    value = jObj.getValue();
                } else {
                    throw new JsonIoException("BigInteger missing 'value' field");
                }
            }
            if (value instanceof JsonObject) {
                JsonObject valueObj = (JsonObject)value;
                if ("java.math.BigDecimal".equals(valueObj.type)) {
                    BigDecimalReader reader = new BigDecimalReader();
                    value = reader.read(value, stack, options);
                } else if ("java.math.BigInteger".equals(valueObj.type)) {
                    value = this.read(value, stack, options);
                } else {
                    return Readers.bigIntegerFrom(valueObj.getValue());
                }
            }
            BigInteger x = Readers.bigIntegerFrom(value);
            if (jObj != null) {
                jObj.target = x;
            }
            return x;
        }
    }

    public static class AtomicLongReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            Object value = o;
            if ((value = Readers.getValueFromJsonObject(o, value, "AtomicLong")) instanceof String) {
                String num = (String)value;
                if ("".equals(num.trim())) {
                    return null;
                }
                return new AtomicLong(Long.parseLong(MetaUtils.removeLeadingAndTrailingQuotes(num)));
            }
            if (value instanceof Number && !(value instanceof Double) && !(value instanceof Float)) {
                return new AtomicLong(((Number)value).longValue());
            }
            throw new JsonIoException("Unknown value in JSON assigned to AtomicLong, value type = " + value.getClass().getName());
        }
    }

    public static class AtomicIntegerReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            Object value = o;
            if ((value = Readers.getValueFromJsonObject(o, value, "AtomicInteger")) instanceof String) {
                String num = (String)value;
                if ("".equals(num.trim())) {
                    return null;
                }
                return new AtomicInteger(Integer.parseInt(MetaUtils.removeLeadingAndTrailingQuotes(num)));
            }
            if (value instanceof Number && !(value instanceof Double) && !(value instanceof Float)) {
                return new AtomicInteger(((Number)value).intValue());
            }
            throw new JsonIoException("Unknown value in JSON assigned to AtomicInteger, value type = " + value.getClass().getName());
        }
    }

    public static class AtomicBooleanReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            Object value = o;
            if ((value = Readers.getValueFromJsonObject(o, value, "AtomicBoolean")) instanceof String) {
                String state = (String)value;
                if ("".equals(state.trim())) {
                    return null;
                }
                return new AtomicBoolean("true".equalsIgnoreCase(state));
            }
            if (value instanceof Boolean) {
                return new AtomicBoolean((Boolean)value);
            }
            if (value instanceof Number && !(value instanceof Double) && !(value instanceof Float)) {
                return new AtomicBoolean(((Number)value).longValue() != 0L);
            }
            throw new JsonIoException("Unknown value in JSON assigned to AtomicBoolean, value type = " + value.getClass().getName());
        }
    }

    public static class ClassReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            if (o instanceof String) {
                String cname = (String)o;
                Class<?> c = MetaUtils.classForName(cname, options.getClassLoader());
                if (c != null) {
                    return c;
                }
                throw new JsonIoException("Unable to load class: " + o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                String value = (String)jObj.getValue();
                jObj.target = MetaUtils.classForName(value, options.getClassLoader());
                if (jObj.target == null) {
                    throw new JsonIoException("Unable to load Class: " + value + ", class not found in JVM.");
                }
                return jObj.target;
            }
            throw new JsonIoException("Class missing 'value' field");
        }
    }

    public static class StringReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            if (o instanceof String) {
                return o;
            }
            if (MetaUtils.isPrimitive(o.getClass())) {
                return o.toString();
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = jObj.getValue();
                return jObj.target;
            }
            throw new JsonIoException("String missing 'value' field");
        }
    }

    public static class CalendarReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            String time = null;
            try {
                Class<?> c;
                JsonObject jObj = (JsonObject)o;
                time = (String)jObj.get("time");
                if (time == null) {
                    throw new JsonIoException("Calendar missing 'time' field");
                }
                Date date = MetaUtils.dateFormat.get().parse(time);
                if (jObj.getTarget() != null) {
                    c = jObj.getTarget().getClass();
                } else {
                    String type = jObj.type;
                    c = MetaUtils.classForName(type, options.getClassLoader());
                    if (c == null) {
                        throw new JsonIoException("Unable to load class: " + type + ", a Calendar type.");
                    }
                }
                Calendar calendar = (Calendar)MetaUtils.newInstance(c, null);
                calendar.setTime(date);
                jObj.setFinishedTarget(calendar, true);
                String zone = (String)jObj.get("zone");
                if (zone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(zone));
                }
                return calendar;
            }
            catch (Exception e) {
                throw new JsonIoException("Failed to parse calendar, time: " + time);
            }
        }
    }

    public static class LocaleReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            JsonObject jObj = (JsonObject)o;
            Object language = jObj.get("language");
            if (language == null) {
                throw new JsonIoException("java.util.Locale must specify 'language' field");
            }
            Object country = jObj.get("country");
            Object variant = jObj.get("variant");
            if (country == null) {
                jObj.target = new Locale((String)language);
                return jObj.target;
            }
            if (variant == null) {
                jObj.target = new Locale((String)language, (String)country);
                return jObj.target;
            }
            jObj.target = new Locale((String)language, (String)country, (String)variant);
            return jObj.target;
        }
    }

    public static class URLReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject> stack, ReadOptions options) {
            boolean isString = o instanceof String;
            try {
                if (isString) {
                    URI uri = URI.create((String)o);
                    return uri.toURL();
                }
                return this.createURLFromJsonObject((JsonObject)o);
            }
            catch (MalformedURLException e) {
                throw new JsonIoException("java.net.URL malformed URL:  " + (o instanceof String ? o : e.getMessage()));
            }
        }

        URL createURLFromJsonObject(JsonObject jObj) throws MalformedURLException {
            jObj.target = jObj.containsKey("value") ? this.createUrlNewWay(jObj) : this.createUrlOldWay(jObj);
            return (URL)jObj.target;
        }

        URL createUrlNewWay(JsonObject jObj) throws MalformedURLException {
            return URI.create((String)jObj.getValue()).toURL();
        }

        URL createUrlOldWay(JsonObject jObj) throws MalformedURLException {
            String protocol = (String)jObj.get("protocol");
            String host = (String)jObj.get("host");
            String file = (String)jObj.get("file");
            String authority = (String)jObj.get("authority");
            String ref = (String)jObj.get("ref");
            Long port = (Long)jObj.get("port");
            StringBuilder builder = new StringBuilder(protocol + ":");
            if (!protocol.equalsIgnoreCase("jar")) {
                builder.append("//");
            }
            if (authority != null && !authority.isEmpty()) {
                builder.append(authority);
            } else {
                if (host != null && !host.isEmpty()) {
                    builder.append(host);
                }
                if (!port.equals(-1L)) {
                    builder.append(":" + port);
                }
            }
            if (file != null && !file.isEmpty()) {
                builder.append(file);
            }
            if (ref != null && !ref.isEmpty()) {
                builder.append("#" + ref);
            }
            return new URL(builder.toString());
        }
    }
}

