/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReadOptionsBuilder {
    ConcurrentMap<String, Object> readOptions = new ConcurrentHashMap<String, Object>();

    public ReadOptionsBuilder setUnknownTypeClass(Class c) {
        this.readOptions.put("UNKNOWN_OBJECT", c.getName());
        return this;
    }

    public ReadOptionsBuilder failOnUnknownType() {
        this.readOptions.put("FAIL_ON_UNKNOWN_TYPE", Boolean.TRUE);
        return this;
    }

    public ReadOptionsBuilder withClassLoader(ClassLoader classLoader) {
        this.readOptions.put("CLASSLOADER", classLoader);
        return this;
    }

    public ReadOptionsBuilder returnAsMaps() {
        this.readOptions.put("USE_MAPS", Boolean.TRUE);
        return this;
    }

    public ReadOptionsBuilder withCustomTypeName(Class type, String newTypeName) {
        return this.withCustomTypeName(type.getName(), newTypeName);
    }

    public ReadOptionsBuilder withCustomTypeName(String type, String newTypeName) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "TYPE_NAME_MAP").put(type, newTypeName);
        return this;
    }

    public ReadOptionsBuilder withCustomTypeNameMap(Map<String, String> map) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "TYPE_NAME_MAP").putAll(map);
        return this;
    }

    public ReadOptionsBuilder withCustomReader(Class c, JsonReader.JsonClassReaderEx writer) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "CUSTOM_READERS").put(c, writer);
        return this;
    }

    public ReadOptionsBuilder withCustomReaderMap(Map<Class, JsonReader.JsonClassReaderEx> map) {
        MetaUtils.computeMapIfAbsent(this.readOptions, "CUSTOM_READERS").putAll(map);
        return this;
    }

    public ReadOptionsBuilder withNonCustomizableClass(Class c) {
        MetaUtils.computeSetIfAbsent(this.readOptions, "NOT_CUSTOM_READERS").add(c);
        return this;
    }

    public ReadOptionsBuilder withNonCustomizableClasses(Collection<Class> collection) {
        MetaUtils.computeSetIfAbsent(this.readOptions, "NOT_CUSTOM_READERS").addAll(collection);
        return this;
    }

    public Map<String, Object> build() {
        return this.readOptions;
    }
}

