/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.convert.CollectionsWrappers;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionUtilities {
    private static final Set<?> unmodifiableEmptySet = Collections.emptySet();
    private static final List<?> unmodifiableEmptyList = Collections.emptyList();
    private static final Class<?> unmodifiableCollectionClass = CollectionsWrappers.getUnmodifiableCollectionClass();
    private static final Class<?> synchronizedCollectionClass = CollectionsWrappers.getSynchronizedCollectionClass();

    private CollectionUtilities() {
    }

    public static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean hasContent(Collection<?> col) {
        return col != null && !col.isEmpty();
    }

    public static int size(Collection<?> col) {
        return col == null ? 0 : col.size();
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableEmptyList;
        }
        ArrayList<T> list = new ArrayList<T>(items.length);
        for (T item : items) {
            list.add(item);
        }
        return Collections.unmodifiableList(list);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableEmptySet;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(items.length);
        for (T item : items) {
            set.add(item);
        }
        return Collections.unmodifiableSet(set);
    }

    public static boolean isUnmodifiable(Class<?> targetType) {
        Objects.requireNonNull(targetType, "targetType (Class) cannot be null");
        return unmodifiableCollectionClass.isAssignableFrom(targetType);
    }

    public static boolean isSynchronized(Class<?> targetType) {
        Objects.requireNonNull(targetType, "targetType (Class) cannot be null");
        return synchronizedCollectionClass.isAssignableFrom(targetType);
    }

    public static <T> Collection<T> getUnmodifiableCollection(Collection<T> collection) {
        Objects.requireNonNull(collection, "Collection must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.unmodifiableNavigableSet((NavigableSet)collection);
        }
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <T> Collection<T> getEmptyCollection(Collection<T> collection) {
        Objects.requireNonNull(collection, "Collection must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.emptyNavigableSet();
        }
        if (collection instanceof SortedSet) {
            return Collections.emptySortedSet();
        }
        if (collection instanceof Set) {
            return Collections.emptySet();
        }
        if (collection instanceof List) {
            return Collections.emptyList();
        }
        return Collections.emptySet();
    }

    public static <T extends Collection<?>, E> Collection<E> getCheckedCollection(T collection, Class<E> type) {
        Objects.requireNonNull(collection, "Collection must not be null");
        Objects.requireNonNull(type, "Type (Class) must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.checkedNavigableSet((NavigableSet)collection, type);
        }
        if (collection instanceof SortedSet) {
            return Collections.checkedSortedSet((SortedSet)collection, type);
        }
        if (collection instanceof Set) {
            return Collections.checkedSet((Set)collection, type);
        }
        if (collection instanceof List) {
            return Collections.checkedList((List)collection, type);
        }
        return Collections.checkedCollection(collection, type);
    }

    public static <T> Collection<T> getSynchronizedCollection(Collection<T> collection) {
        Objects.requireNonNull(collection, "Collection must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.synchronizedNavigableSet((NavigableSet)collection);
        }
        if (collection instanceof SortedSet) {
            return Collections.synchronizedSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.synchronizedSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.synchronizedList((List)collection);
        }
        return Collections.synchronizedCollection(collection);
    }

    public static <T> T deepCopyContainers(T source) {
        boolean rootIsPrimitiveArray;
        if (!CollectionUtilities.isContainer(source)) {
            return source;
        }
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>(64);
        ArrayDeque<ContainerPair> workQueue = new ArrayDeque<ContainerPair>();
        Object rootCopy = CollectionUtilities.createContainerCopy(source);
        visited.put(source, rootCopy);
        Class<?> sourceClass = source.getClass();
        boolean bl = rootIsPrimitiveArray = sourceClass.isArray() && sourceClass.getComponentType().isPrimitive();
        if (!rootIsPrimitiveArray) {
            workQueue.add(new ContainerPair(source, rootCopy));
        }
        while (!workQueue.isEmpty()) {
            ContainerPair pair = (ContainerPair)workQueue.poll();
            Class<?> pairSourceClass = pair.source.getClass();
            if (pairSourceClass.isArray()) {
                if (pairSourceClass.getComponentType().isPrimitive()) continue;
                Object[] srcArr = (Object[])pair.source;
                Object[] dstArr = (Object[])pair.target;
                for (Object element : srcArr) {
                    if (CollectionUtilities.isContainer(element)) {
                        Object existingCopy = visited.get(element);
                        if (existingCopy != null) {
                            dstArr[i] = existingCopy;
                            continue;
                        }
                        Class<?> elementClass = element.getClass();
                        if (elementClass.isArray() && elementClass.getComponentType().isPrimitive()) {
                            int elemLength = ArrayUtilities.getLength(element);
                            Class<?> componentType = elementClass.getComponentType();
                            Object elementCopy = Array.newInstance(componentType, elemLength);
                            System.arraycopy(element, 0, elementCopy, 0, elemLength);
                            visited.put(element, elementCopy);
                            dstArr[i] = elementCopy;
                            continue;
                        }
                        Object elementCopy = CollectionUtilities.createContainerCopy(element);
                        visited.put(element, elementCopy);
                        dstArr[i] = elementCopy;
                        workQueue.add(new ContainerPair(element, elementCopy));
                        continue;
                    }
                    dstArr[i] = element;
                }
                continue;
            }
            if (!(pair.source instanceof Collection)) continue;
            Collection sourceCollection = (Collection)pair.source;
            Collection targetCollection = (Collection)pair.target;
            for (Object element : sourceCollection) {
                if (CollectionUtilities.isContainer(element)) {
                    Object existingCopy = visited.get(element);
                    if (existingCopy != null) {
                        targetCollection.add(existingCopy);
                        continue;
                    }
                    Class<?> elementClass = element.getClass();
                    if (elementClass.isArray() && elementClass.getComponentType().isPrimitive()) {
                        int elemLength = ArrayUtilities.getLength(element);
                        Class<?> componentType = elementClass.getComponentType();
                        Object elementCopy = Array.newInstance(componentType, elemLength);
                        System.arraycopy(element, 0, elementCopy, 0, elemLength);
                        visited.put(element, elementCopy);
                        targetCollection.add(elementCopy);
                        continue;
                    }
                    Object elementCopy = CollectionUtilities.createContainerCopy(element);
                    visited.put(element, elementCopy);
                    targetCollection.add(elementCopy);
                    workQueue.add(new ContainerPair(element, elementCopy));
                    continue;
                }
                targetCollection.add(element);
            }
        }
        return (T)rootCopy;
    }

    private static boolean isContainer(Object obj) {
        return obj != null && (obj.getClass().isArray() || obj instanceof Collection);
    }

    private static Object createContainerCopy(Object source) {
        Class<?> sourceClass = source.getClass();
        if (sourceClass.isArray()) {
            int length = ArrayUtilities.getLength(source);
            Class<?> componentType = sourceClass.getComponentType();
            Object newArray = Array.newInstance(componentType, length);
            if (componentType.isPrimitive()) {
                System.arraycopy(source, 0, newArray, 0, length);
            }
            return newArray;
        }
        if (source instanceof EnumSet) {
            EnumSet src = (EnumSet)source;
            if (src.isEmpty()) {
                Object peer = src.clone();
                ((AbstractCollection)peer).clear();
                return peer;
            }
            return EnumSet.noneOf(((Enum)src.iterator().next()).getDeclaringClass());
        }
        if (source instanceof Deque) {
            return new LinkedList();
        }
        if (source instanceof PriorityQueue) {
            PriorityQueue pq = (PriorityQueue)source;
            Comparator cmp = pq.comparator();
            return new PriorityQueue(Math.max(1, pq.size()), cmp);
        }
        if (source instanceof SortedSet) {
            Comparator cmp = ((SortedSet)source).comparator();
            return cmp == null ? new TreeSet() : new TreeSet(cmp);
        }
        if (source instanceof Set) {
            Set srcSet = (Set)source;
            int capacity = (int)((float)srcSet.size() / 0.75f) + 1;
            return new LinkedHashSet(capacity);
        }
        if (source instanceof List) {
            List srcList = (List)source;
            return new ArrayList(srcList.size());
        }
        if (source instanceof Queue) {
            return new LinkedList();
        }
        if (source instanceof Collection) {
            Collection srcCollection = (Collection)source;
            return new ArrayList(srcCollection.size());
        }
        throw new IllegalArgumentException("Unknown container type: " + source.getClass());
    }

    private static class ContainerPair {
        final Object source;
        final Object target;

        ContainerPair(Object source, Object target) {
            this.source = source;
            this.target = target;
        }
    }
}

