/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.MathUtilities;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.SystemUtilities;
import com.cedarsoftware.util.convert.ConvertWithTarget;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.MapConversions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

final class ObjectConversions {
    static final ConvertWithTarget<Map<?, ?>> OBJECT_TO_MAP_CONVERTER = new ConvertWithTarget<Map<?, ?>>(){

        @Override
        public Map<?, ?> convertWithTarget(Object from, Converter converter, Class<?> target) {
            return ObjectConversions.objectToMapWithTarget(from, converter, target);
        }
    };

    ObjectConversions() {
    }

    static Map<String, Object> objectToMap(Object from, Converter converter) {
        Map<String, Object> result;
        if (from == null) {
            return null;
        }
        if (from instanceof Map) {
            Map<String, Object> result2;
            Map<String, Object> mapResult = result2 = MapConversions.mapToMapWithTarget(from, converter, LinkedHashMap.class);
            return mapResult;
        }
        Map<String, Object> mapResult = result = ObjectConversions.objectToMapWithTarget(from, converter, LinkedHashMap.class);
        return mapResult;
    }

    static Map<?, ?> objectToMapWithTarget(Object from, Converter converter, Class<?> toType) {
        if (from == null) {
            return null;
        }
        if (from instanceof Map) {
            return MapConversions.mapToMapWithTarget(from, converter, toType);
        }
        if (ObjectConversions.isPrimitiveOrWrapper(from.getClass())) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("_v", ObjectConversions.convertToJsonCompatible(from, converter));
            return result;
        }
        if (ObjectConversions.isRecord(from.getClass())) {
            return MapConversions.recordToMap(from, converter);
        }
        return ObjectConversions.traverseObjectFields(from, converter);
    }

    private static Map<String, Object> traverseObjectFields(Object rootObj, Converter converter) {
        if (rootObj == null) {
            return null;
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        LinkedList<WorkItem> workQueue = new LinkedList<WorkItem>();
        LinkedHashMap<String, Object> rootResult = new LinkedHashMap<String, Object>();
        workQueue.add(new WorkItem(rootObj, null, null));
        while (!workQueue.isEmpty()) {
            WorkItem current = (WorkItem)workQueue.removeFirst();
            Object obj = current.obj;
            if (visited.contains(obj)) {
                if (current.targetMap == null || current.fieldName == null) continue;
                current.targetMap.put(current.fieldName, null);
                continue;
            }
            visited.add(obj);
            LinkedHashMap<String, Object> currentMap = current.targetMap == null ? rootResult : new LinkedHashMap<String, Object>();
            try {
                Class<?> clazz = obj.getClass();
                List<Field> fields = ReflectionUtils.getAllDeclaredFields(clazz);
                for (Field field : fields) {
                    if (ObjectConversions.shouldSkipField(field)) continue;
                    try {
                        Object convertedValue;
                        Object value = field.get(obj);
                        if (value == null || (convertedValue = ObjectConversions.convertFieldValueIterative(value, converter, workQueue, currentMap, field.getName())) == null) continue;
                        currentMap.put(field.getName(), convertedValue);
                    }
                    catch (Exception e) {}
                }
                if (current.targetMap == null || current.fieldName == null) continue;
                current.targetMap.put(current.fieldName, currentMap);
            }
            catch (Exception e) {
                if (current.targetMap == null || current.fieldName == null) continue;
                current.targetMap.put(current.fieldName, null);
            }
        }
        return rootResult;
    }

    private static Object convertFieldValueIterative(Object value, Converter converter, Deque<WorkItem> workQueue, Map<String, Object> parentMap, String fieldName) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (ObjectConversions.isPrimitiveOrWrapper(valueClass)) {
            return ObjectConversions.convertToJsonCompatible(value, converter);
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object item : collection) {
                if (item != null && !ObjectConversions.isPrimitiveOrWrapper(item.getClass()) && !(item instanceof String)) {
                    result.add(item.toString());
                    continue;
                }
                result.add(ObjectConversions.convertToJsonCompatible(item, converter));
            }
            return result;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                String key = entry.getKey() != null ? entry.getKey().toString() : null;
                if (key == null) continue;
                Object entryValue = entry.getValue();
                if (entryValue != null && !ObjectConversions.isPrimitiveOrWrapper(entryValue.getClass()) && !(entryValue instanceof String)) {
                    result.put(key, entryValue.toString());
                    continue;
                }
                result.put(key, ObjectConversions.convertToJsonCompatible(entryValue, converter));
            }
            return result;
        }
        if (valueClass.isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            int length = ArrayUtilities.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object item = ArrayUtilities.getElement(value, i);
                if (item != null && !ObjectConversions.isPrimitiveOrWrapper(item.getClass()) && !(item instanceof String)) {
                    result.add(item.toString());
                    continue;
                }
                result.add(ObjectConversions.convertToJsonCompatible(item, converter));
            }
            return result;
        }
        if (ObjectConversions.isRecord(valueClass)) {
            try {
                return MapConversions.recordToMap(value, converter);
            }
            catch (Exception e) {
                return value.toString();
            }
        }
        workQueue.add(new WorkItem(value, parentMap, fieldName));
        return null;
    }

    private static Object convertToJsonCompatible(Object value, Converter converter) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            String numberStr = value.toString();
            try {
                return MathUtilities.parseToMinimalNumericType(numberStr);
            }
            catch (Exception e) {
                return value;
            }
        }
        if (value instanceof Boolean || value instanceof String) {
            return value;
        }
        if (value instanceof Character) {
            return value.toString();
        }
        return value.toString();
    }

    private static boolean shouldSkipField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.isSynthetic();
    }

    private static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return ClassUtilities.isPrimitive(clazz);
    }

    private static boolean isSimpleMapConversion(Object from) {
        if (!(from instanceof Map)) {
            return false;
        }
        Class<?> clazz = from.getClass();
        String className = clazz.getName();
        if (className.contains("CompactMap") || className.contains("CaseInsensitiveMap")) {
            return false;
        }
        return clazz == HashMap.class || clazz == LinkedHashMap.class || clazz == TreeMap.class || clazz == ConcurrentHashMap.class || className.contains("EmptyMap") || className.contains("SingletonMap") || className.contains("UnmodifiableMap") || className.contains("SynchronizedMap");
    }

    private static boolean isRecord(Class<?> clazz) {
        if (!SystemUtilities.isJavaVersionAtLeast(14, 0)) {
            return false;
        }
        try {
            Method isRecordMethod = ReflectionUtils.getMethod(Class.class, "isRecord", new Class[0]);
            if (isRecordMethod != null) {
                return (Boolean)ReflectionUtils.call(clazz, isRecordMethod, new Object[0]);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class WorkItem {
        final Object obj;
        final Map<String, Object> targetMap;
        final String fieldName;

        WorkItem(Object obj, Map<String, Object> targetMap, String fieldName) {
            this.obj = obj;
            this.targetMap = targetMap;
            this.fieldName = fieldName;
        }
    }
}

