/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableMapNullSafe;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.LRUCache;
import com.cedarsoftware.util.MultiKeyMap;
import com.cedarsoftware.util.StringUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;

public class CaseInsensitiveMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final Map<K, V> map;
    private final boolean isMultiKeyMapBacking;
    private static final AtomicReference<List<Map.Entry<Class<?>, Function<Integer, ? extends Map<?, ?>>>>> mapRegistry;

    private static void validateMappings(List<Map.Entry<Class<?>, Function<Integer, ? extends Map<?, ?>>>> registry) {
        for (int i = 0; i < registry.size(); ++i) {
            Class<?> current = registry.get(i).getKey();
            if (current.equals(IdentityHashMap.class)) {
                throw new IllegalStateException("IdentityHashMap is not supported and cannot be added to the registry.");
            }
            for (int j = i + 1; j < registry.size(); ++j) {
                Class<?> next = registry.get(j).getKey();
                if (!current.isAssignableFrom(next)) continue;
                throw new IllegalStateException("Mapping order error: " + next.getName() + " should come before " + current.getName());
            }
        }
    }

    public static void replaceRegistry(List<Map.Entry<Class<?>, Function<Integer, ? extends Map<?, ?>>>> newRegistry) {
        Objects.requireNonNull(newRegistry, "New registry list cannot be null");
        for (Map.Entry<Class<?>, Function<Integer, Map<?, ?>>> entry : newRegistry) {
            Objects.requireNonNull(entry, "Registry entries cannot be null");
            Objects.requireNonNull(entry.getKey(), "Registry entry key (Class) cannot be null");
            Objects.requireNonNull(entry.getValue(), "Registry entry value (Function) cannot be null");
        }
        HashSet seen = new HashSet();
        for (Map.Entry<Class<?>, Function<Integer, Map<?, ?>>> entry : newRegistry) {
            if (seen.add(entry.getKey())) continue;
            throw new IllegalArgumentException("Duplicate map type in registry: " + entry.getKey());
        }
        CaseInsensitiveMap.validateMappings(newRegistry);
        mapRegistry.set(Collections.unmodifiableList(new ArrayList(newRegistry)));
    }

    public static void replaceCache(LRUCache<String, CaseInsensitiveString> lruCache) {
        Objects.requireNonNull(lruCache, "Cache cannot be null");
        Map oldCache = CaseInsensitiveString.COMMON_STRINGS_REF.getAndSet(lruCache);
        if (oldCache instanceof LRUCache) {
            ((LRUCache)oldCache).shutdown();
        }
    }

    public static void setMaxCacheLengthString(int length) {
        if (length < 10) {
            throw new IllegalArgumentException("Max cache String length must be at least 10.");
        }
        CaseInsensitiveString.maxCacheLengthString = length;
    }

    public static <K, V> CaseInsensitiveMap<K, V> concurrent() {
        return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMapNullSafe());
    }

    public static <K, V> CaseInsensitiveMap<K, V> concurrent(int initialCapacity) {
        return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMapNullSafe(initialCapacity));
    }

    public static <K, V> CaseInsensitiveMap<K, V> concurrentSorted() {
        return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentNavigableMapNullSafe());
    }

    protected Map<K, V> determineBackingMap(Map<K, V> source) {
        if (source instanceof IdentityHashMap) {
            throw new IllegalArgumentException("Cannot create a CaseInsensitiveMap from an IdentityHashMap. IdentityHashMap compares keys by reference (==) which is incompatible.");
        }
        int size = source.size();
        for (Map.Entry<Class<?>, Function<Integer, Map<?, ?>>> entry : mapRegistry.get()) {
            if (!entry.getKey().isInstance(source)) continue;
            Map<?, ?> newMap = entry.getValue().apply(size);
            return this.copy(source, newMap);
        }
        return this.copy(source, new LinkedHashMap(size));
    }

    public CaseInsensitiveMap() {
        this.map = new LinkedHashMap();
        this.isMultiKeyMapBacking = false;
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
        this.isMultiKeyMapBacking = false;
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
        this.isMultiKeyMapBacking = false;
    }

    public CaseInsensitiveMap(Map<K, V> source, Map<K, V> mapInstance) {
        Objects.requireNonNull(source, "source map cannot be null");
        Objects.requireNonNull(mapInstance, "mapInstance cannot be null");
        if (!mapInstance.isEmpty()) {
            throw new IllegalArgumentException("mapInstance must be empty");
        }
        this.map = this.copy(source, mapInstance);
        this.isMultiKeyMapBacking = mapInstance instanceof MultiKeyMap;
    }

    public CaseInsensitiveMap(Map<K, V> source) {
        Objects.requireNonNull(source, "Source map cannot be null");
        this.map = this.determineBackingMap(source);
        this.isMultiKeyMapBacking = this.map instanceof MultiKeyMap;
    }

    protected Map<K, V> copy(Map<K, V> source, Map<K, V> dest) {
        if (source.isEmpty()) {
            return dest;
        }
        if (source instanceof CaseInsensitiveMap) {
            CaseInsensitiveMap ciSource = (CaseInsensitiveMap)source;
            dest.putAll(ciSource.map);
        } else {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                dest.put(this.convertKey(entry.getKey()), entry.getValue());
            }
        }
        return dest;
    }

    @Override
    public V get(Object key) {
        if (this.isMultiKeyMapBacking) {
            return this.map.get(this.convertKeyForMultiKeyMap(key));
        }
        return this.map.get(this.convertKey(key));
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isMultiKeyMapBacking) {
            return this.map.containsKey(this.convertKeyForMultiKeyMap(key));
        }
        return this.map.containsKey(this.convertKey(key));
    }

    @Override
    public V put(K key, V value) {
        if (this.isMultiKeyMapBacking) {
            return this.map.put(this.convertKeyForMultiKeyMap(key), value);
        }
        return this.map.put(this.convertKey(key), value);
    }

    @Override
    public V remove(Object key) {
        if (this.isMultiKeyMapBacking) {
            return this.map.remove(this.convertKeyForMultiKeyMap(key));
        }
        return this.map.remove(this.convertKey(key));
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : that.entrySet()) {
            Object thatKey = entry.getKey();
            if (!this.containsKey(thatKey)) {
                return false;
            }
            Object thatValue = entry.getValue();
            V thisValue = this.get(thatKey);
            if (Objects.equals(thisValue, thatValue)) continue;
            return false;
        }
        return true;
    }

    public Map<K, V> getWrappedMap() {
        return this.map;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new ConcurrentAwareKeyIterator(CaseInsensitiveMap.this.map.keySet().iterator());
            }

            @Override
            public int hashCode() {
                int h = 0;
                for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                    if (key == null) continue;
                    h += key.hashCode();
                }
                return h;
            }

            @Override
            public int size() {
                return CaseInsensitiveMap.this.map.size();
            }

            @Override
            public boolean contains(Object o) {
                return CaseInsensitiveMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                int size = CaseInsensitiveMap.this.map.size();
                CaseInsensitiveMap.this.remove(o);
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = this.size();
                T[] result = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                int i = 0;
                for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                    result[i++] = key instanceof CaseInsensitiveString ? key.toString() : key;
                }
                if (result.length > size) {
                    result[size] = null;
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                HashSet<Object> normalizedRetainSet = new HashSet<Object>();
                for (Object o : c) {
                    normalizedRetainSet.add(CaseInsensitiveMap.this.convertKey(o));
                }
                boolean[] changed = new boolean[]{false};
                CaseInsensitiveMap.this.map.keySet().removeIf(key -> {
                    boolean shouldRemove;
                    boolean bl = shouldRemove = !normalizedRetainSet.contains(key);
                    if (shouldRemove) {
                        changed[0] = true;
                    }
                    return shouldRemove;
                });
                return changed[0];
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return CaseInsensitiveMap.this.map.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry that = (Map.Entry)o;
                Object value = CaseInsensitiveMap.this.get(that.getKey());
                return value != null ? value.equals(that.getValue()) : that.getValue() == null && CaseInsensitiveMap.this.containsKey(that.getKey());
            }

            @Override
            public Object[] toArray() {
                Object[] result = new Object[this.size()];
                int i = 0;
                for (Map.Entry entry : CaseInsensitiveMap.this.map.entrySet()) {
                    result[i++] = new CaseInsensitiveEntry(entry);
                }
                return result;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = this.size();
                T[] result = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                Iterator it = CaseInsensitiveMap.this.map.entrySet().iterator();
                for (int i = 0; i < size; ++i) {
                    result[i] = new CaseInsensitiveEntry(it.next());
                }
                if (result.length > size) {
                    result[size] = null;
                }
                return result;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                int size = CaseInsensitiveMap.this.map.size();
                Map.Entry that = (Map.Entry)o;
                CaseInsensitiveMap.this.remove(that.getKey());
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                int size = CaseInsensitiveMap.this.map.size();
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    try {
                        Map.Entry that = (Map.Entry)o;
                        CaseInsensitiveMap.this.remove(that.getKey());
                    }
                    catch (ClassCastException classCastException) {}
                }
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                if (c.isEmpty()) {
                    int oldSize = this.size();
                    this.clear();
                    return oldSize > 0;
                }
                CaseInsensitiveMap other = new CaseInsensitiveMap();
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    Map.Entry entry2 = (Map.Entry)o;
                    other.put(entry2.getKey(), entry2.getValue());
                }
                int originalSize = this.size();
                CaseInsensitiveMap.this.map.entrySet().removeIf(entry -> !other.containsKey(entry.getKey()) || !Objects.equals(other.get(entry.getKey()), entry.getValue()));
                return this.size() != originalSize;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new ConcurrentAwareEntryIterator(CaseInsensitiveMap.this.map.entrySet().iterator());
            }
        };
    }

    private <R> Function<? super K, ? extends R> wrapFunctionForKey(Function<? super K, ? extends R> func) {
        return k -> func.apply((K)this.unwrapKey(k));
    }

    private <R> BiFunction<? super K, ? super V, ? extends R> wrapBiFunctionForKey(BiFunction<? super K, ? super V, ? extends R> func) {
        return (k, v) -> func.apply((K)this.unwrapKey(k), (V)v);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)this.convertKey(key), this.wrapFunctionForKey(mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.computeIfPresent((K)this.convertKey(key), (BiFunction<? super K, ? extends V, ? extends V>)this.wrapBiFunctionForKey(remappingFunction));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.compute((K)this.convertKey(key), (BiFunction<? super K, ? extends V, ? extends V>)this.wrapBiFunctionForKey(remappingFunction));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.map.merge(this.convertKey(key), (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(this.convertKey(key), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(this.convertKey(key), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(this.convertKey(key), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.map.replace(this.convertKey(key), value);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach((k, v) -> action.accept((K)this.unwrapKey(k), (V)v));
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll((k, v) -> function.apply((K)this.unwrapKey(k), (V)v));
    }

    public long mappingCount() {
        if (this.map instanceof ConcurrentHashMap) {
            return ((ConcurrentHashMap)this.map).mappingCount();
        }
        return this.size();
    }

    public void forEach(long parallelismThreshold, BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action, "Action cannot be null");
        if (this.map instanceof ConcurrentHashMap) {
            ((ConcurrentHashMap)this.map).forEach(parallelismThreshold, (k, v) -> action.accept((K)this.unwrapKey(k), (V)v));
        } else {
            this.forEach(action);
        }
    }

    public void forEachKey(long parallelismThreshold, Consumer<? super K> action) {
        Objects.requireNonNull(action, "Action cannot be null");
        if (this.map instanceof ConcurrentHashMap) {
            ((ConcurrentHashMap)this.map).forEachKey(parallelismThreshold, k -> action.accept((K)this.unwrapKey(k)));
        } else {
            this.keySet().forEach(action);
        }
    }

    public void forEachValue(long parallelismThreshold, Consumer<? super V> action) {
        Objects.requireNonNull(action, "Action cannot be null");
        if (this.map instanceof ConcurrentHashMap) {
            ((ConcurrentHashMap)this.map).forEachValue(parallelismThreshold, action);
        } else {
            this.values().forEach(action);
        }
    }

    public <U> U searchKeys(long parallelismThreshold, Function<? super K, ? extends U> searchFunction) {
        Objects.requireNonNull(searchFunction, "Search function cannot be null");
        if (this.map instanceof ConcurrentHashMap) {
            return (U)((ConcurrentHashMap)this.map).searchKeys(parallelismThreshold, k -> searchFunction.apply(this.unwrapKey(k)));
        }
        for (K key : this.keySet()) {
            U result = searchFunction.apply(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <U> U searchValues(long parallelismThreshold, Function<? super V, ? extends U> searchFunction) {
        Objects.requireNonNull(searchFunction, "Search function cannot be null");
        if (this.map instanceof ConcurrentHashMap) {
            return ((ConcurrentHashMap)this.map).searchValues(parallelismThreshold, searchFunction);
        }
        for (Object value : this.values()) {
            U result = searchFunction.apply(value);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <U> U reduceKeys(long parallelismThreshold, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        Objects.requireNonNull(transformer, "Transformer cannot be null");
        Objects.requireNonNull(reducer, "Reducer cannot be null");
        if (this.map instanceof ConcurrentHashMap) {
            return ((ConcurrentHashMap)this.map).reduceKeys(parallelismThreshold, k -> transformer.apply(this.unwrapKey(k)), reducer);
        }
        Object result = null;
        for (K key : this.keySet()) {
            U transformed = transformer.apply(key);
            if (transformed == null) continue;
            result = result == null ? transformed : reducer.apply(result, transformed);
        }
        return (U)result;
    }

    public <U> U reduceValues(long parallelismThreshold, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        Objects.requireNonNull(transformer, "Transformer cannot be null");
        Objects.requireNonNull(reducer, "Reducer cannot be null");
        if (this.map instanceof ConcurrentHashMap) {
            return ((ConcurrentHashMap)this.map).reduceValues(parallelismThreshold, transformer, reducer);
        }
        Object result = null;
        for (Object value : this.values()) {
            U transformed = transformer.apply(value);
            if (transformed == null) continue;
            result = result == null ? transformed : reducer.apply(result, transformed);
        }
        return (U)result;
    }

    private K unwrapKey(K key) {
        return (K)(key instanceof CaseInsensitiveString ? ((CaseInsensitiveString)key).original : key);
    }

    private K convertKey(Object key) {
        if (key instanceof String) {
            return (K)CaseInsensitiveString.of((String)key);
        }
        return (K)key;
    }

    private Object[] convertKeys(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return keys;
        }
        int len = keys.length;
        Object[] convertedKeys = new Object[len];
        for (int i = 0; i < len; ++i) {
            convertedKeys[i] = keys[i] instanceof String ? CaseInsensitiveString.of((String)keys[i]) : keys[i];
        }
        return convertedKeys;
    }

    private Object convertKeyForMultiKeyMap(Object key) {
        if (key == null) {
            return null;
        }
        boolean shouldFlatten = ((MultiKeyMap)this.map).getFlattenDimensions();
        if (!shouldFlatten && (key.getClass().isArray() || key instanceof Collection)) {
            return this.convertElementsRecursively(key);
        }
        if (key.getClass().isArray()) {
            int length = ArrayUtilities.getLength(key);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object element = ArrayUtilities.getElement(key, i);
                result[i] = this.convertKey(element);
            }
            return result;
        }
        if (key instanceof Collection) {
            Collection collection = (Collection)key;
            Object[] result = new Object[collection.size()];
            int i = 0;
            for (Object element : collection) {
                result[i++] = this.convertKey(element);
            }
            return result;
        }
        return this.convertKey(key);
    }

    private Object convertElementsRecursively(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isArray()) {
            int length = ArrayUtilities.getLength(obj);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object element = ArrayUtilities.getElement(obj, i);
                result[i] = this.convertElementsRecursively(element);
            }
            return result;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            ArrayList<Object> result = new ArrayList<Object>(collection.size());
            for (Object element : collection) {
                result.add(this.convertElementsRecursively(element));
            }
            return result;
        }
        return this.convertKey(obj);
    }

    static {
        ArrayList tempList = new ArrayList();
        tempList.add(new AbstractMap.SimpleEntry<Class<Hashtable>, Function<Integer, Map>>(Hashtable.class, size -> new Hashtable()));
        tempList.add(new AbstractMap.SimpleEntry<Class<TreeMap>, Function<Integer, Map>>(TreeMap.class, size -> new TreeMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentSkipListMap>, Function<Integer, Map>>(ConcurrentSkipListMap.class, size -> new ConcurrentSkipListMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentNavigableMapNullSafe>, Function<Integer, Map>>(ConcurrentNavigableMapNullSafe.class, size -> new ConcurrentNavigableMapNullSafe()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentHashMapNullSafe>, Function<Integer, Map>>(ConcurrentHashMapNullSafe.class, size -> new ConcurrentHashMapNullSafe((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<WeakHashMap>, Function<Integer, Map>>(WeakHashMap.class, size -> new WeakHashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<LinkedHashMap>, Function<Integer, Map>>(LinkedHashMap.class, size -> new LinkedHashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<HashMap>, Function<Integer, Map>>(HashMap.class, size -> new HashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentNavigableMap>, Function<Integer, Map>>(ConcurrentNavigableMap.class, size -> new ConcurrentSkipListMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentMap>, Function<Integer, Map>>(ConcurrentMap.class, size -> new ConcurrentHashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<NavigableMap>, Function<Integer, Map>>(NavigableMap.class, size -> new TreeMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<SortedMap>, Function<Integer, Map>>(SortedMap.class, size -> new TreeMap()));
        CaseInsensitiveMap.validateMappings(tempList);
        mapRegistry = new AtomicReference(Collections.unmodifiableList(new ArrayList(tempList)));
    }

    public static final class CaseInsensitiveString
    implements Comparable<Object>,
    CharSequence,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String original;
        private final int hash;
        private static final int DEFAULT_CACHE_SIZE = CaseInsensitiveString.parseIntSafely(System.getProperty("caseinsensitive.cache.size", "5000"), 5000);
        private static final int DEFAULT_MAX_STRING_LENGTH = CaseInsensitiveString.parseIntSafely(System.getProperty("caseinsensitive.max.string.length", "100"), 100);
        private static final AtomicReference<Map<String, CaseInsensitiveString>> COMMON_STRINGS_REF = new AtomicReference(new LRUCache(DEFAULT_CACHE_SIZE, LRUCache.StrategyType.THREADED));
        private static volatile int maxCacheLengthString = DEFAULT_MAX_STRING_LENGTH;

        private static int parseIntSafely(String value, int defaultValue) {
            try {
                return Converter.convert(value, Integer.TYPE);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public static CaseInsensitiveString of(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Cannot convert null to CaseInsensitiveString");
            }
            if (s.length() > maxCacheLengthString) {
                return new CaseInsensitiveString(s);
            }
            Map<String, CaseInsensitiveString> cache = COMMON_STRINGS_REF.get();
            return cache.computeIfAbsent(s, CaseInsensitiveString::new);
        }

        CaseInsensitiveString(String string) {
            this.original = string;
            this.hash = StringUtilities.hashCodeIgnoreCase(string);
        }

        @Override
        public String toString() {
            return this.original;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CaseInsensitiveString) {
                CaseInsensitiveString cis = (CaseInsensitiveString)other;
                return this.hash == cis.hash && (this.hash == 0 || this.original.equalsIgnoreCase(cis.original));
            }
            if (other instanceof String) {
                String str = (String)other;
                int otherHash = StringUtilities.hashCodeIgnoreCase(str);
                return this.hash == otherHash && this.original.equalsIgnoreCase(str);
            }
            return false;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof CaseInsensitiveString) {
                CaseInsensitiveString other = (CaseInsensitiveString)o;
                return this.original.compareToIgnoreCase(other.original);
            }
            if (o instanceof String) {
                return this.original.compareToIgnoreCase((String)o);
            }
            return -1;
        }

        @Override
        public int length() {
            return this.original.length();
        }

        @Override
        public char charAt(int index) {
            return this.original.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.original.subSequence(start, end);
        }

        @Override
        public IntStream chars() {
            return this.original.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.original.codePoints();
        }

        public boolean contains(CharSequence s) {
            return StringUtilities.containsIgnoreCase(this.original, s.toString());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        static {
            String[] commonValues = new String[]{"true", "false", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "id", "name", "code", "type", "status", "date", "value", "amount", "yes", "no", "null", "none"};
            Map<String, CaseInsensitiveString> initialCache = COMMON_STRINGS_REF.get();
            for (String value : commonValues) {
                initialCache.put(value, new CaseInsensitiveString(value));
            }
        }
    }

    private class ConcurrentAwareEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> backingIterator;
        private final boolean isConcurrentBacking;

        ConcurrentAwareEntryIterator(Iterator<Map.Entry<K, V>> backingIterator) {
            this.backingIterator = backingIterator;
            String iteratorClassName = backingIterator.getClass().getName();
            this.isConcurrentBacking = iteratorClassName.contains("ConcurrentHashMap");
        }

        @Override
        public boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new CaseInsensitiveEntry(this.backingIterator.next());
        }

        @Override
        public void remove() {
            this.backingIterator.remove();
        }

        public boolean isConcurrentBacking() {
            return this.isConcurrentBacking;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            if (this.isConcurrentBacking) {
                this.backingIterator.forEachRemaining((? super E entry) -> action.accept(new CaseInsensitiveEntry(entry)));
            } else {
                Iterator.super.forEachRemaining(action);
            }
        }
    }

    private static class ConcurrentAwareKeyIterator<K>
    implements Iterator<K> {
        private final Iterator<K> backingIterator;
        private final boolean isConcurrentBacking;

        ConcurrentAwareKeyIterator(Iterator<K> backingIterator) {
            this.backingIterator = backingIterator;
            String iteratorClassName = backingIterator.getClass().getName();
            this.isConcurrentBacking = iteratorClassName.contains("ConcurrentHashMap");
        }

        @Override
        public boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public K next() {
            K next = this.backingIterator.next();
            return (K)(next instanceof CaseInsensitiveString ? next.toString() : next);
        }

        @Override
        public void remove() {
            this.backingIterator.remove();
        }

        public boolean isConcurrentBacking() {
            return this.isConcurrentBacking;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            if (this.isConcurrentBacking) {
                this.backingIterator.forEachRemaining((? super E key) -> {
                    Object processedKey = key instanceof CaseInsensitiveString ? key.toString() : key;
                    action.accept((Object)processedKey);
                });
            } else {
                Iterator.super.forEachRemaining(action);
            }
        }
    }

    public class CaseInsensitiveEntry
    extends AbstractMap.SimpleEntry<K, V> {
        public CaseInsensitiveEntry(Map.Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public K getKey() {
            Object superKey = super.getKey();
            if (superKey instanceof CaseInsensitiveString) {
                return ((CaseInsensitiveString)superKey).original;
            }
            return superKey;
        }

        public K getOriginalKey() {
            return super.getKey();
        }

        @Override
        public V setValue(V value) {
            return CaseInsensitiveMap.this.put(this.getOriginalKey(), value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.getOriginalKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getOriginalKey()) ^ Objects.hashCode(this.getValue());
        }

        @Override
        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

