/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.convert.CollectionHandling;
import com.cedarsoftware.util.convert.CollectionsWrappers;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.IdentityHashMap;

public final class CollectionConversions {
    private CollectionConversions() {
    }

    public static <T extends Collection<?>> T arrayToCollection(Object array, Class<T> targetType) {
        IdentityHashMap<Object, Collection<Object>> visited = new IdentityHashMap<Object, Collection<Object>>();
        boolean requiresUnmodifiable = CollectionUtilities.isUnmodifiable(targetType);
        boolean requiresSynchronized = CollectionUtilities.isSynchronized(targetType);
        Collection<Object> rootCollection = CollectionHandling.createCollection(array, targetType);
        if (CollectionConversions.isEmptyCollection(targetType)) {
            return (T)rootCollection;
        }
        visited.put(array, rootCollection);
        ArrayDeque<ArrayToCollectionWorkItem> queue = new ArrayDeque<ArrayToCollectionWorkItem>();
        queue.add(new ArrayToCollectionWorkItem(array, rootCollection, targetType));
        while (!queue.isEmpty()) {
            ArrayToCollectionWorkItem work = (ArrayToCollectionWorkItem)queue.poll();
            int workLength = Array.getLength(work.sourceArray);
            for (int i = 0; i < workLength; ++i) {
                Object element = Array.get(work.sourceArray, i);
                if (element != null && element.getClass().isArray()) {
                    if (visited.containsKey(element)) {
                        work.targetCollection.add(visited.get(element));
                        continue;
                    }
                    Collection<Object> nestedCollection = CollectionHandling.createCollection(element, work.targetType);
                    visited.put(element, nestedCollection);
                    work.targetCollection.add(nestedCollection);
                    queue.add(new ArrayToCollectionWorkItem(element, nestedCollection, work.targetType));
                    continue;
                }
                work.targetCollection.add(element);
            }
        }
        if (targetType.isAssignableFrom(rootCollection.getClass())) {
            return (T)rootCollection;
        }
        if (requiresUnmodifiable) {
            return (T)CollectionUtilities.getUnmodifiableCollection(rootCollection);
        }
        if (requiresSynchronized) {
            return (T)CollectionUtilities.getSynchronizedCollection(rootCollection);
        }
        return (T)rootCollection;
    }

    public static Object collectionToCollection(Collection<?> source, Class<?> targetType) {
        IdentityHashMap visited = new IdentityHashMap();
        boolean requiresUnmodifiable = CollectionUtilities.isUnmodifiable(targetType);
        boolean requiresSynchronized = CollectionUtilities.isSynchronized(targetType);
        Collection<Object> rootCollection = CollectionHandling.createCollection(source, targetType);
        if (CollectionConversions.isEmptyCollection(targetType)) {
            return rootCollection;
        }
        visited.put(source, rootCollection);
        ArrayDeque<CollectionToCollectionWorkItem> queue = new ArrayDeque<CollectionToCollectionWorkItem>();
        queue.add(new CollectionToCollectionWorkItem(source, rootCollection, targetType, requiresUnmodifiable, requiresSynchronized));
        while (!queue.isEmpty()) {
            CollectionToCollectionWorkItem work = (CollectionToCollectionWorkItem)queue.poll();
            for (Object element : work.sourceCollection) {
                if (element instanceof Collection) {
                    if (visited.containsKey(element)) {
                        work.targetCollection.add(visited.get(element));
                        continue;
                    }
                    Collection<Object> nestedModifiable = CollectionHandling.createCollection(element, work.targetType);
                    Collection<Object> nestedToAdd = work.requiresUnmodifiable ? CollectionUtilities.getUnmodifiableCollection(nestedModifiable) : (work.requiresSynchronized ? CollectionUtilities.getSynchronizedCollection(nestedModifiable) : nestedModifiable);
                    visited.put((Collection<?>)element, nestedToAdd);
                    work.targetCollection.add(nestedToAdd);
                    queue.add(new CollectionToCollectionWorkItem((Collection)element, nestedModifiable, work.targetType, work.requiresUnmodifiable, work.requiresSynchronized));
                    continue;
                }
                work.targetCollection.add(element);
            }
        }
        if (targetType.isAssignableFrom(rootCollection.getClass())) {
            return rootCollection;
        }
        if (requiresUnmodifiable) {
            return CollectionUtilities.getUnmodifiableCollection(rootCollection);
        }
        if (requiresSynchronized) {
            return CollectionUtilities.getSynchronizedCollection(rootCollection);
        }
        return rootCollection;
    }

    private static boolean isEmptyCollection(Class<?> targetType) {
        return CollectionsWrappers.getEmptyCollectionClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptyListClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptySetClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptySortedSetClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptyNavigableSetClass().isAssignableFrom(targetType);
    }

    private static class ArrayToCollectionWorkItem {
        final Object sourceArray;
        final Collection<Object> targetCollection;
        final Class<?> targetType;

        ArrayToCollectionWorkItem(Object sourceArray, Collection<Object> targetCollection, Class<?> targetType) {
            this.sourceArray = sourceArray;
            this.targetCollection = targetCollection;
            this.targetType = targetType;
        }
    }

    private static class CollectionToCollectionWorkItem {
        final Collection<?> sourceCollection;
        final Collection<Object> targetCollection;
        final Class<?> targetType;
        final boolean requiresUnmodifiable;
        final boolean requiresSynchronized;

        CollectionToCollectionWorkItem(Collection<?> sourceCollection, Collection<Object> targetCollection, Class<?> targetType, boolean requiresUnmodifiable, boolean requiresSynchronized) {
            this.sourceCollection = sourceCollection;
            this.targetCollection = targetCollection;
            this.targetType = targetType;
            this.requiresUnmodifiable = requiresUnmodifiable;
            this.requiresSynchronized = requiresSynchronized;
        }
    }
}

