/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.EncryptionUtilities;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public final class ConcurrentList<E>
implements List<E>,
Deque<E>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BUCKET_SIZE = 1024;
    private final ConcurrentMap<Integer, AtomicReferenceArray<Object>> buckets = new ConcurrentHashMap<Integer, AtomicReferenceArray<Object>>();
    private final AtomicLong head = new AtomicLong(0L);
    private final AtomicLong tail = new AtomicLong(0L);
    private final AtomicLong sizeCounter = new AtomicLong(0L);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentList() {
    }

    public ConcurrentList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity cannot be negative: " + initialCapacity);
        }
    }

    public ConcurrentList(Collection<? extends E> collection) {
        Objects.requireNonNull(collection, "collection cannot be null");
        this.addAll(collection);
    }

    private static int bucketIndex(long pos) {
        long div = pos / 1024L;
        if ((pos ^ 0x400L) < 0L && pos % 1024L != 0L) {
            --div;
        }
        return (int)div;
    }

    private static int bucketOffset(long pos) {
        int rem = (int)(pos % 1024L);
        return rem < 0 ? rem + 1024 : rem;
    }

    private AtomicReferenceArray<Object> ensureBucket(int index) {
        AtomicReferenceArray bucket = (AtomicReferenceArray)this.buckets.get(index);
        if (bucket == null) {
            bucket = new AtomicReferenceArray(1024);
            AtomicReferenceArray existing = this.buckets.putIfAbsent(index, bucket);
            if (existing != null) {
                bucket = existing;
            }
        }
        return bucket;
    }

    private AtomicReferenceArray<Object> getBucket(int index) {
        AtomicReferenceArray bucket = (AtomicReferenceArray)this.buckets.get(index);
        if (bucket == null) {
            return this.ensureBucket(index);
        }
        return bucket;
    }

    @Override
    public int size() {
        long size = this.sizeCounter.get();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public boolean isEmpty() {
        return this.sizeCounter.get() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        for (E element : this) {
            if (!Objects.equals(o, element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        Object[] snapshot = this.toArray();
        ArrayList<Object> list = new ArrayList<Object>(snapshot.length);
        Object[] objectArray = snapshot;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object obj;
            Object e = obj = objectArray[i];
            list.add(e);
        }
        return list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            if (sz == 0) {
                Object[] objectArray = new Object[]{};
                return objectArray;
            }
            ArrayList<E> result = new ArrayList<E>(sz);
            for (int i = 0; i < sz; ++i) {
                try {
                    E element = this.get(i);
                    result.add(element);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
            }
            Object[] objectArray = result.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.readLock().lock();
        try {
            int actualSize;
            int sz = this.size();
            if (sz == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                T[] TArray = a;
                return TArray;
            }
            ArrayList<E> result = new ArrayList<E>(sz);
            for (int i = 0; i < sz; ++i) {
                try {
                    E element = this.get(i);
                    result.add(element);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
            }
            if (a.length < (actualSize = result.size())) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), actualSize);
            }
            for (int i = 0; i < actualSize; ++i) {
                a[i] = result.get(i);
            }
            if (a.length > actualSize) {
                a[actualSize] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                E element = this.get(i);
                if (!Objects.equals(o, element)) continue;
                this.remove(i);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            this.addLast(e);
            modified = true;
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            int i = index;
            for (E e : c) {
                this.add(i++, e);
            }
            boolean bl = !c.isEmpty();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean modified = false;
            for (Object o : c) {
                while (this.remove(o)) {
                    modified = true;
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean modified = false;
            int sz = this.size();
            for (int i = sz - 1; i >= 0; --i) {
                E element = this.get(i);
                if (c.contains(element)) continue;
                this.remove(i);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.buckets.clear();
            this.head.set(0L);
            this.tail.set(0L);
            this.sizeCounter.set(0L);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        this.lock.readLock().lock();
        try {
            Object e;
            long h = this.head.get();
            long t = this.tail.get();
            long pos = h + (long)index;
            if (index < 0 || pos >= t) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
            Object object = e = bucket.get(ConcurrentList.bucketOffset(pos));
            return (E)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.lock.readLock().lock();
        try {
            Object old;
            long h = this.head.get();
            long t = this.tail.get();
            long pos = h + (long)index;
            if (index < 0 || pos >= t) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
            Object object = old = bucket.getAndSet(ConcurrentList.bucketOffset(pos), element);
            return (E)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        if (index == 0) {
            this.addFirst(element);
            return;
        }
        if (index == this.size()) {
            this.addLast(element);
            return;
        }
        this.lock.writeLock().lock();
        try {
            ArrayList<E> list = new ArrayList<E>(this);
            list.add(index, element);
            this.rebuild(list);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        if (index == 0) {
            return this.removeFirst();
        }
        if (index == this.size() - 1) {
            return this.removeLast();
        }
        this.lock.writeLock().lock();
        try {
            ArrayList list = new ArrayList(this);
            Object removed = list.remove(index);
            this.rebuild(list);
            Object e = removed;
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        int idx = 0;
        for (E element : this) {
            if (Objects.equals(o, element)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int idx = this.size() - 1;
        ListIterator<E> it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            E element = it.previous();
            if (Objects.equals(o, element)) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] snapshot = this.toArray();
        ArrayList<Object> list = new ArrayList<Object>(snapshot.length);
        Object[] objectArray = snapshot;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object obj;
            Object e = obj = objectArray[i];
            list.add(e);
        }
        return list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not implemented for ConcurrentList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(E e) {
        this.lock.readLock().lock();
        try {
            long pos = this.head.decrementAndGet();
            AtomicReferenceArray<Object> bucket = this.ensureBucket(ConcurrentList.bucketIndex(pos));
            bucket.lazySet(ConcurrentList.bucketOffset(pos), e);
            this.sizeCounter.incrementAndGet();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLast(E e) {
        this.lock.readLock().lock();
        try {
            long pos = this.tail.getAndIncrement();
            AtomicReferenceArray<Object> bucket = this.ensureBucket(ConcurrentList.bucketIndex(pos));
            bucket.lazySet(ConcurrentList.bucketOffset(pos), e);
            this.sizeCounter.incrementAndGet();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException("List is empty");
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException("List is empty");
        }
        return e;
    }

    @Override
    public E pollFirst() {
        this.lock.writeLock().lock();
        try {
            while (true) {
                long t;
                long h;
                if ((h = this.head.get()) >= (t = this.tail.get())) {
                    E e = null;
                    return e;
                }
                if (!this.head.compareAndSet(h, h + 1L)) continue;
                AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(h));
                E val = bucket.getAndSet(ConcurrentList.bucketOffset(h), null);
                this.sizeCounter.decrementAndGet();
                E e = val;
                return e;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E pollLast() {
        this.lock.writeLock().lock();
        try {
            while (true) {
                long h;
                long t;
                if ((t = this.tail.get()) <= (h = this.head.get())) {
                    E e = null;
                    return e;
                }
                long newTail = t - 1L;
                if (!this.tail.compareAndSet(t, newTail)) continue;
                AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(newTail));
                E val = bucket.getAndSet(ConcurrentList.bucketOffset(newTail), null);
                this.sizeCounter.decrementAndGet();
                E e = val;
                return e;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E getFirst() {
        E e = this.peekFirst();
        if (e == null) {
            throw new NoSuchElementException("List is empty");
        }
        return e;
    }

    @Override
    public E getLast() {
        E e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException("List is empty");
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekFirst() {
        this.lock.readLock().lock();
        try {
            Object val;
            long h = this.head.get();
            long t = this.tail.get();
            if (h >= t) {
                E e = null;
                return e;
            }
            AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(h));
            Object object = val = bucket.get(ConcurrentList.bucketOffset(h));
            return (E)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekLast() {
        this.lock.readLock().lock();
        try {
            Object val;
            long t = this.tail.get();
            long h = this.head.get();
            if (t <= h) {
                E e = null;
                return e;
            }
            long pos = t - 1L;
            AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
            Object object = val = bucket.get(ConcurrentList.bucketOffset(pos));
            return (E)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        this.lock.writeLock().lock();
        try {
            for (int i = this.size() - 1; i >= 0; --i) {
                E element = this.get(i);
                if (!Objects.equals(o, element)) continue;
                this.remove(i);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        final Object[] snapshot = this.toArray();
        return new Iterator<E>(){
            private int index;
            {
                this.index = snapshot.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public E next() {
                if (this.index < 0) {
                    throw new NoSuchElementException();
                }
                return snapshot[this.index--];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        for (E e : this) {
            action.accept(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator<E> it1 = this.iterator();
        Iterator it2 = other.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object e2;
            E e1 = it1.next();
            if (Objects.equals(e1, e2 = it2.next())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    @Override
    public int hashCode() {
        int hash = 1;
        for (E e : this) {
            hash = 31 * hash + (e == null ? 0 : e.hashCode());
        }
        return EncryptionUtilities.finalizeHash(hash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e = it.next();
            sb.append((Object)(e == this ? "(this Collection)" : e));
            if (!it.hasNext()) continue;
            sb.append(',').append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void rebuild(List<E> elements) {
        this.buckets.clear();
        this.head.set(0L);
        this.tail.set(0L);
        this.sizeCounter.set(0L);
        for (E e : elements) {
            long pos = this.tail.getAndIncrement();
            AtomicReferenceArray<Object> bucket = this.ensureBucket(ConcurrentList.bucketIndex(pos));
            bucket.lazySet(ConcurrentList.bucketOffset(pos), e);
            this.sizeCounter.incrementAndGet();
        }
    }
}

