/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;

final class ColorConversions {
    private ColorConversions() {
    }

    static String toString(Object from, Converter converter) {
        Color color = (Color)from;
        if (color.getAlpha() == 255) {
            return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        }
        return String.format("#%02X%02X%02X%02X", color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    static Integer toInteger(Object from, Converter converter) {
        Color color = (Color)from;
        return color.getRGB();
    }

    static Long toLong(Object from, Converter converter) {
        Color color = (Color)from;
        return color.getRGB();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Color color = (Color)from;
        return BigInteger.valueOf(color.getRGB());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Color color = (Color)from;
        return BigDecimal.valueOf(color.getRGB());
    }

    static int[] toIntArray(Object from, Converter converter) {
        Color color = (Color)from;
        if (color.getAlpha() == 255) {
            return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Color color = (Color)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("red", color.getRed());
        target.put("green", color.getGreen());
        target.put("blue", color.getBlue());
        target.put("alpha", color.getAlpha());
        target.put("rgb", color.getRGB());
        return target;
    }
}

