/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class CollectionsWrappers {
    private static final Map<CollectionType, Class<?>> CACHE = new HashMap();

    private CollectionsWrappers() {
    }

    public static <E> Class<Collection<E>> getUnmodifiableCollectionClass() {
        return CACHE.get((Object)CollectionType.UNMODIFIABLE_COLLECTION);
    }

    public static <E> Class<List<E>> getUnmodifiableListClass() {
        return CACHE.get((Object)CollectionType.UNMODIFIABLE_LIST);
    }

    public static <E> Class<Set<E>> getUnmodifiableSetClass() {
        return CACHE.get((Object)CollectionType.UNMODIFIABLE_SET);
    }

    public static <E> Class<SortedSet<E>> getUnmodifiableSortedSetClass() {
        return CACHE.get((Object)CollectionType.UNMODIFIABLE_SORTED_SET);
    }

    public static <E> Class<NavigableSet<E>> getUnmodifiableNavigableSetClass() {
        return CACHE.get((Object)CollectionType.UNMODIFIABLE_NAVIGABLE_SET);
    }

    public static <E> Class<Collection<E>> getSynchronizedCollectionClass() {
        return CACHE.get((Object)CollectionType.SYNCHRONIZED_COLLECTION);
    }

    public static <E> Class<List<E>> getSynchronizedListClass() {
        return CACHE.get((Object)CollectionType.SYNCHRONIZED_LIST);
    }

    public static <E> Class<Set<E>> getSynchronizedSetClass() {
        return CACHE.get((Object)CollectionType.SYNCHRONIZED_SET);
    }

    public static <E> Class<SortedSet<E>> getSynchronizedSortedSetClass() {
        return CACHE.get((Object)CollectionType.SYNCHRONIZED_SORTED_SET);
    }

    public static <E> Class<NavigableSet<E>> getSynchronizedNavigableSetClass() {
        return CACHE.get((Object)CollectionType.SYNCHRONIZED_NAVIGABLE_SET);
    }

    public static <E> Class<Collection<E>> getEmptyCollectionClass() {
        return CACHE.get((Object)CollectionType.EMPTY_COLLECTION);
    }

    public static <E> Class<List<E>> getEmptyListClass() {
        return CACHE.get((Object)CollectionType.EMPTY_LIST);
    }

    public static <E> Class<Set<E>> getEmptySetClass() {
        return CACHE.get((Object)CollectionType.EMPTY_SET);
    }

    public static <E> Class<SortedSet<E>> getEmptySortedSetClass() {
        return CACHE.get((Object)CollectionType.EMPTY_SORTED_SET);
    }

    public static <E> Class<NavigableSet<E>> getEmptyNavigableSetClass() {
        return CACHE.get((Object)CollectionType.EMPTY_NAVIGABLE_SET);
    }

    public static <E> Class<Collection<E>> getCheckedCollectionClass() {
        return CACHE.get((Object)CollectionType.CHECKED_COLLECTION);
    }

    public static <E> Class<List<E>> getCheckedListClass() {
        return CACHE.get((Object)CollectionType.CHECKED_LIST);
    }

    public static <E> Class<Set<E>> getCheckedSetClass() {
        return CACHE.get((Object)CollectionType.CHECKED_SET);
    }

    public static <E> Class<SortedSet<E>> getCheckedSortedSetClass() {
        return CACHE.get((Object)CollectionType.CHECKED_SORTED_SET);
    }

    public static <E> Class<NavigableSet<E>> getCheckedNavigableSetClass() {
        return CACHE.get((Object)CollectionType.CHECKED_NAVIGABLE_SET);
    }

    static {
        CACHE.put(CollectionType.UNMODIFIABLE_COLLECTION, Collections.unmodifiableCollection(new ArrayList()).getClass());
        CACHE.put(CollectionType.UNMODIFIABLE_LIST, Collections.unmodifiableList(new ArrayList()).getClass());
        CACHE.put(CollectionType.UNMODIFIABLE_SET, Collections.unmodifiableSet(new HashSet()).getClass());
        CACHE.put(CollectionType.UNMODIFIABLE_SORTED_SET, Collections.unmodifiableSortedSet(new TreeSet()).getClass());
        CACHE.put(CollectionType.UNMODIFIABLE_NAVIGABLE_SET, Collections.unmodifiableNavigableSet(new TreeSet()).getClass());
        CACHE.put(CollectionType.SYNCHRONIZED_COLLECTION, Collections.synchronizedCollection(new ArrayList()).getClass());
        CACHE.put(CollectionType.SYNCHRONIZED_LIST, Collections.synchronizedList(new ArrayList()).getClass());
        CACHE.put(CollectionType.SYNCHRONIZED_SET, Collections.synchronizedSet(new HashSet()).getClass());
        CACHE.put(CollectionType.SYNCHRONIZED_SORTED_SET, Collections.synchronizedSortedSet(new TreeSet()).getClass());
        CACHE.put(CollectionType.SYNCHRONIZED_NAVIGABLE_SET, Collections.synchronizedNavigableSet(new TreeSet()).getClass());
        CACHE.put(CollectionType.EMPTY_COLLECTION, Collections.emptyList().getClass());
        CACHE.put(CollectionType.EMPTY_LIST, Collections.emptyList().getClass());
        CACHE.put(CollectionType.EMPTY_SET, Collections.emptySet().getClass());
        CACHE.put(CollectionType.EMPTY_SORTED_SET, Collections.emptySortedSet().getClass());
        CACHE.put(CollectionType.EMPTY_NAVIGABLE_SET, Collections.emptyNavigableSet().getClass());
        CACHE.put(CollectionType.CHECKED_COLLECTION, Collections.checkedCollection(new ArrayList(), Object.class).getClass());
        CACHE.put(CollectionType.CHECKED_LIST, Collections.checkedList(new ArrayList(), Object.class).getClass());
        CACHE.put(CollectionType.CHECKED_SET, Collections.checkedSet(new HashSet(), Object.class).getClass());
        CACHE.put(CollectionType.CHECKED_SORTED_SET, Collections.checkedSortedSet(new TreeSet(), Object.class).getClass());
        CACHE.put(CollectionType.CHECKED_NAVIGABLE_SET, Collections.checkedNavigableSet(new TreeSet(), Object.class).getClass());
    }

    private static enum CollectionType {
        UNMODIFIABLE_COLLECTION,
        UNMODIFIABLE_LIST,
        UNMODIFIABLE_SET,
        UNMODIFIABLE_SORTED_SET,
        UNMODIFIABLE_NAVIGABLE_SET,
        SYNCHRONIZED_COLLECTION,
        SYNCHRONIZED_LIST,
        SYNCHRONIZED_SET,
        SYNCHRONIZED_SORTED_SET,
        SYNCHRONIZED_NAVIGABLE_SET,
        EMPTY_COLLECTION,
        EMPTY_LIST,
        EMPTY_SET,
        EMPTY_SORTED_SET,
        EMPTY_NAVIGABLE_SET,
        CHECKED_COLLECTION,
        CHECKED_LIST,
        CHECKED_SET,
        CHECKED_SORTED_SET,
        CHECKED_NAVIGABLE_SET;

    }
}

