/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableSetNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class CaseInsensitiveSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CaseInsensitiveMap<E, Boolean> backingMap;
    private final Set<E> delegate;

    public CaseInsensitiveSet() {
        this.backingMap = new CaseInsensitiveMap();
        this.delegate = Collections.newSetFromMap(this.backingMap);
    }

    public CaseInsensitiveSet(Collection<? extends E> collection) {
        this.backingMap = this.determineBackingMap(collection);
        this.delegate = Collections.newSetFromMap(this.backingMap);
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public CaseInsensitiveSet(Collection<? extends E> source, Map backingMap) {
        this.backingMap = new CaseInsensitiveMap(Collections.emptyMap(), backingMap);
        this.delegate = Collections.newSetFromMap(this.backingMap);
        if (source != null) {
            this.addAll(source);
        }
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.backingMap = new CaseInsensitiveMap(initialCapacity);
        this.delegate = Collections.newSetFromMap(this.backingMap);
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        this.backingMap = new CaseInsensitiveMap(initialCapacity, loadFactor);
        this.delegate = Collections.newSetFromMap(this.backingMap);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        return that.size() == this.size() && this.containsAll(that);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object elem : c) {
            if (!this.remove(elem)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.delegate.removeIf(filter);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.delegate.forEach(action);
    }

    public long elementCount() {
        return this.backingMap.mappingCount();
    }

    public void forEach(long parallelismThreshold, Consumer<? super E> action) {
        this.backingMap.forEachKey(parallelismThreshold, action);
    }

    public <U> U searchElements(long parallelismThreshold, Function<? super E, ? extends U> searchFunction) {
        return this.backingMap.searchKeys(parallelismThreshold, searchFunction);
    }

    public <U> U reduceElements(long parallelismThreshold, Function<? super E, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        return this.backingMap.reduceKeys(parallelismThreshold, transformer, reducer);
    }

    public Map<E, Object> getBackingMap() {
        return this.backingMap;
    }

    private CaseInsensitiveMap<E, Boolean> determineBackingMap(Collection<? extends E> source) {
        if (source == null) {
            return new CaseInsensitiveMap();
        }
        if (source instanceof ConcurrentNavigableSetNullSafe) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentNavigableMapNullSafe());
        }
        if (source instanceof ConcurrentSkipListSet) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentSkipListMap());
        }
        if (source instanceof ConcurrentSet) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMapNullSafe());
        }
        if (source instanceof SortedSet) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new TreeMap());
        }
        int size = source.isEmpty() ? 16 : source.size();
        return new CaseInsensitiveMap(size);
    }

    @Deprecated
    public Set<E> minus(Iterable<E> removeMe) {
        for (E me : removeMe) {
            this.remove(me);
        }
        return this;
    }

    @Deprecated
    public Set<E> minus(E removeMe) {
        this.remove(removeMe);
        return this;
    }

    @Deprecated
    public Set<E> plus(Iterable<E> right) {
        for (E item : right) {
            this.add(item);
        }
        return this;
    }

    @Deprecated
    public Set<E> plus(Object right) {
        this.add(right);
        return this;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

