/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.ConverterOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class BooleanConversions {
    private BooleanConversions() {
    }

    static Byte toByte(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? CommonValues.BYTE_ONE : CommonValues.BYTE_ZERO;
    }

    static Short toShort(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? CommonValues.SHORT_ONE : CommonValues.SHORT_ZERO;
    }

    static Integer toInt(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? CommonValues.INTEGER_ONE : CommonValues.INTEGER_ZERO;
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return new AtomicInteger(b != false ? 1 : 0);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return new AtomicLong(b != false ? 1L : 0L);
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return new AtomicBoolean(b);
    }

    static Long toLong(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? CommonValues.LONG_ONE : CommonValues.LONG_ZERO;
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return (Boolean)from != false ? BigInteger.ONE : BigInteger.ZERO;
    }

    static Float toFloat(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? CommonValues.FLOAT_ONE : CommonValues.FLOAT_ZERO;
    }

    static Double toDouble(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? CommonValues.DOUBLE_ONE : CommonValues.DOUBLE_ZERO;
    }

    static char toCharacter(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        ConverterOptions options = converter.getOptions();
        return (b != false ? options.trueChar() : options.falseChar()).charValue();
    }

    static UUID toUUID(Object from, Converter converter) {
        Boolean b = (Boolean)from;
        return b != false ? new UUID(-1L, -1L) : new UUID(0L, 0L);
    }
}

