/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.FastByteArrayOutputStream;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class UrlUtilities {
    private static final AtomicReference<String> globalUserAgent = new AtomicReference();
    private static final AtomicReference<String> globalReferrer = new AtomicReference();
    public static final ThreadLocal<String> userAgent = new ThreadLocal();
    public static final ThreadLocal<String> referrer = new ThreadLocal();
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE_SEPARATOR = "; ";
    public static final String COOKIE = "Cookie";
    public static final String COOKIE_VALUE_DELIMITER = ";";
    public static final String PATH = "path";
    public static final String EXPIRES = "expires";
    public static final SafeSimpleDateFormat DATE_FORMAT = new SafeSimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    public static final char NAME_VALUE_SEPARATOR = '=';
    public static final char DOT = '.';
    private static volatile int defaultReadTimeout = 220000;
    private static volatile int defaultConnectTimeout = 45000;
    private static volatile long maxDownloadSize = 0x6400000L;
    private static volatile int maxContentLength = 524288000;
    private static final Pattern resPattern = Pattern.compile("^res://", 2);
    @Deprecated
    public static final TrustManager[] NAIVE_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    @Deprecated
    public static final HostnameVerifier NAIVE_VERIFIER = (hostname, sslSession) -> true;
    protected static SSLSocketFactory naiveSSLSocketFactory;
    private static final Logger LOG;

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("urlutilities.security.enabled", "false"));
    }

    private static long getConfiguredMaxDownloadSize() {
        long configured;
        String prop = System.getProperty("urlutilities.max.download.size");
        if (prop != null && (configured = Long.parseLong(prop)) > 0L) {
            return configured;
        }
        return UrlUtilities.isSecurityEnabled() ? maxDownloadSize : Long.MAX_VALUE;
    }

    private static int getConfiguredMaxContentLength() {
        int configured;
        String prop = System.getProperty("urlutilities.max.content.length");
        if (prop != null && (configured = Integer.parseInt(prop)) > 0) {
            return configured;
        }
        return UrlUtilities.isSecurityEnabled() ? maxContentLength : Integer.MAX_VALUE;
    }

    private static boolean isInternalHostAllowed() {
        return Boolean.parseBoolean(System.getProperty("urlutilities.allow.internal.hosts", "true"));
    }

    private static String[] getAllowedProtocols() {
        String prop = System.getProperty("urlutilities.allowed.protocols", "http,https,ftp");
        return prop.split(",");
    }

    private static boolean isStrictCookieDomainEnabled() {
        return Boolean.parseBoolean(System.getProperty("urlutilities.strict.cookie.domain", "false"));
    }

    private UrlUtilities() {
    }

    public static void clearGlobalUserAgent() {
        globalUserAgent.set(null);
    }

    public static void clearGlobalReferrer() {
        globalReferrer.set(null);
    }

    public static void setReferrer(String referer) {
        if (StringUtilities.isEmpty(globalReferrer.get())) {
            globalReferrer.set(referer);
        }
        referrer.set(referer);
    }

    public static String getReferrer() {
        String localReferrer = referrer.get();
        if (StringUtilities.hasContent(localReferrer)) {
            return localReferrer;
        }
        return globalReferrer.get();
    }

    public static void setUserAgent(String agent) {
        if (StringUtilities.isEmpty(globalUserAgent.get())) {
            globalUserAgent.set(agent);
        }
        userAgent.set(agent);
    }

    public static String getUserAgent() {
        String localAgent = userAgent.get();
        if (StringUtilities.hasContent(localAgent)) {
            return localAgent;
        }
        return globalUserAgent.get();
    }

    public static void setDefaultConnectTimeout(int millis) {
        defaultConnectTimeout = millis;
    }

    public static void setDefaultReadTimeout(int millis) {
        defaultReadTimeout = millis;
    }

    public static int getDefaultConnectTimeout() {
        return defaultConnectTimeout;
    }

    public static int getDefaultReadTimeout() {
        return defaultReadTimeout;
    }

    public static void setMaxDownloadSize(long maxSizeBytes) {
        if (maxSizeBytes <= 0L) {
            throw new IllegalArgumentException("Max download size must be positive: " + maxSizeBytes);
        }
        maxDownloadSize = maxSizeBytes;
    }

    public static long getMaxDownloadSize() {
        long configured;
        String prop = System.getProperty("urlutilities.max.download.size");
        if (prop != null && (configured = Long.parseLong(prop)) > 0L) {
            return configured;
        }
        return maxDownloadSize;
    }

    public static void setMaxContentLength(int maxLengthBytes) {
        if (maxLengthBytes <= 0) {
            throw new IllegalArgumentException("Max content length must be positive: " + maxLengthBytes);
        }
        maxContentLength = maxLengthBytes;
    }

    public static int getMaxContentLength() {
        int configured;
        String prop = System.getProperty("urlutilities.max.content.length");
        if (prop != null && (configured = Integer.parseInt(prop)) > 0) {
            return configured;
        }
        return maxContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readErrorResponse(URLConnection c) {
        InputStream in;
        block7: {
            if (c == null) {
                return;
            }
            in = null;
            ((HttpURLConnection)c).getResponseCode();
            in = ((HttpURLConnection)c).getErrorStream();
            if (in != null) break block7;
            IOUtilities.close(in);
            return;
        }
        try {
            int count;
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] bytes = new byte[8192];
            while ((count = in.read(bytes)) != -1) {
                out.write(bytes, 0, count);
            }
        }
        catch (Exception e) {
            try {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
            IOUtilities.close(in);
        }
        IOUtilities.close(in);
    }

    private static void transferWithLimit(InputStream input, OutputStream output, long maxBytes) throws IOException {
        int bytesRead;
        long effectiveLimit = UrlUtilities.isSecurityEnabled() ? UrlUtilities.getConfiguredMaxDownloadSize() : maxBytes;
        byte[] buffer = new byte[8192];
        long totalBytes = 0L;
        while ((bytesRead = input.read(buffer)) != -1) {
            if (effectiveLimit != Long.MAX_VALUE && (totalBytes += (long)bytesRead) > effectiveLimit) {
                throw new SecurityException("Download size exceeds maximum allowed: " + totalBytes + " > " + effectiveLimit);
            }
            output.write(buffer, 0, bytesRead);
        }
    }

    private static void validateContentLength(URLConnection connection) {
        int contentLength = connection.getContentLength();
        if (contentLength == -1) {
            return;
        }
        if (contentLength > maxContentLength) {
            throw new SecurityException("Content-Length exceeds maximum allowed: " + contentLength + " > " + maxContentLength);
        }
        if (contentLength < -1) {
            throw new SecurityException("Invalid Content-Length value: " + contentLength);
        }
    }

    private static void validateCookieName(String cookieName) {
        if (cookieName == null || cookieName.trim().isEmpty()) {
            throw new SecurityException("Cookie name cannot be null or empty");
        }
        if (cookieName.length() > 256) {
            throw new SecurityException("Cookie name too long (max 256): " + cookieName.length());
        }
        if (cookieName.contains("\n") || cookieName.contains("\r") || cookieName.contains("\u0000") || cookieName.contains(COOKIE_VALUE_DELIMITER) || cookieName.contains("=") || cookieName.contains(" ")) {
            throw new SecurityException("Cookie name contains dangerous characters: " + cookieName);
        }
        String lowerName = cookieName.toLowerCase();
        if (lowerName.startsWith("__secure-") || lowerName.startsWith("__host-")) {
            LOG.warning("Cookie name uses reserved prefix: " + cookieName);
        }
    }

    private static void validateCookieValue(String cookieValue) {
        if (cookieValue == null) {
            return;
        }
        if (cookieValue.length() > 4096) {
            throw new SecurityException("Cookie value too long (max 4096): " + cookieValue.length());
        }
        if (cookieValue.contains("\n") || cookieValue.contains("\r") || cookieValue.contains("\u0000")) {
            throw new SecurityException("Cookie value contains dangerous control characters");
        }
    }

    private static void validateCookieDomain(String cookieDomain, String requestHost) {
        if (cookieDomain == null || requestHost == null || !UrlUtilities.isStrictCookieDomainEnabled()) {
            return;
        }
        String normalizedDomain = cookieDomain.toLowerCase().trim();
        String normalizedHost = requestHost.toLowerCase().trim();
        if (normalizedDomain.startsWith(".")) {
            normalizedDomain = normalizedDomain.substring(1);
        }
        if (!normalizedHost.equals(normalizedDomain) && !normalizedHost.endsWith("." + normalizedDomain)) {
            throw new SecurityException("Cookie domain mismatch - potential domain hijacking: " + cookieDomain + " vs " + requestHost);
        }
        if (normalizedDomain.equals("com") || normalizedDomain.equals("org") || normalizedDomain.equals("net") || normalizedDomain.equals("edu") || normalizedDomain.equals("localhost") || normalizedDomain.equals("local")) {
            throw new SecurityException("Cookie domain cannot be set on public suffix: " + cookieDomain);
        }
    }

    public static void disconnect(HttpURLConnection c) {
        if (c != null) {
            try {
                c.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getCookies(URLConnection conn, Map<String, Map<String, Map<String, String>>> store) {
        String headerName;
        Map<Object, Object> domainStore;
        String domain = UrlUtilities.getCookieDomainFromHost(conn.getURL().getHost());
        String requestHost = conn.getURL().getHost();
        if (store.containsKey(domain)) {
            domainStore = store.get(domain);
        } else {
            domainStore = new ConcurrentHashMap();
            store.put(domain, domainStore);
        }
        if (domainStore.containsKey("JSESSIONID")) {
            return;
        }
        int i = 1;
        while ((headerName = conn.getHeaderFieldKey(i)) != null) {
            block13: {
                if (headerName.equalsIgnoreCase(SET_COOKIE)) {
                    try {
                        String value;
                        String key;
                        String token;
                        ConcurrentHashMap<String, String> cookie = new ConcurrentHashMap<String, String>();
                        StringTokenizer st = new StringTokenizer(conn.getHeaderField(i), COOKIE_VALUE_DELIMITER);
                        if (st.hasMoreTokens()) {
                            token = st.nextToken().trim();
                            int sepIndex = token.indexOf(61);
                            if (sepIndex == -1) break block13;
                            key = token.substring(0, sepIndex).trim();
                            value = token.substring(sepIndex + 1);
                            UrlUtilities.validateCookieName(key);
                            UrlUtilities.validateCookieValue(value);
                            domainStore.put(key, cookie);
                            cookie.put(key, value);
                        }
                        while (st.hasMoreTokens()) {
                            token = st.nextToken().trim();
                            int pos = token.indexOf(61);
                            if (pos == -1) continue;
                            key = token.substring(0, pos).toLowerCase().trim();
                            value = token.substring(pos + 1).trim();
                            if ("domain".equals(key)) {
                                UrlUtilities.validateCookieDomain(value, requestHost);
                            }
                            if (value.length() > 4096) {
                                LOG.warning("Cookie attribute value too long, truncating: " + key);
                                continue;
                            }
                            cookie.put(key, value);
                        }
                    }
                    catch (SecurityException e) {
                        LOG.log(Level.WARNING, "Rejecting dangerous cookie from " + requestHost + ": " + e.getMessage());
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Error parsing cookie from " + requestHost + ": " + e.getMessage());
                    }
                }
            }
            ++i;
        }
    }

    public static void setCookies(URLConnection conn, Map<String, Map<String, Map<String, String>>> store) {
        URL url = conn.getURL();
        String domain = UrlUtilities.getCookieDomainFromHost(url.getHost());
        String path = url.getPath();
        Map<String, Map<String, String>> domainStore = store.get(domain);
        if (domainStore == null) {
            return;
        }
        StringBuilder cookieStringBuffer = new StringBuilder();
        Iterator<String> cookieNames = domainStore.keySet().iterator();
        while (cookieNames.hasNext()) {
            String cookieName = cookieNames.next();
            Map<String, String> cookie = domainStore.get(cookieName);
            if (!UrlUtilities.comparePaths(cookie.get(PATH), path) || !UrlUtilities.isNotExpired(cookie.get(EXPIRES))) continue;
            try {
                UrlUtilities.validateCookieName(cookieName);
                String cookieValue = cookie.get(cookieName);
                UrlUtilities.validateCookieValue(cookieValue);
                if (cookieStringBuffer.length() + cookieName.length() + cookieValue.length() + 10 > 8192) {
                    LOG.warning("Cookie header size limit reached, stopping cookie addition");
                    break;
                }
                cookieStringBuffer.append(cookieName);
                cookieStringBuffer.append('=');
                cookieStringBuffer.append(cookieValue);
                if (!cookieNames.hasNext()) continue;
                cookieStringBuffer.append(SET_COOKIE_SEPARATOR);
            }
            catch (SecurityException e) {
                LOG.log(Level.WARNING, "Skipping dangerous cookie in request: " + e.getMessage());
            }
        }
        try {
            conn.setRequestProperty(COOKIE, cookieStringBuffer.toString());
        }
        catch (IllegalStateException e) {
            ExceptionUtilities.uncheckedThrow(new IOException("Illegal State! Cookies cannot be set on a URLConnection that is already connected. Only call setCookies(java.net.URLConnection) AFTER calling java.net.URLConnection.connect()."));
        }
    }

    public static String getCookieDomainFromHost(String host) {
        if (host == null) {
            return null;
        }
        String[] parts = host.split("\\.");
        if (parts.length <= 2) {
            return host;
        }
        String tld = parts[parts.length - 1];
        if (tld.length() == 2 && parts.length >= 3) {
            return parts[parts.length - 3] + '.' + parts[parts.length - 2] + '.' + tld;
        }
        return parts[parts.length - 2] + '.' + tld;
    }

    private static boolean isNotExpired(String cookieExpires) {
        if (cookieExpires == null) {
            return true;
        }
        try {
            return new Date().compareTo(DATE_FORMAT.parse(cookieExpires)) <= 0;
        }
        catch (ParseException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    private static boolean comparePaths(String cookiePath, String targetPath) {
        return cookiePath == null || "/".equals(cookiePath) || targetPath.regionMatches(0, cookiePath, 0, cookiePath.length());
    }

    public static String getContentFromUrlAsString(String url) {
        return UrlUtilities.getContentFromUrlAsString(url, null, null, false);
    }

    public static String getContentFromUrlAsString(URL url, boolean allowAllCerts) {
        return UrlUtilities.getContentFromUrlAsString(url, null, null, allowAllCerts);
    }

    public static String getContentFromUrlAsString(String url, Map inCookies, Map outCookies, boolean trustAllCerts) {
        byte[] bytes = UrlUtilities.getContentFromUrl(url, inCookies, outCookies, trustAllCerts);
        return bytes == null ? null : StringUtilities.createString(bytes, "UTF-8");
    }

    public static String getContentFromUrlAsString(URL url, Map inCookies, Map outCookies, boolean trustAllCerts) {
        byte[] bytes = UrlUtilities.getContentFromUrl(url, inCookies, outCookies, trustAllCerts);
        return bytes == null ? null : StringUtilities.createString(bytes, "UTF-8");
    }

    public static byte[] getContentFromUrl(String url) {
        return UrlUtilities.getContentFromUrl(url, null, null, false);
    }

    public static byte[] getContentFromUrl(URL url, boolean allowAllCerts) {
        return UrlUtilities.getContentFromUrl(url, null, null, allowAllCerts);
    }

    public static byte[] getContentFromUrl(String url, Map inCookies, Map outCookies, boolean allowAllCerts) {
        try {
            return UrlUtilities.getContentFromUrl(UrlUtilities.getActualUrl(url), inCookies, outCookies, allowAllCerts);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContentFromUrl(URL url, Map inCookies, Map outCookies, boolean allowAllCerts) {
        URLConnection c = null;
        try {
            c = UrlUtilities.getConnection(url, inCookies, true, false, false, allowAllCerts);
            FastByteArrayOutputStream out = new FastByteArrayOutputStream(65536);
            InputStream stream = IOUtilities.getInputStream(c);
            UrlUtilities.validateContentLength(c);
            UrlUtilities.transferWithLimit(stream, out, maxDownloadSize);
            stream.close();
            if (outCookies != null) {
                UrlUtilities.getCookies(c, outCookies);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (SSLHandshakeException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            byte[] byArray = null;
            return byArray;
        }
        catch (SecurityException e) {
            LOG.log(Level.SEVERE, "Security violation in URL download: " + e.getMessage(), e);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            UrlUtilities.readErrorResponse(c);
            LOG.log(Level.WARNING, e.getMessage(), e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (c instanceof HttpURLConnection) {
                UrlUtilities.disconnect((HttpURLConnection)c);
            }
        }
    }

    public static void copyContentFromUrl(String url, OutputStream out) {
        UrlUtilities.copyContentFromUrl(UrlUtilities.getActualUrl(url), out, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContentFromUrl(URL url, OutputStream out, Map<String, Map<String, Map<String, String>>> inCookies, Map<String, Map<String, Map<String, String>>> outCookies, boolean allowAllCerts) {
        URLConnection c = null;
        try {
            c = UrlUtilities.getConnection(url, inCookies, true, false, false, allowAllCerts);
            InputStream stream = IOUtilities.getInputStream(c);
            UrlUtilities.validateContentLength(c);
            UrlUtilities.transferWithLimit(stream, out, maxDownloadSize);
            stream.close();
            if (outCookies != null) {
                UrlUtilities.getCookies(c, outCookies);
            }
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        finally {
            if (c instanceof HttpURLConnection) {
                UrlUtilities.disconnect((HttpURLConnection)c);
            }
        }
    }

    public static byte[] getContentFromUrl(String url, Map inCookies, Map outCookies) {
        return UrlUtilities.getContentFromUrl(url, inCookies, outCookies, false);
    }

    public static URLConnection getConnection(String url, boolean input, boolean output, boolean cache) {
        return UrlUtilities.getConnection(UrlUtilities.getActualUrl(url), null, input, output, cache, false);
    }

    public static URLConnection getConnection(URL url, boolean input, boolean output, boolean cache) {
        return UrlUtilities.getConnection(url, null, input, output, cache, false);
    }

    public static URLConnection getConnection(URL url, Map inCookies, boolean input, boolean output, boolean cache, boolean allowAllCerts) {
        String agent;
        URLConnection c = null;
        try {
            c = url.openConnection();
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        c.setRequestProperty("Accept-Encoding", "gzip, deflate");
        c.setAllowUserInteraction(false);
        c.setDoOutput(output);
        c.setDoInput(input);
        c.setUseCaches(cache);
        c.setReadTimeout(defaultReadTimeout);
        c.setConnectTimeout(defaultConnectTimeout);
        String ref = UrlUtilities.getReferrer();
        if (StringUtilities.hasContent(ref)) {
            c.setRequestProperty("Referer", ref);
        }
        if (StringUtilities.hasContent(agent = UrlUtilities.getUserAgent())) {
            c.setRequestProperty("User-Agent", agent);
        }
        if (c instanceof HttpURLConnection) {
            HttpURLConnection.setFollowRedirects(true);
        }
        if (c instanceof HttpsURLConnection && allowAllCerts) {
            LOG.warning("SSL certificate validation disabled - this is a security risk in production environments");
            try {
                UrlUtilities.setNaiveSSLSocketFactory((HttpsURLConnection)c);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (inCookies != null) {
            UrlUtilities.setCookies(c, inCookies);
        }
        return c;
    }

    @Deprecated
    private static void setNaiveSSLSocketFactory(HttpsURLConnection sc) {
        sc.setSSLSocketFactory(naiveSSLSocketFactory);
        sc.setHostnameVerifier(NAIVE_VERIFIER);
    }

    public static URL getActualUrl(String url) {
        Convention.throwIfNull(url, "URL cannot be null");
        Matcher m = resPattern.matcher(url);
        if (m.find()) {
            return ClassUtilities.getClassLoader().getResource(url.substring(m.end()));
        }
        try {
            URL parsedUrl = new URL(url);
            String protocol = parsedUrl.getProtocol();
            if (protocol == null || !protocol.equals("http") && !protocol.equals("https") && !protocol.equals("ftp")) {
                throw new IllegalArgumentException("Unsupported protocol: " + protocol);
            }
            String host = parsedUrl.getHost();
            if (host != null && (host.equals("localhost") || host.equals("127.0.0.1") || host.startsWith("192.168.") || host.startsWith("10.") || host.startsWith("172."))) {
                LOG.warning("Accessing internal/local host: " + host);
            }
            return parsedUrl;
        }
        catch (MalformedURLException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    static {
        LOG = Logger.getLogger(UrlUtilities.class.getName());
        LoggingConfig.init();
        try {
            HttpURLConnection.setFollowRedirects(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, NAIVE_TRUST_MANAGER, new SecureRandom());
            naiveSSLSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }
}

