/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.ClassValueSet;
import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.LRUCache;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.Unsafe;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ReflectPermission;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class ClassUtilities {
    private static final Logger LOG = Logger.getLogger(ClassUtilities.class.getName());
    private static final Map<String, Class<?>> nameToClass;
    private static final Map<Class<?>, Class<?>> wrapperMap;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;
    private static final Map<Class<?>, ClassLoader> osgiClassLoaders;
    private static final ClassLoader SYSTEM_LOADER;
    private static volatile boolean useUnsafe;
    private static volatile Unsafe unsafe;
    private static final int DEFAULT_MAX_CLASS_LOAD_DEPTH = 100;
    private static final int DEFAULT_MAX_CONSTRUCTOR_ARGS = 50;
    private static final int DEFAULT_MAX_REFLECTION_OPERATIONS_PER_CALL = 1000;
    private static final int DEFAULT_MAX_RESOURCE_NAME_LENGTH = 1000;
    private static final ThreadLocal<Integer> CLASS_LOAD_DEPTH;
    private static final Map<Class<?>, Supplier<Object>> DIRECT_CLASS_MAPPING;
    private static final Map<Class<?>, Supplier<Object>> ASSIGNABLE_CLASS_MAPPING;
    private static final ClassValue<Class<?>> ENUM_CLASS_CACHE;
    private static final Map<Class<?>, Constructor<?>> SUCCESSFUL_CONSTRUCTOR_CACHE;
    private static final Map<Class<?>, ClassHierarchyInfo> CLASS_HIERARCHY_CACHE;
    private static final int BUFFER_SIZE = 65536;
    private static final Pattern ARG_PATTERN;
    private static final Class<?> INACCESSIBLE_OBJECT_EXCEPTION_CLASS;
    private static final ClassValueSet BLOCKED_CLASSES;
    private static final Set<String> BLOCKED_CLASS_NAMES_SET;
    private static final ClassValueSet INHERITS_FROM_BLOCKED;
    private static final ClassValueSet VERIFIED_SAFE_CLASSES;
    private static final ClassValue<Boolean> SECURITY_CHECK_CACHE;

    private ClassUtilities() {
    }

    public static Class<?> getPrimitiveFromWrapper(Class<?> toType) {
        Convention.throwIfNull(toType, "toType cannot be null");
        return WRAPPER_TO_PRIMITIVE.get(toType);
    }

    public static void addPermanentClassAlias(Class<?> clazz, String alias) {
        nameToClass.put(alias, clazz);
    }

    public static void removePermanentClassAlias(String alias) {
        nameToClass.remove(alias);
    }

    public static int computeInheritanceDistance(Class<?> source, Class<?> destination) {
        if (source == null || destination == null) {
            return -1;
        }
        if (source.equals(destination)) {
            return 0;
        }
        if ((source.isPrimitive() || ClassUtilities.isPrimitive(source)) && (destination.isPrimitive() || ClassUtilities.isPrimitive(destination))) {
            return ClassUtilities.areSamePrimitiveType(source, destination) ? 0 : -1;
        }
        return ClassUtilities.getClassHierarchyInfo(source).getDistance(destination);
    }

    private static boolean areSamePrimitiveType(Class<?> source, Class<?> destination) {
        Class<?> destPrimitive;
        if (source.isPrimitive() && destination.isPrimitive()) {
            return source.equals(destination);
        }
        Class<?> sourcePrimitive = source.isPrimitive() ? source : WRAPPER_TO_PRIMITIVE.get(source);
        Class<?> clazz = destPrimitive = destination.isPrimitive() ? destination : WRAPPER_TO_PRIMITIVE.get(destination);
        if (sourcePrimitive == null || destPrimitive == null) {
            return false;
        }
        return sourcePrimitive.equals(destPrimitive);
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || WRAPPER_TO_PRIMITIVE.containsKey(c);
    }

    public static Class<?> forName(String name, ClassLoader classLoader) {
        if (StringUtilities.isEmpty(name)) {
            return null;
        }
        try {
            return ClassUtilities.internalClassForName(name, classLoader);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> internalClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> c = nameToClass.get(name);
        if (c != null) {
            return c;
        }
        if (SecurityChecker.isSecurityBlockedName(name)) {
            throw new SecurityException("For security reasons, cannot load: " + name);
        }
        int currentDepth = CLASS_LOAD_DEPTH.get();
        ClassUtilities.validateEnhancedSecurity("Class loading depth", currentDepth, ClassUtilities.getMaxClassLoadDepth());
        try {
            CLASS_LOAD_DEPTH.set(currentDepth + 1);
            c = ClassUtilities.loadClass(name, classLoader);
        }
        finally {
            CLASS_LOAD_DEPTH.set(currentDepth);
        }
        SecurityChecker.verifyClass(c);
        nameToClass.put(name, c);
        return c;
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class<Object> primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            switch (className) {
                case "[B": {
                    primitiveArray = byte[].class;
                    break;
                }
                case "[S": {
                    primitiveArray = short[].class;
                    break;
                }
                case "[I": {
                    primitiveArray = int[].class;
                    break;
                }
                case "[J": {
                    primitiveArray = long[].class;
                    break;
                }
                case "[F": {
                    primitiveArray = float[].class;
                    break;
                }
                case "[D": {
                    primitiveArray = double[].class;
                    break;
                }
                case "[Z": {
                    primitiveArray = boolean[].class;
                    break;
                }
                case "[C": {
                    primitiveArray = char[].class;
                }
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<?> currentClass = null;
        if (null == primitiveArray) {
            try {
                if (classLoader == null) {
                    throw new ClassNotFoundException("No classloader provided");
                }
                currentClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NullPointerException e) {
                ClassLoader ctx = Thread.currentThread().getContextClassLoader();
                if (ctx != null) {
                    ClassUtilities.validateContextClassLoader(ctx);
                    currentClass = ctx.loadClass(className);
                }
                if (SecurityChecker.isSecurityBlockedName(className)) {
                    throw new SecurityException("Class loading denied for security reasons: " + className);
                }
                currentClass = Class.forName(className, false, ClassUtilities.getClassLoader(ClassUtilities.class));
            }
        }
        if (arrayType) {
            Class<Object> clazz = currentClass = null != primitiveArray ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    public static boolean isClassFinal(Class<?> c) {
        return (c.getModifiers() & 0x10) != 0;
    }

    public static boolean areAllConstructorsPrivate(Class<?> c) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = ReflectionUtils.getAllConstructors(c)) {
            if ((constructor.getModifiers() & 2) != 0) continue;
            return false;
        }
        return true;
    }

    public static Class<?> toPrimitiveWrapperClass(Class<?> primitiveClass) {
        if (!primitiveClass.isPrimitive()) {
            return primitiveClass;
        }
        Class<?> c = PRIMITIVE_TO_WRAPPER.get(primitiveClass);
        if (c == null) {
            throw new IllegalArgumentException("Passed in class: " + primitiveClass + " is not a primitive class");
        }
        return c;
    }

    public static Class<?> toPrimitiveClass(Class<?> wrapperClass) {
        if (wrapperClass == null) {
            throw new IllegalArgumentException("Passed in class cannot be null");
        }
        Class<?> primitive = WRAPPER_TO_PRIMITIVE.get(wrapperClass);
        return primitive != null ? primitive : wrapperClass;
    }

    public static boolean doesOneWrapTheOther(Class<?> x, Class<?> y) {
        return wrapperMap.get(x) == y;
    }

    public static ClassLoader getClassLoader() {
        return ClassUtilities.getClassLoader(ClassUtilities.class);
    }

    public static ClassLoader getClassLoader(Class<?> anchorClass) {
        if (anchorClass == null) {
            throw new IllegalArgumentException("Anchor class cannot be null");
        }
        ClassUtilities.checkSecurityAccess();
        ClassLoader cl = ClassUtilities.getOSGiClassLoader(anchorClass);
        if (cl != null) {
            return cl;
        }
        cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        cl = anchorClass.getClassLoader();
        if (cl != null) {
            return cl;
        }
        return SYSTEM_LOADER;
    }

    private static void checkSecurityAccess() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static ClassLoader getOSGiClassLoader(Class<?> classFromBundle) {
        return osgiClassLoaders.computeIfAbsent(classFromBundle, ClassUtilities::getOSGiClassLoader0);
    }

    private static ClassLoader getOSGiClassLoader0(Class<?> classFromBundle) {
        try {
            Class<?> frameworkUtilClass = Class.forName("org.osgi.framework.FrameworkUtil");
            Method getBundleMethod = frameworkUtilClass.getMethod("getBundle", Class.class);
            Object bundle = getBundleMethod.invoke(null, classFromBundle);
            if (bundle != null) {
                Method getClassLoaderMethod;
                Object classLoader;
                Class<?> bundleWiringClass = Class.forName("org.osgi.framework.wiring.BundleWiring");
                Method adaptMethod = bundle.getClass().getMethod("adapt", Class.class);
                Object bundleWiring = adaptMethod.invoke(bundle, bundleWiringClass);
                if (bundleWiring != null && (classLoader = (getClassLoaderMethod = bundleWiringClass.getMethod("getClassLoader", new Class[0])).invoke(bundleWiring, new Object[0])) instanceof ClassLoader) {
                    return (ClassLoader)classLoader;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T> T findClosest(Class<?> clazz, Map<Class<?>, T> candidateClasses, T defaultClass) {
        Convention.throwIfNull(clazz, "Source class cannot be null");
        Convention.throwIfNull(candidateClasses, "Candidate classes Map cannot be null");
        T exactMatch = candidateClasses.get(clazz);
        if (exactMatch != null) {
            return exactMatch;
        }
        T closest = defaultClass;
        int minDistance = Integer.MAX_VALUE;
        Class<?> closestClass = null;
        for (Map.Entry<Class<?>, T> entry : candidateClasses.entrySet()) {
            Class<?> candidateClass = entry.getKey();
            int distance = ClassUtilities.computeInheritanceDistance(clazz, candidateClass);
            if (distance == -1 || distance >= minDistance && (distance != minDistance || !ClassUtilities.shouldPreferNewCandidate(candidateClass, closestClass))) continue;
            minDistance = distance;
            closest = entry.getValue();
            closestClass = candidateClass;
        }
        return closest;
    }

    private static boolean shouldPreferNewCandidate(Class<?> newClass, Class<?> currentClass) {
        if (currentClass == null) {
            return true;
        }
        if (newClass.isInterface() != currentClass.isInterface()) {
            return !newClass.isInterface();
        }
        return newClass.isAssignableFrom(currentClass);
    }

    public static String loadResourceAsString(String resourceName) {
        byte[] resourceBytes = ClassUtilities.loadResourceAsBytes(resourceName);
        return new String(resourceBytes, StandardCharsets.UTF_8);
    }

    public static byte[] loadResourceAsBytes(String resourceName) {
        byte[] byArray;
        block11: {
            Objects.requireNonNull(resourceName, "resourceName cannot be null");
            ClassUtilities.validateResourcePath(resourceName);
            InputStream inputStream = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                inputStream = cl.getResourceAsStream(resourceName);
            }
            if (inputStream == null) {
                cl = ClassUtilities.getClassLoader(ClassUtilities.class);
                inputStream = cl.getResourceAsStream(resourceName);
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: " + resourceName);
            }
            InputStream in = inputStream;
            try {
                byArray = ClassUtilities.readInputStreamFully(in);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error reading resource: " + resourceName, e);
                }
            }
            in.close();
        }
        return byArray;
    }

    private static byte[] readInputStreamFully(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        byte[] data = new byte[65536];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static Object getArgForType(com.cedarsoftware.util.convert.Converter converter, Class<?> argType) {
        if (ClassUtilities.isPrimitive(argType)) {
            return converter.convert(null, argType);
        }
        Supplier<Object> directClassMapping = DIRECT_CLASS_MAPPING.get(argType);
        if (directClassMapping != null) {
            return directClassMapping.get();
        }
        for (Map.Entry<Class<?>, Supplier<Object>> entry : ASSIGNABLE_CLASS_MAPPING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(argType)) continue;
            return entry.getValue().get();
        }
        if (argType.isArray()) {
            return Array.newInstance(argType.getComponentType(), 0);
        }
        return null;
    }

    private static Object[] matchArgumentsToParameters(com.cedarsoftware.util.convert.Converter converter, Collection<?> values, Parameter[] parameters, boolean allowNulls) {
        if (parameters == null || parameters.length == 0) {
            return ArrayUtilities.EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[parameters.length];
        boolean[] parameterMatched = new boolean[parameters.length];
        Object[] valueArray = values.toArray();
        boolean[] valueUsed = new boolean[valueArray.length];
        ClassUtilities.findExactMatches(valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.findInheritanceMatches(valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.findPrimitiveWrapperMatches(valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.findConvertibleMatches(converter, valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.fillRemainingParameters(converter, parameters, parameterMatched, result, allowNulls);
        return result;
    }

    private static void findExactMatches(Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        int valLen = values.length;
        int paramLen = parameters.length;
        block0: for (int i = 0; i < paramLen; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            for (int j = 0; j < valLen; ++j) {
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || value.getClass() != paramType) continue;
                result[i] = value;
                parameterMatched[i] = true;
                valueUsed[j] = true;
                continue block0;
            }
        }
    }

    private static void findInheritanceMatches(Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            int bestDistance = Integer.MAX_VALUE;
            int bestValueIndex = -1;
            for (int j = 0; j < values.length; ++j) {
                Class<?> valueClass;
                int distance;
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || (distance = ClassUtilities.computeInheritanceDistance(valueClass = value.getClass(), paramType)) < 0 || distance >= bestDistance) continue;
                bestDistance = distance;
                bestValueIndex = j;
            }
            if (bestValueIndex < 0) continue;
            result[i] = values[bestValueIndex];
            parameterMatched[i] = true;
            valueUsed[bestValueIndex] = true;
        }
    }

    private static void findPrimitiveWrapperMatches(Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        block0: for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            for (int j = 0; j < values.length; ++j) {
                Class<?> valueClass;
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || !ClassUtilities.doesOneWrapTheOther(paramType, valueClass = value.getClass())) continue;
                result[i] = value;
                parameterMatched[i] = true;
                valueUsed[j] = true;
                continue block0;
            }
        }
    }

    private static void findConvertibleMatches(com.cedarsoftware.util.convert.Converter converter, Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        block2: for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            for (int j = 0; j < values.length; ++j) {
                Class<?> valueClass;
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || !converter.isSimpleTypeConversionSupported(paramType, valueClass = value.getClass())) continue;
                try {
                    Object converted = converter.convert(value, paramType);
                    result[i] = converted;
                    parameterMatched[i] = true;
                    valueUsed[j] = true;
                    continue block2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void fillRemainingParameters(com.cedarsoftware.util.convert.Converter converter, Parameter[] parameters, boolean[] parameterMatched, Object[] result, boolean allowNulls) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Parameter parameter = parameters[i];
            Class<?> paramType = parameter.getType();
            if (allowNulls && !paramType.isPrimitive()) {
                result[i] = null;
                continue;
            }
            Object defaultValue = ClassUtilities.getArgForType(converter, paramType);
            if (defaultValue == null && paramType.isPrimitive()) {
                defaultValue = converter.convert(null, paramType);
            }
            result[i] = defaultValue;
        }
    }

    @Deprecated
    public static int indexOfSmallestValue(int[] array) {
        if (array == null || array.length == 0) {
            return -1;
        }
        int minValue = Integer.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= minValue) continue;
            minValue = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static Class<?> getClassIfEnum(Class<?> c) {
        if (c == null) {
            return null;
        }
        return ENUM_CLASS_CACHE.get(c);
    }

    private static Class<?> computeEnum(Class<?> c) {
        if (c.isEnum() && c != Enum.class) {
            return c;
        }
        Class<?> current = c;
        while ((current = current.getSuperclass()) != null) {
            if (!current.isEnum() || current == Enum.class) continue;
            return current;
        }
        for (current = c.getEnclosingClass(); current != null; current = current.getEnclosingClass()) {
            if (!current.isEnum() || current == Enum.class) continue;
            return current;
        }
        return null;
    }

    public static Object newInstance(Class<?> c, Object arguments) {
        return ClassUtilities.newInstance(Converter.getInstance(), c, arguments);
    }

    public static Object newInstance(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Object arguments) {
        Collection<Object> normalizedArgs;
        Convention.throwIfNull(c, "Class cannot be null");
        Convention.throwIfNull(converter, "Converter cannot be null");
        Map namedParameters = null;
        boolean hasNamedParameters = false;
        if (arguments == null) {
            normalizedArgs = Collections.emptyList();
        } else if (arguments instanceof Collection) {
            normalizedArgs = (Collection)arguments;
        } else if (arguments instanceof Map) {
            Map map = (Map)arguments;
            boolean generatedKeys = ClassUtilities.hasGeneratedKeys(map);
            if (!generatedKeys) {
                hasNamedParameters = true;
                namedParameters = map;
            }
            if (generatedKeys) {
                ArrayList orderedValues = new ArrayList();
                for (int i = 0; i < map.size(); ++i) {
                    orderedValues.add(map.get("arg" + i));
                }
                normalizedArgs = orderedValues;
            } else {
                normalizedArgs = map.values();
            }
        } else {
            normalizedArgs = arguments.getClass().isArray() ? converter.convert(arguments, Collection.class) : Collections.singletonList(arguments);
        }
        if (hasNamedParameters && namedParameters != null) {
            LOG.log(Level.FINE, "Attempting parameter name matching for class: {0}", c.getName());
            LOG.log(Level.FINER, "Provided parameter names: {0}", namedParameters.keySet());
            try {
                Object result = ClassUtilities.newInstanceWithNamedParameters(converter, c, namedParameters);
                if (result != null) {
                    LOG.log(Level.FINE, "Successfully created instance of {0} using parameter names", c.getName());
                    return result;
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Parameter name matching failed for {0}: {1}", new Object[]{c.getName(), e.getMessage()});
                LOG.log(Level.FINER, "Falling back to positional argument matching");
            }
        }
        LOG.log(Level.FINER, "Using positional argument matching for {0}", c.getName());
        Set<Class<?>> visited = Collections.newSetFromMap(new IdentityHashMap());
        try {
            return ClassUtilities.newInstance(converter, c, normalizedArgs, visited);
        }
        catch (Exception e) {
            if (arguments instanceof Map && normalizedArgs != null && !normalizedArgs.isEmpty()) {
                LOG.log(Level.FINER, "Positional matching with map values failed for {0}, trying no-arg constructor", c.getName());
                return ClassUtilities.newInstance(converter, c, null, visited);
            }
            throw e;
        }
    }

    private static Object newInstanceWithNamedParameters(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Map<String, Object> namedParams) {
        Parameter[] parameters;
        Constructor<?>[] sortedConstructors = ReflectionUtils.getAllConstructors(c);
        boolean isFinal = Modifier.isFinal(c.getModifiers());
        boolean isException = Throwable.class.isAssignableFrom(c);
        LOG.log(Level.FINER, "Class {0} is {1}{2}", new Object[]{c.getName(), isFinal ? "final" : "non-final", isException ? " (Exception type)" : ""});
        LOG.log(Level.FINER, "Trying {0} constructors for {1}", new Object[]{sortedConstructors.length, c.getName()});
        boolean anyConstructorHasRealNames = false;
        for (Constructor<?> constructor : sortedConstructors) {
            String firstParamName;
            parameters = constructor.getParameters();
            if (parameters.length <= 0 || ARG_PATTERN.matcher(firstParamName = parameters[0].getName()).matches()) continue;
            anyConstructorHasRealNames = true;
            break;
        }
        if (!anyConstructorHasRealNames) {
            boolean hasParameterizedConstructor = false;
            Constructor<?>[] constructorArray = sortedConstructors;
            int n = constructorArray.length;
            for (int constructor = 0; constructor < n; ++constructor) {
                Constructor<?> cons = constructorArray[constructor];
                if (cons.getParameterCount() <= 0) continue;
                hasParameterizedConstructor = true;
                break;
            }
            if (hasParameterizedConstructor) {
                LOG.log(Level.FINE, "No constructors for {0} have real parameter names - cannot use parameter matching", c.getName());
                return null;
            }
        }
        for (Constructor<?> constructor : sortedConstructors) {
            LOG.log(Level.FINER, "Trying constructor: {0}", constructor);
            parameters = constructor.getParameters();
            String[] paramNames = new String[parameters.length];
            boolean hasRealNames = true;
            for (int i = 0; i < parameters.length; ++i) {
                paramNames[i] = parameters[i].getName();
                LOG.log(Level.FINEST, "  Parameter {0}: name=''{1}'', type={2}", new Object[]{i, paramNames[i], parameters[i].getType().getSimpleName()});
                if (!ARG_PATTERN.matcher(paramNames[i]).matches()) continue;
                hasRealNames = false;
            }
            if (!hasRealNames && parameters.length > 0) {
                LOG.log(Level.FINER, "  Skipping constructor - parameter names not available");
                continue;
            }
            Object[] args = new Object[parameters.length];
            boolean allMatched = true;
            for (int i = 0; i < parameters.length; ++i) {
                if (namedParams.containsKey(paramNames[i])) {
                    Object value = namedParams.get(paramNames[i]);
                    try {
                        args[i] = value == null ? (parameters[i].getType().isPrimitive() ? converter.convert(value, parameters[i].getType()) : null) : (parameters[i].getType().isAssignableFrom(value.getClass()) ? value : converter.convert(value, parameters[i].getType()));
                        LOG.log(Level.FINEST, "  Matched parameter ''{0}'' with value: {1}", new Object[]{paramNames[i], value});
                        continue;
                    }
                    catch (Exception conversionException) {
                        allMatched = false;
                        break;
                    }
                }
                LOG.log(Level.FINER, "  Missing parameter: {0}", paramNames[i]);
                allMatched = false;
                break;
            }
            if (!allMatched) continue;
            try {
                Object instance = constructor.newInstance(args);
                LOG.log(Level.FINE, "  Successfully created instance of {0}", c.getName());
                return instance;
            }
            catch (Exception e) {
                LOG.log(Level.FINER, "  Failed to invoke constructor: {0}", e.getMessage());
            }
        }
        return null;
    }

    private static boolean hasGeneratedKeys(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        for (String key : map.keySet()) {
            if (ARG_PATTERN.matcher(key).matches()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static Object newInstance(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Collection<?> argumentValues) {
        return ClassUtilities.newInstance(converter, c, argumentValues);
    }

    private static Object newInstance(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Collection<?> argumentValues, Set<Class<?>> visitedClasses) {
        Convention.throwIfNull(c, "Class cannot be null");
        SecurityChecker.verifyClass(c);
        if (argumentValues != null) {
            ClassUtilities.validateEnhancedSecurity("Constructor argument", argumentValues.size(), ClassUtilities.getMaxConstructorArgs());
        }
        if (visitedClasses.contains(c)) {
            throw new IllegalStateException("Circular reference detected for " + c.getName());
        }
        if (c.isInterface()) {
            throw new IllegalArgumentException("Cannot instantiate interface: " + c.getName());
        }
        if (Modifier.isAbstract(c.getModifiers())) {
            throw new IllegalArgumentException("Cannot instantiate abstract class: " + c.getName());
        }
        ArrayList normalizedArgs = argumentValues == null ? new ArrayList() : new ArrayList(argumentValues);
        Constructor<?> cachedConstructor = SUCCESSFUL_CONSTRUCTOR_CACHE.get(c);
        if (cachedConstructor != null) {
            try {
                Parameter[] parameters = cachedConstructor.getParameters();
                try {
                    Object[] argsNonNull = ClassUtilities.matchArgumentsToParameters(converter, normalizedArgs, parameters, false);
                    return cachedConstructor.newInstance(argsNonNull);
                }
                catch (Exception e) {
                    Object[] argsNull = ClassUtilities.matchArgumentsToParameters(converter, normalizedArgs, parameters, true);
                    return cachedConstructor.newInstance(argsNull);
                }
            }
            catch (Exception parameters) {
                // empty catch block
            }
        }
        if (c.getEnclosingClass() != null && !Modifier.isStatic(c.getModifiers())) {
            visitedClasses.add(c);
            try {
                Class<?> enclosingClass = c.getEnclosingClass();
                if (!visitedClasses.contains(enclosingClass)) {
                    Object enclosingInstance = ClassUtilities.newInstance(converter, enclosingClass, Collections.emptyList(), visitedClasses);
                    Constructor<?> constructor = ReflectionUtils.getConstructor(c, enclosingClass);
                    if (constructor != null) {
                        SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, constructor);
                        return constructor.newInstance(enclosingInstance);
                    }
                }
            }
            catch (Exception enclosingClass) {
                // empty catch block
            }
        }
        Constructor<?>[] constructors = ReflectionUtils.getAllConstructors(c);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Constructor<?> constructor : constructors) {
            Parameter[] parameters = constructor.getParameters();
            try {
                Object[] argsNonNull = ClassUtilities.matchArgumentsToParameters(converter, normalizedArgs, parameters, false);
                Object instance = constructor.newInstance(argsNonNull);
                SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, constructor);
                return instance;
            }
            catch (Exception e1) {
                exceptions.add(e1);
                try {
                    Object[] argsNull = ClassUtilities.matchArgumentsToParameters(converter, normalizedArgs, parameters, true);
                    Object instance = constructor.newInstance(argsNull);
                    SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, constructor);
                    return instance;
                }
                catch (Exception e2) {
                    exceptions.add(e2);
                }
            }
        }
        Object instance = ClassUtilities.tryUnsafeInstantiation(c);
        if (instance != null) {
            return instance;
        }
        String msg = "Unable to instantiate: " + c.getName();
        if (!exceptions.isEmpty()) {
            Exception lastException = (Exception)exceptions.get(exceptions.size() - 1);
            msg = msg + " - Most recent error: " + lastException.getMessage();
            if (exceptions.size() > 1) {
                StringBuilder errorDetails = new StringBuilder("\nAll constructor errors:\n");
                for (int i = 0; i < exceptions.size(); ++i) {
                    Exception e = (Exception)exceptions.get(i);
                    errorDetails.append("  ").append(i + 1).append(") ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).append("\n");
                }
                msg = msg + errorDetails.toString();
            }
        }
        throw new IllegalArgumentException(msg);
    }

    static void trySetAccessible(AccessibleObject object) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            catch (SecurityException e) {
                LOG.log(Level.WARNING, "Security manager denies access to: " + object);
                throw e;
            }
        }
        try {
            object.setAccessible(true);
        }
        catch (SecurityException e) {
            LOG.log(Level.WARNING, "Unable to set accessible: " + object + " - " + e.getMessage());
            throw e;
        }
        catch (Throwable t) {
            ExceptionUtilities.safelyIgnoreException(t);
        }
    }

    private static Object tryUnsafeInstantiation(Class<?> c) {
        if (useUnsafe) {
            try {
                SecurityChecker.verifyClass(c);
                return unsafe.allocateInstance(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setUseUnsafe(boolean state) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && state) {
            sm.checkPermission(new RuntimePermission("accessClassInPackage.sun.misc"));
            sm.checkPermission(new RuntimePermission("setFactory"));
        }
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (Exception e) {
                useUnsafe = false;
                LOG.log(Level.WARNING, "Failed to initialize unsafe instantiation: " + e.getMessage());
            }
        } else {
            unsafe = null;
        }
    }

    public static void logAccessIssue(AccessibleObject accessible, Exception e, String operation) {
        String modifiers;
        String declaringClass;
        String elementName;
        String elementType;
        if (!LOG.isLoggable(Level.FINEST)) {
            return;
        }
        if (accessible instanceof Field) {
            Field field = (Field)accessible;
            elementType = "field";
            elementName = field.getName();
            declaringClass = field.getDeclaringClass().getName();
            modifiers = Modifier.toString(field.getModifiers());
        } else if (accessible instanceof Method) {
            Method method = (Method)accessible;
            elementType = "method";
            elementName = method.getName() + "()";
            declaringClass = method.getDeclaringClass().getName();
            modifiers = Modifier.toString(method.getModifiers());
        } else if (accessible instanceof Constructor) {
            Constructor constructor = (Constructor)accessible;
            elementType = "constructor";
            elementName = constructor.getDeclaringClass().getSimpleName() + "()";
            declaringClass = constructor.getDeclaringClass().getName();
            modifiers = Modifier.toString(constructor.getModifiers());
        } else {
            elementType = "member";
            elementName = accessible.toString();
            declaringClass = "unknown";
            modifiers = "";
        }
        String reason = null;
        if (e instanceof IllegalAccessException) {
            String msg = e.getMessage();
            if (msg != null) {
                if (msg.contains("module")) {
                    reason = "Java module system restriction";
                } else if (msg.contains("private")) {
                    reason = "private access";
                } else if (msg.contains("protected")) {
                    reason = "protected access";
                } else if (msg.contains("package")) {
                    reason = "package-private access";
                }
            }
        } else if (INACCESSIBLE_OBJECT_EXCEPTION_CLASS != null && INACCESSIBLE_OBJECT_EXCEPTION_CLASS.isInstance(e)) {
            reason = "Java module system restriction (InaccessibleObjectException)";
        } else if (e instanceof SecurityException) {
            reason = "Security manager restriction";
        }
        if (reason == null) {
            reason = e.getClass().getSimpleName();
        }
        if (operation != null && !operation.isEmpty()) {
            LOG.log(Level.FINEST, "Cannot {0} {1} {2} ''{3}'' on {4} ({5})", new Object[]{operation, modifiers, elementType, elementName, declaringClass, reason});
        } else {
            LOG.log(Level.FINEST, "Cannot access {0} {1} ''{2}'' on {3} ({4})", new Object[]{modifiers, elementType, elementName, declaringClass, reason});
        }
    }

    private static void validateResourcePath(String resourceName) {
        if (resourceName == null || resourceName.trim().isEmpty()) {
            throw new SecurityException("Resource name cannot be null or empty");
        }
        if (resourceName.contains("..") || resourceName.contains("\\") || resourceName.startsWith("/") || resourceName.contains("//") || resourceName.contains("\\\\") || resourceName.contains("\u0000")) {
            throw new SecurityException("Invalid resource path detected: " + resourceName);
        }
        String lowerPath = resourceName.toLowerCase();
        if (lowerPath.startsWith("meta-inf") || lowerPath.contains("passwd") || lowerPath.contains("shadow") || lowerPath.contains("hosts") || lowerPath.contains("system32") || lowerPath.contains("windows")) {
            throw new SecurityException("Access to system resource denied: " + resourceName);
        }
        int maxLength = ClassUtilities.getMaxResourceNameLength();
        if (resourceName.length() > maxLength) {
            throw new SecurityException("Resource name too long (max " + maxLength + "): " + resourceName.length());
        }
    }

    private static void validateContextClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        String loaderClassName = classLoader.getClass().getName();
        if (loaderClassName.contains("Remote") || loaderClassName.contains("Injection") || loaderClassName.contains("Malicious") || loaderClassName.contains("Evil")) {
            throw new SecurityException("Untrusted ClassLoader detected: " + loaderClassName);
        }
        if (!(loaderClassName.startsWith("java.") || loaderClassName.startsWith("jdk.") || loaderClassName.startsWith("sun.") || loaderClassName.startsWith("com.cedarsoftware."))) {
            LOG.log(Level.WARNING, "Using non-standard ClassLoader: " + loaderClassName);
        }
    }

    public static void logFieldAccessIssue(Field field, Exception e) {
        ClassUtilities.logAccessIssue(field, e, "read");
    }

    public static void logMethodAccessIssue(Method method, Exception e) {
        ClassUtilities.logAccessIssue(method, e, "invoke");
    }

    public static void logConstructorAccessIssue(Constructor<?> constructor, Exception e) {
        ClassUtilities.logAccessIssue(constructor, e, "invoke");
    }

    public static Set<Class<?>> findLowestCommonSupertypesExcluding(Class<?> classA, Class<?> classB, Set<Class<?>> excluded) {
        if (classA == null || classB == null) {
            return Collections.emptySet();
        }
        if (classA.equals(classB)) {
            return excluded.contains(classA) ? Collections.emptySet() : Collections.singleton(classA);
        }
        Set<Class<?>> allA = ClassUtilities.getClassHierarchyInfo(classA).getAllSupertypes();
        Set<Class<?>> allB = ClassUtilities.getClassHierarchyInfo(classB).getAllSupertypes();
        LinkedHashSet common = new LinkedHashSet();
        for (Class<?> type : allA) {
            if (!allB.contains(type) || excluded.contains(type)) continue;
            common.add(type);
        }
        if (common.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList candidates = new ArrayList(common);
        candidates.sort((x, y) -> {
            int dx = ClassUtilities.getClassHierarchyInfo(x).getDepth();
            int dy = ClassUtilities.getClassHierarchyInfo(y).getDepth();
            return Integer.compare(dy, dx);
        });
        LinkedHashSet lowest = new LinkedHashSet();
        HashSet unionOfAncestors = new HashSet();
        for (Class type : candidates) {
            if (unionOfAncestors.contains(type)) continue;
            lowest.add(type);
            unionOfAncestors.addAll(ClassUtilities.getClassHierarchyInfo(type).getAllSupertypes());
        }
        return lowest;
    }

    public static Set<Class<?>> findLowestCommonSupertypes(Class<?> classA, Class<?> classB) {
        return ClassUtilities.findLowestCommonSupertypesExcluding(classA, classB, CollectionUtilities.setOf(Object.class, Serializable.class, Externalizable.class, Cloneable.class));
    }

    public static Class<?> findLowestCommonSupertype(Class<?> classA, Class<?> classB) {
        Set<Class<?>> all = ClassUtilities.findLowestCommonSupertypes(classA, classB);
        return all.isEmpty() ? null : all.iterator().next();
    }

    public static ClassHierarchyInfo getClassHierarchyInfo(Class<?> clazz) {
        return CLASS_HIERARCHY_CACHE.computeIfAbsent(clazz, key -> {
            LinkedHashSet<Class> allSupertypes = new LinkedHashSet<Class>();
            HashMap distanceMap = new HashMap();
            ArrayDeque queue = new ArrayDeque();
            queue.add((Class<?>)key);
            distanceMap.put((Class<?>)key, 0);
            while (!queue.isEmpty()) {
                Class current = (Class)queue.poll();
                int currentDistance = (Integer)distanceMap.get(current);
                if (current == null || !allSupertypes.add(current)) continue;
                Class superclass = current.getSuperclass();
                if (superclass != null && !distanceMap.containsKey(superclass)) {
                    distanceMap.put(superclass, currentDistance + 1);
                    queue.add(superclass);
                }
                for (Class<?> iface : current.getInterfaces()) {
                    if (distanceMap.containsKey(iface)) continue;
                    distanceMap.put(iface, currentDistance + 1);
                    queue.add(iface);
                }
            }
            return new ClassHierarchyInfo(Collections.unmodifiableSet(allSupertypes), Collections.unmodifiableMap(distanceMap), (Class<?>)key);
        });
    }

    public static boolean haveCommonAncestor(Class<?> a, Class<?> b) {
        return !ClassUtilities.findLowestCommonSupertypes(a, b).isEmpty();
    }

    private static boolean isEnhancedSecurityEnabled() {
        String enabled = System.getProperty("classutilities.enhanced.security.enabled");
        return "true".equalsIgnoreCase(enabled);
    }

    private static int getMaxClassLoadDepth() {
        if (!ClassUtilities.isEnhancedSecurityEnabled()) {
            return 0;
        }
        String maxDepthProp = System.getProperty("classutilities.max.class.load.depth");
        if (maxDepthProp != null) {
            try {
                int value = Integer.parseInt(maxDepthProp);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 100;
    }

    private static int getMaxConstructorArgs() {
        if (!ClassUtilities.isEnhancedSecurityEnabled()) {
            return 0;
        }
        String maxArgsProp = System.getProperty("classutilities.max.constructor.args");
        if (maxArgsProp != null) {
            try {
                int value = Integer.parseInt(maxArgsProp);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 50;
    }

    private static int getMaxReflectionOperations() {
        if (!ClassUtilities.isEnhancedSecurityEnabled()) {
            return 0;
        }
        String maxOpsProp = System.getProperty("classutilities.max.reflection.operations");
        if (maxOpsProp != null) {
            try {
                int value = Integer.parseInt(maxOpsProp);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1000;
    }

    private static int getMaxResourceNameLength() {
        if (!ClassUtilities.isEnhancedSecurityEnabled()) {
            return 1000;
        }
        String maxLengthProp = System.getProperty("classutilities.max.resource.name.length");
        if (maxLengthProp != null) {
            try {
                int value = Integer.parseInt(maxLengthProp);
                return Math.max(100, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1000;
    }

    private static void validateEnhancedSecurity(String operation, int currentCount, int maxAllowed) {
        if (!ClassUtilities.isEnhancedSecurityEnabled() || maxAllowed <= 0) {
            return;
        }
        if (currentCount > maxAllowed) {
            throw new SecurityException(operation + " count exceeded limit: " + currentCount + " > " + maxAllowed);
        }
    }

    static {
        LoggingConfig.init();
        nameToClass = new LRUCache(5000);
        PRIMITIVE_TO_WRAPPER = new ClassValueMap();
        WRAPPER_TO_PRIMITIVE = new ClassValueMap();
        osgiClassLoaders = new ClassValueMap<ClassLoader>();
        SYSTEM_LOADER = ClassLoader.getSystemClassLoader();
        useUnsafe = false;
        CLASS_LOAD_DEPTH = ThreadLocal.withInitial(() -> 0);
        DIRECT_CLASS_MAPPING = new ClassValueMap<Supplier<Object>>();
        ASSIGNABLE_CLASS_MAPPING = new ClassValueMap<Supplier<Object>>();
        ENUM_CLASS_CACHE = new ClassValue<Class<?>>(){

            @Override
            protected Class<?> computeValue(Class<?> type) {
                return ClassUtilities.computeEnum(type);
            }
        };
        SUCCESSFUL_CONSTRUCTOR_CACHE = new ClassValueMap();
        CLASS_HIERARCHY_CACHE = new ClassValueMap<ClassHierarchyInfo>();
        DIRECT_CLASS_MAPPING.put(Date.class, Date::new);
        DIRECT_CLASS_MAPPING.put(StringBuilder.class, StringBuilder::new);
        DIRECT_CLASS_MAPPING.put(StringBuffer.class, StringBuffer::new);
        DIRECT_CLASS_MAPPING.put(Locale.class, Locale::getDefault);
        DIRECT_CLASS_MAPPING.put(TimeZone.class, TimeZone::getDefault);
        DIRECT_CLASS_MAPPING.put(Timestamp.class, () -> new Timestamp(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(java.sql.Date.class, () -> new java.sql.Date(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(LocalDate.class, LocalDate::now);
        DIRECT_CLASS_MAPPING.put(LocalDateTime.class, LocalDateTime::now);
        DIRECT_CLASS_MAPPING.put(OffsetDateTime.class, OffsetDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZonedDateTime.class, ZonedDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZoneId.class, ZoneId::systemDefault);
        DIRECT_CLASS_MAPPING.put(AtomicBoolean.class, AtomicBoolean::new);
        DIRECT_CLASS_MAPPING.put(AtomicInteger.class, AtomicInteger::new);
        DIRECT_CLASS_MAPPING.put(AtomicLong.class, AtomicLong::new);
        DIRECT_CLASS_MAPPING.put(URL.class, () -> ExceptionUtilities.safelyIgnoreException(() -> new URL("http://localhost"), null));
        DIRECT_CLASS_MAPPING.put(URI.class, () -> ExceptionUtilities.safelyIgnoreException(() -> new URI("http://localhost"), null));
        DIRECT_CLASS_MAPPING.put(Object.class, Object::new);
        DIRECT_CLASS_MAPPING.put(String.class, () -> "");
        DIRECT_CLASS_MAPPING.put(BigInteger.class, () -> BigInteger.ZERO);
        DIRECT_CLASS_MAPPING.put(BigDecimal.class, () -> BigDecimal.ZERO);
        DIRECT_CLASS_MAPPING.put(Class.class, () -> String.class);
        DIRECT_CLASS_MAPPING.put(Calendar.class, Calendar::getInstance);
        DIRECT_CLASS_MAPPING.put(Instant.class, Instant::now);
        DIRECT_CLASS_MAPPING.put(Duration.class, () -> Duration.ofSeconds(10L));
        DIRECT_CLASS_MAPPING.put(Period.class, () -> Period.ofDays(0));
        DIRECT_CLASS_MAPPING.put(Year.class, Year::now);
        DIRECT_CLASS_MAPPING.put(YearMonth.class, YearMonth::now);
        DIRECT_CLASS_MAPPING.put(MonthDay.class, MonthDay::now);
        DIRECT_CLASS_MAPPING.put(ZoneOffset.class, () -> ZoneOffset.UTC);
        DIRECT_CLASS_MAPPING.put(OffsetTime.class, OffsetTime::now);
        DIRECT_CLASS_MAPPING.put(LocalTime.class, LocalTime::now);
        DIRECT_CLASS_MAPPING.put(ByteBuffer.class, () -> ByteBuffer.allocate(0));
        DIRECT_CLASS_MAPPING.put(CharBuffer.class, () -> CharBuffer.allocate(0));
        DIRECT_CLASS_MAPPING.put(HashSet.class, HashSet::new);
        DIRECT_CLASS_MAPPING.put(TreeSet.class, TreeSet::new);
        DIRECT_CLASS_MAPPING.put(HashMap.class, HashMap::new);
        DIRECT_CLASS_MAPPING.put(TreeMap.class, TreeMap::new);
        DIRECT_CLASS_MAPPING.put(Hashtable.class, Hashtable::new);
        DIRECT_CLASS_MAPPING.put(ArrayList.class, ArrayList::new);
        DIRECT_CLASS_MAPPING.put(LinkedList.class, LinkedList::new);
        DIRECT_CLASS_MAPPING.put(Vector.class, Vector::new);
        DIRECT_CLASS_MAPPING.put(Stack.class, Stack::new);
        DIRECT_CLASS_MAPPING.put(Properties.class, Properties::new);
        DIRECT_CLASS_MAPPING.put(ConcurrentHashMap.class, ConcurrentHashMap::new);
        DIRECT_CLASS_MAPPING.put(LinkedHashMap.class, LinkedHashMap::new);
        DIRECT_CLASS_MAPPING.put(LinkedHashSet.class, LinkedHashSet::new);
        DIRECT_CLASS_MAPPING.put(ArrayDeque.class, ArrayDeque::new);
        DIRECT_CLASS_MAPPING.put(PriorityQueue.class, PriorityQueue::new);
        DIRECT_CLASS_MAPPING.put(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new);
        DIRECT_CLASS_MAPPING.put(CopyOnWriteArraySet.class, CopyOnWriteArraySet::new);
        DIRECT_CLASS_MAPPING.put(LinkedBlockingQueue.class, LinkedBlockingQueue::new);
        DIRECT_CLASS_MAPPING.put(LinkedBlockingDeque.class, LinkedBlockingDeque::new);
        DIRECT_CLASS_MAPPING.put(ConcurrentSkipListMap.class, ConcurrentSkipListMap::new);
        DIRECT_CLASS_MAPPING.put(ConcurrentSkipListSet.class, ConcurrentSkipListSet::new);
        DIRECT_CLASS_MAPPING.put(WeakHashMap.class, WeakHashMap::new);
        DIRECT_CLASS_MAPPING.put(IdentityHashMap.class, IdentityHashMap::new);
        DIRECT_CLASS_MAPPING.put(EnumMap.class, () -> new EnumMap(TimeUnit.class));
        DIRECT_CLASS_MAPPING.put(UUID.class, UUID::randomUUID);
        DIRECT_CLASS_MAPPING.put(Currency.class, () -> Currency.getInstance(Locale.getDefault()));
        DIRECT_CLASS_MAPPING.put(Pattern.class, () -> Pattern.compile(".*"));
        DIRECT_CLASS_MAPPING.put(BitSet.class, BitSet::new);
        DIRECT_CLASS_MAPPING.put(StringJoiner.class, () -> new StringJoiner(","));
        DIRECT_CLASS_MAPPING.put(Optional.class, Optional::empty);
        DIRECT_CLASS_MAPPING.put(OptionalInt.class, OptionalInt::empty);
        DIRECT_CLASS_MAPPING.put(OptionalLong.class, OptionalLong::empty);
        DIRECT_CLASS_MAPPING.put(OptionalDouble.class, OptionalDouble::empty);
        DIRECT_CLASS_MAPPING.put(Stream.class, Stream::empty);
        DIRECT_CLASS_MAPPING.put(IntStream.class, IntStream::empty);
        DIRECT_CLASS_MAPPING.put(LongStream.class, LongStream::empty);
        DIRECT_CLASS_MAPPING.put(DoubleStream.class, DoubleStream::empty);
        DIRECT_CLASS_MAPPING.put(boolean[].class, () -> new boolean[0]);
        DIRECT_CLASS_MAPPING.put(byte[].class, () -> new byte[0]);
        DIRECT_CLASS_MAPPING.put(short[].class, () -> new short[0]);
        DIRECT_CLASS_MAPPING.put(int[].class, () -> new int[0]);
        DIRECT_CLASS_MAPPING.put(long[].class, () -> new long[0]);
        DIRECT_CLASS_MAPPING.put(float[].class, () -> new float[0]);
        DIRECT_CLASS_MAPPING.put(double[].class, () -> new double[0]);
        DIRECT_CLASS_MAPPING.put(char[].class, () -> new char[0]);
        DIRECT_CLASS_MAPPING.put(Object[].class, () -> ArrayUtilities.EMPTY_OBJECT_ARRAY);
        DIRECT_CLASS_MAPPING.put(Boolean[].class, () -> new Boolean[0]);
        DIRECT_CLASS_MAPPING.put(Byte[].class, () -> new Byte[0]);
        DIRECT_CLASS_MAPPING.put(Short[].class, () -> new Short[0]);
        DIRECT_CLASS_MAPPING.put(Integer[].class, () -> new Integer[0]);
        DIRECT_CLASS_MAPPING.put(Long[].class, () -> new Long[0]);
        DIRECT_CLASS_MAPPING.put(Float[].class, () -> new Float[0]);
        DIRECT_CLASS_MAPPING.put(Double[].class, () -> new Double[0]);
        DIRECT_CLASS_MAPPING.put(Character[].class, () -> new Character[0]);
        ASSIGNABLE_CLASS_MAPPING.put(EnumSet.class, () -> null);
        ASSIGNABLE_CLASS_MAPPING.put(BlockingDeque.class, LinkedBlockingDeque::new);
        ASSIGNABLE_CLASS_MAPPING.put(Deque.class, ArrayDeque::new);
        ASSIGNABLE_CLASS_MAPPING.put(BlockingQueue.class, LinkedBlockingQueue::new);
        ASSIGNABLE_CLASS_MAPPING.put(Queue.class, LinkedList::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(Set.class, LinkedHashSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(ConcurrentMap.class, ConcurrentHashMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Map.class, LinkedHashMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(List.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(Collection.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(ListIterator.class, () -> new ArrayList().listIterator());
        ASSIGNABLE_CLASS_MAPPING.put(Iterator.class, Collections::emptyIterator);
        ASSIGNABLE_CLASS_MAPPING.put(Enumeration.class, Collections::emptyEnumeration);
        ASSIGNABLE_CLASS_MAPPING.put(RandomAccess.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(CharSequence.class, StringBuilder::new);
        ASSIGNABLE_CLASS_MAPPING.put(Comparable.class, () -> "");
        ASSIGNABLE_CLASS_MAPPING.put(Cloneable.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(AutoCloseable.class, () -> new ByteArrayInputStream(new byte[0]));
        ASSIGNABLE_CLASS_MAPPING.put(Iterable.class, ArrayList::new);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("string", String.class);
        nameToClass.put("date", Date.class);
        nameToClass.put("class", Class.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Void.TYPE, Void.class);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Void.class, Void.TYPE);
        ClassValueMap map = new ClassValueMap();
        map.putAll(PRIMITIVE_TO_WRAPPER);
        map.putAll(WRAPPER_TO_PRIMITIVE);
        wrapperMap = Collections.unmodifiableMap(map);
        ARG_PATTERN = Pattern.compile("arg\\d+");
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.reflect.InaccessibleObjectException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INACCESSIBLE_OBJECT_EXCEPTION_CLASS = clazz;
        BLOCKED_CLASSES = new ClassValueSet();
        BLOCKED_CLASS_NAMES_SET = new HashSet<String>(SecurityChecker.SECURITY_BLOCKED_CLASS_NAMES);
        INHERITS_FROM_BLOCKED = new ClassValueSet();
        VERIFIED_SAFE_CLASSES = new ClassValueSet();
        for (Class<?> blockedClass : SecurityChecker.SECURITY_BLOCKED_CLASSES.toSet()) {
            BLOCKED_CLASSES.add(blockedClass);
        }
        SECURITY_CHECK_CACHE = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> type) {
                if (BLOCKED_CLASSES.contains(type)) {
                    return Boolean.TRUE;
                }
                if (BLOCKED_CLASS_NAMES_SET.contains(type.getName())) {
                    return Boolean.TRUE;
                }
                if (INHERITS_FROM_BLOCKED.contains(type)) {
                    return Boolean.TRUE;
                }
                if (VERIFIED_SAFE_CLASSES.contains(type)) {
                    return Boolean.FALSE;
                }
                for (Class<?> superType : ClassUtilities.getClassHierarchyInfo(type).getAllSupertypes()) {
                    if (!BLOCKED_CLASSES.contains(superType)) continue;
                    INHERITS_FROM_BLOCKED.add(type);
                    return Boolean.TRUE;
                }
                VERIFIED_SAFE_CLASSES.add(type);
                return Boolean.FALSE;
            }
        };
    }

    public static class ClassHierarchyInfo {
        private final Set<Class<?>> allSupertypes;
        private final Map<Class<?>, Integer> distanceMap;
        private final int depth;

        ClassHierarchyInfo(Set<Class<?>> supertypes, Map<Class<?>, Integer> distances, Class<?> sourceClass) {
            this.allSupertypes = Collections.unmodifiableSet(supertypes);
            this.distanceMap = Collections.unmodifiableMap(distances);
            int maxDepth = 0;
            Class<?> current = sourceClass;
            while (current != null) {
                current = current.getSuperclass();
                ++maxDepth;
            }
            this.depth = maxDepth - 1;
        }

        public Map<Class<?>, Integer> getDistanceMap() {
            return this.distanceMap;
        }

        Set<Class<?>> getAllSupertypes() {
            return this.allSupertypes;
        }

        int getDistance(Class<?> type) {
            return this.distanceMap.getOrDefault(type, -1);
        }

        public int getDepth() {
            return this.depth;
        }
    }

    public static class SecurityChecker {
        static final ClassValueSet SECURITY_BLOCKED_CLASSES = ClassValueSet.of(ClassLoader.class, ProcessBuilder.class, Process.class, Constructor.class, Method.class, Field.class, Runtime.class, System.class);
        static final Set<String> SECURITY_BLOCKED_CLASS_NAMES = new HashSet<String>(CollectionUtilities.listOf("java.lang.ProcessImpl", "java.lang.Runtime", "java.lang.ProcessBuilder", "java.lang.System", "javax.script.ScriptEngineManager", "javax.script.ScriptEngine"));

        public static boolean isSecurityBlocked(Class<?> clazz) {
            return (Boolean)SECURITY_CHECK_CACHE.get(clazz);
        }

        public static boolean isSecurityBlockedName(String className) {
            return BLOCKED_CLASS_NAMES_SET.contains(className);
        }

        public static void verifyClass(Class<?> clazz) {
            if (SecurityChecker.isSecurityBlocked(clazz)) {
                throw new SecurityException("For security reasons, access to this class is not allowed: " + clazz.getName());
            }
        }
    }
}

