/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.LRUCache;
import com.cedarsoftware.util.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class ReflectionUtils {
    private static final int CACHE_SIZE = 1500;
    private static volatile Map<ConstructorCacheKey, Constructor<?>> CONSTRUCTOR_CACHE = new LRUCache(1500);
    private static volatile Map<MethodCacheKey, Method> METHOD_CACHE = new LRUCache<MethodCacheKey, Method>(1500);
    private static volatile Map<FieldsCacheKey, Collection<Field>> FIELDS_CACHE = new LRUCache<FieldsCacheKey, Collection<Field>>(1500);
    private static volatile Map<FieldNameCacheKey, Field> FIELD_NAME_CACHE = new LRUCache<FieldNameCacheKey, Field>(15000);
    private static volatile Map<ClassAnnotationCacheKey, Annotation> CLASS_ANNOTATION_CACHE = new LRUCache<ClassAnnotationCacheKey, Annotation>(1500);
    private static volatile Map<MethodAnnotationCacheKey, Annotation> METHOD_ANNOTATION_CACHE = new LRUCache<MethodAnnotationCacheKey, Annotation>(1500);
    private static final Predicate<Field> DEFAULT_FIELD_FILTER = field -> {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        String fieldName = field.getName();
        Class<Enum> declaringClass = field.getDeclaringClass();
        if (declaringClass.isEnum() && ("internal".equals(fieldName) || "ENUM$VALUES".equals(fieldName))) {
            return false;
        }
        if ("metaClass".equals(fieldName) && "groovy.lang.MetaClass".equals(field.getType().getName())) {
            return false;
        }
        return !declaringClass.isAssignableFrom(Enum.class) || !"hash".equals(fieldName) && !"ordinal".equals(fieldName);
    };
    private static final int CONSTANT_UTF8 = 1;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACEMETHODREF = 11;
    private static final int CONSTANT_NAMEANDTYPE = 12;
    private static final int CONSTANT_METHODHANDLE = 15;
    private static final int CONSTANT_METHODTYPE = 16;
    private static final int CONSTANT_DYNAMIC = 17;
    private static final int CONSTANT_INVOKEDYNAMIC = 18;
    private static final int CONSTANT_MODULE = 19;
    private static final int CONSTANT_PACKAGE = 20;

    public static void setMethodCache(Map<Object, Method> cache) {
        METHOD_CACHE = cache;
    }

    public static void setClassFieldsCache(Map<Object, Collection<Field>> cache) {
        FIELDS_CACHE = cache;
    }

    public static void setFieldCache(Map<Object, Field> cache) {
        FIELD_NAME_CACHE = cache;
    }

    public static void setClassAnnotationCache(Map<Object, Annotation> cache) {
        CLASS_ANNOTATION_CACHE = cache;
    }

    public static void setMethodAnnotationCache(Map<Object, Annotation> cache) {
        METHOD_ANNOTATION_CACHE = cache;
    }

    public static void setConstructorCache(Map<Object, Constructor<?>> cache) {
        CONSTRUCTOR_CACHE = cache;
    }

    private ReflectionUtils() {
    }

    public static <T extends Annotation> T getClassAnnotation(Class<?> classToCheck, Class<T> annoClass) {
        if (classToCheck == null) {
            return null;
        }
        Convention.throwIfNull(annoClass, "annotation class cannot be null");
        ClassAnnotationCacheKey key = new ClassAnnotationCacheKey(classToCheck, annoClass);
        Annotation annotation = CLASS_ANNOTATION_CACHE.computeIfAbsent(key, k -> ReflectionUtils.findClassAnnotation(classToCheck, annoClass));
        return (T)annotation;
    }

    private static <T extends Annotation> T findClassAnnotation(Class<?> classToCheck, Class<T> annoClass) {
        HashSet<Class> visited = new HashSet<Class>();
        LinkedList stack = new LinkedList();
        stack.add(classToCheck);
        while (!stack.isEmpty()) {
            Class classToChk = (Class)stack.pop();
            if (classToChk == null || visited.contains(classToChk)) continue;
            visited.add(classToChk);
            T a = classToChk.getAnnotation(annoClass);
            if (a != null) {
                return a;
            }
            stack.push(classToChk.getSuperclass());
            ReflectionUtils.addInterfaces(classToChk, stack);
        }
        return null;
    }

    private static void addInterfaces(Class<?> classToCheck, LinkedList<Class<?>> stack) {
        for (Class<?> interFace : classToCheck.getInterfaces()) {
            stack.push(interFace);
        }
    }

    public static <T extends Annotation> T getMethodAnnotation(Method method, Class<T> annoClass) {
        Convention.throwIfNull(method, "method cannot be null");
        Convention.throwIfNull(annoClass, "annotation class cannot be null");
        MethodAnnotationCacheKey key = new MethodAnnotationCacheKey(method, annoClass);
        Annotation annotation = METHOD_ANNOTATION_CACHE.computeIfAbsent(key, k -> {
            for (Class<?> currentClass = method.getDeclaringClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                try {
                    Method currentMethod = currentClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    Object found = currentMethod.getAnnotation(annoClass);
                    if (found == null) continue;
                    return found;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Class<?> iface : method.getDeclaringClass().getInterfaces()) {
                try {
                    Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                    Object found = ifaceMethod.getAnnotation(annoClass);
                    if (found == null) continue;
                    return found;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        });
        return (T)annotation;
    }

    public static Field getField(Class<?> c, String fieldName) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldName, "fieldName cannot be null");
        FieldNameCacheKey key = new FieldNameCacheKey(c, fieldName);
        return FIELD_NAME_CACHE.computeIfAbsent(key, k -> {
            List<Field> fields = ReflectionUtils.getAllDeclaredFields(c);
            for (Field field : fields) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
            return null;
        });
    }

    public static List<Field> getDeclaredFields(Class<?> c, Predicate<Field> fieldFilter) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldFilter, "fieldFilter cannot be null");
        FieldsCacheKey key = new FieldsCacheKey(c, fieldFilter, false);
        Collection cachedFields = FIELDS_CACHE.computeIfAbsent(key, k -> {
            Field[] declared = c.getDeclaredFields();
            ArrayList<Field> filteredList = new ArrayList<Field>(declared.length);
            for (Field field : declared) {
                if (!fieldFilter.test(field)) continue;
                if (!Modifier.isPublic(field.getModifiers())) {
                    try {
                        field.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                filteredList.add(field);
            }
            return Collections.unmodifiableList(filteredList);
        });
        return (List)cachedFields;
    }

    public static List<Field> getDeclaredFields(Class<?> c) {
        return ReflectionUtils.getDeclaredFields(c, DEFAULT_FIELD_FILTER);
    }

    public static List<Field> getAllDeclaredFields(Class<?> c, Predicate<Field> fieldFilter) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldFilter, "fieldFilter cannot be null");
        FieldsCacheKey key = new FieldsCacheKey(c, fieldFilter, true);
        Collection cached = FIELDS_CACHE.computeIfAbsent(key, k -> {
            ArrayList<Field> allFields = new ArrayList<Field>();
            for (Class current = c; current != null; current = current.getSuperclass()) {
                allFields.addAll(ReflectionUtils.getDeclaredFields(current, fieldFilter));
            }
            return Collections.unmodifiableList(allFields);
        });
        return (List)cached;
    }

    public static List<Field> getAllDeclaredFields(Class<?> c) {
        return ReflectionUtils.getAllDeclaredFields(c, DEFAULT_FIELD_FILTER);
    }

    public static Map<String, Field> getAllDeclaredFieldsMap(Class<?> c, Predicate<Field> fieldFilter) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldFilter, "fieldFilter cannot be null");
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(c, fieldFilter);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldMap.containsKey(fieldName)) {
                fieldMap.put(field.getDeclaringClass().getName() + '.' + fieldName, field);
                continue;
            }
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }

    public static Map<String, Field> getAllDeclaredFieldsMap(Class<?> c) {
        return ReflectionUtils.getAllDeclaredFieldsMap(c, DEFAULT_FIELD_FILTER);
    }

    @Deprecated
    public static Collection<Field> getDeepDeclaredFields(Class<?> c) {
        Convention.throwIfNull(c, "Class cannot be null");
        Predicate<Field> legacyFilter = field -> DEFAULT_FIELD_FILTER.test((Field)field) && !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic();
        return ReflectionUtils.getAllDeclaredFields(c, legacyFilter);
    }

    @Deprecated
    public static Map<String, Field> getDeepDeclaredFieldMap(Class<?> c) {
        Convention.throwIfNull(c, "class cannot be null");
        Predicate<Field> legacyFilter = field -> DEFAULT_FIELD_FILTER.test((Field)field) && !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic();
        return ReflectionUtils.getAllDeclaredFieldsMap(c, legacyFilter);
    }

    @Deprecated
    public static void getDeclaredFields(Class<?> c, Collection<Field> fields) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fields, "fields collection cannot be null");
        try {
            Predicate<Field> legacyFilter = field -> DEFAULT_FIELD_FILTER.test((Field)field) && !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic();
            List<Field> filteredFields = ReflectionUtils.getDeclaredFields(c, legacyFilter);
            fields.addAll(filteredFields);
        }
        catch (Throwable t) {
            ExceptionUtilities.safelyIgnoreException(t);
        }
    }

    public static Object call(Object instance, Method method, Object ... args) {
        if (method == null) {
            String className = instance == null ? "null instance" : instance.getClass().getName();
            throw new IllegalArgumentException("null Method passed to ReflectionUtils.call() on instance of type: " + className);
        }
        if (instance == null) {
            throw new IllegalArgumentException("Cannot call [" + method.getName() + "()] on a null object.");
        }
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException occurred attempting to reflectively call method: " + method.getName() + "()", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception thrown inside reflectively called method: " + method.getName() + "()", e.getTargetException());
        }
    }

    public static Object call(Object instance, String methodName, Object ... args) {
        Method method = ReflectionUtils.getMethod(instance, methodName, args.length);
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException occurred attempting to reflectively call method: " + method.getName() + "()", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception thrown inside reflectively called method: " + method.getName() + "()", e.getTargetException());
        }
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... types) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(methodName, "methodName cannot be null");
        MethodCacheKey key = new MethodCacheKey(c, methodName, types);
        return METHOD_CACHE.computeIfAbsent(key, k -> {
            Method method = null;
            for (Class current = c; current != null && method == null; current = current.getSuperclass()) {
                try {
                    method = current.getDeclaredMethod(methodName, types);
                    if (Modifier.isPublic(method.getModifiers())) continue;
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {}
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return method;
        });
    }

    public static Method getMethod(Object instance, String methodName, int argCount) {
        Convention.throwIfNull(instance, "Object instance cannot be null");
        Convention.throwIfNull(methodName, "Method name cannot be null");
        if (argCount < 0) {
            throw new IllegalArgumentException("Argument count cannot be negative");
        }
        Class<?> beanClass = instance.getClass();
        Object[] types = new Class[argCount];
        Arrays.fill(types, Object.class);
        MethodCacheKey key = new MethodCacheKey(beanClass, methodName, (Class<?>[])types);
        Method cached = METHOD_CACHE.get(key);
        if (cached != null || METHOD_CACHE.containsKey(key)) {
            return cached;
        }
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Class<?> current = beanClass; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterCount() != argCount) continue;
                candidates.add(method);
            }
        }
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException(String.format("Method '%s' with %d parameters not found in %s or its superclasses", methodName, argCount, beanClass.getName()));
        }
        Method selected = ReflectionUtils.selectMethod(candidates);
        if (!selected.isAccessible()) {
            try {
                selected.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        METHOD_CACHE.put(key, selected);
        return selected;
    }

    private static Method selectMethod(List<Method> candidates) {
        return candidates.stream().min((m1, m2) -> {
            if (m1.isSynthetic() != m2.isSynthetic()) {
                return m1.isSynthetic() ? 1 : -1;
            }
            if (m1.isBridge() != m2.isBridge()) {
                return m1.isBridge() ? 1 : -1;
            }
            int accessDiff = ReflectionUtils.getAccessibilityScore(m2.getModifiers()) - ReflectionUtils.getAccessibilityScore(m1.getModifiers());
            if (accessDiff != 0) {
                return accessDiff;
            }
            if (m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass())) {
                return 1;
            }
            if (m2.getDeclaringClass().isAssignableFrom(m1.getDeclaringClass())) {
                return -1;
            }
            return 0;
        }).orElse(candidates.get(0));
    }

    private static int getAccessibilityScore(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return 4;
        }
        if (Modifier.isProtected(modifiers)) {
            return 3;
        }
        if (Modifier.isPrivate(modifiers)) {
            return 1;
        }
        return 2;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        Convention.throwIfNull(clazz, "class cannot be null");
        ConstructorCacheKey key = new ConstructorCacheKey(clazz, parameterTypes);
        return CONSTRUCTOR_CACHE.computeIfAbsent(key, k -> {
            try {
                Constructor ctor = clazz.getDeclaredConstructor(parameterTypes);
                if (!Modifier.isPublic(ctor.getModifiers())) {
                    try {
                        ctor.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return ctor;
            }
            catch (Exception ignored) {
                return null;
            }
        });
    }

    public static Constructor<?>[] getAllConstructors(Class<?> clazz) {
        if (clazz == null) {
            return new Constructor[0];
        }
        Constructor<?>[] declared = clazz.getDeclaredConstructors();
        if (declared.length == 0) {
            return declared;
        }
        for (int i = 0; i < declared.length; ++i) {
            Constructor cached;
            Constructor<?> ctor = declared[i];
            Class<?>[] paramTypes = ctor.getParameterTypes();
            ConstructorCacheKey key = new ConstructorCacheKey(clazz, paramTypes);
            declared[i] = cached = CONSTRUCTOR_CACHE.computeIfAbsent(key, k -> {
                if (!Modifier.isPublic(ctor.getModifiers())) {
                    try {
                        ctor.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return ctor;
            });
        }
        return declared;
    }

    private static String makeParamKey(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(":");
        Iterator i = Arrays.stream(parameterTypes).iterator();
        while (i.hasNext()) {
            Class param = (Class)i.next();
            builder.append(param.getSimpleName());
            if (!i.hasNext()) continue;
            builder.append('|');
        }
        return builder.toString();
    }

    public static Method getNonOverloadedMethod(Class<?> clazz, String methodName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Attempted to call getMethod() [" + methodName + "()] on a null class.");
        }
        if (StringUtilities.isEmpty(methodName)) {
            throw new IllegalArgumentException("Attempted to call getMethod() with a null or blank method name on class: " + clazz.getName());
        }
        MethodCacheKey key = new MethodCacheKey(clazz, methodName, new Class[0]);
        return METHOD_CACHE.computeIfAbsent(key, k -> {
            Method foundMethod = null;
            for (Method m : clazz.getMethods()) {
                if (!methodName.equals(m.getName())) continue;
                if (foundMethod != null) {
                    throw new IllegalArgumentException("Method: " + methodName + "() called on a class with overloaded methods - ambiguous as to which one to return. Use getMethod() with argument types or argument count.");
                }
                foundMethod = m;
            }
            if (foundMethod == null) {
                throw new IllegalArgumentException("Method: " + methodName + "() is not found on class: " + clazz.getName() + ". Perhaps the method is protected, private, or misspelled?");
            }
            return foundMethod;
        });
    }

    public static String getClassName(Object o) {
        return o == null ? "null" : o.getClass().getName();
    }

    public static String getClassNameFromByteCode(byte[] byteCode) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(byteCode);){
            String string;
            try (DataInputStream dis = new DataInputStream(is);){
                dis.readInt();
                dis.readShort();
                dis.readShort();
                int cpcnt = (dis.readShort() & 0xFFFF) - 1;
                int[] classes = new int[cpcnt];
                String[] strings = new String[cpcnt];
                block23: for (int i = 0; i < cpcnt; ++i) {
                    int t = dis.read();
                    switch (t) {
                        case 1: {
                            strings[i] = dis.readUTF();
                            continue block23;
                        }
                        case 3: 
                        case 4: {
                            dis.readInt();
                            continue block23;
                        }
                        case 5: 
                        case 6: {
                            dis.readInt();
                            dis.readInt();
                            ++i;
                            continue block23;
                        }
                        case 7: {
                            classes[i] = dis.readShort() & 0xFFFF;
                            continue block23;
                        }
                        case 8: {
                            dis.readShort();
                            continue block23;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            dis.readShort();
                            dis.readShort();
                            continue block23;
                        }
                        case 12: {
                            dis.readShort();
                            dis.readShort();
                            continue block23;
                        }
                        case 15: {
                            dis.readByte();
                            dis.readShort();
                            continue block23;
                        }
                        case 16: {
                            dis.readShort();
                            continue block23;
                        }
                        case 17: 
                        case 18: {
                            dis.readShort();
                            dis.readShort();
                            continue block23;
                        }
                        case 19: 
                        case 20: {
                            dis.readShort();
                            continue block23;
                        }
                        default: {
                            throw new IllegalStateException("Unrecognized constant pool tag: " + t);
                        }
                    }
                }
                dis.readShort();
                int thisClassIndex = dis.readShort() & 0xFFFF;
                int stringIndex = classes[thisClassIndex - 1];
                String className = strings[stringIndex - 1];
                string = className.replace('/', '.');
            }
            return string;
        }
    }

    private static String getClassLoaderName(Class<?> c) {
        ClassLoader loader = c.getClassLoader();
        if (loader == null) {
            return "bootstrap";
        }
        return loader.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(loader));
    }

    private static final class ClassAnnotationCacheKey {
        private final String classLoaderName;
        private final String className;
        private final String annotationClassName;
        private final int hash;

        ClassAnnotationCacheKey(Class<?> clazz, Class<? extends Annotation> annotationClass) {
            this.classLoaderName = ReflectionUtils.getClassLoaderName(clazz);
            this.className = clazz.getName();
            this.annotationClassName = annotationClass.getName();
            this.hash = Objects.hash(this.classLoaderName, this.className, this.annotationClassName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassAnnotationCacheKey)) {
                return false;
            }
            ClassAnnotationCacheKey that = (ClassAnnotationCacheKey)o;
            return Objects.equals(this.classLoaderName, that.classLoaderName) && Objects.equals(this.className, that.className) && Objects.equals(this.annotationClassName, that.annotationClassName);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class MethodAnnotationCacheKey {
        private final String classLoaderName;
        private final String className;
        private final String methodName;
        private final String parameterTypes;
        private final String annotationClassName;
        private final int hash;

        MethodAnnotationCacheKey(Method method, Class<? extends Annotation> annotationClass) {
            Class<?> declaringClass = method.getDeclaringClass();
            this.classLoaderName = ReflectionUtils.getClassLoaderName(declaringClass);
            this.className = declaringClass.getName();
            this.methodName = method.getName();
            this.parameterTypes = ReflectionUtils.makeParamKey(method.getParameterTypes());
            this.annotationClassName = annotationClass.getName();
            this.hash = Objects.hash(this.classLoaderName, this.className, this.methodName, this.parameterTypes, this.annotationClassName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodAnnotationCacheKey)) {
                return false;
            }
            MethodAnnotationCacheKey that = (MethodAnnotationCacheKey)o;
            return Objects.equals(this.classLoaderName, that.classLoaderName) && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.annotationClassName, that.annotationClassName);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class FieldNameCacheKey {
        private final String classLoaderName;
        private final String className;
        private final String fieldName;
        private final int hash;

        FieldNameCacheKey(Class<?> clazz, String fieldName) {
            this.classLoaderName = ReflectionUtils.getClassLoaderName(clazz);
            this.className = clazz.getName();
            this.fieldName = fieldName;
            this.hash = Objects.hash(this.classLoaderName, this.className, fieldName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldNameCacheKey)) {
                return false;
            }
            FieldNameCacheKey that = (FieldNameCacheKey)o;
            return Objects.equals(this.classLoaderName, that.classLoaderName) && Objects.equals(this.className, that.className) && Objects.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class FieldsCacheKey {
        private final String classLoaderName;
        private final String className;
        private final Predicate<Field> predicate;
        private final boolean deep;
        private final int hash;

        FieldsCacheKey(Class<?> clazz, Predicate<Field> predicate, boolean deep) {
            this.classLoaderName = ReflectionUtils.getClassLoaderName(clazz);
            this.className = clazz.getName();
            this.predicate = predicate;
            this.deep = deep;
            this.hash = Objects.hash(this.classLoaderName, this.className, deep, System.identityHashCode(predicate));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldsCacheKey)) {
                return false;
            }
            FieldsCacheKey other = (FieldsCacheKey)o;
            return this.deep == other.deep && Objects.equals(this.classLoaderName, other.classLoaderName) && Objects.equals(this.className, other.className) && this.predicate == other.predicate;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class MethodCacheKey {
        private final String classLoaderName;
        private final String className;
        private final String methodName;
        private final String parameterTypes;
        private final int hash;

        public MethodCacheKey(Class<?> clazz, String methodName, Class<?> ... types) {
            this.classLoaderName = ReflectionUtils.getClassLoaderName(clazz);
            this.className = clazz.getName();
            this.methodName = methodName;
            this.parameterTypes = ReflectionUtils.makeParamKey(types);
            this.hash = Objects.hash(this.classLoaderName, this.className, methodName, this.parameterTypes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCacheKey)) {
                return false;
            }
            MethodCacheKey that = (MethodCacheKey)o;
            return Objects.equals(this.classLoaderName, that.classLoaderName) && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class ConstructorCacheKey {
        private final String classLoaderName;
        private final String className;
        private final String parameterTypes;
        private final int hash;

        ConstructorCacheKey(Class<?> clazz, Class<?> ... types) {
            this.classLoaderName = ReflectionUtils.getClassLoaderName(clazz);
            this.className = clazz.getName();
            this.parameterTypes = ReflectionUtils.makeParamKey(types);
            this.hash = Objects.hash(this.classLoaderName, this.className, this.parameterTypes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConstructorCacheKey)) {
                return false;
            }
            ConstructorCacheKey that = (ConstructorCacheKey)o;
            return Objects.equals(this.classLoaderName, that.classLoaderName) && Objects.equals(this.className, that.className) && Objects.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

