/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CompactMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class CompactSet<E>
implements Set<E> {
    private static final Object PRESENT = new Object();
    private final CompactMap<E, Object> map;

    public CompactSet() {
        CompactMap defaultMap = CompactMap.builder().compactSize(this.compactSize()).caseSensitive(!this.isCaseInsensitive()).build();
        if (defaultMap.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
        this.map = defaultMap;
    }

    protected CompactSet(CompactMap<E, Object> map) {
        if (map.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
        this.map = map;
    }

    public CompactSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        return this.map.keySet().equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    @Deprecated
    protected int compactSize() {
        return 70;
    }

    @Deprecated
    protected boolean isCaseInsensitive() {
        return false;
    }

    @Deprecated
    protected Set<E> getNewSet() {
        return new LinkedHashSet(2);
    }

    public static final class Builder<E> {
        private final CompactMap.Builder<E, Object> mapBuilder = CompactMap.builder();

        private Builder() {
        }

        public Builder<E> caseSensitive(boolean caseSensitive) {
            this.mapBuilder.caseSensitive(caseSensitive);
            return this;
        }

        public Builder<E> compactSize(int size) {
            this.mapBuilder.compactSize(size);
            return this;
        }

        public Builder<E> sortedOrder() {
            this.mapBuilder.sortedOrder();
            return this;
        }

        public Builder<E> reverseOrder() {
            this.mapBuilder.reverseOrder();
            return this;
        }

        public Builder<E> insertionOrder() {
            this.mapBuilder.insertionOrder();
            return this;
        }

        public Builder<E> noOrder() {
            this.mapBuilder.noOrder();
            return this;
        }

        public CompactSet<E> build() {
            CompactMap<E, Object> builtMap = this.mapBuilder.build();
            return new CompactSet<E>(builtMap);
        }
    }
}

