/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.MapUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.TrackingMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompactMap<K, V>
implements Map<K, V> {
    private static final String EMPTY_MAP = "_\ufe3f_\u03c8_\u263c";
    public static final String COMPACT_SIZE = "compactSize";
    public static final String CASE_SENSITIVE = "caseSensitive";
    public static final String MAP_TYPE = "mapType";
    public static final String SINGLE_KEY = "singleKey";
    public static final String SOURCE_MAP = "source";
    public static final String ORDERING = "ordering";
    public static final String UNORDERED = "unordered";
    public static final String SORTED = "sorted";
    public static final String INSERTION = "insertion";
    public static final String REVERSE = "reverse";
    private static final int DEFAULT_COMPACT_SIZE = 70;
    private static final boolean DEFAULT_CASE_SENSITIVE = true;
    private static final Class<? extends Map> DEFAULT_MAP_TYPE = HashMap.class;
    private static final String DEFAULT_SINGLE_KEY = "id";
    private static final String INNER_MAP_TYPE = "innerMapType";
    private static final TemplateClassLoader templateClassLoader = new TemplateClassLoader(ClassUtilities.getClassLoader(CompactMap.class));
    private static final Map<String, ReentrantLock> CLASS_LOCKS = new ConcurrentHashMap<String, ReentrantLock>();
    protected Object val = "_\ufe3f_\u03c8_\u263c";

    public CompactMap() {
        SortedMap sortedMap;
        Comparator comparator;
        Map<K, V> map;
        if (this.compactSize() < 2) {
            throw new IllegalArgumentException("compactSize() must be >= 2");
        }
        if (this.getClass() != CompactMap.class && this.isLegacyConstructed() && (map = this.getNewMap()) instanceof SortedMap && (comparator = (sortedMap = (SortedMap)map).comparator()) == String.CASE_INSENSITIVE_ORDER && !this.isCaseInsensitive()) {
            throw new IllegalStateException("Inconsistent configuration: Map uses case-insensitive comparison but isCaseInsensitive() returns false");
        }
    }

    public CompactMap(Map<K, V> other) {
        this();
        this.putAll(other);
    }

    @Override
    public int size() {
        if (this.val instanceof Object[]) {
            return ((Object[])this.val).length >> 1;
        }
        if (this.val instanceof Map) {
            return ((Map)this.val).size();
        }
        if (this.val == EMPTY_MAP) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.val == EMPTY_MAP;
    }

    private boolean areKeysEqual(Object key, Object aKey) {
        if (key instanceof String && aKey instanceof String) {
            return this.isCaseInsensitive() ? ((String)key).equalsIgnoreCase((String)aKey) : key.equals(aKey);
        }
        return Objects.equals(key, aKey);
    }

    private boolean isLegacyConstructed() {
        return !this.getClass().getName().startsWith("com.cedarsoftware.util.CompactMap$");
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                if (!this.areKeysEqual(key, entries[i])) continue;
                return true;
            }
            return false;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.containsKey(key);
        }
        if (this.val == EMPTY_MAP) {
            return false;
        }
        return this.areKeysEqual(key, this.getLogicalSingleKey());
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aValue = entries[i + 1];
                if (!Objects.equals(value, aValue)) continue;
                return true;
            }
            return false;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.containsValue(value);
        }
        if (this.val == EMPTY_MAP) {
            return false;
        }
        return Objects.equals(this.getLogicalSingleValue(), value);
    }

    @Override
    public V get(Object key) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                if (!this.areKeysEqual(key, entries[i])) continue;
                return (V)entries[i + 1];
            }
            return null;
        }
        if (this.val instanceof Map) {
            return ((Map)this.val).get(key);
        }
        if (this.val == EMPTY_MAP) {
            return null;
        }
        if (this.areKeysEqual(key, this.getLogicalSingleKey())) {
            return this.getLogicalSingleValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (this.val instanceof Object[]) {
            return this.putInCompactArray((Object[])this.val, key, value);
        }
        if (this.val instanceof Map) {
            return ((Map)this.val).put(key, value);
        }
        if (this.val == EMPTY_MAP) {
            this.val = this.areKeysEqual(key, this.getSingleValueKey()) && !(value instanceof Map) && !(value instanceof Object[]) ? value : new CompactMapEntry(key, value);
            return null;
        }
        return this.handleSingleEntryPut(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.val instanceof Object[]) {
            return this.removeFromCompactArray(key);
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return this.removeFromMap(map, key);
        }
        if (this.val == EMPTY_MAP) {
            return null;
        }
        return this.handleSingleEntryRemove(key);
    }

    private V putInCompactArray(Object[] entries, K key, V value) {
        int len = entries.length;
        for (int i = 0; i < len; i += 2) {
            if (!this.areKeysEqual(key, entries[i])) continue;
            int i1 = i + 1;
            Object oldValue = entries[i1];
            entries[i1] = value;
            return (V)oldValue;
        }
        if (this.size() < this.compactSize()) {
            Object[] expand = new Object[len + 2];
            System.arraycopy(entries, 0, expand, 0, len);
            expand[len] = key;
            expand[len + 1] = value;
            this.val = expand;
        } else {
            this.switchToMap(entries, key, value);
        }
        return null;
    }

    private V removeFromCompactArray(Object key) {
        Object[] entries = (Object[])this.val;
        int pairCount = this.size();
        if (pairCount == 2) {
            return this.handleTransitionToSingleEntry(entries, key);
        }
        int len = entries.length;
        for (int i = 0; i < len; i += 2) {
            if (!this.areKeysEqual(key, entries[i])) continue;
            Object oldValue = entries[i + 1];
            Object[] shrink = new Object[len - 2];
            if (i > 0) {
                System.arraycopy(entries, 0, shrink, 0, i);
            }
            if (i + 2 < len) {
                System.arraycopy(entries, i + 2, shrink, i, len - i - 2);
            }
            this.val = shrink;
            return (V)oldValue;
        }
        return null;
    }

    private void sortCompactArray(Object[] array) {
        int pairCount = array.length / 2;
        if (pairCount <= 1) {
            return;
        }
        if (this.isLegacyConstructed()) {
            Map<K, V> mapInstance = this.getNewMap();
            if (mapInstance instanceof SortedMap) {
                SortedMap sortedMap = (SortedMap)mapInstance;
                boolean reverse = sortedMap.comparator() != null && sortedMap.comparator().getClass().getName().toLowerCase().contains("reversecomp");
                CompactMapComparator comparator = new CompactMapComparator(this.isCaseInsensitive(), reverse);
                this.quickSort(array, 0, pairCount - 1, comparator);
            }
            return;
        }
        String ordering = this.getOrdering();
        if (ordering.equals(UNORDERED) || ordering.equals(INSERTION)) {
            return;
        }
        CompactMapComparator comparator = new CompactMapComparator(this.isCaseInsensitive(), REVERSE.equals(ordering));
        this.quickSort(array, 0, pairCount - 1, comparator);
    }

    private void quickSort(Object[] array, int lowPair, int highPair, Comparator<Object> comparator) {
        if (lowPair < highPair) {
            int pivotPair = this.partition(array, lowPair, highPair, comparator);
            this.quickSort(array, lowPair, pivotPair - 1, comparator);
            this.quickSort(array, pivotPair + 1, highPair, comparator);
        }
    }

    private int partition(Object[] array, int lowPair, int highPair, Comparator<Object> comparator) {
        int low = lowPair * 2;
        int high = highPair * 2;
        int mid = low + (high - low) / 4 * 2;
        Object pivot = this.selectPivot(array, low, mid, high, comparator);
        int i = low - 2;
        for (int j = low; j < high; j += 2) {
            if (comparator.compare(array[j], pivot) > 0) continue;
            this.swapPairs(array, i += 2, j);
        }
        this.swapPairs(array, i += 2, high);
        return i / 2;
    }

    private Object selectPivot(Object[] array, int low, int mid, int high, Comparator<Object> comparator) {
        Object first = array[low];
        Object middle = array[mid];
        Object last = array[high];
        if (comparator.compare(first, middle) <= 0) {
            if (comparator.compare(middle, last) <= 0) {
                this.swapPairs(array, mid, high);
                return middle;
            }
            if (comparator.compare(first, last) <= 0) {
                return last;
            }
            this.swapPairs(array, low, high);
            return first;
        }
        if (comparator.compare(first, last) <= 0) {
            this.swapPairs(array, low, high);
            return first;
        }
        if (comparator.compare(middle, last) <= 0) {
            this.swapPairs(array, mid, high);
            return middle;
        }
        return last;
    }

    private void swapPairs(Object[] array, int i, int j) {
        Object tempKey = array[i];
        Object tempValue = array[i + 1];
        array[i] = array[j];
        array[i + 1] = array[j + 1];
        array[j] = tempKey;
        array[j + 1] = tempValue;
    }

    private void switchToMap(Object[] entries, K key, V value) {
        Map<Object, Object> map = this.getNewMap();
        int len = entries.length;
        for (int i = 0; i < len; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        map.put(key, value);
        this.val = map;
    }

    private V handleTransitionToSingleEntry(Object[] entries, Object key) {
        if (this.areKeysEqual(key, entries[0])) {
            Object prevValue = entries[1];
            this.clear();
            this.put(entries[2], entries[3]);
            return (V)prevValue;
        }
        if (this.areKeysEqual(key, entries[2])) {
            Object prevValue = entries[3];
            this.clear();
            this.put(entries[0], entries[1]);
            return (V)prevValue;
        }
        return null;
    }

    private V handleSingleEntryPut(K key, V value) {
        if (this.areKeysEqual(key, this.getLogicalSingleKey())) {
            V save = this.getLogicalSingleValue();
            this.val = this.areKeysEqual(key, this.getSingleValueKey()) && !(value instanceof Map) && !(value instanceof Object[]) ? value : new CompactMapEntry(key, value);
            return save;
        }
        Object[] entries = new Object[4];
        K existingKey = this.getLogicalSingleKey();
        V existingValue = this.getLogicalSingleValue();
        entries[0] = existingKey;
        entries[1] = existingValue;
        entries[2] = key;
        entries[3] = value;
        this.val = entries;
        return null;
    }

    private V handleSingleEntryRemove(Object key) {
        if (this.areKeysEqual(key, this.getLogicalSingleKey())) {
            V save = this.getLogicalSingleValue();
            this.clear();
            return save;
        }
        return null;
    }

    private V removeFromMap(Map<K, V> map, Object key) {
        if (!map.containsKey(key)) {
            return null;
        }
        V save = map.remove(key);
        if (map.size() == this.compactSize()) {
            Object[] entries = new Object[this.compactSize() * 2];
            int idx = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                entries[idx] = entry.getKey();
                entries[idx + 1] = entry.getValue();
                idx += 2;
            }
            this.val = entries;
        }
        return save;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.val = EMPTY_MAP;
    }

    @Override
    public int hashCode() {
        if (this.val instanceof Object[]) {
            int h = 0;
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aKey = entries[i];
                Object aValue = entries[i + 1];
                h += this.computeKeyHashCode(aKey) ^ this.computeValueHashCode(aValue);
            }
            return h;
        }
        if (this.val instanceof Map) {
            return this.val.hashCode();
        }
        if (this.val == EMPTY_MAP) {
            return 0;
        }
        return this.computeKeyHashCode(this.getLogicalSingleKey()) ^ this.computeValueHashCode(this.getLogicalSingleValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.val instanceof Object[]) {
            for (Map.Entry entry : other.entrySet()) {
                Object thatKey = entry.getKey();
                if (!this.containsKey(thatKey)) {
                    return false;
                }
                Object thatValue = entry.getValue();
                V thisValue = this.get(thatKey);
                if (!(thatValue == null || thisValue == null ? thatValue != thisValue : !thisValue.equals(thatValue))) continue;
                return false;
            }
        } else {
            if (this.val instanceof Map) {
                Map map = (Map)this.val;
                return map.equals(other);
            }
            if (this.val == EMPTY_MAP) {
                return other.isEmpty();
            }
        }
        return this.entrySet().equals(other.entrySet());
    }

    public String toString() {
        return MapUtilities.mapToString(this);
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new CompactKeyIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return CompactMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                int size = this.size();
                CompactMap.this.remove(o);
                return this.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = this.size();
                for (Object o : c) {
                    CompactMap.this.remove(o);
                }
                return this.size() != size;
            }

            @Override
            public boolean retainAll(Collection c) {
                Map other = CompactMap.this.getNewMap();
                for (Object o : c) {
                    other.put(o, null);
                }
                int size = this.size();
                CompactMap.this.keySet().removeIf(key -> !other.containsKey(key));
                return this.size() != size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new CompactValueIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CompactEntryIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Object entryKey = entry.getKey();
                    Object value = CompactMap.this.get(entryKey);
                    if (value != null) {
                        return Objects.equals(value, entry.getValue());
                    }
                    if (CompactMap.this.containsKey(entryKey)) {
                        value = CompactMap.this.get(entryKey);
                        return Objects.equals(value, entry.getValue());
                    }
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                int size = this.size();
                Map.Entry that = (Map.Entry)o;
                CompactMap.this.remove(that.getKey());
                return this.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = this.size();
                for (Object o : c) {
                    this.remove(o);
                }
                return this.size() != size;
            }

            @Override
            public boolean retainAll(Collection c) {
                CompactMap other = new CompactMap<K, V>(){

                    @Override
                    protected boolean isCaseInsensitive() {
                        return CompactMap.this.isCaseInsensitive();
                    }

                    @Override
                    protected int compactSize() {
                        return CompactMap.this.compactSize();
                    }

                    @Override
                    protected Map<K, V> getNewMap() {
                        return CompactMap.this.getNewMap();
                    }
                };
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    other.put(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
                }
                int origSize = this.size();
                Iterator i = CompactMap.this.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!other.containsKey(key)) {
                        i.remove();
                        continue;
                    }
                    Object v = other.get(key);
                    if (Objects.equals(v, value)) continue;
                    i.remove();
                }
                return this.size() != origSize;
            }
        };
    }

    @Deprecated
    public Map<K, V> minus(Object removeMe) {
        throw new UnsupportedOperationException("Unsupported operation [minus] or [-] between Maps.  Use removeAll() or retainAll() instead.");
    }

    @Deprecated
    public Map<K, V> plus(Object right) {
        throw new UnsupportedOperationException("Unsupported operation [plus] or [+] between Maps.  Use putAll() instead.");
    }

    protected LogicalValueType getLogicalValueType() {
        if (this.val instanceof Object[]) {
            return LogicalValueType.ARRAY;
        }
        if (this.val instanceof Map) {
            return LogicalValueType.MAP;
        }
        if (this.val == EMPTY_MAP) {
            return LogicalValueType.EMPTY;
        }
        if (CompactMapEntry.class.isInstance(this.val)) {
            return LogicalValueType.ENTRY;
        }
        return LogicalValueType.OBJECT;
    }

    protected int computeKeyHashCode(Object key) {
        if (key instanceof String) {
            if (this.isCaseInsensitive()) {
                return StringUtilities.hashCodeIgnoreCase((String)key);
            }
            return key.hashCode();
        }
        if (key == null) {
            return 0;
        }
        return key == this ? 37 : key.hashCode();
    }

    protected int computeValueHashCode(Object value) {
        if (value == this) {
            return 17;
        }
        return value == null ? 0 : value.hashCode();
    }

    private K getLogicalSingleKey() {
        if (CompactMapEntry.class.isInstance(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getKey();
        }
        return this.getSingleValueKey();
    }

    private V getLogicalSingleValue() {
        if (CompactMapEntry.class.isInstance(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getValue();
        }
        return (V)this.val;
    }

    protected K getSingleValueKey() {
        return (K)DEFAULT_SINGLE_KEY;
    }

    protected Map<K, V> getNewMap() {
        return new HashMap();
    }

    protected boolean isCaseInsensitive() {
        return false;
    }

    protected int compactSize() {
        return 70;
    }

    protected String getOrdering() {
        return UNORDERED;
    }

    static <K, V> CompactMap<K, V> newMap(Map<String, Object> options) {
        CompactMap.validateAndFinalizeOptions(options);
        try {
            Class templateClass = TemplateGenerator.getOrCreateTemplateClass(options);
            CompactMap map = (CompactMap)templateClass.newInstance();
            Map source = (Map)options.get(SOURCE_MAP);
            if (source != null) {
                map.putAll(source);
            }
            return map;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Failed to create CompactMap instance", e);
        }
    }

    static void validateAndFinalizeOptions(Map<String, Object> options) {
        String ordering = (String)options.getOrDefault(ORDERING, UNORDERED);
        int compactSize = (Integer)options.getOrDefault(COMPACT_SIZE, 70);
        if (compactSize < 2) {
            throw new IllegalArgumentException("compactSize must be >= 2");
        }
        Class<Map> mapType = CompactMap.determineMapType(options, ordering);
        boolean caseSensitive = (Boolean)options.getOrDefault(CASE_SENSITIVE, true);
        options.put(MAP_TYPE, mapType);
        Map sourceMap = (Map)options.get(SOURCE_MAP);
        if (sourceMap != null) {
            String sourceOrdering = MapUtilities.detectMapOrdering(sourceMap);
            if (!(UNORDERED.equals(ordering) || UNORDERED.equals(sourceOrdering) || ordering.equals(sourceOrdering))) {
                throw new IllegalArgumentException("Requested ordering '" + ordering + "' conflicts with source map's ordering '" + sourceOrdering + "'. Map structure: " + MapUtilities.getMapStructureString(sourceMap));
            }
        }
        if (!(caseSensitive || SORTED.equals(ordering) || REVERSE.equals(ordering) || mapType == CaseInsensitiveMap.class)) {
            options.put(INNER_MAP_TYPE, mapType);
            options.put(MAP_TYPE, CaseInsensitiveMap.class);
        }
        options.putIfAbsent(COMPACT_SIZE, 70);
        options.putIfAbsent(CASE_SENSITIVE, true);
    }

    private static Class<? extends Map> determineMapType(Map<String, Object> options, String ordering) {
        boolean isValidForOrdering;
        Class rawMapType = (Class<LinkedHashMap>)options.get(MAP_TYPE);
        if (rawMapType != null) {
            if (IdentityHashMap.class.isAssignableFrom(rawMapType)) {
                throw new IllegalArgumentException("IdentityHashMap is not supported as it compares keys by reference identity");
            }
            if (WeakHashMap.class.isAssignableFrom(rawMapType)) {
                throw new IllegalArgumentException("WeakHashMap is not supported as it can unpredictably remove entries");
            }
        }
        if (rawMapType == null) {
            rawMapType = ordering.equals(INSERTION) ? LinkedHashMap.class : (ordering.equals(SORTED) || ordering.equals(REVERSE) ? TreeMap.class : DEFAULT_MAP_TYPE);
        } else if (options.get(ORDERING) == null) {
            ordering = LinkedHashMap.class.isAssignableFrom(rawMapType) || EnumMap.class.isAssignableFrom(rawMapType) ? INSERTION : (SortedMap.class.isAssignableFrom(rawMapType) ? (rawMapType.getName().toLowerCase().contains(REVERSE) || rawMapType.getName().toLowerCase().contains("descending") ? REVERSE : SORTED) : UNORDERED);
            options.put(ORDERING, ordering);
        }
        if (rawMapType != CompactMap.class && rawMapType != CaseInsensitiveMap.class && rawMapType != TrackingMap.class && !(isValidForOrdering = ordering.equals(INSERTION) ? LinkedHashMap.class.isAssignableFrom(rawMapType) || EnumMap.class.isAssignableFrom(rawMapType) : (ordering.equals(SORTED) || ordering.equals(REVERSE) ? SortedMap.class.isAssignableFrom(rawMapType) : true))) {
            throw new IllegalArgumentException("Map type " + rawMapType.getSimpleName() + " is not compatible with ordering '" + ordering + "'");
        }
        options.put(MAP_TYPE, rawMapType);
        if (rawMapType != null && !Map.class.isAssignableFrom(rawMapType)) {
            throw new IllegalArgumentException("mapType must be a Map class");
        }
        return rawMapType;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    private static final class TemplateClassLoader
    extends ClassLoader {
        private final Map<String, Class<?>> definedClasses = new ConcurrentHashMap();
        private final Map<String, ReentrantLock> classLoadLocks = new ConcurrentHashMap<String, ReentrantLock>();

        private TemplateClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = this.findClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> defineTemplateClass(String name, byte[] bytes) {
            ReentrantLock lock = this.classLoadLocks.computeIfAbsent(name, k -> new ReentrantLock());
            lock.lock();
            try {
                Class<?> cached = this.definedClasses.get(name);
                if (cached != null) {
                    Class<?> clazz = cached;
                    return clazz;
                }
                Class<?> definedClass = this.defineClass(name, bytes, 0, bytes.length);
                this.definedClasses.put(name, definedClass);
                Class<?> clazz = definedClass;
                return clazz;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("com.cedarsoftware.util.CompactMap$")) {
                Class<?> cached = this.definedClasses.get(name);
                if (cached != null) {
                    return cached;
                }
                throw new ClassNotFoundException("Not found: " + name);
            }
            return super.findClass(name);
        }
    }

    public class CompactMapEntry
    extends AbstractMap.SimpleEntry<K, V> {
        public CompactMapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            Object save = this.getValue();
            super.setValue(value);
            CompactMap.this.put(this.getKey(), value);
            return save;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Map.Entry e = (Map.Entry)o;
            return CompactMap.this.areKeysEqual(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            return CompactMap.this.computeKeyHashCode(this.getKey()) ^ CompactMap.this.computeValueHashCode(this.getValue());
        }
    }

    public static class CompactMapComparator
    implements Comparator<Object> {
        private final boolean caseInsensitive;
        private final boolean reverse;

        public CompactMapComparator(boolean caseInsensitive, boolean reverse) {
            this.caseInsensitive = caseInsensitive;
            this.reverse = reverse;
        }

        @Override
        public int compare(Object key1, Object key2) {
            if (key1 == null) {
                return key2 == null ? 0 : 1;
            }
            if (key2 == null) {
                return -1;
            }
            Class<?> key1Class = key1.getClass();
            Class<?> key2Class = key2.getClass();
            int result = key1Class == String.class ? (key2Class == String.class ? (this.caseInsensitive ? String.CASE_INSENSITIVE_ORDER.compare((String)key1, (String)key2) : ((String)key1).compareTo((String)key2)) : key1Class.getName().compareTo(key2Class.getName())) : (key1Class == key2Class && key1 instanceof Comparable ? ((Comparable)key1).compareTo(key2) : key1Class.getName().compareTo(key2Class.getName()));
            return this.reverse ? -result : result;
        }

        public String toString() {
            return "CompactMapComparator{caseInsensitive=" + this.caseInsensitive + ", reverse=" + this.reverse + "}";
        }
    }

    protected static enum LogicalValueType {
        EMPTY,
        OBJECT,
        ENTRY,
        MAP,
        ARRAY;

    }

    private static final class TemplateGenerator {
        private static final String TEMPLATE_CLASS_PREFIX = "com.cedarsoftware.util.CompactMap$";

        private TemplateGenerator() {
        }

        private static Class<?> getOrCreateTemplateClass(Map<String, Object> options) {
            String className = TemplateGenerator.generateClassName(options);
            try {
                return templateClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return TemplateGenerator.generateTemplateClass(options);
            }
        }

        private static String generateClassName(Map<String, Object> options) {
            StringBuilder keyBuilder = new StringBuilder(TEMPLATE_CLASS_PREFIX);
            Object mapTypeObj = options.get(CompactMap.MAP_TYPE);
            if (mapTypeObj instanceof Class) {
                keyBuilder.append(((Class)mapTypeObj).getSimpleName());
            } else {
                keyBuilder.append((String)mapTypeObj);
            }
            keyBuilder.append('_').append((Boolean)options.getOrDefault(CompactMap.CASE_SENSITIVE, true) != false ? "CS" : "CI");
            keyBuilder.append("_S").append(options.getOrDefault(CompactMap.COMPACT_SIZE, 70));
            String singleKey = (String)options.getOrDefault(CompactMap.SINGLE_KEY, CompactMap.DEFAULT_SINGLE_KEY);
            singleKey = singleKey.substring(0, 1).toUpperCase() + singleKey.substring(1);
            singleKey = singleKey.replaceAll("[^a-zA-Z0-9]", "");
            keyBuilder.append('_').append(singleKey);
            String ordering = (String)options.getOrDefault(CompactMap.ORDERING, CompactMap.UNORDERED);
            keyBuilder.append('_');
            switch (ordering) {
                case "sorted": {
                    keyBuilder.append("Sort");
                    break;
                }
                case "reverse": {
                    keyBuilder.append("Rev");
                    break;
                }
                case "insertion": {
                    keyBuilder.append("Ins");
                    break;
                }
                default: {
                    keyBuilder.append("Unord");
                }
            }
            return keyBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Class<?> generateTemplateClass(Map<String, Object> options) {
            String className = TemplateGenerator.generateClassName(options);
            ReentrantLock lock = CLASS_LOCKS.computeIfAbsent(className, k -> new ReentrantLock());
            lock.lock();
            try {
                Class<?> clazz = ClassUtilities.getClassLoader(CompactMap.class).loadClass(className);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class<?> templateClass;
                String sourceCode = TemplateGenerator.generateSourceCode(className, options);
                Class<?> clazz = templateClass = TemplateGenerator.compileClass(className, sourceCode);
                return clazz;
            }
            finally {
                lock.unlock();
            }
        }

        private static String generateSourceCode(String className, Map<String, Object> options) {
            String mapClassName;
            String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
            StringBuilder sb = new StringBuilder();
            sb.append("package com.cedarsoftware.util;\n\n");
            sb.append("import java.util.*;\n");
            sb.append("import java.util.concurrent.*;\n");
            Class mapType = (Class)options.get(CompactMap.MAP_TYPE);
            if (!(mapType == null || (mapClassName = TemplateGenerator.getMapClassName(mapType)).startsWith("java.util.") || mapClassName.startsWith("java.util.concurrent.") || mapClassName.startsWith("com.cedarsoftware.util."))) {
                sb.append("import ").append(mapClassName).append(";\n");
            }
            sb.append("\n");
            sb.append("public class ").append(simpleClassName).append(" extends CompactMap {\n");
            boolean caseSensitive = (Boolean)options.getOrDefault(CompactMap.CASE_SENSITIVE, true);
            sb.append("    @Override\n").append("    protected boolean isCaseInsensitive() {\n").append("        return ").append(!caseSensitive).append(";\n").append("    }\n\n");
            sb.append("    @Override\n").append("    protected int compactSize() {\n").append("        return ").append(options.getOrDefault(CompactMap.COMPACT_SIZE, 70)).append(";\n").append("    }\n\n");
            sb.append("    @Override\n").append("    protected Object getSingleValueKey() {\n").append("        return \"").append(options.getOrDefault(CompactMap.SINGLE_KEY, CompactMap.DEFAULT_SINGLE_KEY)).append("\";\n").append("    }\n\n");
            String ordering = (String)options.getOrDefault(CompactMap.ORDERING, CompactMap.UNORDERED);
            sb.append("    @Override\n").append("    protected String getOrdering() {\n").append("        return \"").append(ordering).append("\";\n").append("    }\n\n");
            TemplateGenerator.appendGetNewMapOverride(sb, options);
            sb.append("}\n");
            return sb.toString();
        }

        private static void appendGetNewMapOverride(StringBuilder sb, Map<String, Object> options) {
            String methodTemplate = "    @Override\n    protected Map getNewMap() {\n        Map map;\n        try {\n%s        } catch (Exception e) {\n            throw new IllegalStateException(\"Failed to create map instance\", e);\n        }\n        if (!(map instanceof Map)) {\n            throw new IllegalStateException(\"mapType must be a Map class\");\n        }\n        return map;\n    }\n";
            String mapCreationCode = TemplateGenerator.getMapCreationCode(options);
            String indentedCreationCode = TemplateGenerator.indentCode(mapCreationCode, 12);
            sb.append(String.format(methodTemplate, indentedCreationCode));
        }

        private static String getSortedMapCreationCode(Class<?> mapType, boolean caseSensitive, String ordering, Map<String, Object> options) {
            String comparatorTemplate = "map = new %s(new CompactMapComparator(%b, %b));";
            String capacityTemplate = "map = new %s();\ntry {\n    map = new %s(%d);\n} catch (Exception e) {\n    // Fallback to default constructor already done\n}";
            if (TemplateGenerator.hasComparatorConstructor(mapType)) {
                return String.format(comparatorTemplate, TemplateGenerator.getMapClassName(mapType), !caseSensitive, CompactMap.REVERSE.equals(ordering));
            }
            int compactSize = (Integer)options.getOrDefault(CompactMap.COMPACT_SIZE, 70);
            return String.format(capacityTemplate, TemplateGenerator.getMapClassName(mapType), TemplateGenerator.getMapClassName(mapType), compactSize + 1);
        }

        private static String getStandardMapCreationCode(Class<?> mapType, Map<String, Object> options) {
            String template = "map = new %s();\ntry {\n    map = new %s(%d);\n} catch (Exception e) {\n    // Fallback to default constructor already done\n}";
            String mapClassName = TemplateGenerator.getMapClassName(mapType);
            int compactSize = (Integer)options.getOrDefault(CompactMap.COMPACT_SIZE, 70);
            return String.format(template, mapClassName, mapClassName, compactSize + 1);
        }

        private static String getMapClassName(Class<?> mapType) {
            if (mapType.getEnclosingClass() != null) {
                if (mapType.getName().contains("Test")) {
                    return mapType.getSimpleName();
                }
                if (mapType.getPackage().getName().equals("com.cedarsoftware.util")) {
                    return mapType.getEnclosingClass().getSimpleName() + "." + mapType.getSimpleName();
                }
                return mapType.getName().replace('$', '.');
            }
            return mapType.getName();
        }

        private static boolean hasComparatorConstructor(Class<?> mapType) {
            try {
                mapType.getConstructor(Comparator.class);
                return true;
            }
            catch (NoSuchMethodException ignored) {
                return false;
            }
        }

        private static String indentCode(String code, int spaces) {
            String indent = String.format("%" + spaces + "s", "");
            return Arrays.stream(code.split("\n")).map(line -> indent + line).collect(Collectors.joining("\n"));
        }

        private static String getMapCreationCode(Map<String, Object> options) {
            Class innerMapType;
            String ordering = (String)options.getOrDefault(CompactMap.ORDERING, CompactMap.UNORDERED);
            boolean caseSensitive = (Boolean)options.getOrDefault(CompactMap.CASE_SENSITIVE, true);
            Class mapType = (Class)options.getOrDefault(CompactMap.MAP_TYPE, DEFAULT_MAP_TYPE);
            if (mapType == CaseInsensitiveMap.class && (innerMapType = (Class)options.get(CompactMap.INNER_MAP_TYPE)) != null) {
                if (CompactMap.SORTED.equals(ordering) || CompactMap.REVERSE.equals(ordering)) {
                    return String.format("map = new CaseInsensitiveMap(new %s(new CompactMapComparator(%b, %b)));", TemplateGenerator.getMapClassName(innerMapType), !caseSensitive, CompactMap.REVERSE.equals(ordering));
                }
                String template = "Map innerMap = new %s();\ntry {\n    innerMap = new %s(%d);\n} catch (Exception e) {\n    // Fallback to default constructor already done\n}\nmap = new CaseInsensitiveMap(innerMap);";
                return String.format(template, TemplateGenerator.getMapClassName(innerMapType), TemplateGenerator.getMapClassName(innerMapType), (Integer)options.getOrDefault(CompactMap.COMPACT_SIZE, 70) + 1);
            }
            if (CompactMap.SORTED.equals(ordering) || CompactMap.REVERSE.equals(ordering)) {
                return TemplateGenerator.getSortedMapCreationCode(mapType, caseSensitive, ordering, options);
            }
            return TemplateGenerator.getStandardMapCreationCode(mapType, options);
        }

        private static Class<?> compileClass(String className, final String sourceCode) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new IllegalStateException("No JavaCompiler found. Ensure JDK (not just JRE) is being used.");
            }
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            StandardJavaFileManager stdFileManager = compiler.getStandardFileManager(diagnostics, null, null);
            SimpleJavaFileObject sourceFile = new SimpleJavaFileObject(URI.create("string:///" + className.replace('.', '/') + ".java"), JavaFileObject.Kind.SOURCE){

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                    return sourceCode;
                }
            };
            final HashMap classOutputs = new HashMap();
            ForwardingJavaFileManager fileManager = new ForwardingJavaFileManager(stdFileManager){

                @Override
                public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                    if (kind == JavaFileObject.Kind.CLASS) {
                        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        classOutputs.put(className, outputStream);
                        return new SimpleJavaFileObject(URI.create("byte:///" + className.replace('.', '/') + ".class"), JavaFileObject.Kind.CLASS){

                            @Override
                            public OutputStream openOutputStream() {
                                return outputStream;
                            }
                        };
                    }
                    return super.getJavaFileForOutput(location, className, kind, sibling);
                }
            };
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, Collections.singletonList("-proc:none"), null, Collections.singletonList(sourceFile));
            boolean success = task.call();
            if (!success) {
                StringBuilder error = new StringBuilder("Compilation failed:\n");
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    error.append(diagnostic.toString()).append('\n');
                }
                throw new IllegalStateException(error.toString());
            }
            ByteArrayOutputStream classOutput = (ByteArrayOutputStream)classOutputs.get(className);
            if (classOutput == null) {
                throw new IllegalStateException("No class file generated for " + className);
            }
            byte[] classBytes = classOutput.toByteArray();
            return TemplateGenerator.defineClass(className, classBytes);
        }

        private static Class<?> defineClass(String className, byte[] classBytes) {
            return templateClassLoader.defineTemplateClass(className, classBytes);
        }
    }

    public static final class Builder<K, V> {
        private final Map<String, Object> options = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder<K, V> caseSensitive(boolean caseSensitive) {
            this.options.put(CompactMap.CASE_SENSITIVE, caseSensitive);
            return this;
        }

        public Builder<K, V> mapType(Class<? extends Map> mapType) {
            if (!Map.class.isAssignableFrom(mapType)) {
                throw new IllegalArgumentException("mapType must be a Map class");
            }
            this.options.put(CompactMap.MAP_TYPE, mapType);
            return this;
        }

        public Builder<K, V> singleValueKey(K key) {
            this.options.put(CompactMap.SINGLE_KEY, key);
            return this;
        }

        public Builder<K, V> compactSize(int size) {
            this.options.put(CompactMap.COMPACT_SIZE, size);
            return this;
        }

        public Builder<K, V> sortedOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.SORTED);
            return this;
        }

        public Builder<K, V> reverseOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.REVERSE);
            return this;
        }

        public Builder<K, V> insertionOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.INSERTION);
            return this;
        }

        public Builder<K, V> noOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.UNORDERED);
            return this;
        }

        public Builder<K, V> sourceMap(Map<K, V> source) {
            this.options.put(CompactMap.SOURCE_MAP, source);
            return this;
        }

        public CompactMap<K, V> build() {
            return CompactMap.newMap(this.options);
        }
    }

    final class CompactEntryIterator
    extends CompactIterator
    implements Iterator<Map.Entry<K, V>> {
        CompactEntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.advance();
            if (this.mapIterator != null) {
                return (Map.Entry)this.current;
            }
            if (this.expectedSize == 1) {
                if (CompactMap.this.val instanceof CompactMapEntry) {
                    return (CompactMapEntry)CompactMap.this.val;
                }
                return new CompactMapEntry(CompactMap.this.getLogicalSingleKey(), CompactMap.this.getLogicalSingleValue());
            }
            Object[] objs = (Object[])CompactMap.this.val;
            return new CompactMapEntry(objs[this.index * 2], objs[this.index * 2 + 1]);
        }
    }

    final class CompactValueIterator
    extends CompactIterator
    implements Iterator<V> {
        CompactValueIterator() {
        }

        @Override
        public V next() {
            this.advance();
            if (this.mapIterator != null) {
                return ((Map.Entry)this.current).getValue();
            }
            if (this.expectedSize == 1) {
                return CompactMap.this.getLogicalSingleValue();
            }
            return ((Object[])CompactMap.this.val)[this.index * 2 + 1];
        }
    }

    final class CompactKeyIterator
    extends CompactIterator
    implements Iterator<K> {
        CompactKeyIterator() {
        }

        @Override
        public K next() {
            this.advance();
            if (this.mapIterator != null) {
                return ((Map.Entry)this.current).getKey();
            }
            return this.current;
        }
    }

    abstract class CompactIterator {
        Iterator<Map.Entry<K, V>> mapIterator;
        Object current;
        int expectedSize;
        int index;

        CompactIterator() {
            this.expectedSize = CompactMap.this.size();
            this.current = CompactMap.EMPTY_MAP;
            this.index = -1;
            if (CompactMap.this.val instanceof Object[]) {
                CompactMap.this.sortCompactArray((Object[])CompactMap.this.val);
            } else if (CompactMap.this.val instanceof Map) {
                this.mapIterator = ((Map)CompactMap.this.val).entrySet().iterator();
            } else if (CompactMap.this.val == CompactMap.EMPTY_MAP) {
                // empty if block
            }
        }

        public final boolean hasNext() {
            if (CompactMap.this.val instanceof Object[]) {
                return this.index + 1 < CompactMap.this.size();
            }
            if (CompactMap.this.val instanceof Map) {
                return this.mapIterator.hasNext();
            }
            if (CompactMap.this.val == CompactMap.EMPTY_MAP) {
                return false;
            }
            return this.index < 0;
        }

        final void advance() {
            if (this.expectedSize != CompactMap.this.size()) {
                throw new ConcurrentModificationException();
            }
            if (++this.index >= CompactMap.this.size()) {
                throw new NoSuchElementException();
            }
            if (CompactMap.this.val instanceof Object[]) {
                this.current = ((Object[])CompactMap.this.val)[this.index * 2];
            } else if (CompactMap.this.val instanceof Map) {
                this.current = this.mapIterator.next();
            } else {
                if (CompactMap.this.val == CompactMap.EMPTY_MAP) {
                    throw new NoSuchElementException();
                }
                this.current = CompactMap.this.getLogicalSingleKey();
            }
        }

        public final void remove() {
            if (this.current == CompactMap.EMPTY_MAP) {
                throw new IllegalStateException();
            }
            if (CompactMap.this.size() != this.expectedSize) {
                throw new ConcurrentModificationException();
            }
            int newSize = this.expectedSize - 1;
            if (this.mapIterator != null && newSize == CompactMap.this.compactSize()) {
                this.current = ((Map.Entry)this.current).getKey();
                this.mapIterator = null;
            }
            if (this.mapIterator == null) {
                CompactMap.this.remove(this.current);
            } else {
                this.mapIterator.remove();
            }
            --this.index;
            this.current = CompactMap.EMPTY_MAP;
            --this.expectedSize;
        }
    }
}

