/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.convert.ByteBufferConversions;
import com.cedarsoftware.util.convert.Converter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

final class CharBufferConversions {
    private CharBufferConversions() {
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        return ((CharBuffer)from).asReadOnlyBuffer();
    }

    static byte[] toByteArray(Object from, Converter converter) {
        return ByteBufferConversions.toByteArray(CharBufferConversions.toByteBuffer(from, converter), converter);
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        return converter.getOptions().getCharset().encode(CharBufferConversions.toCharBuffer(from, converter));
    }

    static String toString(Object from, Converter converter) {
        return CharBufferConversions.toCharBuffer(from, converter).toString();
    }

    static char[] toCharArray(Object from, Converter converter) {
        CharBuffer buffer = CharBufferConversions.toCharBuffer(from, converter);
        if (buffer == null || !buffer.hasRemaining()) {
            return ArrayUtilities.EMPTY_CHAR_ARRAY;
        }
        char[] chars = new char[buffer.remaining()];
        buffer.get(chars);
        return chars;
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return new StringBuffer(CharBufferConversions.toCharBuffer(from, converter));
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return new StringBuilder(CharBufferConversions.toCharBuffer(from, converter));
    }
}

