/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.DateConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class CalendarConversions {
    private CalendarConversions() {
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        return calendar.toInstant().atZone(calendar.getTimeZone().toZoneId());
    }

    static Long toLong(Object from, Converter converter) {
        return ((Calendar)from).getTime().getTime();
    }

    static double toDouble(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        long epochMillis = calendar.getTime().getTime();
        return (double)epochMillis / 1000.0;
    }

    static Date toDate(Object from, Converter converter) {
        return ((Calendar)from).getTime();
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(((Calendar)from).getTime().getTime());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(((Calendar)from).getTimeInMillis());
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(((Calendar)from).getTime().getTime());
    }

    static Instant toInstant(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        return calendar.toInstant();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return CalendarConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return CalendarConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return CalendarConversions.toZonedDateTime(from, converter).toLocalTime();
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Calendar cal = (Calendar)from;
        long epochMillis = cal.getTime().getTime();
        return new BigDecimal(epochMillis).divide(BigDecimalConversions.GRAND);
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return BigInteger.valueOf(((Calendar)from).getTime().getTime() * 1000000L);
    }

    static Calendar clone(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        return (Calendar)calendar.clone();
    }

    static Calendar create(long epochMilli, Converter converter) {
        Calendar cal = Calendar.getInstance(converter.getOptions().getTimeZone());
        cal.clear();
        cal.setTimeInMillis(epochMilli);
        return cal;
    }

    static String toString(Object from, Converter converter) {
        Calendar cal = (Calendar)from;
        return DateConversions.toString(cal.getTime(), converter);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Calendar cal = (Calendar)from;
        CompactLinkedMap<String, Object> target = new CompactLinkedMap<String, Object>();
        target.put("year", cal.get(1));
        target.put("month", cal.get(2) + 1);
        target.put("day", cal.get(5));
        target.put("hour", cal.get(11));
        target.put("minute", cal.get(12));
        target.put("second", cal.get(13));
        target.put("millis", cal.get(14));
        target.put("zone", cal.getTimeZone().getID());
        return target;
    }
}

