/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;

final class DoubleConversions {
    private DoubleConversions() {
    }

    static Instant toInstant(Object from, Converter converter) {
        double d = (Double)from;
        long seconds = (long)d;
        long nanoAdjustment = (long)((d - (double)seconds) * 1.0E9);
        return Instant.ofEpochSecond(seconds, nanoAdjustment);
    }

    static Date toDate(Object from, Converter converter) {
        double d = (Double)from;
        return new Date((long)(d * 1000.0));
    }

    static Date toSqlDate(Object from, Converter converter) {
        double d = (Double)from;
        return new java.sql.Date((long)(d * 1000.0));
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return DoubleConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return DoubleConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return DoubleConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId());
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return DoubleConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId()).toOffsetDateTime();
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return Timestamp.from(DoubleConversions.toInstant(from, converter));
    }

    static Duration toDuration(Object from, Converter converter) {
        double d = (Double)from;
        long seconds = (long)d;
        long nanoAdjustment = (long)((d - (double)seconds) * 1.0E9);
        return Duration.ofSeconds(seconds, nanoAdjustment);
    }
}

