/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;

final class BigIntegerConversions {
    static final BigInteger BILLION = BigInteger.valueOf(1000000000L);

    private BigIntegerConversions() {
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        return new BigDecimal((BigInteger)from);
    }

    static UUID toUUID(Object from, Converter converter) {
        BigInteger bigInteger = (BigInteger)from;
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException("Cannot convert a negative number [" + bigInteger + "] to a UUID");
        }
        StringBuilder hex = new StringBuilder(bigInteger.toString(16));
        while (hex.length() < 32) {
            hex.insert(0, "0");
        }
        String highBitsHex = hex.substring(0, 16);
        String lowBitsHex = hex.substring(16, 32);
        String uuidString = highBitsHex.substring(0, 8) + "-" + highBitsHex.substring(8, 12) + "-" + highBitsHex.substring(12, 16) + "-" + lowBitsHex.substring(0, 4) + "-" + lowBitsHex.substring(4, 16);
        return UUID.fromString(uuidString);
    }

    static Date toDate(Object from, Converter converter) {
        return Date.from(BigIntegerConversions.toInstant(from, converter));
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(BigIntegerConversions.toInstant(from, converter).toEpochMilli());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return Timestamp.from(BigIntegerConversions.toInstant(from, converter));
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return BigIntegerConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId());
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return BigIntegerConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return BigIntegerConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return BigIntegerConversions.toZonedDateTime(from, converter).toOffsetDateTime();
    }

    static Instant toInstant(Object from, Converter converter) {
        BigInteger nanoseconds = (BigInteger)from;
        BigInteger[] secondsAndNanos = nanoseconds.divideAndRemainder(BILLION);
        long seconds = secondsAndNanos[0].longValue();
        int nanos = secondsAndNanos[1].intValue();
        return Instant.ofEpochSecond(seconds, nanos);
    }

    static Duration toDuration(Object from, Converter converter) {
        BigInteger nanoseconds = (BigInteger)from;
        BigInteger[] secondsAndNanos = nanoseconds.divideAndRemainder(BILLION);
        long seconds = secondsAndNanos[0].longValue();
        int nanos = secondsAndNanos[1].intValue();
        return Duration.ofSeconds(seconds, nanos);
    }
}

