/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Map<K, Node> map;
    private final Node head;
    private final Node tail;
    private final int capacity;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.map = new ConcurrentHashMap<K, Node>(capacity);
        this.head = new Node(null, null);
        this.head.next = this.tail = new Node(null, null);
        this.tail.prev = this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this.lock.readLock().lock();
        try {
            Node node = this.map.get(key);
            if (node == null) {
                V v = null;
                return v;
            }
            this.moveToHead(node);
            Object v = node.value;
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            Node oldestNode;
            Node newNode = new Node(key, value);
            Node oldNode = this.map.put(key, newNode);
            if (oldNode != null) {
                this.removeNode(oldNode);
            }
            this.addToHead(newNode);
            if (this.map.size() > this.capacity && (oldestNode = this.removeTailNode()) != null) {
                this.map.remove(oldestNode.key);
            }
            V v = oldNode != null ? (V)oldNode.value : null;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.lock.writeLock().lock();
        try {
            Node node = this.map.remove(key);
            if (node != null) {
                this.removeNode(node);
                Object v = node.value;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node node : this.map.values()) {
            if (!Objects.equals(node.value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashMap result = new LinkedHashMap();
        for (Node node : this.map.values()) {
            result.put(node.key, node.value);
        }
        return Collections.unmodifiableSet(result.entrySet());
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Node node : this.map.values()) {
            values.add(node.value);
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            Map other = (Map)o;
            if (other.size() != this.size()) {
                return false;
            }
            for (Map.Entry entry : other.entrySet()) {
                V value = this.get(entry.getKey());
                if (Objects.equals(value, entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Map.Entry<K, Node> entry : this.map.entrySet()) {
            hashCode = 31 * hashCode + (entry.getKey() == null ? 0 : entry.getKey().hashCode());
            hashCode = 31 * hashCode + (entry.getValue().value == null ? 0 : entry.getValue().value.hashCode());
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<K, Node> entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue().value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }

    private void addToHead(Node node) {
        Node nextNode;
        node.next = nextNode = this.head.next;
        node.prev = this.head;
        this.head.next = node;
        nextNode.prev = node;
    }

    private void removeNode(Node node) {
        Node nextNode;
        Node prevNode = node.prev;
        prevNode.next = nextNode = node.next;
        nextNode.prev = prevNode;
    }

    private void moveToHead(Node node) {
        this.removeNode(node);
        this.addToHead(node);
    }

    private Node removeTailNode() {
        Node oldestNode = this.tail.prev;
        if (oldestNode == this.head) {
            return null;
        }
        this.removeNode(oldestNode);
        return oldestNode;
    }

    private class Node {
        K key;
        V value;
        Node prev;
        Node next;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.key, node.key) && Objects.equals(this.value, node.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "Node{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

