/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft;

import com.cedarsoft.Version;
import com.cedarsoft.VersionException;
import com.cedarsoft.VersionRange;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnsupportedVersionException
extends VersionException {
    @NotNull
    private final Version actual;
    @Nullable
    private final VersionRange supportedRange;

    public UnsupportedVersionException(@NotNull Version actual) {
        this(actual, null);
    }

    public UnsupportedVersionException(@NotNull Version actual, @Nullable VersionRange supportedRange) {
        this(actual, supportedRange, "Unsupported version. ");
    }

    public UnsupportedVersionException(@NotNull Version actual, @Nullable VersionRange supportedRange, @NotNull String messagePrefix) {
        this(actual, supportedRange, messagePrefix, true);
    }

    public UnsupportedVersionException(@NotNull Version actual, @Nullable VersionRange supportedRange, @NotNull String messagePrefix, boolean appendSuffix) {
        super(messagePrefix, UnsupportedVersionException.createMessageSuffix(actual, supportedRange), appendSuffix);
        this.actual = actual;
        this.supportedRange = supportedRange;
    }

    @NotNull
    public Version getActual() {
        return this.actual;
    }

    @Nullable
    public VersionRange getSupportedRange() {
        return this.supportedRange;
    }

    @NotNull
    @NonNls
    private static String createMessageSuffix(@NotNull Version actual, @Nullable VersionRange supportedRange) {
        if (supportedRange == null) {
            return "Was <" + actual + ">";
        }
        return "Was <" + actual + ">. Supported range <" + supportedRange.toString() + ">";
    }
}

