/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.crypt;

import com.cedarsoft.crypt.CertificateUrl;
import com.cedarsoft.crypt.PrivateKeyUrl;
import com.cedarsoft.crypt.Signature;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;

public class X509Support {
    @Nonnull
    public static final String RSA = "RSA";
    @Nonnull
    public static final String SHA_256_WITH_RSA = "SHA256withRSA";
    @Nonnull
    public static final String X_509_CERTIFICATE_TYPE = "X.509";
    @Nonnull
    private final X509Certificate certificate;
    @Nullable
    private final RSAPrivateKey privateKey;

    public X509Support(@Nonnull URL certificate) throws IOException, GeneralSecurityException {
        this(certificate, null);
    }

    @Inject
    public X509Support(@CertificateUrl @Nonnull URL certificate, @PrivateKeyUrl @Nullable URL privateKey) throws IOException, GeneralSecurityException {
        this(X509Support.readCertificate(certificate), X509Support.readPrivateKey(privateKey));
    }

    public X509Support(@Nonnull X509Certificate certificate) {
        this(certificate, null);
    }

    public X509Support(@Nonnull X509Certificate certificate, @Nullable RSAPrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public boolean isPrivateKeyAvailable() {
        return this.privateKey != null;
    }

    @Nonnull
    public byte[] cipher(@Nonnull byte[] plainText) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, this.getPrivateKey());
        return cipher.doFinal(plainText);
    }

    @Nonnull
    public byte[] decipher(@Nonnull byte[] bytes) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, this.certificate);
        return cipher.doFinal(bytes);
    }

    @Nonnull
    public Signature sign(@Nonnull byte[] plainText) throws GeneralSecurityException {
        java.security.Signature signature = java.security.Signature.getInstance(SHA_256_WITH_RSA);
        signature.initSign(this.getPrivateKey());
        signature.update(plainText);
        return new Signature(signature.sign());
    }

    public boolean verifySignature(@Nonnull byte[] plainText, @Nonnull Signature signature) throws GeneralSecurityException {
        java.security.Signature sign = java.security.Signature.getInstance(SHA_256_WITH_RSA);
        sign.initVerify(this.certificate);
        sign.update(plainText);
        return sign.verify(signature.getBytes());
    }

    @Nonnull
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Nonnull
    public RSAPrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            throw new IllegalStateException("Private key not avaible");
        }
        return this.privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static RSAPrivateKey readPrivateKey(@Nullable URL privateKeyUrl) throws IOException, GeneralSecurityException {
        if (privateKeyUrl == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(privateKeyUrl.openStream());
        try {
            byte[] keyBytes = IOUtils.toByteArray((InputStream)in);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(keyBytes);
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
            return rSAPrivateKey;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static X509Certificate readCertificate(@Nonnull URL certificateUrl) throws IOException, GeneralSecurityException {
        DataInputStream in = new DataInputStream(certificateUrl.openStream());
        try {
            CertificateFactory cf = CertificateFactory.getInstance(X_509_CERTIFICATE_TYPE);
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(in);
            certificate.checkValidity();
            X509Certificate x509Certificate = certificate;
            return x509Certificate;
        }
        finally {
            in.close();
        }
    }
}

