/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.value.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class IpAddress
extends Value {
    private final String ipAddress;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public IpAddress(String ipAddress) throws NullPointerException, IllegalArgumentException {
        if (!IpAddressValidator.validIPv4(ipAddress) && !IpAddressValidator.validIPv6(ipAddress)) {
            throw new IllegalArgumentException("Input string is not a valid IPv4 or IPv6 address\n(Note we do not allow mixing IPv4 and IPv6 syntax. E.g., \"::ffff:127.0.0.1\") \n " + ipAddress);
        }
        this.ipAddress = ipAddress;
    }

    @Override
    public String toCedarExpr() {
        return "ip(\"" + this.ipAddress + "\")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAddress ipAddress1 = (IpAddress)o;
        return this.ipAddress.equals(ipAddress1.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress);
    }

    public String toString() {
        return this.ipAddress;
    }

    private static class IpAddressValidator {
        private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
        private static final Pattern IPV6_PATTERN = Pattern.compile("^(([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|:))|(([0-9A-Fa-f]{1,4}:)(((:[0-9A-Fa-f]{1,4}){1,6})|:))|((:)(((:[0-9A-Fa-f]{1,4}){1,7})|:))|$");

        private IpAddressValidator() {
        }

        public static boolean validIPv4(String ip) {
            if (ip == null || ip.isEmpty()) {
                return false;
            }
            if ((ip = ip.trim()).length() < 6 || ip.length() > 15) {
                return false;
            }
            try {
                Matcher matcher = IPV4_PATTERN.matcher(ip);
                return matcher.matches();
            }
            catch (PatternSyntaxException ex) {
                return false;
            }
        }

        public static boolean validIPv6(String ip) {
            if (ip == null || ip.isEmpty()) {
                return false;
            }
            if ((ip = ip.trim()).length() < 3 || ip.length() > 39) {
                return false;
            }
            try {
                Matcher matcher = IPV6_PATTERN.matcher(ip);
                return matcher.matches();
            }
            catch (PatternSyntaxException ex) {
                return false;
            }
        }
    }
}

