/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class DetailedError {
    @JsonProperty(value="message")
    public final String message;
    @JsonProperty(value="help")
    public final Optional<String> help;
    @JsonProperty(value="code")
    public final Optional<String> code;
    @JsonProperty(value="url")
    public final Optional<String> url;
    @JsonProperty(value="severity")
    public final Optional<Severity> severity;
    @JsonProperty(value="sourceLocations")
    public final ImmutableList<SourceLabel> sourceLocations;
    @JsonProperty(value="related")
    public final ImmutableList<DetailedError> related;

    @JsonCreator
    public DetailedError(@JsonProperty(value="message") String message, @JsonProperty(value="help") Optional<String> help, @JsonProperty(value="code") Optional<String> code, @JsonProperty(value="url") Optional<String> url, @JsonProperty(value="severity") Optional<Severity> severity, @JsonProperty(value="sourceLocations") Optional<List<SourceLabel>> sourceLocations, @JsonProperty(value="related") Optional<List<DetailedError>> related) {
        this.message = message;
        this.help = help;
        this.code = code;
        this.url = url;
        this.severity = severity;
        this.sourceLocations = sourceLocations.isPresent() ? ImmutableList.copyOf((Collection)sourceLocations.get()) : ImmutableList.of();
        this.related = related.isPresent() ? ImmutableList.copyOf((Collection)related.get()) : ImmutableList.of();
    }

    public String toString() {
        return String.format("DetailedError{message=\"%s\", help=\"%s\", code=\"%s\", url=\"%s\", severity=%s, sourcelocations=%s, related=%s}", this.message, this.help.orElse(""), this.code.orElse(""), this.url.orElse(""), this.severity.map(Enum::toString).orElse(""), this.sourceLocations, this.related);
    }

    public static final class SourceLabel {
        @JsonProperty(value="label")
        public final Optional<String> label;
        @JsonProperty(value="start")
        public final int start;
        @JsonProperty(value="end")
        public final int end;

        @JsonCreator
        public SourceLabel(@JsonProperty(value="label") Optional<String> label, @JsonProperty(value="start") int start, @JsonProperty(value="end") int end) {
            this.label = label;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return String.format("SourceLabel{label=\"%s\", start=%s, end=%s}", this.label.orElse(""), this.start, this.end);
        }
    }

    public static enum Severity {
        Advice,
        Warning,
        Error;

    }
}

