/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xsl.Sort;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslSort;
import java.util.ArrayList;

public class XslApplyTemplates
extends XslNode {
    private String _select;
    private String _mode;
    private ArrayList<XslSort> _sorts = new ArrayList();

    @Override
    public String getTagName() {
        return "xsl:apply-templates";
    }

    @Override
    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("select")) {
            this._select = value;
        } else if (name.getName().equals("mode")) {
            this._mode = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    @Override
    public void endAttributes() throws XslParseException {
    }

    @Override
    public void addChild(XslNode node) throws XslParseException {
        if (node instanceof XslSort) {
            this._sorts.add((XslSort)node);
        } else {
            super.addChild(node);
        }
    }

    @Override
    public void generate(JavaWriter out) throws Exception {
        AbstractPattern selectPattern = null;
        if (this._select != null) {
            selectPattern = this.parseSelect(this._select);
        }
        Sort[] sort = null;
        if (this._sorts.size() > 0) {
            sort = new Sort[this._sorts.size()];
            for (int i = 0; i < this._sorts.size(); ++i) {
                sort[i] = this._sorts.get(i).generateSort();
            }
        }
        if (sort != null && selectPattern == null) {
            selectPattern = this.parseSelect("*");
        }
        this.pushCall(out);
        this.generateChildren(out);
        this.printApplyTemplates(out, selectPattern, this._mode, sort);
        this.popCall(out);
    }

    private void printApplyTemplates(JavaWriter out, AbstractPattern select, String mode, Sort[] sort) throws Exception {
        int min = 0;
        int max = Integer.MAX_VALUE;
        String applyName = "applyNode" + this._gen.getModeName(mode);
        String env = "_xsl_arg" + this._gen.getCallDepth();
        if (select == null && sort == null) {
            out.println("for (Node _xsl_node = node.getFirstChild();");
            out.println("     _xsl_node != null;");
            out.println("     _xsl_node = _xsl_node.getNextSibling()) {");
            out.println("  " + env + ".setSelect(node, null);");
            out.println("  " + env + ".setCurrentNode(_xsl_node);");
            out.println("  " + applyName + "(out, _xsl_node, " + env + ", " + min + ", " + max + ");");
            out.println("}");
        } else if (sort == null) {
            int oldSelectDepth = this._gen.getSelectDepth();
            String name = this.printSelectBegin(out, select, false, null);
            out.println(env + ".setSelect(node, _select_patterns[" + this._gen.addSelect(select) + "]);");
            out.println(env + ".setCurrentNode(" + name + ");");
            out.println(applyName + "(out, " + name + ", " + env + ", " + min + ", " + max + ");");
            while (this._gen.getSelectDepth() > oldSelectDepth) {
                out.popDepth();
                out.println("}");
                this._gen.popSelectDepth();
            }
        } else {
            int sortIndex = this._gen.addSort(sort);
            out.println("{");
            out.pushDepth();
            out.println("ArrayList _xsl_list = xslSort(node, env, _select_patterns[" + this._gen.addSelect(select) + "], _xsl_sorts[" + sortIndex + "]);");
            out.println(env + ".setContextSize(_xsl_list.size());");
            out.println("for (int _xsl_i = 0; _xsl_i < _xsl_list.size(); _xsl_i++) {");
            out.println("  " + env + ".setContextPosition(_xsl_i + 1);");
            out.println("  " + applyName + "(out, (Node) _xsl_list.get(_xsl_i), " + env + ", " + min + ", " + max + ");");
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }

    @Override
    protected void popScope(JavaWriter out) throws Exception {
    }
}

