/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2.readers;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml2.XmlChar;
import com.caucho.xml2.XmlParser;
import java.io.IOException;
import org.xml.sax.SAXException;

public class XmlReader {
    static final L10N L = new L10N(XmlReader.class);
    protected static boolean[] isAsciiNameChar = XmlChar.getAsciiNameCharArray();
    protected XmlParser _parser;
    protected XmlReader _next;
    protected Path _searchPath;
    protected ReadStream _is;
    protected String _filename;
    protected int _line;
    protected String _systemId;
    protected String _publicId;

    public XmlReader() {
    }

    public XmlReader(XmlParser parser, ReadStream is) {
        this.init(parser, is);
    }

    public void init(XmlParser parser, ReadStream is) {
        this._parser = parser;
        this._is = is;
        this._filename = is.getUserPath();
        this._line = 1;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public int getLine() {
        return this._line;
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setPublicId(String publicId) {
        this._publicId = publicId;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public void setSearchPath(Path searchPath) {
        this._searchPath = searchPath;
    }

    public Path getSearchPath() {
        return this._searchPath;
    }

    public void setNext(XmlReader next) {
        this._next = next;
    }

    public XmlReader getNext() {
        return this._next;
    }

    public ReadStream getReadStream() {
        return this._is;
    }

    public int read() throws IOException {
        int ch = this._is.readChar();
        if (ch == 10) {
            this._parser.setLine(++this._line);
        }
        return ch;
    }

    public int parseName(CharBuffer name, int ch) throws IOException, SAXException {
        char[] buffer = name.getBuffer();
        int capacity = buffer.length;
        int offset = 0;
        buffer[offset++] = (char)ch;
        ch = this.read();
        while (ch > 0 && ch < 128 && isAsciiNameChar[ch] || XmlChar.isNameChar(ch)) {
            if (offset >= capacity) {
                name.setLength(offset);
                name.append((char)ch);
                ++offset;
                buffer = name.getBuffer();
                capacity = buffer.length;
            } else {
                buffer[offset++] = (char)ch;
            }
            ch = this.read();
        }
        name.setLength(offset);
        return ch;
    }

    public void finish() {
        this._is = null;
    }
}

