/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.Vfs;
import com.caucho.xml.ExtendedLocator;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xml2.AttributesImpl;
import com.caucho.xml2.Intern;
import com.caucho.xml2.InternQName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderImpl
implements XMLReader {
    private static final L10N L = new L10N(XMLReaderImpl.class);
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    static final QName DOC_NAME = new QName(null, "#document", null);
    static final QName TEXT_NAME = new QName(null, "#text", null);
    static final QName JSP_NAME = new QName(null, "#jsp", null);
    static final QName WHITESPACE_NAME = new QName(null, "#whitespace", null);
    static final QName JSP_ATTRIBUTE_NAME = new QName("xtp", "jsp-attribute", null);
    static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final boolean[] XML_NAME_CHAR = new boolean[65536];
    private ContentHandler _contentHandler;
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    private ErrorHandler _errorHandler;
    private Reader _reader;
    private final AttributesImpl _attributes = new AttributesImpl();
    private final ExtendedLocator _locator = new LocatorImpl();
    private final Intern _intern = new Intern();
    private final HashMap<NameKey, QName> _nameMap = new HashMap();
    private final NameKey _nameKey = new NameKey();
    private char[] _valueBuf;
    private char[] _inputBuf;
    private int _inputOffset;
    private int _inputLength;
    private String _filename;
    private String _systemId;
    private String _publicId;
    private int _line;

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!LEXICAL_HANDLER.equals(name)) {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this._errorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    @Override
    public void parse(InputSource source) throws IOException, SAXException {
        InputStream is = source.getByteStream();
        if (is != null) {
            this._systemId = source.getSystemId();
            if (is instanceof ReadStream) {
                this._filename = ((ReadStream)is).getPath().getUserPath();
                if (this._systemId == null) {
                    this._systemId = ((ReadStream)is).getPath().getURL();
                }
            } else {
                this._filename = this._systemId;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this._reader = new InputStreamReader(is);
        this.parseImpl();
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        ReadStream is = Vfs.lookup((String)systemId).openRead();
        this._reader = is.getReader();
        this._systemId = systemId;
        this._filename = systemId;
        try {
            this.parseImpl();
        }
        finally {
            this._reader = null;
        }
    }

    private void parseImpl() throws IOException, SAXException {
        TempCharBuffer inputBuffer = TempCharBuffer.allocate();
        TempCharBuffer valueBuffer = TempCharBuffer.allocate();
        try {
            this._valueBuf = valueBuffer.getBuffer();
            this._inputBuf = inputBuffer.getBuffer();
            this._inputLength = 0;
            this._inputOffset = 0;
            this._line = 1;
            this._contentHandler.setDocumentLocator((Locator)this._locator);
            this._contentHandler.startDocument();
            this.parseContent();
            this._contentHandler.endDocument();
        }
        finally {
            this._inputBuf = null;
            this._valueBuf = null;
            TempCharBuffer.free((TempCharBuffer)inputBuffer);
            TempCharBuffer.free((TempCharBuffer)valueBuffer);
        }
    }

    private void parseContent() throws IOException, SAXException {
        char[] inputBuf = this._inputBuf;
        char[] valueBuffer = this._valueBuf;
        int valueLength = valueBuffer.length;
        int valueOffset = 0;
        boolean isWhitespace = true;
        boolean seenCr = false;
        block12: while (true) {
            if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                this.writeText(valueBuffer, valueOffset, isWhitespace);
                return;
            }
            char ch = inputBuf[this._inputOffset++];
            switch (ch) {
                case '\t': 
                case ' ': {
                    if (valueOffset < valueLength) {
                        valueBuffer[valueOffset++] = ch;
                        continue block12;
                    }
                    this.writeText(valueBuffer, valueOffset, isWhitespace);
                    valueOffset = 0;
                    continue block12;
                }
                case '\n': {
                    if (valueOffset < valueLength) {
                        valueBuffer[valueOffset++] = ch;
                    } else {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    ++this._line;
                    continue block12;
                }
                case '\r': {
                    if (valueOffset < valueLength) {
                        valueBuffer[valueOffset++] = ch;
                    } else {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    this.addCarriageReturnLine();
                    continue block12;
                }
                case '<': {
                    if (valueOffset > 0) {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                        this.error("XXX: unexpected eof");
                    }
                    ch = inputBuf[this._inputOffset];
                    switch (ch) {
                        case '!': {
                            break;
                        }
                        case '?': {
                            break;
                        }
                        case '/': {
                            ++this._inputOffset;
                            return;
                        }
                        default: {
                            this.parseElement();
                        }
                    }
                    isWhitespace = true;
                    continue block12;
                }
                case '&': {
                    if (valueOffset > 0) {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    isWhitespace = true;
                    continue block12;
                }
            }
            isWhitespace = false;
            if (valueOffset < valueLength) {
                valueBuffer[valueOffset++] = ch;
                continue;
            }
            this.writeText(valueBuffer, valueOffset, false);
            valueOffset = 0;
        }
    }

    private void parseElement() throws IOException, SAXException {
        int ch;
        InternQName qName = this.parseName();
        String name = qName.getName();
        this._attributes.clear();
        block8: while (true) {
            ch = this.read();
            switch (ch) {
                case -1: {
                    throw this.error("XXX: unexpected eof");
                }
                case 9: 
                case 32: {
                    continue block8;
                }
                case 13: {
                    this.addCarriageReturnLine();
                    continue block8;
                }
                case 10: {
                    ++this._line;
                    continue block8;
                }
                case 47: {
                    ch = this.read();
                    if (ch != 62) {
                        throw this.error("XXX: expected '>'");
                    }
                    this._contentHandler.startElement("", "", name, this._attributes);
                    this._contentHandler.endElement("", "", name);
                    return;
                }
                case 62: {
                    this._contentHandler.startElement("", "", name, this._attributes);
                    this.parseContent();
                    InternQName tailQName = this.parseName();
                    String tailName = tailQName.getName();
                    ch = this.read();
                    if (ch != 62) {
                        throw this.error("XXX: expected '>'");
                    }
                    if (!name.equals(tailName)) {
                        throw this.error("XXX: mismatch name");
                    }
                    this._contentHandler.endElement("", "", name);
                    return;
                }
            }
            if (!XmlChar.isNameStart((int)ch)) break;
            this.unread();
            InternQName attrName = this.parseName();
            ch = this.skipWhitespace(this.read());
            if (ch != 61) {
                throw this.error(L.l("Expected '=' for attribute value at {0}.", (Object)this.badChar(ch)));
            }
            String attrValue = this.parseValue();
            this._attributes.add(attrName, attrValue);
        }
        throw this.error(L.l("{0} is an unexpected character in element.", (Object)this.badChar(ch)));
    }

    private QName parseAttrName() throws IOException {
        int valueOffset = 0;
        char[] inputBuf = this._inputBuf;
        char[] valueBuf = this._valueBuf;
        int inputLength = this._inputLength;
        int inputOffset = this._inputOffset;
        while (true) {
            char ch;
            if (inputOffset >= inputLength) {
                if (this.fillBuffer()) {
                    inputLength = this._inputLength;
                    inputOffset = 0;
                } else {
                    this._nameKey.init(valueBuf, 0, valueOffset);
                    QName name = this._nameMap.get(this._nameKey);
                    if (name == null) {
                        name = new QName(new String(valueBuf, 0, valueOffset), null);
                        this._nameMap.put(new NameKey(valueBuf, 0, valueOffset), name);
                    }
                    return name;
                }
            }
            if (XML_NAME_CHAR[ch = inputBuf[inputOffset++]]) {
                valueBuf[valueOffset++] = ch;
                continue;
            }
            if (ch != ':') break;
            valueBuf[valueOffset++] = ch;
        }
        this._inputOffset = inputOffset - 1;
        QName name = this._nameMap.get(this._nameKey);
        if (name == null) {
            name = new QName(new String(valueBuf, 0, valueOffset), null);
            this._nameMap.put(new NameKey(valueBuf, 0, valueOffset), name);
        }
        return name;
    }

    private InternQName parseName() throws IOException {
        int valueOffset = 0;
        char[] inputBuf = this._inputBuf;
        char[] valueBuf = this._valueBuf;
        int inputLength = this._inputLength;
        int inputOffset = this._inputOffset;
        int colon = 0;
        while (true) {
            if (inputOffset < inputLength) {
                char ch;
                if (XML_NAME_CHAR[ch = inputBuf[inputOffset++]]) {
                    valueBuf[valueOffset++] = ch;
                    continue;
                }
                if (ch == ':') {
                    if (colon <= 0) {
                        colon = valueOffset;
                    }
                    valueBuf[valueOffset++] = ch;
                    continue;
                }
                this._inputOffset = inputOffset - 1;
                return this._intern.add(valueBuf, 0, valueOffset, colon);
            }
            if (!this.fillBuffer()) break;
            inputLength = this._inputLength;
            inputOffset = 0;
        }
        return this._intern.add(valueBuf, 0, valueOffset, colon);
    }

    private void writeText(char[] buffer, int length, boolean isWhitespace) throws SAXException {
    }

    private void addCarriageReturnLine() throws IOException {
        if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
            ++this._line;
        } else if (this._inputBuf[this._inputOffset] != '\n') {
            ++this._line;
        }
    }

    private String parseValue() throws IOException, SAXException {
        int end = this.skipWhitespace(this.read());
        if (end != 39 && end != 34) {
            throw this.error(L.l("expected quote at '{0}'", (Object)this.badChar(end)));
        }
        int index = 0;
        char[] inputBuf = this._inputBuf;
        char[] valueBuf = this._valueBuf;
        while (true) {
            if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                throw this.error(L.l("Unexpected end of file in attribute value."));
            }
            int ch = inputBuf[this._inputOffset++];
            switch (ch) {
                case 38: {
                    throw this.error(L.l("Can't handle entities yet."));
                }
                case 13: {
                    this.addCarriageReturnLine();
                    ch = 32;
                    break;
                }
                case 10: {
                    ++this._line;
                    ch = 32;
                    break;
                }
                case 34: 
                case 39: {
                    if (ch != end) break;
                    return new String(valueBuf, 0, index);
                }
            }
            valueBuf[index++] = ch;
        }
    }

    private int skipWhitespace(int ch) throws IOException {
        while (true) {
            switch (ch) {
                case -1: {
                    return -1;
                }
                case 9: 
                case 32: {
                    break;
                }
                case 13: {
                    this.addCarriageReturnLine();
                    break;
                }
                case 10: {
                    ++this._line;
                    break;
                }
                default: {
                    return ch;
                }
            }
            if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                return -1;
            }
            ch = this._inputBuf[this._inputOffset++];
        }
    }

    private int read() throws IOException {
        if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
            return -1;
        }
        return this._inputBuf[this._inputOffset++];
    }

    private void unread() throws IOException {
        --this._inputOffset;
    }

    private boolean fillBuffer() throws IOException {
        this._inputOffset = 0;
        this._inputLength = this._reader.read(this._inputBuf, 0, this._inputBuf.length);
        return this._inputLength > 0;
    }

    private String badChar(int ch) {
        return "" + (char)ch;
    }

    private SAXException error(String msg) {
        return new SAXException(msg);
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            XMLReaderImpl.XML_NAME_CHAR[i] = XmlChar.isNameChar((int)i) && i != 58;
        }
    }

    static class NameKey {
        char[] _buf;
        int _offset;
        int _length;

        NameKey() {
        }

        NameKey(char[] buf, int offset, int length) {
            this._buf = new char[length];
            System.arraycopy(buf, offset, this._buf, 0, length);
            this._offset = 0;
            this._length = 0;
        }

        void init(char[] buf, int offset, int length) {
            this._buf = buf;
            this._offset = offset;
            this._length = length;
        }

        public int hashCode() {
            int hash = 37;
            char[] buf = this._buf;
            for (int i = this._length - 1; i >= 0; --i) {
                hash = 65537 * hash + buf[i];
            }
            return hash;
        }

        public boolean equals(Object o) {
            NameKey key = (NameKey)o;
            int length = this._length;
            if (length != key._length) {
                return false;
            }
            char[] aBuf = this._buf;
            char[] bBuf = key._buf;
            int aOffset = this._offset;
            int bOffset = key._offset;
            for (int i = 0; i < length; ++i) {
                if (aBuf[aOffset + i] == bBuf[bOffset + i]) continue;
                return false;
            }
            return true;
        }
    }

    class LocatorImpl
    implements ExtendedLocator {
        LocatorImpl() {
        }

        public String getSystemId() {
            return XMLReaderImpl.this._systemId;
        }

        public String getFilename() {
            return XMLReaderImpl.this._filename;
        }

        public String getPublicId() {
            return XMLReaderImpl.this._publicId;
        }

        public int getLineNumber() {
            return XMLReaderImpl.this._line;
        }

        public int getColumnNumber() {
            return -1;
        }
    }
}

