/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import sun.security.x509.X500Name;

public class SelfSignedCert
implements Serializable {
    private static final L10N L = new L10N(SelfSignedCert.class);
    private static final Logger log = Logger.getLogger(SelfSignedCert.class.getName());
    private X509Certificate _cert;
    private PrivateKey _key;
    private transient KeyManagerFactory _kmf;

    private SelfSignedCert(X509Certificate cert, PrivateKey key) throws Exception {
        this._cert = cert;
        this._key = key;
        this._kmf = this.getKeyManagerFactory();
    }

    public static SelfSignedCert create(String name, String[] cipherSuites) {
        try {
            String keyAlgName = null;
            String sigAlgName = null;
            if (cipherSuites != null) {
                for (String s : cipherSuites) {
                    if (s.indexOf("RSA") >= 0 && s.indexOf("SHA") >= 0) {
                        keyAlgName = "RSA";
                        sigAlgName = "SHA1WithRSA";
                        continue;
                    }
                    if (sigAlgName == null && s.indexOf("DSS") >= 0 && s.indexOf("SHA") >= 0) {
                        keyAlgName = "DSA";
                        sigAlgName = "SHA1WithDSA";
                        continue;
                    }
                    if (sigAlgName != null || s.indexOf("RSA") < 0 || s.indexOf("MD5") < 0) continue;
                    keyAlgName = "RSA";
                    sigAlgName = "MD5WithRSA";
                }
            }
            if (sigAlgName == null) {
                keyAlgName = "RSA";
                sigAlgName = "SHA1WithRSA";
            }
            String providerName = null;
            int keysize = 1024;
            int days = 365;
            CertAndKeyGen keypair = new CertAndKeyGen(keyAlgName, sigAlgName, providerName);
            keypair.generate(keysize);
            PrivateKey privKey = keypair.getPrivateKey();
            X500Name x500name = new X500Name("CN=" + name);
            X509Certificate cert = keypair.getSelfCertificate(x500name, days * 24 * 3600);
            return new SelfSignedCert(cert, privKey);
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((String)L.l("SelfSigned certificates require Sun JDK\n  {0}", (Object)e), (Throwable)e);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            e.printStackTrace();
            return null;
        }
    }

    public PrivateKey getPrivateKey() {
        return this._key;
    }

    public X509Certificate[] getCertificateChain() {
        return new X509Certificate[]{this._cert};
    }

    public boolean isExpired() {
        long expiry = this._cert.getNotAfter().getTime() - 43200000L;
        boolean isExpired = expiry < System.currentTimeMillis();
        return isExpired;
    }

    public KeyManager[] getKeyManagers() {
        try {
            return this.getKeyManagerFactory().getKeyManagers();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException, IOException, GeneralSecurityException {
        if (this._kmf == null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, "password".toCharArray());
            ks.setKeyEntry("anonymous", this.getPrivateKey(), "key-password".toCharArray(), this.getCertificateChain());
            kmf.init(ks, "key-password".toCharArray());
            this._kmf = kmf;
        }
        return this._kmf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cert.getSubjectX500Principal() + "]";
    }

    static class CertAndKeyGen {
        private Class<?> _cls;
        private Object _obj;

        public CertAndKeyGen(String keyAlgName, String sigAlgName, String providerName) throws Exception {
            String clsName = "sun.security.x509.CertAndKeyGen";
            String clsName2 = "sun.security.tools.keytool.CertAndKeyGen";
            try {
                this._cls = Class.forName(clsName);
            }
            catch (Exception e) {
                this._cls = Class.forName(clsName2);
            }
            if (this._cls == null) {
                throw new ConfigException(L.l("cannot find {0} nor {1}", (Object)clsName, (Object)clsName2));
            }
            Constructor<?> cons = this._cls.getConstructor(String.class, String.class, String.class);
            this._obj = cons.newInstance(keyAlgName, sigAlgName, providerName);
        }

        public void generate(int keySize) throws Exception {
            Method method = this._cls.getMethod("generate", Integer.TYPE);
            method.invoke(this._obj, keySize);
        }

        public PrivateKey getPrivateKey() throws Exception {
            Method method = this._cls.getMethod("getPrivateKey", new Class[0]);
            Object result = method.invoke(this._obj, new Object[0]);
            return (PrivateKey)result;
        }

        public X509Certificate getSelfCertificate(X500Name name, long days) throws Exception {
            Method method = this._cls.getMethod("getSelfCertificate", X500Name.class, Long.TYPE);
            Object result = method.invoke(this._obj, name, days);
            return (X509Certificate)result;
        }
    }
}

