/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.tools.profiler.XAConnectionWrapper;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public final class XADataSourceWrapper
implements XADataSource {
    private final ProfilerPoint _profilerPoint;
    private final XADataSource _dataSource;

    public XADataSourceWrapper(ProfilerPoint profilerPoint, XADataSource dataSource) {
        this._profilerPoint = profilerPoint;
        this._dataSource = dataSource;
    }

    private XAConnectionWrapper wrap(XAConnection connection) {
        return new XAConnectionWrapper(this._profilerPoint, connection);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.wrap(this._dataSource.getXAConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return this.wrap(this._dataSource.getXAConnection(user, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this._dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this._dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public String toString() {
        return "XADataSourceWrapper[" + this._profilerPoint.getName() + "]";
    }
}

