/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.tools.profiler.ResultSetWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public final class StatementWrapper
implements Statement {
    private final ProfilerPoint _parentProfilerPoint;
    private final Statement _statement;
    private ProfilerPoint _profilerPoint;

    public StatementWrapper(ProfilerPoint profilerPoint, Statement statement) {
        this._parentProfilerPoint = profilerPoint;
        this._profilerPoint = profilerPoint;
        this._statement = statement;
    }

    private void setSql(String sql) {
        this._profilerPoint = this._parentProfilerPoint.addProfilerPoint(sql);
    }

    private ResultSet wrap(ResultSet resultSet) {
        return new ResultSetWrapper(this._profilerPoint, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSet resultSet = this.wrap(this._statement.executeQuery(sql));
            return resultSet;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void close() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.close();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getMaxFieldSize();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setMaxFieldSize(max);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getMaxRows();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setMaxRows(max);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setEscapeProcessing(enable);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getQueryTimeout();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setQueryTimeout(seconds);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void cancel() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.cancel();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            SQLWarning sQLWarning = this._statement.getWarnings();
            return sQLWarning;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.clearWarnings();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setCursorName(name);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.wrap(this._statement.getResultSet());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getUpdateCount();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.getMoreResults();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setFetchDirection(direction);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getFetchDirection();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setFetchSize(rows);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getFetchSize();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getResultSetConcurrency();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getResultSetType();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.addBatch(sql);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.clearBatch();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int[] nArray = this._statement.executeBatch();
            return nArray;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Connection connection = this._statement.getConnection();
            return connection;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.getMoreResults(current);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.wrap(this._statement.getGeneratedKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql, columnIndexes);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql, columnNames);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getResultSetHoldability();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    public String toString() {
        return "StatementWrapper[" + this._profilerPoint.getName() + "]";
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

