/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.spy.SpyXAConnection;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SpyXADataSource
implements XADataSource {
    protected static final Logger log = Logger.getLogger(SpyXADataSource.class.getName());
    protected static final L10N L = new L10N(SpyXADataSource.class);
    private static int _staticId;
    private int _id;
    private int _connCount;
    private XADataSource _dataSource;

    public SpyXADataSource(XADataSource dataSource) {
        this._dataSource = dataSource;
        this._id = _staticId++;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        long start = this.start();
        try {
            XAConnection conn = this._dataSource.getXAConnection();
            String connId = this._id + "." + this._connCount++;
            this.log(start, "getXAConnection() -> " + connId + ":" + conn);
            return new SpyXAConnection(conn, connId);
        }
        catch (SQLException e) {
            this.log(start, "exn-connect(" + e + ")");
            throw e;
        }
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        long start = this.start();
        try {
            XAConnection conn = this._dataSource.getXAConnection(user, password);
            String connId = this._id + "." + this._connCount++;
            this.log(start, "getXAConnection(" + user + ") -> " + connId + ":" + conn);
            return new SpyXAConnection(conn, connId);
        }
        catch (SQLException e) {
            this.log(start, "exn-connect(" + e + ")");
            throw e;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this._dataSource.setLoginTimeout(timeout);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter log) throws SQLException {
        this._dataSource.setLogWriter(log);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    protected long start() {
        return CurrentTime.getExactTime();
    }

    protected void log(long start, String msg) {
        long delta = CurrentTime.getExactTime() - start;
        log.fine("[" + delta + "ms] " + this._id + ":" + msg);
    }

    public String toString() {
        return "SpyXADataSource[id=" + this._id + ",data-source=" + this._dataSource + "]";
    }
}

