/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.env.dbpool.IdlePoolSet;
import com.caucho.server.cluster.ServletService;
import com.caucho.sql.ConnectionConfig;
import com.caucho.sql.Credential;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.DriverConfig;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.UserDataSource;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;

public class ManagedFactoryImpl
implements ManagedConnectionFactory,
ValidatingManagedConnectionFactory {
    protected static final Logger log = Logger.getLogger(ManagedFactoryImpl.class.getName());
    private static final L10N L = new L10N(ManagedFactoryImpl.class);
    private DBPoolImpl _dbPool;
    private DriverConfig[] _drivers;
    private DriverConfig[] _backupDrivers;
    private long _roundRobin;

    ManagedFactoryImpl(DBPoolImpl dbPool, DriverConfig[] drivers, DriverConfig[] backupDrivers) {
        ClusterServer selfServer;
        this._dbPool = dbPool;
        this._drivers = drivers;
        this._backupDrivers = backupDrivers;
        ServletService server = ServletService.getCurrent();
        if (server != null && (selfServer = server.getSelfServer()) != null && this._drivers.length > 1) {
            this._roundRobin = selfServer.getIndex() % this._drivers.length;
        }
    }

    public DBPoolImpl getDBPool() {
        return this._dbPool;
    }

    public String getURL() {
        if (this._drivers.length > 0) {
            return this._drivers[0].getURL();
        }
        if (this._backupDrivers.length > 0) {
            return this._backupDrivers[0].getURL();
        }
        return null;
    }

    ConnectionConfig getConnectionConfig() {
        return this._dbPool.getConnectionConfig();
    }

    public Object createConnectionFactory(ConnectionManager connManager) throws ResourceException {
        return new UserDataSource(this, connManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo requestInfo) throws ResourceException {
        DriverConfig driver;
        int index;
        int i;
        Credential credential = (Credential)requestInfo;
        SQLException exn = null;
        for (i = 0; i < this._drivers.length; ++i) {
            index = (int)(this._roundRobin++ % (long)this._drivers.length);
            driver = this._drivers[index];
            try {
                return new ManagedConnectionImpl(this, driver, this._dbPool.getConnectionConfig(), credential);
            }
            catch (SQLException e) {
                exn = e;
                continue;
            }
        }
        for (i = 0; i < this._backupDrivers.length; ++i) {
            index = (int)(this._roundRobin++ % (long)this._backupDrivers.length);
            driver = this._backupDrivers[index];
            try {
                return new ManagedConnectionImpl(this, driver, this._dbPool.getConnectionConfig(), credential);
            }
            catch (SQLException e) {
                exn = e;
                continue;
            }
        }
        if (exn != null) {
            throw new ResourceException(exn);
        }
        throw new ResourceException(L.l("Can't create a database connection because no drivers have been defined."));
    }

    public ManagedConnection matchManagedConnections(Set connSet, Subject subject, ConnectionRequestInfo requestInfo) throws ResourceException {
        Credential mCredentials;
        if (connSet instanceof IdlePoolSet) {
            IdlePoolSet idle = (IdlePoolSet)connSet;
            ManagedConnectionImpl mConn = (ManagedConnectionImpl)idle.first();
            if (mConn == null) {
                return null;
            }
            mCredentials = mConn.getCredentials();
            if (requestInfo == mCredentials || requestInfo != null && requestInfo.equals((Object)mCredentials)) {
                return mConn;
            }
        }
        for (ManagedConnectionImpl mConn : connSet) {
            mCredentials = mConn.getCredentials();
            if (requestInfo != mCredentials && (requestInfo == null || !requestInfo.equals((Object)mCredentials))) continue;
            return mConn;
        }
        return null;
    }

    public Set getInvalidConnections(Set connSet) throws ResourceException {
        Iterator iter = connSet.iterator();
        HashSet<ManagedConnectionImpl> invalidSet = null;
        while (iter.hasNext()) {
            ManagedConnectionImpl mConn = (ManagedConnectionImpl)iter.next();
            if (mConn.isValid()) continue;
            if (invalidSet == null) {
                invalidSet = new HashSet<ManagedConnectionImpl>();
            }
            invalidSet.add(mConn);
        }
        return invalidSet;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter adapter) {
    }

    public String toString() {
        return "ManagedFactoryImpl[" + this._dbPool + "]";
    }
}

