/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.webdav;

import com.caucho.server.webapp.WebApp;
import com.caucho.servlets.webdav.AbstractPath;
import com.caucho.servlets.webdav.ApplicationPath;
import com.caucho.servlets.webdav.AttributeName;
import com.caucho.servlets.webdav.FilePath;
import com.caucho.util.CharBuffer;
import com.caucho.util.HTTPUtil;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebDavServlet
extends GenericServlet {
    private static final Logger log = Logger.getLogger(WebDavServlet.class.getName());
    private QDate _calendar = new QDate();
    private boolean _enable = false;
    private boolean _enableWrite = false;
    private boolean _addCrLf = false;
    private String _user;
    private String _role;
    private boolean _needsSecure;
    private AbstractPath _path;
    private String _root;

    public void setEnable(String enable) {
        if (enable == null || enable.equals("")) {
            return;
        }
        if (enable.equals("read")) {
            this._enable = true;
        } else if (enable.equals("write") || enable.equals("all") || enable.equals("yes") || enable.equals("true")) {
            this._enable = true;
            this._enableWrite = true;
        }
    }

    public void setRole(String role) {
        this._role = role;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public void setSecure(boolean needsSecure) {
        this._needsSecure = needsSecure;
    }

    public void setPathSource(AbstractPath path) {
        this._path = path;
    }

    public void setRoot(String root) {
        this._root = root;
    }

    public void setCrLf(boolean addCrLf) {
        this._addCrLf = addCrLf;
    }

    public void init() throws ServletException {
        String secure;
        String role;
        String enable = this.getInitParameter("enable");
        if (enable != null) {
            this.setEnable(enable);
        }
        if ((role = this.getInitParameter("role")) != null) {
            this.setRole(role);
        }
        if (this._role == null) {
            this._role = "webdav";
        } else if (this._role.equals("*")) {
            this._role = null;
        }
        String user = this.getInitParameter("user");
        if (user != null) {
            this.setUser(user);
        }
        if ((secure = this.getInitParameter("secure")) != null) {
            this._needsSecure = !"false".equalsIgnoreCase(secure) && !"no".equalsIgnoreCase(secure);
        }
        String pathSource = this.getInitParameter("path-source");
        try {
            if (pathSource != null) {
                Context env = (Context)new InitialContext().lookup("java:comp/env");
                this._path = (AbstractPath)env.lookup(pathSource);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            if (pathSource != null && this._path == null) {
                this._path = (AbstractPath)new InitialContext().lookup(pathSource);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String root = this.getInitParameter("root");
        if (this._path == null) {
            if (this._root != null) {
                Path pwd = ((WebApp)this.getServletContext()).getRootDirectory();
                this._path = new FilePath(pwd.lookup(this._root));
            } else if (root != null) {
                Path pwd = ((WebApp)this.getServletContext()).getRootDirectory();
                this._path = new FilePath(pwd.lookup(root));
            } else {
                this._path = new ApplicationPath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!this._enable) {
            res.sendError(403);
            return;
        }
        if (this._needsSecure && !req.isSecure()) {
            res.sendError(403);
            return;
        }
        if (this._role != null && !req.isUserInRole(this._role)) {
            res.sendError(403);
            return;
        }
        if (this._user != null) {
            Principal principal = req.getUserPrincipal();
            if (principal == null) {
                res.sendError(403);
                return;
            }
            if (!principal.getName().equals(this._user)) {
                res.sendError(403);
                return;
            }
        }
        ServletContext app = this.getServletContext();
        String requestURI = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        String depthString = req.getHeader("Depth");
        int depth = Integer.MAX_VALUE;
        ServletOutputStream os = res.getOutputStream();
        WriteStream out = Vfs.openWrite((OutputStream)os);
        out.setEncoding("UTF-8");
        if (this._addCrLf) {
            out.setNewlineString("\r\n");
        }
        try {
            if ("0".equals(depthString)) {
                depth = 0;
            } else if ("1".equals(depthString)) {
                depth = 1;
            }
            if (req.getMethod().equals("OPTIONS")) {
                res.setHeader("DAV", "1");
                res.setHeader("MS-Author-Via", "DAV");
                if (this._enableWrite) {
                    res.setHeader("Allow", "OPTIONS, PROPFIND, GET, HEAD, PUT, MKCOL, DELETE, COPY, MOVE, PROPPATCH");
                } else if (this._enable) {
                    res.setHeader("Allow", "OPTIONS, PROPFIND, GET, HEAD");
                }
            } else if (req.getMethod().equals("PROPFIND")) {
                this.handlePropfind(req, res, out, depth);
            } else if (req.getMethod().equals("GET") || req.getMethod().equals("HEAD")) {
                this.handleGet(req, res, out);
            } else if (req.getMethod().equals("PUT") && this._enableWrite) {
                this.handlePut(req, res, out);
            } else if (req.getMethod().equals("MKCOL") && this._enableWrite) {
                this.handleMkcol(req, res, out);
            } else if (req.getMethod().equals("DELETE") && this._enableWrite) {
                this.handleDelete(req, res, out);
            } else if (req.getMethod().equals("COPY") && this._enableWrite) {
                this.handleCopy(req, res, out, depth);
            } else if (req.getMethod().equals("MOVE") && this._enableWrite) {
                this.handleMove(req, res, out);
            } else if (req.getMethod().equals("PROPPATCH") && this._enableWrite) {
                this.handleProppatch(req, res, out, depth);
            } else if (!this._enableWrite && "PUT".equals(req.getMethod()) || "MKCOL".equals(req.getMethod()) || "DELETE".equals(req.getMethod()) || "COPY".equals(req.getMethod()) || "MOVE".equals(req.getMethod()) || "PROPPATCH".equals(req.getMethod())) {
                res.sendError(403);
            } else {
                res.sendError(501, "Method not implemented");
            }
        }
        finally {
            out.close();
        }
    }

    private void handlePropfind(HttpServletRequest req, HttpServletResponse res, WriteStream out, int depth) throws ServletException, IOException {
        ServletInputStream is = req.getInputStream();
        PropfindHandler handler = new PropfindHandler();
        XmlParser parser = new XmlParser();
        parser.setContentHandler((ContentHandler)handler);
        try {
            parser.parse((InputStream)is);
        }
        catch (SAXException e) {
            this.sendError(res, out, 400, "Bad Request for PROPFIND", String.valueOf(e));
            return;
        }
        WebApp app = (WebApp)this.getServletContext();
        Path appDir = app.getRootDirectory();
        String pathInfo = req.getPathInfo();
        String uriPwd = app.getContextPath() + req.getServletPath();
        if (pathInfo == null) {
            pathInfo = "/";
        } else {
            uriPwd = uriPwd + pathInfo;
        }
        if (this._path.isDirectory(pathInfo, req, app) && !uriPwd.endsWith("/")) {
            uriPwd = uriPwd + "/";
        }
        ServletContext rootApp = app.getContext("/");
        ArrayList<AttributeName> properties = handler.getProperties();
        boolean isPropname = handler.isPropname();
        if (properties.size() == 0) {
            this.addAllProperties(properties, pathInfo, req, app);
        }
        this.startMultistatus(res, out);
        this.printPathProperties(out, req, app, uriPwd, pathInfo, properties, isPropname, depth);
        out.println("</D:multistatus>");
    }

    private void handleProppatch(HttpServletRequest req, HttpServletResponse res, WriteStream out, int depth) throws ServletException, IOException {
        ServletInputStream is = req.getInputStream();
        ProppatchHandler handler = new ProppatchHandler();
        XmlParser parser = new XmlParser();
        parser.setContentHandler((ContentHandler)handler);
        try {
            parser.parse((InputStream)is);
        }
        catch (SAXException e) {
            this.sendError(res, out, 400, "Bad Request for PROPPATCH", "Bad Request: " + e);
            return;
        }
        WebApp app = (WebApp)this.getServletContext();
        Path appDir = app.getRootDirectory();
        String pathInfo = req.getPathInfo();
        String uriPwd = app.getContextPath() + req.getServletPath();
        if (pathInfo == null) {
            pathInfo = "/";
        } else {
            uriPwd = uriPwd + pathInfo;
        }
        if (this._path.isDirectory(pathInfo, req, app) && !uriPwd.endsWith("/")) {
            uriPwd = uriPwd + "/";
        }
        ArrayList forbidden = new ArrayList();
        this.startMultistatus(res, out);
        out.println("<D:response>");
        out.println("<D:href>" + this.escapeXml(uriPwd) + "</D:href>");
        ArrayList properties = new ArrayList();
        ArrayList<ProppatchCommand> commands = handler.getCommands();
        for (int i = 0; i < commands.size(); ++i) {
            ProppatchCommand command = commands.get(i);
            int code = command.getCode();
            AttributeName name = command.getName();
            String value = command.getValue();
            out.println("<D:propstat><D:prop><" + name.getName() + " xmlns:" + name.getPrefix() + "=\"" + name.getNamespace() + "\"/>");
            if (code == ProppatchCommand.SET) {
                this._path.setAttribute(name, value, pathInfo, req, app);
                out.println("<D:status>HTTP/1.1 200 OK</D:status>");
            } else if (code == ProppatchCommand.REMOVE) {
                this._path.removeAttribute(name, pathInfo, req, app);
                out.println("<D:status>HTTP/1.1 200 OK</D:status>");
            } else {
                out.println("<D:status>HTTP/1.1 424 Failed</D:status>");
            }
            out.println("</D:prop></D:propstat>");
        }
        out.println("</D:response>");
        out.println("</D:multistatus>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePut(HttpServletRequest req, HttpServletResponse res, WriteStream out) throws ServletException, IOException {
        OutputStream os;
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if (!this._path.isDirectory(this.getParent(pathInfo), req, app)) {
            this.sendError(res, out, 409, "Conflict", "PUT requires a parent collection");
            return;
        }
        if (!this._path.exists(pathInfo, req, app)) {
            res.setStatus(201, "Created");
        } else {
            res.setStatus(204, "No Content");
        }
        try {
            os = this._path.openWrite(pathInfo, req, app);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            this.sendError(res, out, 403, "Forbidden", "PUT forbidden");
            return;
        }
        WriteStream ws = Vfs.openWrite((OutputStream)os);
        Path path = ws.getPath();
        try {
            ServletInputStream is = req.getInputStream();
            ws.writeStream((InputStream)is);
        }
        finally {
            ws.close();
        }
    }

    private void handleMkcol(HttpServletRequest req, HttpServletResponse res, WriteStream out) throws ServletException, IOException {
        res.setContentType("text/xml; charset=\"utf-8\"");
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if (this._path.exists(pathInfo, req, app)) {
            res.sendError(405, "Collection already exists");
            return;
        }
        if (!this._path.isDirectory(this.getParent(pathInfo), req, app)) {
            res.sendError(409, "MKCOL needs parent collection");
            return;
        }
        ServletInputStream is = req.getInputStream();
        int ch = is.read();
        if (ch >= 0) {
            res.sendError(415, "MKCOL doesn't understand content-type");
            return;
        }
        if (!this._path.mkdir(pathInfo, req, app)) {
            res.sendError(403, "MKCOL forbidden");
            return;
        }
        res.setHeader("Location", req.getRequestURI());
        this.sendError(res, out, 201, null, "Created collection " + HTTPUtil.encodeString((String)req.getRequestURI()));
    }

    private void addAllProperties(ArrayList<AttributeName> properties, String pathInfo, HttpServletRequest req, WebApp app) throws IOException, ServletException {
        properties.add(new AttributeName("DAV:", "resourcetype", "D:resourcetype"));
        properties.add(new AttributeName("DAV:", "getcontenttype", "D:getcontenttype"));
        properties.add(new AttributeName("DAV:", "getcontentlength", "D:getcontentlength"));
        properties.add(new AttributeName("DAV:", "creationdate", "D:creationdate"));
        properties.add(new AttributeName("DAV:", "getlastmodified", "D:getlastmodified"));
        Iterator iter = this._path.getAttributeNames(pathInfo, req, app);
        while (iter.hasNext()) {
            AttributeName name = (AttributeName)iter.next();
            if (properties.contains(name)) continue;
            properties.add(name);
        }
    }

    private void printPathProperties(WriteStream out, HttpServletRequest req, ServletContext app, String uri, String pathInfo, ArrayList<AttributeName> properties, boolean isPropname, int depth) throws IOException, ServletException {
        String qName;
        AttributeName prop;
        int j;
        out.println("<D:response>");
        out.print("<D:href>");
        out.print(this.escapeXml(uri));
        out.println("</D:href>");
        if (!this._path.exists(pathInfo, req, app)) {
            out.println("<D:propstat>");
            out.println("<D:status>HTTP/1.1 404 Not Found</D:status>");
            out.println("</D:propstat>");
            out.println("</D:response>");
            return;
        }
        ArrayList<AttributeName> unknownProperties = new ArrayList<AttributeName>();
        out.println("<D:propstat>");
        out.println("<D:prop>");
        boolean isDirectory = this._path.isDirectory(pathInfo, req, app);
        for (j = 0; j < properties.size(); ++j) {
            prop = properties.get(j);
            String localName = prop.getLocal();
            String propUri = prop.getNamespace();
            qName = prop.getName();
            String prefix = prop.getPrefix();
            if (isPropname) {
                if (propUri.equals("DAV:")) {
                    out.println("<D:" + localName + "/>");
                    continue;
                }
                if (prefix.equals("D")) {
                    prefix = "caucho-D";
                    qName = "caucho-D:" + localName;
                }
                String nsPrefix = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                out.println("<" + qName + " " + nsPrefix + "=\"" + propUri + "\"/>");
                continue;
            }
            String value = this._path.getAttribute(prop, pathInfo, req, app);
            if (value != null) {
                if (prefix.equals("D")) {
                    prefix = "caucho-D";
                    qName = "caucho-D:" + localName;
                }
                String nsPrefix = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                out.print("<" + qName + " " + nsPrefix + "=\"" + propUri + "\">");
                out.print(value);
                out.println("</" + prop.getName() + ">");
                continue;
            }
            if (!propUri.equals("DAV:")) {
                unknownProperties.add(prop);
                continue;
            }
            if (localName.equals("resourcetype")) {
                if (isDirectory) {
                    out.print("<D:resourcetype>");
                    out.print("<D:collection/>");
                    out.println("</D:resourcetype>");
                    continue;
                }
                out.println("<D:resourcetype/>");
                continue;
            }
            if (localName.equals("getcontentlength")) {
                out.print("<D:getcontentlength>");
                out.print(this._path.getLength(pathInfo, req, app));
                out.println("</D:getcontentlength>");
                continue;
            }
            if (localName.equals("getlastmodified")) {
                out.print("<D:getlastmodified>");
                out.print(QDate.formatGMT((long)this._path.getLastModified(pathInfo, req, app)));
                out.println("</D:getlastmodified>");
                continue;
            }
            if (localName.equals("creationdate")) {
                out.print("<D:creationdate>");
                long time = this._path.getLastModified(pathInfo, req, app);
                out.print(QDate.formatGMT((long)time, (String)"%Y-%m-%dT%H:%M:%SZ"));
                out.println("</D:creationdate>");
                continue;
            }
            if (localName.equals("displayname")) {
                int p;
                out.print("<D:displayname>");
                String name = pathInfo;
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((p = pathInfo.lastIndexOf(47)) > 0 && p < pathInfo.length()) {
                    name = pathInfo.substring(p + 1);
                }
                out.print(this.escapeXml(name));
                out.println("</D:displayname>");
                continue;
            }
            if (localName.equals("getcontenttype")) {
                String mimeType = app.getMimeType(uri);
                if (mimeType != null) {
                    out.print("<D:getcontenttype>");
                    out.print(mimeType);
                    out.println("</D:getcontenttype>");
                    continue;
                }
                out.println("<D:getcontenttype/>");
                continue;
            }
            unknownProperties.add(prop);
        }
        out.println("</D:prop>");
        out.println("<D:status>HTTP/1.1 200 OK</D:status>");
        out.println("</D:propstat>");
        if (unknownProperties.size() != 0) {
            out.println("<D:propstat>");
            out.println("<D:prop>");
            for (j = 0; j < unknownProperties.size(); ++j) {
                prop = (AttributeName)unknownProperties.get(j);
                if (prop.getNamespace().equals("DAV:")) {
                    out.println("<D:" + prop.getLocal() + "/>");
                    continue;
                }
                String prefix = prop.getPrefix();
                qName = prop.getName();
                if (prefix.equals("D")) {
                    prefix = "caucho-D";
                    qName = "caucho-D:" + prop.getLocal();
                }
                String nsPrefix = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                out.println("<" + qName + " " + nsPrefix + "=\"" + prop.getNamespace() + "\"/>");
            }
            out.println("</D:prop>");
            out.println("<D:status>HTTP/1.1 404 Not Found</D:status>");
            out.println("</D:propstat>");
        }
        out.println("</D:response>");
        if (depth > 0 && this._path.isDirectory(pathInfo, req, app)) {
            int i;
            String[] list = this._path.list(pathInfo, req, app);
            ArrayList<String> sortedList = new ArrayList<String>();
            for (i = 0; i < list.length; ++i) {
                sortedList.add(list[i]);
            }
            Collections.sort(sortedList);
            for (i = 0; i < sortedList.size(); ++i) {
                String filename = (String)sortedList.get(i);
                String suburi = uri.endsWith("/") ? uri + filename : uri + "/" + filename;
                String subpath = pathInfo.endsWith("/") ? pathInfo + filename : pathInfo + "/" + filename;
                if (this._path.isDirectory(subpath, req, app)) {
                    suburi = suburi + '/';
                }
                if (!this._path.canRead(subpath, req, app) || filename.startsWith(".") || filename.equals("CVS") || filename.endsWith("~")) continue;
                this.printPathProperties(out, req, app, suburi, subpath, properties, isPropname, depth - 1);
            }
        }
    }

    private void handleDelete(HttpServletRequest req, HttpServletResponse res, WriteStream out) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        String uri = req.getContextPath() + pathInfo;
        if (this._path.isFile(pathInfo, req, app)) {
            if (!this._path.remove(pathInfo, req, app)) {
                res.sendError(403, "Forbidden");
            } else {
                res.setStatus(204, "No Content");
            }
        } else if (this._path.isDirectory(pathInfo, req, app)) {
            if (this.deleteRecursive(req, res, out, uri, pathInfo, false)) {
                out.println("<D:status>HTTP/1.0 403 Forbidden</D:status>");
                out.println("</D:response>");
                out.println("</D:multistatus>");
            } else {
                res.setStatus(204, "No Content");
            }
        } else {
            res.sendError(404);
        }
    }

    private boolean deleteRecursive(HttpServletRequest req, HttpServletResponse res, WriteStream out, String uri, String pathInfo, boolean hasError) throws IOException {
        ServletContext app = this.getServletContext();
        boolean newError = false;
        if (this._path.isDirectory(pathInfo, req, app)) {
            String[] list = this._path.list(pathInfo, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    String suburi = this.lookup(uri, list[i]);
                    String subpath = this.lookup(pathInfo, list[i]);
                    hasError = this.deleteRecursive(req, res, out, suburi, subpath, hasError);
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            if (!this._path.rmdir(pathInfo, req, app)) {
                newError = true;
            }
        } else if (!this._path.remove(pathInfo, req, app)) {
            newError = true;
        }
        if (newError) {
            if (!hasError) {
                this.startMultistatus(res, out);
                out.println("<D:response>");
            }
            out.println("<D:href>" + this.escapeXml(uri) + "</D:href>");
            hasError = true;
        }
        return hasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCopy(HttpServletRequest req, HttpServletResponse res, WriteStream out, int depth) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if (depth == 1) {
            depth = Integer.MAX_VALUE;
        }
        if (!this._path.exists(pathInfo, req, app)) {
            res.sendError(404);
            return;
        }
        String destURI = this.getDestination(req);
        if (destURI == null) {
            res.sendError(403, "Forbidden");
            return;
        }
        String prefix = req.getContextPath();
        if (req.getServletPath() != null) {
            prefix = prefix + req.getServletPath();
        }
        if (!destURI.startsWith(prefix)) {
            res.sendError(403, "Forbidden");
            return;
        }
        String destPath = destURI.substring(prefix.length());
        if (destPath.equals(pathInfo)) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (destPath.startsWith(pathInfo) && (pathInfo.endsWith("/") || destPath.startsWith(pathInfo + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (pathInfo.startsWith(destPath) && (destPath.endsWith("/") || pathInfo.startsWith(destPath + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        String overwrite = req.getHeader("Overwrite");
        if (overwrite == null) {
            overwrite = "T";
        }
        if (!this._path.exists(destPath, req, app)) {
            res.setStatus(201);
        } else if (!overwrite.equals("F")) {
            this.removeRecursive(destPath, req);
            res.setStatus(204, "No Content");
        } else {
            res.sendError(412, "Overwrite not allowed for COPY");
            return;
        }
        if (!this._path.exists(this.getParent(destPath), req, app)) {
            res.sendError(409, "COPY needs parent of destination");
            return;
        }
        if (this._path.isFile(pathInfo, req, app)) {
            OutputStream os = this._path.openWrite(destPath, req, app);
            WriteStream ws = Vfs.openWrite((OutputStream)os);
            try {
                InputStream is = this._path.openRead(pathInfo, req, app);
                try {
                    ws.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                ws.close();
            }
            return;
        }
        this.copyRecursive(pathInfo, destPath, depth, req);
    }

    private void removeRecursive(String pathInfo, HttpServletRequest req) throws IOException {
        ServletContext app = this.getServletContext();
        if (this._path.isDirectory(pathInfo, req, app)) {
            String[] list = this._path.list(pathInfo, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.removeRecursive(this.lookup(pathInfo, list[i]), req);
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        this._path.remove(pathInfo, req, app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRecursive(String srcPath, String destPath, int depth, HttpServletRequest req) throws IOException {
        ServletContext app = this.getServletContext();
        if (this._path.isDirectory(srcPath, req, app)) {
            this._path.mkdir(destPath, req, app);
            if (depth == 0) {
                return;
            }
            String[] list = this._path.list(srcPath, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.copyRecursive(this.lookup(srcPath, list[i]), this.lookup(destPath, list[i]), depth - 1, req);
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        } else {
            OutputStream os = this._path.openWrite(destPath, req, app);
            WriteStream ws = Vfs.openWrite((OutputStream)os);
            try {
                InputStream is = this._path.openRead(srcPath, req, app);
                try {
                    ws.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                ws.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMove(HttpServletRequest req, HttpServletResponse res, WriteStream out) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        int depth = Integer.MAX_VALUE;
        if (!this._path.exists(pathInfo, req, app)) {
            res.sendError(404);
            return;
        }
        String destURI = this.getDestination(req);
        if (destURI == null) {
            res.sendError(403, "Forbidden");
            return;
        }
        String prefix = req.getContextPath();
        if (req.getServletPath() != null) {
            prefix = prefix + req.getServletPath();
        }
        if (!destURI.startsWith(prefix)) {
            res.sendError(403, "Forbidden");
            return;
        }
        String destPath = destURI.substring(prefix.length());
        if (destPath.equals(pathInfo)) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (destPath.startsWith(pathInfo) && (pathInfo.endsWith("/") || destPath.startsWith(pathInfo + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (pathInfo.startsWith(destPath) && (destPath.endsWith("/") || pathInfo.startsWith(destPath + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        String overwrite = req.getHeader("Overwrite");
        if (overwrite == null) {
            overwrite = "T";
        }
        if (!this._path.exists(destPath, req, app)) {
            res.setStatus(201);
        } else if (!overwrite.equals("F")) {
            this.removeRecursive(destPath, req);
            res.setStatus(204, "No Content");
        } else {
            res.sendError(412, "Overwrite not allowed for MOVE");
            return;
        }
        if (!this._path.exists(this.getParent(destPath), req, app)) {
            res.sendError(409, "MOVE needs parent of destination");
            return;
        }
        if (this._path.rename(pathInfo, destPath, req, app)) {
            res.setStatus(204, "No Content");
        } else if (this._path.isFile(pathInfo, req, app)) {
            HashMap<AttributeName, String> props = this.getProperties(pathInfo, req, app);
            OutputStream os = this._path.openWrite(destPath, req, app);
            WriteStream ws = Vfs.openWrite((OutputStream)os);
            try {
                InputStream is = this._path.openRead(pathInfo, req, app);
                try {
                    ws.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                ws.close();
            }
            this.setProperties(props, destPath, req, app);
            this._path.remove(pathInfo, req, app);
        } else {
            this.moveRecursive(pathInfo, destPath, req);
            res.setStatus(204, "No Content");
        }
    }

    private String getDestination(HttpServletRequest request) {
        String dest = request.getHeader("Destination");
        if ((dest = URLDecoder.decode(dest)).startsWith("/")) {
            return dest;
        }
        String prefix = request.getScheme() + "://";
        String host = request.getHeader("Host");
        if (host != null) {
            prefix = prefix + host.toLowerCase(Locale.ENGLISH);
        }
        if (dest.startsWith(prefix)) {
            return dest.substring(prefix.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRecursive(String srcPath, String destPath, HttpServletRequest req) throws IOException {
        ServletContext app = this.getServletContext();
        if (this._path.isDirectory(srcPath, req, app)) {
            this._path.mkdir(destPath, req, app);
            String[] list = this._path.list(srcPath, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.moveRecursive(this.lookup(srcPath, list[i]), this.lookup(destPath, list[i]), req);
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._path.remove(srcPath, req, app);
        } else {
            HashMap<AttributeName, String> props = this.getProperties(srcPath, req, app);
            OutputStream os = this._path.openWrite(destPath, req, app);
            WriteStream rs = Vfs.openWrite((OutputStream)os);
            try {
                InputStream is = this._path.openRead(srcPath, req, app);
                try {
                    rs.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                rs.close();
                os.close();
            }
            this.setProperties(props, destPath, req, app);
            this._path.remove(srcPath, req, app);
        }
    }

    private HashMap<AttributeName, String> getProperties(String pathInfo, HttpServletRequest req, ServletContext app) throws IOException {
        HashMap<AttributeName, String> properties = null;
        Iterator iter = this._path.getAttributeNames(pathInfo, req, app);
        while (iter.hasNext()) {
            AttributeName name = (AttributeName)iter.next();
            String value = this._path.getAttribute(name, pathInfo, req, app);
            if (properties == null) {
                properties = new HashMap<AttributeName, String>();
            }
            properties.put(name, value);
        }
        return properties;
    }

    private void setProperties(HashMap<AttributeName, String> map, String pathInfo, HttpServletRequest req, ServletContext app) throws IOException {
        if (map == null) {
            return;
        }
        for (AttributeName name : map.keySet()) {
            String value = map.get(name);
            this._path.setAttribute(name, value, pathInfo, req, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGet(HttpServletRequest req, HttpServletResponse res, WriteStream out) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        String mimeType = app.getMimeType(pathInfo);
        res.setContentType(mimeType);
        if (!this._path.isFile(pathInfo, req, app) || !this._path.canRead(pathInfo, req, app)) {
            res.sendError(404);
            return;
        }
        long length = this._path.getLength(pathInfo, req, app);
        res.setContentLength((int)length);
        if ("HTTP/1.1".equals(req.getProtocol())) {
            res.setDateHeader("Last-Modified", this._path.getLastModified(pathInfo, req, app));
            res.setHeader("Cache-Control", "private");
        }
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        ServletOutputStream os = res.getOutputStream();
        InputStream is = this._path.openRead(pathInfo, req, app);
        ReadStream rs = Vfs.openRead((InputStream)is);
        try {
            rs.writeToStream((OutputStream)os);
        }
        finally {
            rs.close();
        }
    }

    protected void startMultistatus(HttpServletResponse res, WriteStream out) throws IOException {
        res.setStatus(207, "Multistatus");
        res.setContentType("text/xml; charset=\"utf-8\"");
        out.println("<?xml version=\"1.0\"?>");
        out.println("<D:multistatus xmlns:D=\"DAV:\">");
    }

    protected void sendError(HttpServletResponse res, WriteStream out, int status, String statusText, String message) throws IOException {
        if (statusText == null) {
            res.setStatus(status);
        } else {
            res.setStatus(status, statusText);
        }
        res.setContentType("text/html");
        if (statusText != null) {
            out.print("<title>");
            out.print(statusText);
            out.println("</title>");
            out.print("<h1>");
            out.print(statusText);
            out.println("</h1>");
            out.println(message);
        } else {
            out.print("<title>");
            out.print(message);
            out.println("</title>");
            out.print("<h1>");
            out.print(message);
            out.println("</h1>");
        }
    }

    private void handleDirectory(HttpServletRequest req, HttpServletResponse res, WriteStream out, String pathInfo) throws IOException, ServletException {
        ServletContext app = this.getServletContext();
        res.setContentType("text/html");
        out.println("<title>Directory of " + pathInfo + "</title>");
        out.println("<h1>Directory of " + pathInfo + "</h1>");
        String[] list = this._path.list(pathInfo, req, app);
        for (int i = 0; i < list.length; ++i) {
            out.println("<a href=\"" + list[i] + "\">" + list[i] + "</a><br>");
        }
    }

    private String escapeXml(String data) {
        CharBuffer cb = CharBuffer.allocate();
        block5: for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            switch (ch) {
                case '<': {
                    cb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    cb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    cb.append("&amp;");
                    continue block5;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.close();
    }

    protected String getParent(String pathInfo) {
        int p = pathInfo.lastIndexOf(47, pathInfo.length() - 2);
        if (p < 0) {
            return "/";
        }
        return pathInfo.substring(0, p);
    }

    protected String lookup(String parent, String child) {
        if (parent.endsWith("/")) {
            return parent + child;
        }
        return parent + '/' + child;
    }

    public void destroy() {
        this._path.destroy();
    }

    static class ProppatchCommand {
        public static int SET = 0;
        public static int REMOVE = 1;
        public static int CHANGE = 2;
        private int _code;
        private AttributeName _name;
        private String _value;

        ProppatchCommand(int code, AttributeName name, String value) {
            this._code = code;
            this._name = name;
            this._value = value;
        }

        int getCode() {
            return this._code;
        }

        AttributeName getName() {
            return this._name;
        }

        String getValue() {
            return this._value;
        }
    }

    static class ProppatchHandler
    extends DefaultHandler {
        ArrayList<ProppatchCommand> _commands = new ArrayList();
        boolean _inProp;
        boolean _inSet;
        boolean _inRemove;
        boolean _isPropname;
        AttributeName _attributeName;
        CharBuffer _value;

        ProppatchHandler() {
        }

        boolean isPropname() {
            return this._isPropname;
        }

        ArrayList<ProppatchCommand> getCommands() {
            return this._commands;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("set")) {
                this._inSet = true;
            } else if (localName.equals("remove")) {
                this._inRemove = true;
            } else if (localName.equals("prop")) {
                this._inProp = true;
            } else if (localName.equals("propname")) {
                this._isPropname = true;
            } else if (this._inProp) {
                if (this._attributeName == null) {
                    this._attributeName = new AttributeName(uri, localName, qName);
                    this._value = CharBuffer.allocate();
                } else {
                    int p = qName.indexOf(58);
                    if (p > 0) {
                        this._value.append("<" + qName + " xmlns:" + qName.substring(p + 1) + "=\"" + uri + "\">");
                    } else {
                        this._value.append("<" + qName + " xmlns=\"" + uri + "\">");
                    }
                }
            }
        }

        @Override
        public void characters(char[] buffer, int offset, int length) {
            if (this._value != null) {
                this._value.append(buffer, offset, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("prop")) {
                this._inProp = false;
            } else if (localName.equals("set")) {
                this._inSet = false;
            } else if (localName.equals("remove")) {
                this._inRemove = false;
            } else if (this._attributeName != null) {
                if (localName.equals(this._attributeName.getLocal()) && uri.equals(this._attributeName.getNamespace())) {
                    if (this._inSet) {
                        this._commands.add(new ProppatchCommand(ProppatchCommand.SET, this._attributeName, this._value.close()));
                    } else if (this._inRemove) {
                        this._commands.add(new ProppatchCommand(ProppatchCommand.REMOVE, this._attributeName, this._value.close()));
                    }
                    this._value = null;
                    this._attributeName = null;
                } else {
                    this._value.append("</" + qName + ">");
                }
            }
        }
    }

    static class PropfindHandler
    extends DefaultHandler {
        ArrayList<AttributeName> properties = new ArrayList();
        boolean inProp;
        boolean isPropname;

        PropfindHandler() {
        }

        ArrayList<AttributeName> getProperties() {
            return this.properties;
        }

        boolean isPropname() {
            return this.isPropname;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("prop")) {
                this.inProp = true;
            } else if (localName.equals("propname")) {
                this.isPropname = true;
            } else if (this.inProp) {
                if (qName.indexOf(58) > 0 && uri.equals("")) {
                    throw new SAXException("illegal empty namespace");
                }
                this.properties.add(new AttributeName(uri, localName, qName));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("prop")) {
                this.inProp = false;
            }
        }
    }
}

